/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.tuners.stats;

import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.logging.Logger;
import oracle.ucp.tuners.stats.HistogramInsertionException;
import oracle.ucp.util.Pair;

public class Histogram {
    private final long min;
    private final long max;
    private final long step;
    private final long[] hist;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    public Histogram(long min2, long max, long step) {
        this.min = min2;
        this.max = max;
        this.step = step;
        this.hist = new long[(int)Math.ceil((max - min2) / step)];
        Arrays.fill(this.hist, 0L);
        if (max <= min2 || step > max - min2) {
            throw new IllegalArgumentException();
        }
    }

    public void insert(long data) throws HistogramInsertionException {
        if (data < this.min || data > this.max) {
            throw new HistogramInsertionException("data out of range");
        }
        int n2 = (int)((data - this.min) / this.step);
        this.hist[n2] = this.hist[n2] + 1L;
    }

    public Histogram add(Histogram anotherHist) {
        int len = this.hist.length;
        if (len != anotherHist.hist.length) {
            throw new IllegalArgumentException("incompatible histograms");
        }
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = i2;
            this.hist[n2] = this.hist[n2] + anotherHist.hist[i2];
        }
        return this;
    }

    public Pair<Long, Long> computeEffectiveRange() {
        long maxValue = 0L;
        int indexMax = 0;
        for (int i2 = 0; i2 < this.hist.length; ++i2) {
            if (this.hist[i2] <= maxValue) continue;
            maxValue = this.hist[i2] * (((long)i2 + this.min) * this.step);
            indexMax = i2;
        }
        int leftBound = indexMax;
        for (int i3 = indexMax; i3 >= 0; --i3) {
            if (this.hist[i3] * (((long)i3 + this.min) * this.step) > maxValue / 2L) continue;
            leftBound = i3;
            break;
        }
        int rightBound = indexMax;
        for (int i4 = indexMax; i4 < this.hist.length; ++i4) {
            if (this.hist[i4] * (((long)i4 + this.min) * this.step) > maxValue / 2L) continue;
            rightBound = i4;
            break;
        }
        return new Pair<Long, Long>(this.min + (long)leftBound * this.step, this.min + (long)rightBound * this.step);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (long i2 = this.min; i2 < this.max; i2 += this.step) {
            sb.append(i2).append(':').append(this.hist[(int)((i2 - this.min) / this.step)]);
            if (i2 >= this.max - this.step) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    static {
        try {
            $$$methodRef$$$4 = Histogram.class.getDeclaredConstructor(Long.TYPE, Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = Histogram.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = Histogram.class.getDeclaredMethod("computeEffectiveRange", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = Histogram.class.getDeclaredMethod("add", Histogram.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = Histogram.class.getDeclaredMethod("insert", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

