/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.WritableToken;
import org.antlr.v4.runtime.misc.Interval;

public class BufferedTokenStream
implements TokenStream {
    protected TokenSource tokenSource;
    protected List<Token> tokens = new ArrayList<Token>(100);
    protected int p = -1;
    protected boolean fetchedEOF;

    public BufferedTokenStream(TokenSource tokenSource) {
        if (tokenSource == null) {
            throw new NullPointerException("tokenSource cannot be null");
        }
        this.tokenSource = tokenSource;
    }

    @Override
    public TokenSource getTokenSource() {
        return this.tokenSource;
    }

    @Override
    public int index() {
        return this.p;
    }

    @Override
    public int mark() {
        return 0;
    }

    @Override
    public void release(int marker) {
    }

    @Deprecated
    public void reset() {
        this.seek(0);
    }

    @Override
    public void seek(int index) {
        this.lazyInit();
        this.p = this.adjustSeekIndex(index);
    }

    @Override
    public int size() {
        return this.tokens.size();
    }

    @Override
    public void consume() {
        boolean skipEofCheck = this.p >= 0 ? (this.fetchedEOF ? this.p < this.tokens.size() - 1 : this.p < this.tokens.size()) : false;
        if (!skipEofCheck && this.LA(1) == -1) {
            throw new IllegalStateException("cannot consume EOF");
        }
        if (this.sync(this.p + 1)) {
            this.p = this.adjustSeekIndex(this.p + 1);
        }
    }

    protected boolean sync(int i2) {
        assert (i2 >= 0);
        int n2 = i2 - this.tokens.size() + 1;
        if (n2 > 0) {
            int fetched = this.fetch(n2);
            return fetched >= n2;
        }
        return true;
    }

    protected int fetch(int n2) {
        if (this.fetchedEOF) {
            return 0;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Token t2 = this.tokenSource.nextToken();
            if (t2 instanceof WritableToken) {
                ((WritableToken)t2).setTokenIndex(this.tokens.size());
            }
            this.tokens.add(t2);
            if (t2.getType() != -1) continue;
            this.fetchedEOF = true;
            return i2 + 1;
        }
        return n2;
    }

    @Override
    public Token get(int i2) {
        if (i2 < 0 || i2 >= this.tokens.size()) {
            throw new IndexOutOfBoundsException("token index " + i2 + " out of range 0.." + (this.tokens.size() - 1));
        }
        return this.tokens.get(i2);
    }

    public List<Token> get(int start, int stop) {
        Token t2;
        if (start < 0 || stop < 0) {
            return null;
        }
        this.lazyInit();
        ArrayList<Token> subset = new ArrayList<Token>();
        if (stop >= this.tokens.size()) {
            stop = this.tokens.size() - 1;
        }
        for (int i2 = start; i2 <= stop && (t2 = this.tokens.get(i2)).getType() != -1; ++i2) {
            subset.add(t2);
        }
        return subset;
    }

    @Override
    public int LA(int i2) {
        return this.LT(i2).getType();
    }

    protected Token LB(int k2) {
        if (this.p - k2 < 0) {
            return null;
        }
        return this.tokens.get(this.p - k2);
    }

    @Override
    public Token LT(int k2) {
        this.lazyInit();
        if (k2 == 0) {
            return null;
        }
        if (k2 < 0) {
            return this.LB(-k2);
        }
        int i2 = this.p + k2 - 1;
        this.sync(i2);
        if (i2 >= this.tokens.size()) {
            return this.tokens.get(this.tokens.size() - 1);
        }
        return this.tokens.get(i2);
    }

    protected int adjustSeekIndex(int i2) {
        return i2;
    }

    protected final void lazyInit() {
        if (this.p == -1) {
            this.setup();
        }
    }

    protected void setup() {
        this.sync(0);
        this.p = this.adjustSeekIndex(0);
    }

    public void setTokenSource(TokenSource tokenSource) {
        this.tokenSource = tokenSource;
        this.tokens.clear();
        this.p = -1;
        this.fetchedEOF = false;
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public List<Token> getTokens(int start, int stop) {
        return this.getTokens(start, stop, null);
    }

    public List<Token> getTokens(int start, int stop, Set<Integer> types) {
        this.lazyInit();
        if (start < 0 || stop >= this.tokens.size() || stop < 0 || start >= this.tokens.size()) {
            throw new IndexOutOfBoundsException("start " + start + " or stop " + stop + " not in 0.." + (this.tokens.size() - 1));
        }
        if (start > stop) {
            return null;
        }
        ArrayList<Token> filteredTokens = new ArrayList<Token>();
        for (int i2 = start; i2 <= stop; ++i2) {
            Token t2 = this.tokens.get(i2);
            if (types != null && !types.contains(t2.getType())) continue;
            filteredTokens.add(t2);
        }
        if (filteredTokens.isEmpty()) {
            filteredTokens = null;
        }
        return filteredTokens;
    }

    public List<Token> getTokens(int start, int stop, int ttype) {
        HashSet<Integer> s2 = new HashSet<Integer>(ttype);
        s2.add(ttype);
        return this.getTokens(start, stop, s2);
    }

    protected int nextTokenOnChannel(int i2, int channel) {
        this.sync(i2);
        if (i2 >= this.size()) {
            return this.size() - 1;
        }
        Token token = this.tokens.get(i2);
        while (token.getChannel() != channel) {
            if (token.getType() == -1) {
                return i2;
            }
            this.sync(++i2);
            token = this.tokens.get(i2);
        }
        return i2;
    }

    protected int previousTokenOnChannel(int i2, int channel) {
        this.sync(i2);
        if (i2 >= this.size()) {
            return this.size() - 1;
        }
        while (i2 >= 0) {
            Token token = this.tokens.get(i2);
            if (token.getType() == -1 || token.getChannel() == channel) {
                return i2;
            }
            --i2;
        }
        return i2;
    }

    public List<Token> getHiddenTokensToRight(int tokenIndex, int channel) {
        this.lazyInit();
        if (tokenIndex < 0 || tokenIndex >= this.tokens.size()) {
            throw new IndexOutOfBoundsException(tokenIndex + " not in 0.." + (this.tokens.size() - 1));
        }
        int nextOnChannel = this.nextTokenOnChannel(tokenIndex + 1, 0);
        int from = tokenIndex + 1;
        int to = nextOnChannel == -1 ? this.size() - 1 : nextOnChannel;
        return this.filterForChannel(from, to, channel);
    }

    public List<Token> getHiddenTokensToRight(int tokenIndex) {
        return this.getHiddenTokensToRight(tokenIndex, -1);
    }

    public List<Token> getHiddenTokensToLeft(int tokenIndex, int channel) {
        this.lazyInit();
        if (tokenIndex < 0 || tokenIndex >= this.tokens.size()) {
            throw new IndexOutOfBoundsException(tokenIndex + " not in 0.." + (this.tokens.size() - 1));
        }
        if (tokenIndex == 0) {
            return null;
        }
        int prevOnChannel = this.previousTokenOnChannel(tokenIndex - 1, 0);
        if (prevOnChannel == tokenIndex - 1) {
            return null;
        }
        int from = prevOnChannel + 1;
        int to = tokenIndex - 1;
        return this.filterForChannel(from, to, channel);
    }

    public List<Token> getHiddenTokensToLeft(int tokenIndex) {
        return this.getHiddenTokensToLeft(tokenIndex, -1);
    }

    protected List<Token> filterForChannel(int from, int to, int channel) {
        ArrayList<Token> hidden = new ArrayList<Token>();
        for (int i2 = from; i2 <= to; ++i2) {
            Token t2 = this.tokens.get(i2);
            if (channel == -1) {
                if (t2.getChannel() == 0) continue;
                hidden.add(t2);
                continue;
            }
            if (t2.getChannel() != channel) continue;
            hidden.add(t2);
        }
        if (hidden.size() == 0) {
            return null;
        }
        return hidden;
    }

    @Override
    public String getSourceName() {
        return this.tokenSource.getSourceName();
    }

    @Override
    public String getText() {
        return this.getText(Interval.of(0, this.size() - 1));
    }

    @Override
    public String getText(Interval interval) {
        Token t2;
        int start = interval.a;
        int stop = interval.b;
        if (start < 0 || stop < 0) {
            return "";
        }
        this.sync(stop);
        if (stop >= this.tokens.size()) {
            stop = this.tokens.size() - 1;
        }
        StringBuilder buf = new StringBuilder();
        for (int i2 = start; i2 <= stop && (t2 = this.tokens.get(i2)).getType() != -1; ++i2) {
            buf.append(t2.getText());
        }
        return buf.toString();
    }

    @Override
    public String getText(RuleContext ctx) {
        return this.getText(ctx.getSourceInterval());
    }

    @Override
    public String getText(Token start, Token stop) {
        if (start != null && stop != null) {
            return this.getText(Interval.of(start.getTokenIndex(), stop.getTokenIndex()));
        }
        return "";
    }

    public void fill() {
        int fetched;
        this.lazyInit();
        int blockSize = 1000;
        while ((fetched = this.fetch(1000)) >= 1000) {
        }
    }
}

