/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.config;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetMethods;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;

public class PropertiesUtils {
    public static void set(Object instance, String propertyName, String kvs) {
        String[] keyValues;
        if (instance == null || kvs == null || kvs.trim().isEmpty()) {
            return;
        }
        String[] stringArray = keyValues = kvs.split(",");
        int n2 = keyValues.length;
        int n3 = 0;
        while (n3 < n2) {
            String kv = stringArray[n3];
            PropertiesUtils.processKeyValue(instance, propertyName, kv);
            ++n3;
        }
    }

    private static void processKeyValue(Object instance, String propertyName, String kv) {
        String[] t2 = kv.split("=");
        if (t2.length != 2) {
            throw ConversionException.couldNotTranslatePropertiesIntoObject(instance, propertyName, kv, null);
        }
        String methodName = "set" + t2[0].trim();
        String value = t2[1].trim();
        List<Method> methods = PropertiesUtils.getMethodsMatchingName(instance, methodName);
        MethodMatch match = null;
        try {
            match = PropertiesUtils.getMethodMatchingParameter(methods, value);
        }
        catch (Exception e2) {
            throw ConversionException.couldNotTranslatePropertiesIntoObject(instance, propertyName, kv, e2);
        }
        if (match != null) {
            Method method = match.getMethod();
            Object parsedValue = match.getParsedValue();
            try {
                PropertiesUtils.invokeMethod(method, instance, parsedValue);
            }
            catch (Exception e3) {
                throw ConversionException.couldNotTranslatePropertiesIntoObject(instance, propertyName, kv, e3);
            }
        } else {
            throw ConversionException.couldNotTranslatePropertiesIntoObject(instance, propertyName, kv, null);
        }
    }

    private static MethodMatch getMethodMatchingParameter(List<Method> methods, String parameter) throws Exception {
        Object parsedParameterValue = null;
        Object res = null;
        for (Method method : methods) {
            Class<?>[] params = method.getParameterTypes();
            if (params.length == 1) {
                Class<?> param = params[0];
                if (param == String.class) {
                    parsedParameterValue = parameter;
                } else if (param == Integer.class || param == Integer.TYPE) {
                    parsedParameterValue = Integer.parseInt(parameter);
                } else if (param == Boolean.class || param == Boolean.TYPE) {
                    String lower = parameter.toLowerCase();
                    if ("true".equals(lower)) {
                        parsedParameterValue = Boolean.TRUE;
                    } else if ("false".equals(lower)) {
                        parsedParameterValue = Boolean.FALSE;
                    }
                } else if (param == Long.class || param == Long.TYPE) {
                    parsedParameterValue = Long.parseLong(parameter);
                } else if (param == Float.class || param == Float.TYPE) {
                    parsedParameterValue = Float.valueOf(Float.parseFloat(parameter));
                } else if (param == Double.class || param == Double.TYPE) {
                    parsedParameterValue = Double.parseDouble(parameter);
                }
            }
            if (parsedParameterValue == null) continue;
            return new MethodMatch(method, parsedParameterValue);
        }
        return null;
    }

    private static List<Method> getMethodsMatchingName(Object instance, String methodName) {
        ArrayList<Method> methods = new ArrayList<Method>();
        Method[] methodArray = PropertiesUtils.getMethods(instance.getClass());
        int n2 = methodArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Method method = methodArray[n3];
            if (method.getName().equalsIgnoreCase(methodName)) {
                methods.add(method);
            }
            ++n3;
        }
        return methods;
    }

    private static Method[] getMethods(Class<?> cls) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return AccessController.doPrivileged(new PrivilegedGetMethods(cls));
        }
        return PrivilegedAccessHelper.getMethods(cls);
    }

    private static Object invokeMethod(Method method, Object instance, Object ... params) throws Exception {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return AccessController.doPrivileged(new PrivilegedMethodInvoker(method, instance, params));
        }
        return method.invoke(instance, params);
    }

    private static class MethodMatch {
        final Method method;
        final Object parsedValue;

        public MethodMatch(Method m4, Object p2) {
            this.method = m4;
            this.parsedValue = p2;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object getParsedValue() {
            return this.parsedValue;
        }
    }
}

