/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.partitioning;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.partitioning.FieldPartitioningPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;

public class ValuePartitioningPolicy
extends FieldPartitioningPolicy {
    protected Map<Object, String> partitions = new HashMap<Object, String>();
    protected Map<String, String> partitionNames = new HashMap<String, String>();
    protected String partitionValueTypeName;
    protected Class partitionValueType;
    protected List<String> orderedPartitions = new ArrayList<String>();
    protected String defaultConnectionPool;

    public ValuePartitioningPolicy() {
    }

    public ValuePartitioningPolicy(String partitionField) {
        super(partitionField);
    }

    public ValuePartitioningPolicy(String partitionField, boolean unionUnpartitionableQueries) {
        super(partitionField, unionUnpartitionableQueries);
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        block9: {
            if (this.partitionValueType == null && this.partitionValueTypeName != null) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            this.partitionValueType = AccessController.doPrivileged(new PrivilegedClassForName(this.partitionValueTypeName, true, classLoader));
                            break block9;
                        }
                        catch (PrivilegedActionException e2) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.partitionValueTypeName, e2.getException());
                        }
                    }
                    this.partitionValueType = PrivilegedAccessHelper.getClassForName(this.partitionValueTypeName, true, classLoader);
                }
                catch (Exception exception) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.partitionValueTypeName, exception);
                }
            }
        }
        if (this.partitionValueType != null) {
            for (String valueName : this.partitionNames.keySet()) {
                Object value = this.initObject(this.partitionValueType, valueName);
                if (this.getPartitions().containsKey(value)) {
                    throw ValidationException.duplicatePartitionValue(this.getName(), value);
                }
                this.addPartition(value, this.partitionNames.get(valueName));
            }
        }
    }

    private Object initObject(Class type, String value) {
        return ConversionManager.getDefaultManager().convertObject(value, type);
    }

    public void setPartitionValueTypeName(String partitionValueTypeName) {
        this.partitionValueTypeName = partitionValueTypeName;
    }

    public List<String> getOrderedPartitions() {
        return this.orderedPartitions;
    }

    public void setOrderedPartitions(List<String> orderedPartitions) {
        this.orderedPartitions = orderedPartitions;
    }

    public String getDefaultConnectionPool() {
        return this.defaultConnectionPool;
    }

    public void setDefaultConnectionPool(String defaultConnectionPool) {
        this.defaultConnectionPool = defaultConnectionPool;
    }

    public Map<Object, String> getPartitions() {
        return this.partitions;
    }

    public void setPartitions(Map<Object, String> partitions) {
        this.partitions = partitions;
    }

    public void addPartition(Object value, String connectionPool) {
        this.getPartitions().put(value, connectionPool);
        this.getOrderedPartitions().add(connectionPool);
    }

    public void addPartitionName(String valueName, String connectionPool) {
        this.partitionNames.put(valueName, connectionPool);
    }

    @Override
    public List<Accessor> getConnectionsForQuery(AbstractSession session, DatabaseQuery query, AbstractRecord arguments) {
        Object value = arguments.get(this.partitionField);
        if (value == null) {
            if (this.unionUnpartitionableQueries) {
                ArrayList<Accessor> accessors = new ArrayList<Accessor>(this.partitions.size());
                for (String poolName : this.partitions.values()) {
                    accessors.add(this.getAccessor(poolName, session, query, false));
                }
                return accessors;
            }
            return null;
        }
        ArrayList<Accessor> accessors = new ArrayList<Accessor>(1);
        String poolName = this.partitions.get(value);
        if (poolName == null) {
            if (this.defaultConnectionPool == null) {
                return null;
            }
            poolName = this.defaultConnectionPool;
        }
        if (session.getPlatform().hasPartitioningCallback()) {
            session.getPlatform().getPartitioningCallback().setPartitionId(this.getOrderedPartitions().indexOf(poolName));
            return null;
        }
        accessors.add(this.getAccessor(poolName, session, query, false));
        return accessors;
    }

    @Override
    public void partitionPersist(AbstractSession session, Object object, ClassDescriptor descriptor) {
        Object value = this.extractPartitionValueForPersist(session, object, descriptor);
        if (value == null) {
            return;
        }
        String poolName = this.partitions.get(value);
        if (poolName == null) {
            return;
        }
        if (session.getPlatform().hasPartitioningCallback()) {
            session.getPlatform().getPartitioningCallback().setPartitionId(this.getOrderedPartitions().indexOf(poolName));
        } else {
            this.getAccessor(poolName, session, null, false);
        }
    }
}

