/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;

public class SDOException
extends EclipseLinkException {
    public static final int NO_ID_SPECIFIED = 45000;
    public static final int ERROR_PROCESSING_IMPORT = 45001;
    public static final int ERROR_PROCESSING_INCLUDE = 45002;
    public static final int REFERENCED_PROPERTY_NOT_FOUND = 45003;
    public static final int OLD_SEQUENCE_NOT_FOUND = 45004;
    public static final int FOUND_SIMPLE_VALUE_FOR_FOR_NON_DATATYPE_PROPERTY = 45005;
    public static final int SEQUENCE_NULL_ON_SEQUENCED_DATAOBJECT = 45006;
    public static final int NO_TYPE_SPECIFIED_FOR_PROPERTY = 45007;
    public static final int IO_EXCEPTION_OCCURRED = 45008;
    public static final int TYPE_NOT_FOUND = 45009;
    public static final int TYPE_NOT_FOUND_FOR_INTERFACE = 45010;
    public static final int ERROR_CREATING_DATAOBJECT_FOR_TYPE = 45011;
    public static final int ERROR_CREATING_DATAOBJECT_FOR_CLASS = 45012;
    public static final int NO_APP_INFO_FOR_NULL = 45013;
    public static final int ERROR_DEFINING_TYPE = 45014;
    public static final int ERROR_DEFINING_TYPE_NO_NAME = 45015;
    public static final int MISSING_REF_ATTRIBUTE = 45016;
    public static final int ERROR_PROCESSING_XPATH = 45017;
    public static final int SEQUENCE_DUPLICATE_ADD_NOT_SUPPORTED = 45018;
    public static final int SEQUENCE_ERROR_PROPERTY_IS_ATTRIBUTE = 45019;
    public static final int SEQUENCE_ERROR_NO_PATH_FOUND = 45020;
    public static final int SEQUENCE_ERROR_DATAOBJECT_IS_NULL = 45021;
    public static final int SEQUENCE_NOT_SUPPORTED_FOR_PROPERTY = 45022;
    public static final int WRONG_VALUE_FOR_PROPERTY = 45023;
    public static final int CONVERSION_ERROR = 45024;
    public static final int PROPERTY_NOT_FOUND_AT_INDEX = 45025;
    public static final int CANNOT_PERFORM_OPERATION_ON_NULL_ARGUMENT = 45026;
    public static final int CLASS_NOT_FOUND = 45027;
    public static final int TYPE_CANNOT_BE_OPEN_AND_DATATYPE = 45028;
    public static final int INVALID_INDEX = 45029;
    public static final int JAVA_CLASS_INVOKING_ERROR = 45030;
    public static final int CANNOT_SET_PROPERTY_TYPE_ANNOTATION_IF_TARGET_DATATYPE_TRUE = 45031;
    public static final int XMLMARSHAL_EXCEPTION_OCCURRED = 45032;
    public static final int TYPE_REFERENCED_BUT_NEVER_DEFINED = 45033;
    public static final int OPTIONS_MUST_BE_A_DATAOBJECT = 45034;
    public static final int TYPE_PROPERTY_MUST_BE_A_TYPE = 45035;
    public static final int GLOBAL_PROPERTY_NOT_FOUND = 45036;
    public static final int PREFIX_USED_BUT_NOT_DEFINED = 45037;
    public static final int CANNOT_PERFORM_OPERATION_ON_PROPERTY = 45038;
    public static final int ERROR_ACCESSING_EXTERNALIZABLEDELEGATOR = 45039;
    public static final int CANNOT_PERFORM_OP_WITH_NULL_PARAM = 45040;
    public static final int INVALID_PROPERTY_VALUE = 45041;
    public static final int ERROR_PERFORMING_WLS_LOOKUP = 45100;
    public static final int ERROR_MAKING_WLS_REFLECTIVE_CALL = 45101;
    public static final int ERROR_GETTING_OBJECTNAME = 45102;
    public static final int ERROR_CREATING_INITIAL_CONTEXT = 45103;
    public static final int SDO_JAXB_NO_DESCRIPTOR_FOR_TYPE = 45200;
    public static final int SDO_JAXB_NO_MAPPING_FOR_PROPERTY = 45201;
    public static final int SDO_JAXB_NO_TYPE_FOR_CLASS = 45202;
    public static final int SDO_JAXB_NO_SCHEMA_REFERENCE = 45203;
    public static final int SDO_JAXB_NO_SCHEMA_CONTEXT = 45204;
    public static final int SDO_JAXB_NO_TYPE_FOR_CLASS_BY_SCHEMA_CONTEXT = 45205;
    public static final int SDO_JAXB_ERROR_CREATING_JAXB_UNMARSHALLER = 45206;
    public static final int ERROR_RESOLVING_ENTITY = 45207;
    public static final int MISSING_DEPENDENCY_FOR_BINARY_MAPPING = 45208;
    public static final int ATTEMPT_TO_RESET_APP_RESOLVER = 45209;
    public static final int DATAOBJECT_FROM_DIFFERENT_HELPERCONTEXT = 45210;
    public static final int ERROR_DEFINING_TYPE_INVALID_NAME = 45211;
    public static final int ERROR_DEFINING_PROPERTY_INVALID_NAME = 45212;

    protected SDOException(String message) {
        super(message);
    }

    protected SDOException(String message, Exception internalException) {
        super(message, internalException);
    }

    public static SDOException errorPerformingWLSLookup(String failedLookup, Exception nestedException) {
        Object[] args = new Object[]{failedLookup};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45100, args), nestedException);
        exception.setErrorCode(45100);
        return exception;
    }

    public static SDOException errorInvokingWLSMethodReflectively(String methodName, String theClass, Exception nestedException) {
        Object[] args = new Object[]{methodName, theClass};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45101, args), nestedException);
        exception.setErrorCode(45101);
        return exception;
    }

    public static SDOException errorGettingWLSObjectName(String objectName, Exception nestedException) {
        Object[] args = new Object[]{objectName};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45102, args), nestedException);
        exception.setErrorCode(45102);
        return exception;
    }

    public static SDOException errorCreatingWLSInitialContext(Exception nestedException) {
        Object[] args = new Object[]{};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45103, args), nestedException);
        exception.setErrorCode(45103);
        return exception;
    }

    public static SDOException noTargetIdSpecified(String uri, String name) {
        Object[] args = new Object[]{uri, name};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45000, args));
        exception.setErrorCode(45000);
        return exception;
    }

    public static SDOException errorProcessingImport(String schemaLocation, String namespace, Exception nestedException) {
        Object[] args = new Object[]{schemaLocation, namespace};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45001, args), nestedException);
        exception.setErrorCode(45001);
        return exception;
    }

    public static SDOException errorProcessingInclude(String schemaLocation, Exception nestedException) {
        Object[] args = new Object[]{schemaLocation};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45002, args), nestedException);
        exception.setErrorCode(45002);
        return exception;
    }

    public static SDOException referencedPropertyNotFound(String uri, String localName) {
        Object[] args = new Object[]{uri, localName};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45003, args));
        exception.setErrorCode(45003);
        return exception;
    }

    public static SDOException globalPropertyNotFound() {
        Object[] args = new Object[]{};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45036, args));
        exception.setErrorCode(45036);
        return exception;
    }

    public static SDOException oldSequenceNotFound() {
        Object[] args = new Object[]{};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45004, args));
        exception.setErrorCode(45004);
        return exception;
    }

    public static SDOException foundSimpleValueForNonDataTypeProperty(String propertyName) {
        Object[] args = new Object[]{propertyName};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45005, args));
        exception.setErrorCode(45005);
        return exception;
    }

    public static SDOException sequenceNullOnSequencedDataObject() {
        Object[] args = new Object[]{};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45006, args));
        exception.setErrorCode(45006);
        return exception;
    }

    public static SDOException noTypeSpecifiedForProperty(String propertyName) {
        Object[] args = new Object[]{propertyName};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45007, args));
        exception.setErrorCode(45007);
        return exception;
    }

    public static SDOException ioExceptionOccurred(IOException nestedException) {
        Object[] args = new Object[]{};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45008, args), nestedException);
        exception.setErrorCode(45008);
        return exception;
    }

    public static SDOException xmlMarshalExceptionOccurred(XMLMarshalException nestedException, String rootElementURI, String rootElementName) {
        Object[] args = new Object[]{nestedException.getLocalizedMessage(), rootElementURI, rootElementName};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45032, args), nestedException);
        exception.setErrorCode(45032);
        return exception;
    }

    public static SDOException typeNotFound(String uri, String name) {
        Object[] args = new Object[]{uri, name};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45009, args));
        exception.setErrorCode(45009);
        return exception;
    }

    public static SDOException typeNotFoundForInterface(String className, boolean loadersAreRelated) {
        Object[] args = new Object[]{className, loadersAreRelated};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45010, args));
        exception.setErrorCode(45010);
        return exception;
    }

    public static SDOException errorCreatingDataObjectForType(String uri, String name) {
        Object[] args = new Object[]{uri, name};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45011, args));
        exception.setErrorCode(45011);
        return exception;
    }

    public static SDOException cannotPerformOperationWithNullInputParameter(String operation, String parameter) {
        Object[] args = new Object[]{operation, parameter};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45040, args));
        exception.setErrorCode(45040);
        return exception;
    }

    public static SDOException invalidPropertyValue(String property, String type, String valueType, String value, ConversionException coe) {
        Object[] args = new Object[]{value, valueType, property, type};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45041, args), coe);
        exception.setErrorCode(45041);
        return exception;
    }

    public static SDOException errorCreatingDataObjectForClass(Exception nestedException, String className, String uri, String name) {
        Object[] args = new Object[]{className, uri, name};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45012, args), nestedException);
        exception.setErrorCode(45012);
        return exception;
    }

    public static SDOException noAppInfoForNull() {
        Object[] args = new Object[]{};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45013, args));
        exception.setErrorCode(45013);
        return exception;
    }

    public static SDOException errorDefiningType() {
        Object[] args = new Object[]{};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45014, args));
        exception.setErrorCode(45014);
        return exception;
    }

    public static SDOException errorDefiningTypeNoName() {
        Object[] args = new Object[]{};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45015, args));
        exception.setErrorCode(45015);
        return exception;
    }

    public static SDOException errorDefiningTypeInvalidName(String name) {
        Object[] args = new Object[]{name};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45211, args));
        exception.setErrorCode(45211);
        return exception;
    }

    public static SDOException errorDefiningPropertyInvalidName(String name) {
        Object[] args = new Object[]{name};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45212, args));
        exception.setErrorCode(45212);
        return exception;
    }

    public static SDOException missingRefAttribute() {
        Object[] args = new Object[]{};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45016, args));
        exception.setErrorCode(45016);
        return exception;
    }

    public static SDOException errorProcessingXPath(String xpath) {
        Object[] args = new Object[]{xpath};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45017, args));
        exception.setErrorCode(45017);
        return exception;
    }

    public static SDOException sequenceDuplicateSettingNotSupportedForComplexSingleObject(int index, String settingPropertyName) {
        Object[] args = new Object[]{index, settingPropertyName};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45018, args));
        exception.setErrorCode(45018);
        return exception;
    }

    public static SDOException sequenceAttributePropertyNotSupported(String settingPropertyName) {
        Object[] args = new Object[]{settingPropertyName};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45019, args));
        exception.setErrorCode(45019);
        return exception;
    }

    public static SDOException sequenceNotFoundForPath(String path) {
        Object[] args = new Object[]{path};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45020, args));
        exception.setErrorCode(45020);
        return exception;
    }

    public static SDOException sequenceDataObjectInstanceFieldIsNull() {
        Object[] args = new Object[]{};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45021, args));
        exception.setErrorCode(45021);
        return exception;
    }

    public static SDOException sequenceNotSupportedForProperty(String propertyName) {
        Object[] args = new Object[]{propertyName};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45022, args));
        exception.setErrorCode(45022);
        return exception;
    }

    public static SDOException wrongValueForProperty(String typeUri, String typeName, Class valueClass) {
        Object[] args = new Object[]{typeUri, typeName, valueClass.getName()};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45023, args));
        exception.setErrorCode(45023);
        return exception;
    }

    public static SDOException conversionError(Exception e2) {
        Object[] args = new Object[]{};
        SDOException exception = null;
        exception = e2 != null ? new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45024, args), e2) : new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45024, args));
        exception.setErrorCode(45024);
        return exception;
    }

    public static SDOException propertyNotFoundAtIndex(Exception e2, int propIndex) {
        Object[] args = new Object[]{propIndex};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45025, args), e2);
        exception.setErrorCode(45025);
        return exception;
    }

    public static SDOException cannotPerformOperationOnNullArgument(String methodName) {
        Object[] args = new Object[]{methodName};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45026, args));
        exception.setErrorCode(45026);
        return exception;
    }

    public static SDOException cannotPerformOperationOnProperty(String propertyName, String path) {
        Object[] args = new Object[]{propertyName, path};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45038, args));
        exception.setErrorCode(45038);
        return exception;
    }

    public static SDOException classNotFound(Exception nestedException, String uri, String name) {
        Object[] args = new Object[]{uri, name};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45027, args), nestedException);
        exception.setErrorCode(45027);
        return exception;
    }

    public static SDOException typeCannotBeOpenAndDataType(String uri, String name) {
        Object[] args = new Object[]{uri, name};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45028, args));
        exception.setErrorCode(45028);
        return exception;
    }

    public static SDOException invalidIndex(IndexOutOfBoundsException nestedException, int index) {
        Object[] args = new Object[]{index};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45029, args), nestedException);
        exception.setErrorCode(45029);
        return exception;
    }

    public static SDOException noConstructorWithString(Exception nestedException, String className) {
        Object[] args = new Object[]{className};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45030, args), nestedException);
        exception.setErrorCode(45030);
        return exception;
    }

    public static SDOException propertyTypeAnnotationTargetCannotBeDataTypeTrue(String targetTypeName, String sourcePropertyName) {
        Object[] args = new Object[]{targetTypeName, sourcePropertyName};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45031, args));
        exception.setErrorCode(45031);
        return exception;
    }

    public static SDOException typeReferencedButNotDefined(String namespaceUri, String typeName) {
        Object[] args = new Object[]{namespaceUri, typeName};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45033, args));
        exception.setErrorCode(45033);
        return exception;
    }

    public static SDOException optionsMustBeADataObject(Exception nestedException, String uri, String name) {
        Object[] args = new Object[]{uri, name};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45034, args), nestedException);
        exception.setErrorCode(45034);
        return exception;
    }

    public static SDOException typePropertyMustBeAType(Exception nestedException) {
        Object[] args = new Object[]{};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45035, args), nestedException);
        exception.setErrorCode(45035);
        return exception;
    }

    public static SDOException prefixUsedButNotDefined(String prefix) {
        Object[] args = new Object[]{prefix};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45037, args));
        exception.setErrorCode(45037);
        return exception;
    }

    public static SDOException errorAccessingExternalizableDelegator(String fieldName, Exception nestedException) {
        Object[] args = new Object[]{fieldName};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45039, args), nestedException);
        exception.setErrorCode(45039);
        return exception;
    }

    public static SDOException sdoJaxbNoDescriptorForType(QName sdoQName, QName xmlQName) {
        Object[] args = new Object[]{sdoQName.toString(), xmlQName.toString()};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45200, args));
        exception.setErrorCode(45200);
        return exception;
    }

    public static SDOException sdoJaxbNoMappingForProperty(String propertyName, String xPath) {
        Object[] args = new Object[]{propertyName, xPath};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45201, args));
        exception.setErrorCode(45201);
        return exception;
    }

    public static SDOException sdoJaxbNoTypeForClass(Class clazz) {
        Object[] args = new Object[]{clazz.toString()};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45202, args));
        exception.setErrorCode(45202);
        return exception;
    }

    public static SDOException sdoJaxbNoSchemaReference(Class clazz) {
        Object[] args = new Object[]{clazz.toString()};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45203, args));
        exception.setErrorCode(45203);
        return exception;
    }

    public static SDOException sdoJaxbNoSchemaContext(Class clazz) {
        Object[] args = new Object[]{clazz.toString()};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45204, args));
        exception.setErrorCode(45204);
        return exception;
    }

    public static SDOException sdoJaxbNoTypeForClassBySchemaContext(Class clazz, QName schemaContext) {
        Object[] args = new Object[]{clazz.toString(), schemaContext.toString()};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45205, args));
        exception.setErrorCode(45205);
        return exception;
    }

    public static SDOException sdoJaxbErrorCreatingJAXBUnmarshaller(Exception jaxbException) {
        Object[] args = new Object[]{};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45206, args), jaxbException);
        exception.setErrorCode(45206);
        return exception;
    }

    public static SDOException errorResolvingSchema(Exception nestedException) {
        Object[] args = new Object[]{};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45207, args));
        exception.setErrorCode(45207);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static SDOException unableToMapDataHandlerDueToMissingDependency(String propertyName, String typeName) {
        Object[] args = new Object[]{propertyName, typeName};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45208, args));
        exception.setErrorCode(45208);
        return exception;
    }

    public static SDOException attemptToResetApplicationResolver() {
        Object[] args = new Object[]{};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45209, args));
        exception.setErrorCode(45209);
        return exception;
    }

    public static SDOException dataObjectNotFromHelperContext() {
        Object[] args = new Object[]{};
        SDOException exception = new SDOException(ExceptionMessageGenerator.buildMessage(SDOException.class, 45210, args));
        exception.setErrorCode(45210);
        return exception;
    }
}

