/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.indirection;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.MapChangeEvent;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.Helper;

public class IndirectMap<K, V>
extends Hashtable<K, V>
implements CollectionChangeTracker,
IndirectCollection {
    protected volatile Hashtable<K, V> delegate;
    protected volatile ValueHolderInterface valueHolder;
    private transient PropertyChangeListener changeListener;
    private transient String attributeName;
    protected int initialCapacity = 11;
    protected float loadFactor = 0.75f;

    public IndirectMap() {
        this(11);
    }

    public IndirectMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IndirectMap(int initialCapacity, float loadFactor) {
        super(0);
        this.initialize(initialCapacity, loadFactor);
    }

    public IndirectMap(Map<? extends K, ? extends V> m4) {
        super(0);
        this.initialize(m4);
    }

    protected Hashtable<K, V> buildDelegate() {
        Hashtable value = (Hashtable)this.getValueHolder().getValue();
        if (value == null) {
            value = new Hashtable(this.initialCapacity, this.loadFactor);
        }
        return value;
    }

    @Override
    public synchronized void clear() {
        if (this.hasTrackedPropertyChangeListener()) {
            Iterator<K> objects = this.keySet().iterator();
            while (objects.hasNext()) {
                K o2 = objects.next();
                objects.remove();
            }
        } else {
            this.getDelegate().clear();
        }
    }

    @Override
    public void clearDeferredChanges() {
    }

    @Override
    public synchronized Object clone() {
        IndirectMap result = (IndirectMap)super.clone();
        result.delegate = (Hashtable)this.getDelegate().clone();
        result.valueHolder = new ValueHolder(result.delegate);
        result.attributeName = null;
        result.changeListener = null;
        return result;
    }

    @Override
    public synchronized boolean contains(Object value) {
        return this.getDelegate().contains(value);
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.getDelegate().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getDelegate().containsValue(value);
    }

    @Override
    public synchronized Enumeration<V> elements() {
        return this.getDelegate().elements();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new Set<Map.Entry<K, V>>(){
            Set<Map.Entry<K, V>> delegateSet;
            {
                this.delegateSet = IndirectMap.this.getDelegate().entrySet();
            }

            @Override
            public int size() {
                return this.delegateSet.size();
            }

            @Override
            public boolean isEmpty() {
                return this.delegateSet.isEmpty();
            }

            @Override
            public boolean contains(Object o2) {
                return this.delegateSet.contains(o2);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    Iterator<Map.Entry<K, V>> delegateIterator;
                    Map.Entry<K, V> currentObject;
                    {
                        this.delegateIterator = delegateSet.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this.currentObject = this.delegateIterator.next();
                        return this.currentObject;
                    }

                    @Override
                    public void remove() {
                        this.delegateIterator.remove();
                        if (this.currentObject != null) {
                            IndirectMap.this.raiseRemoveChangeEvent(this.currentObject.getKey(), this.currentObject.getValue());
                        }
                    }

                    @Override
                    public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
                        this.delegateIterator.forEachRemaining(action);
                    }
                };
            }

            @Override
            public Object[] toArray() {
                return this.delegateSet.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a2) {
                return this.delegateSet.toArray(a2);
            }

            @Override
            public boolean add(Map.Entry<K, V> o2) {
                return this.delegateSet.add(o2);
            }

            @Override
            public boolean remove(Object o2) {
                if (!(o2 instanceof Map.Entry)) {
                    return false;
                }
                return IndirectMap.this.remove(((Map.Entry)o2).getKey()) != null;
            }

            @Override
            public boolean containsAll(Collection<?> c2) {
                return this.delegateSet.containsAll(c2);
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> c2) {
                return this.delegateSet.addAll(c2);
            }

            @Override
            public boolean retainAll(Collection<?> c2) {
                boolean result = false;
                Iterator objects = this.delegateSet.iterator();
                while (objects.hasNext()) {
                    Map.Entry object = objects.next();
                    if (c2.contains(object)) continue;
                    objects.remove();
                    IndirectMap.this.raiseRemoveChangeEvent(object.getKey(), object.getValue());
                    result = true;
                }
                return result;
            }

            @Override
            public boolean removeAll(Collection<?> c2) {
                boolean result = false;
                for (Object object : c2) {
                    Object removed;
                    if (!(object instanceof Map.Entry) || (removed = IndirectMap.this.remove(((Map.Entry)object).getKey())) == null) continue;
                    result = true;
                }
                return result;
            }

            @Override
            public void clear() {
                IndirectMap.this.clear();
            }

            @Override
            public boolean equals(Object o2) {
                return this.delegateSet.equals(o2);
            }

            @Override
            public int hashCode() {
                return this.delegateSet.hashCode();
            }

            @Override
            public boolean removeIf(Predicate<? super Map.Entry<K, V>> filter) {
                boolean hasChanged = false;
                Iterator objects = this.iterator();
                while (objects.hasNext()) {
                    if (!filter.test(objects.next())) continue;
                    objects.remove();
                    hasChanged |= true;
                }
                return hasChanged;
            }

            @Override
            public Stream<Map.Entry<K, V>> stream() {
                return this.delegateSet.stream();
            }

            @Override
            public Stream<Map.Entry<K, V>> parallelStream() {
                return this.delegateSet.parallelStream();
            }

            @Override
            public void forEach(Consumer<? super Map.Entry<K, V>> action) {
                this.delegateSet.forEach(action);
            }

            @Override
            public Spliterator<Map.Entry<K, V>> spliterator() {
                return this.delegateSet.spliterator();
            }
        };
    }

    @Override
    public synchronized boolean equals(Object o2) {
        return this.getDelegate().equals(o2);
    }

    @Override
    public synchronized V get(Object key) {
        return this.getDelegate().get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable<K, V> getDelegate() {
        Hashtable<K, V> newDelegate = this.delegate;
        if (newDelegate == null) {
            IndirectMap indirectMap = this;
            synchronized (indirectMap) {
                newDelegate = this.delegate;
                if (newDelegate == null) {
                    this.delegate = newDelegate = this.buildDelegate();
                }
            }
        }
        return newDelegate;
    }

    @Override
    public Object getDelegateObject() {
        return this.getDelegate();
    }

    @Override
    public String getTrackedAttributeName() {
        return this.attributeName;
    }

    @Override
    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this.changeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueHolderInterface getValueHolder() {
        ValueHolderInterface vh = this.valueHolder;
        if (vh == null) {
            IndirectMap indirectMap = this;
            synchronized (indirectMap) {
                vh = this.valueHolder;
                if (vh == null) {
                    this.valueHolder = vh = new ValueHolder(new Hashtable(this.initialCapacity, this.loadFactor));
                }
            }
        }
        return vh;
    }

    @Override
    public synchronized int hashCode() {
        return this.getDelegate().hashCode();
    }

    public boolean hasTrackedPropertyChangeListener() {
        return this.changeListener != null;
    }

    protected void initialize(int initialCapacity, float loadFactor) {
        this.delegate = null;
        this.loadFactor = loadFactor;
        this.initialCapacity = initialCapacity;
        this.valueHolder = null;
    }

    protected void initialize(Map<? extends K, ? extends V> m4) {
        this.delegate = null;
        Hashtable<? extends K, ? extends V> temp = new Hashtable<K, V>(m4);
        this.valueHolder = new ValueHolder(temp);
    }

    @Override
    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    @Override
    public boolean isInstantiated() {
        return this.getValueHolder().isInstantiated();
    }

    @Override
    public synchronized Enumeration<K> keys() {
        return this.getDelegate().keys();
    }

    @Override
    public Set<K> keySet() {
        return new Set<K>(){
            Set<K> delegateSet;
            {
                this.delegateSet = IndirectMap.this.getDelegate().keySet();
            }

            @Override
            public int size() {
                return this.delegateSet.size();
            }

            @Override
            public boolean isEmpty() {
                return this.delegateSet.isEmpty();
            }

            @Override
            public boolean contains(Object o2) {
                return this.delegateSet.contains(o2);
            }

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    Iterator<K> delegateIterator;
                    K currentObject;
                    {
                        this.delegateIterator = delegateSet.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    @Override
                    public K next() {
                        this.currentObject = this.delegateIterator.next();
                        return this.currentObject;
                    }

                    @Override
                    public void remove() {
                        IndirectMap.this.raiseRemoveChangeEvent(this.currentObject, IndirectMap.this.getDelegate().get(this.currentObject));
                        this.delegateIterator.remove();
                    }

                    @Override
                    public void forEachRemaining(Consumer<? super K> action) {
                        this.delegateIterator.forEachRemaining(action);
                    }
                };
            }

            @Override
            public Object[] toArray() {
                return this.delegateSet.toArray();
            }

            @Override
            public Object[] toArray(Object[] a2) {
                return this.delegateSet.toArray(a2);
            }

            @Override
            public boolean add(K o2) {
                return this.delegateSet.add(o2);
            }

            @Override
            public boolean remove(Object o2) {
                return IndirectMap.this.remove(o2) != null;
            }

            @Override
            public boolean containsAll(Collection<?> c2) {
                return this.delegateSet.containsAll(c2);
            }

            @Override
            public boolean addAll(Collection<? extends K> c2) {
                return this.delegateSet.addAll(c2);
            }

            @Override
            public boolean retainAll(Collection<?> c2) {
                boolean result = false;
                Iterator objects = this.delegateSet.iterator();
                while (objects.hasNext()) {
                    Object object = objects.next();
                    if (c2.contains(object)) continue;
                    objects.remove();
                    IndirectMap.this.raiseRemoveChangeEvent(object, IndirectMap.this.getDelegate().get(object));
                    result = true;
                }
                return result;
            }

            @Override
            public boolean removeAll(Collection<?> c2) {
                boolean result = false;
                Iterator<?> cs = c2.iterator();
                while (cs.hasNext()) {
                    if (IndirectMap.this.remove(cs.next()) == null) continue;
                    result = true;
                }
                return result;
            }

            @Override
            public void clear() {
                IndirectMap.this.clear();
            }

            @Override
            public boolean equals(Object o2) {
                return this.delegateSet.equals(o2);
            }

            @Override
            public int hashCode() {
                return this.delegateSet.hashCode();
            }

            @Override
            public boolean removeIf(Predicate<? super K> filter) {
                boolean hasChanged = false;
                Iterator objects = this.iterator();
                while (objects.hasNext()) {
                    if (!filter.test(objects.next())) continue;
                    objects.remove();
                    hasChanged |= true;
                }
                return hasChanged;
            }

            @Override
            public Stream<K> stream() {
                return this.delegateSet.stream();
            }

            @Override
            public Stream<K> parallelStream() {
                return this.delegateSet.parallelStream();
            }

            @Override
            public void forEach(Consumer<? super K> action) {
                this.delegateSet.forEach(action);
            }

            @Override
            public Spliterator<K> spliterator() {
                return this.delegateSet.spliterator();
            }
        };
    }

    @Override
    public synchronized V put(K key, V value) {
        V oldValue = this.getDelegate().put(key, value);
        if (oldValue != null) {
            this.raiseRemoveChangeEvent(key, oldValue);
        }
        this.raiseAddChangeEvent(key, value);
        return oldValue;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> t2) {
        if (this.hasTrackedPropertyChangeListener()) {
            t2.entrySet().stream().forEach((? super T newEntry) -> this.put(newEntry.getKey(), newEntry.getValue()));
        } else {
            this.getDelegate().putAll(t2);
        }
    }

    @Override
    public synchronized V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (this.hasTrackedPropertyChangeListener()) {
            V oldValue = this.get(key);
            V newValue = remappingFunction.apply(key, oldValue);
            if (oldValue != null) {
                if (newValue != null) {
                    this.put(key, newValue);
                    return newValue;
                }
                this.remove(key);
            } else if (newValue != null) {
                this.put(key, newValue);
                return newValue;
            }
            return null;
        }
        return this.getDelegate().compute(key, remappingFunction);
    }

    @Override
    public synchronized V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        if (this.hasTrackedPropertyChangeListener()) {
            V oldValue = this.get(key);
            if (oldValue == null) {
                V newValue = mappingFunction.apply(key);
                if (newValue != null) {
                    this.put(key, newValue);
                }
                return newValue;
            }
            return oldValue;
        }
        return this.getDelegate().computeIfAbsent(key, mappingFunction);
    }

    @Override
    public synchronized V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (this.hasTrackedPropertyChangeListener()) {
            if (this.get(key) != null) {
                V oldValue = this.get(key);
                V newValue = remappingFunction.apply(key, oldValue);
                if (newValue != null) {
                    this.put(key, newValue);
                    return newValue;
                }
                this.remove(key);
            }
            return null;
        }
        return this.getDelegate().computeIfPresent(key, remappingFunction);
    }

    @Override
    public synchronized void forEach(BiConsumer<? super K, ? super V> action) {
        this.getDelegate().forEach(action);
    }

    @Override
    public synchronized V getOrDefault(Object key, V defaultValue) {
        return this.getDelegate().getOrDefault(key, defaultValue);
    }

    @Override
    public synchronized V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        if (this.hasTrackedPropertyChangeListener()) {
            V newValue;
            V oldValue = this.get(key);
            V v2 = newValue = oldValue == null ? value : remappingFunction.apply(oldValue, value);
            if (newValue == null) {
                this.remove(key);
            } else {
                this.put(key, newValue);
            }
            return newValue;
        }
        return this.getDelegate().merge(key, value, remappingFunction);
    }

    @Override
    public synchronized V putIfAbsent(K key, V value) {
        if (this.hasTrackedPropertyChangeListener()) {
            V current = this.getDelegate().get(key);
            if (current == null) {
                V v2 = this.getDelegate().put(key, value);
                this.raiseAddChangeEvent(key, value);
                return v2;
            }
            return current;
        }
        return this.getDelegate().putIfAbsent(key, value);
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        if (this.hasTrackedPropertyChangeListener()) {
            Hashtable<K, V> del = this.getDelegate();
            if (del.containsKey(key) && Objects.equals(del.get(key), value)) {
                del.remove(key);
                this.raiseRemoveChangeEvent(key, value);
                return true;
            }
            return false;
        }
        return this.getDelegate().remove(key, value);
    }

    @Override
    public synchronized V replace(K key, V value) {
        if (this.hasTrackedPropertyChangeListener()) {
            Hashtable<K, V> del = this.getDelegate();
            if (del.containsKey(key)) {
                return this.put(key, value);
            }
            return null;
        }
        return this.getDelegate().replace(key, value);
    }

    @Override
    public synchronized boolean replace(K key, V oldValue, V newValue) {
        if (this.hasTrackedPropertyChangeListener()) {
            Hashtable<K, V> del = this.getDelegate();
            if (del.containsKey(key) && Objects.equals(del.get(key), oldValue)) {
                this.put(key, newValue);
                return true;
            }
            return false;
        }
        return this.getDelegate().replace(key, oldValue, newValue);
    }

    @Override
    public synchronized void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        if (this.hasTrackedPropertyChangeListener()) {
            this.getDelegate().entrySet().stream().forEach((? super T entry) -> {
                Object key = entry.getKey();
                Object oldValue = entry.getValue();
                entry.setValue(function.apply((K)key, (V)entry.getValue()));
                this.raiseRemoveChangeEvent(key, oldValue);
                this.raiseAddChangeEvent(key, entry.getValue());
            });
            return;
        }
        this.getDelegate().replaceAll(function);
    }

    @Override
    protected void rehash() {
        throw new InternalError("unsupported");
    }

    protected void raiseAddChangeEvent(Object key, Object value) {
        if (this.hasTrackedPropertyChangeListener()) {
            this._persistence_getPropertyChangeListener().propertyChange(new MapChangeEvent((Object)this, this.getTrackedAttributeName(), (Object)this, key, value, 0, true));
        }
    }

    protected void raiseRemoveChangeEvent(Object key, Object value) {
        if (this.hasTrackedPropertyChangeListener()) {
            this._persistence_getPropertyChangeListener().propertyChange(new MapChangeEvent((Object)this, this.getTrackedAttributeName(), (Object)this, key, value, 1, true));
        }
    }

    @Override
    public synchronized V remove(Object key) {
        V value = this.getDelegate().remove(key);
        if (value != null) {
            this.raiseRemoveChangeEvent(key, value);
        }
        return value;
    }

    @Override
    public void setTrackedAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    @Override
    public void _persistence_setPropertyChangeListener(PropertyChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public void setValueHolder(ValueHolderInterface valueHolder) {
        this.delegate = null;
        this.valueHolder = valueHolder;
    }

    @Override
    public int size() {
        return this.getDelegate().size();
    }

    @Override
    public void setUseLazyInstantiation(boolean useLazyInstantiation) {
    }

    @Override
    public Collection<Map.Entry<K, V>> getRemovedElements() {
        return null;
    }

    @Override
    public Collection<Map.Entry<K, V>> getAddedElements() {
        return null;
    }

    @Override
    public boolean hasDeferredChanges() {
        return false;
    }

    @Override
    public String toString() {
        if (this.isInstantiated()) {
            return "{" + this.getDelegate().toString() + "}";
        }
        return "{" + Helper.getShortClassName(this.getClass()) + ": not instantiated}";
    }

    @Override
    public Collection<V> values() {
        return new Collection<V>(){
            protected Collection<V> delegateCollection;
            {
                this.delegateCollection = IndirectMap.this.getDelegate().values();
            }

            @Override
            public int size() {
                return this.delegateCollection.size();
            }

            @Override
            public boolean isEmpty() {
                return this.delegateCollection.isEmpty();
            }

            @Override
            public boolean contains(Object o2) {
                return this.delegateCollection.contains(o2);
            }

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    Iterator<V> delegateIterator;
                    V currentObject;
                    {
                        this.delegateIterator = delegateCollection.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    @Override
                    public V next() {
                        this.currentObject = this.delegateIterator.next();
                        return this.currentObject;
                    }

                    @Override
                    public void remove() {
                        for (Map.Entry entry : IndirectMap.this.getDelegate().entrySet()) {
                            if (!entry.getValue().equals(this.currentObject)) continue;
                            IndirectMap.this.raiseRemoveChangeEvent(entry.getKey(), entry.getValue());
                        }
                        this.delegateIterator.remove();
                    }

                    @Override
                    public void forEachRemaining(Consumer<? super V> action) {
                        this.delegateIterator.forEachRemaining(action);
                    }
                };
            }

            @Override
            public Object[] toArray() {
                return this.delegateCollection.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a2) {
                return this.delegateCollection.toArray(a2);
            }

            @Override
            public boolean add(V o2) {
                return this.delegateCollection.add(o2);
            }

            @Override
            public boolean remove(Object o2) {
                Iterator entryIt = IndirectMap.this.getDelegate().entrySet().iterator();
                while (entryIt.hasNext()) {
                    Map.Entry entry = entryIt.next();
                    if (!entry.getValue().equals(o2)) continue;
                    IndirectMap.this.raiseRemoveChangeEvent(entry.getKey(), entry.getValue());
                    entryIt.remove();
                    return true;
                }
                return false;
            }

            @Override
            public boolean containsAll(Collection<?> c2) {
                return this.delegateCollection.containsAll(c2);
            }

            @Override
            public boolean addAll(Collection<? extends V> c2) {
                return this.delegateCollection.addAll(c2);
            }

            @Override
            public boolean removeAll(Collection<?> c2) {
                boolean result = false;
                Iterator<?> iterator = c2.iterator();
                while (iterator.hasNext()) {
                    if (!this.remove(iterator.next())) continue;
                    result = true;
                }
                return result;
            }

            @Override
            public boolean retainAll(Collection<?> c2) {
                boolean result = false;
                Iterator iterator = IndirectMap.this.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (c2.contains(entry.getValue())) continue;
                    iterator.remove();
                    result = true;
                }
                return result;
            }

            @Override
            public void clear() {
                IndirectMap.this.clear();
            }

            @Override
            public boolean equals(Object o2) {
                return this.delegateCollection.equals(o2);
            }

            @Override
            public int hashCode() {
                return this.delegateCollection.hashCode();
            }

            @Override
            public void forEach(Consumer<? super V> action) {
                this.delegateCollection.forEach(action);
            }

            @Override
            public boolean removeIf(Predicate<? super V> filter) {
                boolean hasChanged = false;
                Iterator objects = this.iterator();
                while (objects.hasNext()) {
                    if (!filter.test(objects.next())) continue;
                    objects.remove();
                    hasChanged |= true;
                }
                return hasChanged;
            }

            @Override
            public Spliterator<V> spliterator() {
                return this.delegateCollection.spliterator();
            }

            @Override
            public Stream<V> stream() {
                return this.delegateCollection.stream();
            }

            @Override
            public Stream<V> parallelStream() {
                return this.delegateCollection.parallelStream();
            }
        };
    }
}

