/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.cache;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.eclipse.persistence.internal.cache.ComputableTask;
import org.eclipse.persistence.internal.cache.LowLevelProcessor;

public class Memoizer<A, V>
implements LowLevelProcessor<A, V> {
    private final ConcurrentMap<MemoizerKey, Future<V>> cache = new ConcurrentHashMap<MemoizerKey, Future<V>>();
    private final KeyStorage keyStorage = new KeyStorage();

    /*
     * Loose catch block
     */
    @Override
    public V compute(final ComputableTask<A, V> c2, final A taskArg) throws InterruptedException {
        MemoizerKey key = this.keyStorage.get(c2, taskArg);
        while (true) {
            Callable evaluation;
            FutureTask ft;
            FutureTask f2;
            if ((f2 = (FutureTask)this.cache.get(key)) == null && (f2 = (Future)this.cache.putIfAbsent(key, ft = new FutureTask(evaluation = new Callable<V>(){

                @Override
                public V call() throws InterruptedException {
                    return c2.compute(taskArg);
                }
            }))) == null) {
                f2 = ft;
                ft.run();
            }
            try {
                return f2.get();
            }
            catch (CancellationException e2) {
                this.cache.remove(key, f2);
                continue;
            }
            break;
        }
        catch (ExecutionException e3) {
            throw new RuntimeException(e3);
        }
    }

    public void forget(ComputableTask<A, V> task, A key) {
        Memoizer memoizer = this;
        memoizer.getClass();
        this.cache.remove(memoizer.new MemoizerKey(task, key));
    }

    public void forgetAll() {
        this.cache.clear();
    }

    private class KeyStorage {
        Map<MemoizerKey, MemoizerKey> map = new ConcurrentHashMap<MemoizerKey, MemoizerKey>();

        private KeyStorage() {
        }

        public MemoizerKey get(ComputableTask<A, V> c2, A taskArg) {
            MemoizerKey certificate = new MemoizerKey(c2, taskArg);
            MemoizerKey key = this.map.putIfAbsent(certificate, certificate);
            return key == null ? certificate : key;
        }
    }

    private class MemoizerKey {
        private final ComputableTask<A, V> task;
        private final A key;

        private MemoizerKey(ComputableTask<A, V> task, A key) {
            this.task = task;
            this.key = key;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            MemoizerKey cacheKey = (MemoizerKey)o2;
            if (this.key != null ? !this.key.equals(cacheKey.key) : cacheKey.key != null) {
                return false;
            }
            return !(this.task != null ? !this.task.equals(cacheKey.task) : cacheKey.task != null);
        }

        public int hashCode() {
            int result = this.task != null ? this.task.hashCode() : 0;
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }
    }
}

