/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.jaxb.TypeMappingInfo;

public class JaxbClassLoader
extends ClassLoader {
    private static final String GENERATED_CLASS_NAME = "org.eclipse.persistence.jaxb.generated";
    private Map<String, Type> generatedClasses;
    private AtomicInteger generatedClassCounter = new AtomicInteger();

    public JaxbClassLoader(ClassLoader nestedClassLoader) {
        super(nestedClassLoader);
        this.generatedClasses = new HashMap<String, Type>();
    }

    public JaxbClassLoader(ClassLoader nestedClassLoader, Class[] classes) {
        super(nestedClassLoader);
        this.generatedClasses = new HashMap<String, Type>();
        if (classes != null) {
            int i2 = 0;
            while (i2 < classes.length) {
                Class nextClass = classes[i2];
                this.generatedClasses.put(nextClass.getName(), nextClass);
                ++i2;
            }
        }
    }

    public JaxbClassLoader(ClassLoader nestedClassLoader, Type[] types) {
        super(nestedClassLoader);
        this.generatedClasses = new HashMap<String, Type>();
        if (types != null) {
            int i2 = 0;
            while (i2 < types.length) {
                Type nextType = types[i2];
                if (nextType instanceof Class) {
                    this.generatedClasses.put(((Class)nextType).getName(), nextType);
                }
                ++i2;
            }
        }
    }

    public JaxbClassLoader(ClassLoader nestedClassLoader, TypeMappingInfo[] types) {
        super(nestedClassLoader);
        this.generatedClasses = new HashMap<String, Type>();
        if (types != null) {
            int i2 = 0;
            while (i2 < types.length) {
                TypeMappingInfo tmi = types[i2];
                Type nextType = tmi.getType();
                if (nextType == null) {
                    throw JAXBException.nullTypeOnTypeMappingInfo(tmi.getXmlTagName());
                }
                if (nextType instanceof Class) {
                    this.generatedClasses.put(((Class)nextType).getName(), nextType);
                }
                ++i2;
            }
        }
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        Class javaClass;
        block5: {
            javaClass = null;
            if (className.indexOf(46) == -1 && (className.equals("boolean") || className.equals("short") || className.equals("int") || className.equals("long") || className.equals("float") || className.equals("double") || className.equals("byte") || className.equals("char")) && (javaClass = (Class)this.generatedClasses.get(className)) != null) {
                return javaClass;
            }
            try {
                javaClass = this.getParent().loadClass(className);
            }
            catch (ClassNotFoundException e2) {
                javaClass = (Class)this.generatedClasses.get(className);
                if (javaClass != null) {
                    return javaClass;
                }
                throw e2;
            }
            catch (NoClassDefFoundError error) {
                javaClass = (Class)this.generatedClasses.get(className);
                if (javaClass != null) break block5;
                throw error;
            }
        }
        return javaClass;
    }

    public Class generateClass(String className, byte[] bytes) {
        Class<?> theClass = this.defineClass(className, bytes, 0, bytes.length);
        this.generatedClasses.put(className, theClass);
        return theClass;
    }

    public void putClass(String className, Class clazz) {
        this.generatedClasses.put(className, clazz);
    }

    public String nextAvailableGeneratedClassName() {
        return GENERATED_CLASS_NAME + this.generatedClassCounter.getAndIncrement();
    }
}

