/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb.many;

import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.persistence.internal.jaxb.many.ManyValue;
import org.eclipse.persistence.internal.jaxb.many.MultiDimensionalManyValue;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

@XmlTransient
public abstract class MultiDimensionalArrayValue<T extends ManyValue<?, Object>>
extends MultiDimensionalManyValue<T> {
    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public Object getItem() {
        Object array = Array.newInstance(this.containerClass(), this.adaptedValue.size());
        int x2 = 0;
        for (ManyValue value : this.adaptedValue) {
            Array.set(array, x2, value.getItem());
            ++x2;
        }
        return array;
    }

    @Override
    public void setItem(Object array) {
        try {
            int arraySize = Array.getLength(array);
            this.adaptedValue = new ArrayList(arraySize);
            int x2 = 0;
            while (x2 < arraySize) {
                ManyValue manyValue = (ManyValue)PrivilegedAccessHelper.newInstanceFromClass(this.componentClass());
                manyValue.setItem(Array.get(array, x2));
                this.adaptedValue.add(manyValue);
                ++x2;
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }
}

