/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatformUtils;

public final class IsolatedHashMap<K, V>
implements Map<K, V> {
    private static final String DEFAULT_PARTITION_ID = "0";
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final ServerPlatform serverPlatform;
    private static final boolean supportPartitions;
    private final int initialCapacity;
    private final float loadFactor;
    private final Map<String, Map<K, V>> maps;

    static {
        String serverPlatformName = ServerPlatformUtils.detectServerPlatform(null);
        serverPlatform = serverPlatformName != null ? ServerPlatformUtils.createServerPlatform(null, serverPlatformName, IsolatedHashMap.class.getClassLoader()) : null;
        supportPartitions = serverPlatform != null ? serverPlatform.usesPartitions() : false;
    }

    public static final <K, V> Map<K, V> newMap() {
        return supportPartitions ? new IsolatedHashMap<K, V>() : new HashMap();
    }

    private IsolatedHashMap() {
        this(16, 0.75f);
    }

    private IsolatedHashMap(int initialCapacity, float loadFactor) {
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.maps = new ConcurrentHashMap<String, Map<K, V>>(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<K, V> getMap() {
        String partitionId = supportPartitions ? serverPlatform.getPartitionID() : DEFAULT_PARTITION_ID;
        Map<K, V> partitionMap = this.maps.get(partitionId);
        if (partitionMap == null) {
            IsolatedHashMap isolatedHashMap = this;
            synchronized (isolatedHashMap) {
                partitionMap = this.maps.get(partitionId);
                if (partitionMap == null) {
                    partitionMap = new HashMap(this.initialCapacity, this.loadFactor);
                    this.maps.put(partitionId, partitionMap);
                }
            }
        }
        return partitionMap;
    }

    @Override
    public int size() {
        return this.getMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getMap().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getMap().containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.getMap().get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.getMap().put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.getMap().remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m4) {
        this.getMap().putAll(m4);
    }

    @Override
    public void clear() {
        this.getMap().clear();
    }

    @Override
    public Set<K> keySet() {
        return this.getMap().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.getMap().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.getMap().entrySet();
    }
}

