/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;

public class MetadataHelper {
    private MetadataHelper() {
        throw new UnsupportedOperationException("Instances of MetadataHelper are not allowed");
    }

    public static void buildColsFromMappings(StringBuilder target, Collection<? extends MetadataAccessor> mappings, String separator) {
        Iterator<? extends MetadataAccessor> i2 = mappings.iterator();
        while (i2.hasNext()) {
            target.append(i2.next().getName().toUpperCase(Locale.ROOT));
            if (!i2.hasNext()) continue;
            target.append(separator);
        }
    }

    public static void buildValuesAsQMarksFromMappings(StringBuilder target, Collection<? extends MetadataAccessor> mappings, String separator) {
        int count = mappings.size();
        if (count > 0) {
            int i2 = 0;
            while (i2 < count) {
                if (i2 > 0) {
                    target.append(separator);
                }
                target.append('?');
                ++i2;
            }
        }
    }

    public static void buildColsAndValuesBindingsFromMappings(StringBuilder target, Collection<? extends MetadataAccessor> mappings, int valueIndex, String binder, String separator) {
        int idx = valueIndex;
        Iterator<? extends MetadataAccessor> i2 = mappings.iterator();
        while (i2.hasNext()) {
            target.append(i2.next().getName().toUpperCase(Locale.ROOT)).append(binder).append(Integer.toString(++idx));
            if (!i2.hasNext()) continue;
            target.append(separator);
        }
    }
}

