/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.mappings;

import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

public class CascadeMetadata
extends ORMetadata {
    private Boolean m_cascadeAll;
    private Boolean m_cascadePersist;
    private Boolean m_cascadeMerge;
    private Boolean m_cascadeRemove;
    private Boolean m_cascadeRefresh;
    private Boolean m_cascadeDetach;

    public CascadeMetadata() {
        super("<cascade>");
    }

    public CascadeMetadata(Object[] cascadeTypes, MetadataAccessor accessor) {
        super(null, accessor);
        Object[] objectArray = cascadeTypes;
        int n2 = cascadeTypes.length;
        int n3 = 0;
        while (n3 < n2) {
            Object cascadeType = objectArray[n3];
            if (cascadeType.equals("ALL")) {
                this.m_cascadeAll = true;
            } else if (cascadeType.equals("PERSIST")) {
                this.m_cascadePersist = true;
            } else if (cascadeType.equals("MERGE")) {
                this.m_cascadeMerge = true;
            } else if (cascadeType.equals("REMOVE")) {
                this.m_cascadeRemove = true;
            } else if (cascadeType.equals("REFRESH")) {
                this.m_cascadeRefresh = true;
            } else if (cascadeType.equals("DETACH")) {
                this.m_cascadeDetach = true;
            }
            ++n3;
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof CascadeMetadata) {
            CascadeMetadata cascade = (CascadeMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_cascadeAll, cascade.getCascadeAll())) {
                return false;
            }
            if (!this.valuesMatch(this.m_cascadePersist, cascade.getCascadePersist())) {
                return false;
            }
            if (!this.valuesMatch(this.m_cascadeMerge, cascade.getCascadeMerge())) {
                return false;
            }
            if (!this.valuesMatch(this.m_cascadeRemove, cascade.getCascadeRemove())) {
                return false;
            }
            if (!this.valuesMatch(this.m_cascadeRefresh, cascade.getCascadeRefresh())) {
                return false;
            }
            return this.valuesMatch(this.m_cascadeDetach, cascade.getCascadeDetach());
        }
        return false;
    }

    public int hashCode() {
        int result = this.m_cascadeAll != null ? this.m_cascadeAll.hashCode() : 0;
        result = 31 * result + (this.m_cascadePersist != null ? this.m_cascadePersist.hashCode() : 0);
        result = 31 * result + (this.m_cascadeMerge != null ? this.m_cascadeMerge.hashCode() : 0);
        result = 31 * result + (this.m_cascadeRemove != null ? this.m_cascadeRemove.hashCode() : 0);
        result = 31 * result + (this.m_cascadeRefresh != null ? this.m_cascadeRefresh.hashCode() : 0);
        result = 31 * result + (this.m_cascadeDetach != null ? this.m_cascadeDetach.hashCode() : 0);
        return result;
    }

    public Boolean getCascadeAll() {
        return this.m_cascadeAll;
    }

    public Boolean getCascadeDetach() {
        return this.m_cascadeDetach;
    }

    public Boolean getCascadeMerge() {
        return this.m_cascadeMerge;
    }

    public Boolean getCascadePersist() {
        return this.m_cascadePersist;
    }

    public Boolean getCascadeRefresh() {
        return this.m_cascadeRefresh;
    }

    public Boolean getCascadeRemove() {
        return this.m_cascadeRemove;
    }

    public boolean isCascadeAll() {
        return this.m_cascadeAll != null && this.m_cascadeAll != false;
    }

    public boolean isCascadeDetach() {
        return this.m_cascadeDetach != null && this.m_cascadeDetach != false;
    }

    public boolean isCascadeMerge() {
        return this.m_cascadeMerge != null && this.m_cascadeMerge != false;
    }

    public boolean isCascadePersist() {
        return this.m_cascadePersist != null && this.m_cascadePersist != false;
    }

    public boolean isCascadeRefresh() {
        return this.m_cascadeRefresh != null && this.m_cascadeRefresh != false;
    }

    public boolean isCascadeRemove() {
        return this.m_cascadeRemove != null && this.m_cascadeRemove != false;
    }

    public void process(ForeignReferenceMapping mapping) {
        if (this.isCascadeAll()) {
            mapping.setCascadeAll(true);
        }
        if (this.isCascadeDetach()) {
            mapping.setCascadeDetach(true);
        }
        if (this.isCascadeMerge()) {
            mapping.setCascadeMerge(true);
        }
        if (this.isCascadePersist()) {
            mapping.setCascadePersist(true);
        }
        if (this.isCascadeRefresh()) {
            mapping.setCascadeRefresh(true);
        }
        if (this.isCascadeRemove()) {
            mapping.setCascadeRemove(true);
        }
    }

    public void setCascadeAll(Boolean cascadeAll) {
        this.m_cascadeAll = cascadeAll;
    }

    public void setCascadeDetach(Boolean cascadeDetach) {
        this.m_cascadeDetach = cascadeDetach;
    }

    public void setCascadeMerge(Boolean cascadeMerge) {
        this.m_cascadeMerge = cascadeMerge;
    }

    public void setCascadePersist(Boolean cascadePersist) {
        this.m_cascadePersist = cascadePersist;
    }

    public void setCascadeRefresh(Boolean cascadeRefresh) {
        this.m_cascadeRefresh = cascadeRefresh;
    }

    public void setCascadeRemove(Boolean cascadeRemove) {
        this.m_cascadeRemove = cascadeRemove;
    }
}

