/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.tables;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.ForeignKeyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class RelationalTableMetadata
extends TableMetadata {
    private ForeignKeyMetadata m_foreignKey;
    private List<JoinColumnMetadata> m_joinColumns = new ArrayList<JoinColumnMetadata>();

    public RelationalTableMetadata(MetadataAccessor accessor) {
        super(null, accessor);
    }

    public RelationalTableMetadata(MetadataAnnotation relationalTable, MetadataAccessor accessor) {
        super(relationalTable, accessor);
        if (relationalTable != null) {
            Object[] objectArray = relationalTable.getAttributeArray("joinColumns");
            int n2 = objectArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Object joinColumn = objectArray[n3];
                this.m_joinColumns.add(new JoinColumnMetadata((MetadataAnnotation)joinColumn, accessor));
                ++n3;
            }
            if (relationalTable.hasAttribute("foreignKey")) {
                this.m_foreignKey = new ForeignKeyMetadata(relationalTable.getAttributeAnnotation("foreignKey"), accessor);
            }
        }
    }

    public RelationalTableMetadata(String xmlElement) {
        super(xmlElement);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof RelationalTableMetadata) {
            RelationalTableMetadata relationalTable = (RelationalTableMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_joinColumns, relationalTable.getJoinColumns())) {
                return false;
            }
            return this.valuesMatch(this.m_foreignKey, relationalTable.getForeignKey());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = this.m_foreignKey != null ? this.m_foreignKey.hashCode() : 0;
        result = 31 * result + (this.m_joinColumns != null ? this.m_joinColumns.hashCode() : 0);
        return result;
    }

    public ForeignKeyMetadata getForeignKey() {
        return this.m_foreignKey;
    }

    public List<JoinColumnMetadata> getJoinColumns() {
        return this.m_joinColumns;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_foreignKey, accessibleObject);
        this.initXMLObjects(this.m_joinColumns, accessibleObject);
    }

    @Override
    public void processForeignKey() {
        if (this.m_foreignKey != null) {
            this.m_foreignKey.process(this.getDatabaseTable());
        }
    }

    public void setForeignKey(ForeignKeyMetadata foreignKey) {
        this.m_foreignKey = foreignKey;
    }

    public void setJoinColumns(List<JoinColumnMetadata> joinColumns) {
        this.m_joinColumns = joinColumns;
    }
}

