/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ConverterAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFile;
import org.eclipse.persistence.internal.jpa.metadata.columns.TenantDiscriminatorColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.MixedConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ObjectTypeConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.SerializedConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.StructConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TypeConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListenerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.mappings.AccessMethodsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.HashPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.PartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.PinnedPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.RangePartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.ReplicationPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.RoundRobinPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.UnionPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.ValuePartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedNativeQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedPLSQLStoredFunctionQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedPLSQLStoredProcedureQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedStoredFunctionQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedStoredProcedureQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.OracleArrayTypeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.OracleObjectTypeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLRecordMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.SQLResultSetMappingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.SequenceGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.TableGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.UuidGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsReader;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsWriter;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLPersistenceUnitMetadata;

public class XMLEntityMappings
extends ORMetadata {
    private AccessMethodsMetadata m_accessMethods;
    private boolean m_isEclipseLinkORMFile = false;
    private boolean m_loadedForCanonicalModel = false;
    private ClassLoader m_loader;
    private List<EntityAccessor> m_entities;
    private List<MixedConverterMetadata> m_mixedConverters;
    private List<ConverterAccessor> m_converterAccessors;
    private List<ConverterMetadata> m_converters = new ArrayList<ConverterMetadata>();
    private List<EmbeddableAccessor> m_embeddables;
    private List<MappedSuperclassAccessor> m_mappedSuperclasses;
    private List<NamedNativeQueryMetadata> m_namedNativeQueries;
    private List<NamedQueryMetadata> m_namedQueries;
    private List<NamedStoredProcedureQueryMetadata> m_namedStoredProcedureQueries;
    private List<NamedStoredFunctionQueryMetadata> m_namedStoredFunctionQueries;
    private List<NamedPLSQLStoredProcedureQueryMetadata> m_namedPLSQLStoredProcedureQueries;
    private List<NamedPLSQLStoredFunctionQueryMetadata> m_namedPLSQLStoredFunctionQueries;
    private List<OracleObjectTypeMetadata> m_oracleObjectTypes;
    private List<OracleArrayTypeMetadata> m_oracleArrayTypes;
    private List<PLSQLRecordMetadata> m_plsqlRecords;
    private List<PLSQLTableMetadata> m_plsqlTables;
    private List<ObjectTypeConverterMetadata> m_objectTypeConverters;
    private List<SequenceGeneratorMetadata> m_sequenceGenerators;
    private List<SQLResultSetMappingMetadata> m_sqlResultSetMappings;
    private List<StructConverterMetadata> m_structConverters;
    private List<TableGeneratorMetadata> m_tableGenerators;
    private List<TypeConverterMetadata> m_typeConverters;
    private List<UuidGeneratorMetadata> m_uuidGenerators;
    private List<SerializedConverterMetadata> m_serializedConverters;
    private List<PartitioningMetadata> m_partitioning;
    private List<RangePartitioningMetadata> m_rangePartitioning;
    private List<ValuePartitioningMetadata> m_valuePartitioning;
    private List<UnionPartitioningMetadata> m_unionPartitioning;
    private List<ReplicationPartitioningMetadata> m_replicationPartitioning;
    private List<RoundRobinPartitioningMetadata> m_roundRobinPartitioning;
    private List<HashPartitioningMetadata> m_hashPartitioning;
    private List<PinnedPartitioningMetadata> m_pinnedPartitioning;
    private List<TenantDiscriminatorColumnMetadata> m_tenantDiscriminatorColumns;
    private MetadataFactory m_factory;
    private MetadataFile m_file;
    private MetadataProject m_project;
    private String m_access;
    private String m_catalog;
    private String m_description;
    private String m_package;
    private String m_schema;
    private String m_version;
    private String m_mappingFileNameOrURL;
    private XMLPersistenceUnitMetadata m_persistenceUnitMetadata;

    public XMLEntityMappings() {
        super("<entity-mappings>");
        this.m_converterAccessors = new ArrayList<ConverterAccessor>();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof XMLEntityMappings) {
            XMLEntityMappings entityMappings = (XMLEntityMappings)objectToCompare;
            return this.valuesMatch(this.m_mappingFileNameOrURL, entityMappings.getMappingFileOrURL());
        }
        return false;
    }

    public int hashCode() {
        return this.m_mappingFileNameOrURL != null ? this.m_mappingFileNameOrURL.hashCode() : 0;
    }

    public String getAccess() {
        return this.m_access;
    }

    public AccessMethodsMetadata getAccessMethods() {
        return this.m_accessMethods;
    }

    public String getCatalog() {
        return this.m_catalog;
    }

    public List<ConverterAccessor> getConverterAccessors() {
        return this.m_converterAccessors;
    }

    public List<ConverterMetadata> getConverters() {
        return this.m_converters;
    }

    protected String getDefaultCatalog() {
        if (this.m_catalog == null) {
            if (this.m_project.getPersistenceUnitMetadata() == null) {
                return null;
            }
            return this.m_project.getPersistenceUnitMetadata().getCatalog();
        }
        return this.m_catalog;
    }

    protected String getDefaultSchema() {
        if (this.m_schema == null) {
            if (this.m_project.getPersistenceUnitMetadata() == null) {
                return null;
            }
            return this.m_project.getPersistenceUnitMetadata().getSchema();
        }
        return this.m_schema;
    }

    public String getDescription() {
        return this.m_description;
    }

    public List<EmbeddableAccessor> getEmbeddables() {
        return this.m_embeddables;
    }

    public List<EntityAccessor> getEntities() {
        return this.m_entities;
    }

    public String getPackageQualifiedClassName(String className) {
        if (this.m_package == null || this.m_package.equals("")) {
            return className;
        }
        if (className.indexOf(".") > -1) {
            return className;
        }
        if (this.m_package.endsWith(".")) {
            return String.valueOf(this.m_package) + className;
        }
        return String.valueOf(this.m_package) + "." + className;
    }

    @Override
    public MetadataLogger getLogger() {
        return this.m_project.getLogger();
    }

    public List<HashPartitioningMetadata> getHashPartitioning() {
        return this.m_hashPartitioning;
    }

    public List<MappedSuperclassAccessor> getMappedSuperclasses() {
        return this.m_mappedSuperclasses;
    }

    public String getMappingFileOrURL() {
        return this.m_mappingFileNameOrURL;
    }

    @Override
    public MetadataFactory getMetadataFactory() {
        return this.m_factory;
    }

    public List<MixedConverterMetadata> getMixedConverters() {
        return this.m_mixedConverters;
    }

    public List<NamedNativeQueryMetadata> getNamedNativeQueries() {
        return this.m_namedNativeQueries;
    }

    public List<NamedPLSQLStoredFunctionQueryMetadata> getNamedPLSQLStoredFunctionQueries() {
        return this.m_namedPLSQLStoredFunctionQueries;
    }

    public List<NamedPLSQLStoredProcedureQueryMetadata> getNamedPLSQLStoredProcedureQueries() {
        return this.m_namedPLSQLStoredProcedureQueries;
    }

    public List<NamedQueryMetadata> getNamedQueries() {
        return this.m_namedQueries;
    }

    public List<NamedStoredFunctionQueryMetadata> getNamedStoredFunctionQueries() {
        return this.m_namedStoredFunctionQueries;
    }

    public List<NamedStoredProcedureQueryMetadata> getNamedStoredProcedureQueries() {
        return this.m_namedStoredProcedureQueries;
    }

    public List<ObjectTypeConverterMetadata> getObjectTypeConverters() {
        return this.m_objectTypeConverters;
    }

    public String getPackage() {
        return this.m_package;
    }

    public List<PartitioningMetadata> getPartitioning() {
        return this.m_partitioning;
    }

    public XMLPersistenceUnitMetadata getPersistenceUnitMetadata() {
        return this.m_persistenceUnitMetadata;
    }

    public List<PinnedPartitioningMetadata> getPinnedPartitioning() {
        return this.m_pinnedPartitioning;
    }

    public List<OracleArrayTypeMetadata> getOracleArrayTypes() {
        return this.m_oracleArrayTypes;
    }

    public List<OracleObjectTypeMetadata> getOracleObjectTypes() {
        return this.m_oracleObjectTypes;
    }

    public List<PLSQLRecordMetadata> getPLSQLRecords() {
        return this.m_plsqlRecords;
    }

    public List<PLSQLTableMetadata> getPLSQLTables() {
        return this.m_plsqlTables;
    }

    @Override
    public MetadataProject getProject() {
        return this.m_project;
    }

    public List<RangePartitioningMetadata> getRangePartitioning() {
        return this.m_rangePartitioning;
    }

    public List<ReplicationPartitioningMetadata> getReplicationPartitioning() {
        return this.m_replicationPartitioning;
    }

    public List<RoundRobinPartitioningMetadata> getRoundRobinPartitioning() {
        return this.m_roundRobinPartitioning;
    }

    public String getSchema() {
        return this.m_schema;
    }

    public List<SequenceGeneratorMetadata> getSequenceGenerators() {
        return this.m_sequenceGenerators;
    }

    public List<SQLResultSetMappingMetadata> getSqlResultSetMappings() {
        return this.m_sqlResultSetMappings;
    }

    public List<StructConverterMetadata> getStructConverters() {
        return this.m_structConverters;
    }

    public List<TableGeneratorMetadata> getTableGenerators() {
        return this.m_tableGenerators;
    }

    public List<TenantDiscriminatorColumnMetadata> getTenantDiscriminatorColumns() {
        return this.m_tenantDiscriminatorColumns;
    }

    public List<TypeConverterMetadata> getTypeConverters() {
        return this.m_typeConverters;
    }

    public List<SerializedConverterMetadata> getSerializedConverters() {
        return this.m_serializedConverters;
    }

    public List<UnionPartitioningMetadata> getUnionPartitioning() {
        return this.m_unionPartitioning;
    }

    public List<UuidGeneratorMetadata> getUuidGenerators() {
        return this.m_uuidGenerators;
    }

    public List<ValuePartitioningMetadata> getValuePartitioning() {
        return this.m_valuePartitioning;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void initPersistenceUnitClasses(HashMap<String, EntityAccessor> allEntities, HashMap<String, EmbeddableAccessor> allEmbeddables) {
        for (MixedConverterMetadata mixedConverter : this.m_mixedConverters) {
            if (mixedConverter.isConverterMetadata()) {
                this.m_converters.add(mixedConverter.buildConverterMetadata());
                continue;
            }
            this.m_converterAccessors.add(mixedConverter.buildConverterAccessor());
        }
        for (EntityAccessor entity : this.getEntities()) {
            MetadataClass entityClass = this.getMetadataClass(this.getPackageQualifiedClassName(entity.getClassName()), false);
            entity.initXMLClassAccessor(entityClass, new MetadataDescriptor(entityClass, entity), this.m_project, this);
            if (allEntities.containsKey(entityClass.getName())) {
                allEntities.get(entityClass.getName()).merge(entity);
                continue;
            }
            allEntities.put(entityClass.getName(), entity);
        }
        for (EmbeddableAccessor embeddable : this.getEmbeddables()) {
            MetadataClass embeddableClass = this.getMetadataClass(this.getPackageQualifiedClassName(embeddable.getClassName()), false);
            embeddable.initXMLClassAccessor(embeddableClass, new MetadataDescriptor(embeddableClass, embeddable), this.m_project, this);
            if (allEmbeddables.containsKey(embeddableClass.getName())) {
                allEmbeddables.get(embeddableClass.getName()).merge(embeddable);
                continue;
            }
            allEmbeddables.put(embeddableClass.getName(), embeddable);
        }
        for (MappedSuperclassAccessor mappedSuperclass : this.getMappedSuperclasses()) {
            MetadataClass mappedSuperclassClass = this.getMetadataClass(this.getPackageQualifiedClassName(mappedSuperclass.getClassName()), false);
            mappedSuperclass.initXMLClassAccessor(mappedSuperclassClass, new MetadataDescriptor(mappedSuperclassClass, mappedSuperclass), this.m_project, this);
            if (this.m_project.hasMappedSuperclass(mappedSuperclassClass)) {
                this.m_project.getMappedSuperclassAccessor(mappedSuperclassClass).merge(mappedSuperclass);
                continue;
            }
            this.m_project.addMappedSuperclass(mappedSuperclass);
        }
        for (ConverterAccessor converterAccessor : this.m_converterAccessors) {
            MetadataClass converterClass = this.getMetadataClass(this.getPackageQualifiedClassName(converterAccessor.getClassName()), false);
            converterAccessor.initXMLObject(converterClass, this);
            if (this.m_project.hasConverterAccessor(converterClass)) {
                this.m_project.getConverterAccessor(converterClass).merge(converterAccessor);
                continue;
            }
            this.m_project.addConverterAccessor(converterAccessor);
        }
    }

    public boolean isEclipseLinkORMFile() {
        return this.m_isEclipseLinkORMFile;
    }

    public boolean loadedForCanonicalModel() {
        return this.m_loadedForCanonicalModel;
    }

    protected XMLEntityMappings newXMLEntityMappingsObject() {
        XMLEntityMappings entityMappingsOut = new XMLEntityMappings();
        entityMappingsOut.setVersion(this.getVersion());
        return entityMappingsOut;
    }

    public void process() {
        for (ConverterMetadata converterMetadata : this.m_converters) {
            converterMetadata.initXMLObject(this.m_file, this);
            this.m_project.addConverter(converterMetadata);
        }
        for (TypeConverterMetadata typeConverterMetadata : this.m_typeConverters) {
            typeConverterMetadata.initXMLObject(this.m_file, this);
            this.m_project.addConverter(typeConverterMetadata);
        }
        for (ObjectTypeConverterMetadata objectTypeConverterMetadata : this.m_objectTypeConverters) {
            objectTypeConverterMetadata.initXMLObject(this.m_file, this);
            this.m_project.addConverter(objectTypeConverterMetadata);
        }
        for (SerializedConverterMetadata serializedConverterMetadata : this.m_serializedConverters) {
            serializedConverterMetadata.initXMLObject(this.m_file, this);
            this.m_project.addConverter(serializedConverterMetadata);
        }
        for (StructConverterMetadata structConverterMetadata : this.m_structConverters) {
            structConverterMetadata.initXMLObject(this.m_file, this);
            this.m_project.addConverter(structConverterMetadata);
        }
        for (TableGeneratorMetadata tableGeneratorMetadata : this.m_tableGenerators) {
            tableGeneratorMetadata.initXMLObject(this.m_file, this);
            this.m_project.addTableGenerator(tableGeneratorMetadata, this.getDefaultCatalog(), this.getDefaultSchema());
        }
        for (SequenceGeneratorMetadata sequenceGeneratorMetadata : this.m_sequenceGenerators) {
            sequenceGeneratorMetadata.initXMLObject(this.m_file, this);
            this.m_project.addSequenceGenerator(sequenceGeneratorMetadata, this.getDefaultCatalog(), this.getDefaultSchema());
        }
        for (UuidGeneratorMetadata uuidGeneratorMetadata : this.m_uuidGenerators) {
            uuidGeneratorMetadata.initXMLObject(this.m_file, this);
            this.m_project.addUuidGenerator(uuidGeneratorMetadata);
        }
        for (PartitioningMetadata partitioningMetadata : this.m_partitioning) {
            partitioningMetadata.initXMLObject(this.m_file, this);
            this.m_project.addPartitioningPolicy(partitioningMetadata);
        }
        for (ReplicationPartitioningMetadata replicationPartitioningMetadata : this.m_replicationPartitioning) {
            replicationPartitioningMetadata.initXMLObject(this.m_file, this);
            this.m_project.addPartitioningPolicy(replicationPartitioningMetadata);
        }
        for (RoundRobinPartitioningMetadata roundRobinPartitioningMetadata : this.m_roundRobinPartitioning) {
            roundRobinPartitioningMetadata.initXMLObject(this.m_file, this);
            this.m_project.addPartitioningPolicy(roundRobinPartitioningMetadata);
        }
        for (PinnedPartitioningMetadata pinnedPartitioningMetadata : this.m_pinnedPartitioning) {
            pinnedPartitioningMetadata.initXMLObject(this.m_file, this);
            this.m_project.addPartitioningPolicy(pinnedPartitioningMetadata);
        }
        for (RangePartitioningMetadata rangePartitioningMetadata : this.m_rangePartitioning) {
            rangePartitioningMetadata.initXMLObject(this.m_file, this);
            this.m_project.addPartitioningPolicy(rangePartitioningMetadata);
        }
        for (ValuePartitioningMetadata valuePartitioningMetadata : this.m_valuePartitioning) {
            valuePartitioningMetadata.initXMLObject(this.m_file, this);
            this.m_project.addPartitioningPolicy(valuePartitioningMetadata);
        }
        for (HashPartitioningMetadata hashPartitioningMetadata : this.m_hashPartitioning) {
            hashPartitioningMetadata.initXMLObject(this.m_file, this);
            this.m_project.addPartitioningPolicy(hashPartitioningMetadata);
        }
        for (NamedQueryMetadata namedQueryMetadata : this.m_namedQueries) {
            namedQueryMetadata.initXMLObject(this.m_file, this);
            this.m_project.addQuery(namedQueryMetadata);
        }
        for (NamedNativeQueryMetadata namedNativeQueryMetadata : this.m_namedNativeQueries) {
            namedNativeQueryMetadata.initXMLObject(this.m_file, this);
            this.m_project.addQuery(namedNativeQueryMetadata);
        }
        for (NamedStoredProcedureQueryMetadata namedStoredProcedureQueryMetadata : this.m_namedStoredProcedureQueries) {
            namedStoredProcedureQueryMetadata.initXMLObject(this.m_file, this);
            this.m_project.addQuery(namedStoredProcedureQueryMetadata);
        }
        for (NamedStoredFunctionQueryMetadata namedStoredFunctionQueryMetadata : this.m_namedStoredFunctionQueries) {
            namedStoredFunctionQueryMetadata.initXMLObject(this.m_file, this);
            this.m_project.addQuery(namedStoredFunctionQueryMetadata);
        }
        for (NamedPLSQLStoredProcedureQueryMetadata namedPLSQLStoredProcedureQueryMetadata : this.m_namedPLSQLStoredProcedureQueries) {
            namedPLSQLStoredProcedureQueryMetadata.initXMLObject(this.m_file, this);
            this.m_project.addQuery(namedPLSQLStoredProcedureQueryMetadata);
        }
        for (NamedPLSQLStoredFunctionQueryMetadata namedPLSQLStoredFunctionQueryMetadata : this.m_namedPLSQLStoredFunctionQueries) {
            namedPLSQLStoredFunctionQueryMetadata.initXMLObject(this.m_file, this);
            this.m_project.addQuery(namedPLSQLStoredFunctionQueryMetadata);
        }
        for (SQLResultSetMappingMetadata sQLResultSetMappingMetadata : this.m_sqlResultSetMappings) {
            sQLResultSetMappingMetadata.initXMLObject(this.m_file, this);
            this.m_project.addSQLResultSetMapping(sQLResultSetMappingMetadata);
        }
        for (OracleObjectTypeMetadata oracleObjectTypeMetadata : this.m_oracleObjectTypes) {
            oracleObjectTypeMetadata.initXMLObject(this.m_file, this);
            this.m_project.addComplexMetadataType(oracleObjectTypeMetadata);
        }
        for (OracleArrayTypeMetadata oracleArrayTypeMetadata : this.m_oracleArrayTypes) {
            oracleArrayTypeMetadata.initXMLObject(this.m_file, this);
            this.m_project.addComplexMetadataType(oracleArrayTypeMetadata);
        }
        for (PLSQLRecordMetadata pLSQLRecordMetadata : this.m_plsqlRecords) {
            pLSQLRecordMetadata.initXMLObject(this.m_file, this);
            this.m_project.addComplexMetadataType(pLSQLRecordMetadata);
        }
        for (PLSQLTableMetadata pLSQLTableMetadata : this.m_plsqlTables) {
            pLSQLTableMetadata.initXMLObject(this.m_file, this);
            this.m_project.addComplexMetadataType(pLSQLTableMetadata);
        }
    }

    public void processEntityMappingsDefaults(ClassAccessor accessor) {
        MetadataDescriptor descriptor = accessor.getDescriptor();
        if (this.m_access != null) {
            descriptor.setDefaultAccess(this.m_access);
        }
        if (this.m_accessMethods != null) {
            descriptor.setDefaultAccessMethods(this.m_accessMethods);
        }
        if (this.m_catalog != null) {
            descriptor.setDefaultCatalog(this.m_catalog);
        }
        if (this.m_schema != null) {
            descriptor.setDefaultSchema(this.m_schema);
        }
        if (!this.m_tenantDiscriminatorColumns.isEmpty()) {
            descriptor.setDefaultTenantDiscriminatorColumns(this.m_tenantDiscriminatorColumns);
        }
    }

    public void processPersistenceUnitMetadata() {
        this.m_file = new MetadataFile(this);
        if (this.m_persistenceUnitMetadata != null) {
            this.m_persistenceUnitMetadata.initXMLObject(this.m_file, this);
            this.m_project.setPersistenceUnitMetadata(this.m_persistenceUnitMetadata);
            for (EntityListenerMetadata defaultListener : this.m_persistenceUnitMetadata.getDefaultListeners()) {
                defaultListener.initXMLObject(this.m_file, this);
                this.m_project.addDefaultListener(defaultListener);
            }
        }
    }

    @Override
    public EntityAccessor reloadEntity(EntityAccessor accessor, MetadataDescriptor descriptor) {
        XMLEntityMappings xmlEntityMappings = this.newXMLEntityMappingsObject();
        ArrayList<EntityAccessor> list = new ArrayList<EntityAccessor>();
        list.add(accessor);
        xmlEntityMappings.setEntities(list);
        xmlEntityMappings = this.reloadXMLEntityMappingsObject(xmlEntityMappings);
        EntityAccessor entity = xmlEntityMappings.getEntities().get(0);
        MetadataClass metadataClass = this.getMetadataFactory().getMetadataClass(this.getPackageQualifiedClassName(entity.getClassName()));
        entity.initXMLClassAccessor(metadataClass, descriptor, this.m_project, this);
        return entity;
    }

    @Override
    public MappedSuperclassAccessor reloadMappedSuperclass(MappedSuperclassAccessor accessor, MetadataDescriptor descriptor) {
        XMLEntityMappings xmlEntityMappings = this.newXMLEntityMappingsObject();
        ArrayList<MappedSuperclassAccessor> list = new ArrayList<MappedSuperclassAccessor>();
        list.add(accessor);
        xmlEntityMappings.setMappedSuperclasses(list);
        xmlEntityMappings = this.reloadXMLEntityMappingsObject(xmlEntityMappings);
        MappedSuperclassAccessor mappedSuperclass = xmlEntityMappings.getMappedSuperclasses().get(0);
        MetadataClass metadataClass = this.getMetadataFactory().getMetadataClass(this.getPackageQualifiedClassName(mappedSuperclass.getClassName()));
        mappedSuperclass.initXMLClassAccessor(metadataClass, descriptor, this.m_project, this);
        return mappedSuperclass;
    }

    protected XMLEntityMappings reloadXMLEntityMappingsObject(XMLEntityMappings xmlEntityMappings) {
        ByteArrayOutputStream outputStream = null;
        StringReader reader1 = null;
        StringReader reader2 = null;
        try {
            XMLEntityMappings newXMLEntityMappings;
            outputStream = new ByteArrayOutputStream();
            XMLEntityMappingsWriter.write(xmlEntityMappings, outputStream);
            reader1 = new StringReader(outputStream.toString());
            reader2 = new StringReader(outputStream.toString());
            XMLEntityMappings xMLEntityMappings = newXMLEntityMappings = XMLEntityMappingsReader.read("tempStream", reader1, reader2, this.m_loader, null);
            return xMLEntityMappings;
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (reader1 != null) {
                reader1.close();
            }
            if (reader2 != null) {
                reader2.close();
            }
        }
    }

    public void setAccess(String access) {
        this.m_access = access;
    }

    public void setAccessMethods(AccessMethodsMetadata accessMethods) {
        this.m_accessMethods = accessMethods;
    }

    public void setCatalog(String catalog) {
        this.m_catalog = catalog;
    }

    public void setConverterAccessors(List<ConverterAccessor> converterAccessors) {
        this.m_converterAccessors = converterAccessors;
    }

    public void setConverters(List<ConverterMetadata> converters) {
        this.m_converters = converters;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setEmbeddables(List<EmbeddableAccessor> embeddables) {
        this.m_embeddables = embeddables;
    }

    public void setEntities(List<EntityAccessor> entities) {
        this.m_entities = entities;
    }

    public void setHashPartitioning(List<HashPartitioningMetadata> hashPartitioning) {
        this.m_hashPartitioning = hashPartitioning;
    }

    public void setIsEclipseLinkORMFile(boolean isEclipseLinkORMFile) {
        this.m_isEclipseLinkORMFile = isEclipseLinkORMFile;
    }

    public void setLoadedForCanonicalModel(boolean loadedForCanonicalModel) {
        this.m_loadedForCanonicalModel = loadedForCanonicalModel;
    }

    public void setLoader(ClassLoader loader) {
        this.m_loader = loader;
    }

    public void setMappedSuperclasses(List<MappedSuperclassAccessor> mappedSuperclasses) {
        this.m_mappedSuperclasses = mappedSuperclasses;
    }

    public void setMappingFile(String mappingFileNameOrURL) {
        this.m_mappingFileNameOrURL = mappingFileNameOrURL;
    }

    public void setMetadataFactory(MetadataFactory factory) {
        this.m_factory = factory;
    }

    public void setMixedConverters(List<MixedConverterMetadata> mixedConverters) {
        this.m_mixedConverters = mixedConverters;
    }

    public void setNamedNativeQueries(List<NamedNativeQueryMetadata> namedNativeQueries) {
        this.m_namedNativeQueries = namedNativeQueries;
    }

    public void setNamedPLSQLStoredFunctionQueries(List<NamedPLSQLStoredFunctionQueryMetadata> namedPLSQLStoredFunctionQueries) {
        this.m_namedPLSQLStoredFunctionQueries = namedPLSQLStoredFunctionQueries;
    }

    public void setNamedPLSQLStoredProcedureQueries(List<NamedPLSQLStoredProcedureQueryMetadata> namedPLSQLStoredProcedureQueries) {
        this.m_namedPLSQLStoredProcedureQueries = namedPLSQLStoredProcedureQueries;
    }

    public void setNamedQueries(List<NamedQueryMetadata> namedQueries) {
        this.m_namedQueries = namedQueries;
    }

    public void setNamedStoredFunctionQueries(List<NamedStoredFunctionQueryMetadata> namedStoredFunctionQueries) {
        this.m_namedStoredFunctionQueries = namedStoredFunctionQueries;
    }

    public void setNamedStoredProcedureQueries(List<NamedStoredProcedureQueryMetadata> namedStoredProcedureQueries) {
        this.m_namedStoredProcedureQueries = namedStoredProcedureQueries;
    }

    public void setObjectTypeConverters(List<ObjectTypeConverterMetadata> objectTypeConverters) {
        this.m_objectTypeConverters = objectTypeConverters;
    }

    public void setPackage(String pkg) {
        this.m_package = pkg;
    }

    public void setPartitioning(List<PartitioningMetadata> partitioning) {
        this.m_partitioning = partitioning;
    }

    public void setPersistenceUnitMetadata(XMLPersistenceUnitMetadata persistenceUnitMetadata) {
        this.m_persistenceUnitMetadata = persistenceUnitMetadata;
    }

    public void setPinnedPartitioning(List<PinnedPartitioningMetadata> pinnedPartitioning) {
        this.m_pinnedPartitioning = pinnedPartitioning;
    }

    public void setOracleArrayTypes(List<OracleArrayTypeMetadata> arrayTypes) {
        this.m_oracleArrayTypes = arrayTypes;
    }

    public void setOracleObjectTypes(List<OracleObjectTypeMetadata> objectTypes) {
        this.m_oracleObjectTypes = objectTypes;
    }

    public void setPLSQLRecords(List<PLSQLRecordMetadata> records) {
        this.m_plsqlRecords = records;
    }

    public void setPLSQLTables(List<PLSQLTableMetadata> tables) {
        this.m_plsqlTables = tables;
    }

    @Override
    public void setProject(MetadataProject project) {
        this.m_project = project;
    }

    public void setRangePartitioning(List<RangePartitioningMetadata> rangePartitioning) {
        this.m_rangePartitioning = rangePartitioning;
    }

    public void setReplicationPartitioning(List<ReplicationPartitioningMetadata> replicationPartitioning) {
        this.m_replicationPartitioning = replicationPartitioning;
    }

    public void setRoundRobinPartitioning(List<RoundRobinPartitioningMetadata> roundRobinPartitioning) {
        this.m_roundRobinPartitioning = roundRobinPartitioning;
    }

    public void setSchema(String schema) {
        this.m_schema = schema;
    }

    public void setSequenceGenerators(List<SequenceGeneratorMetadata> sequenceGenerators) {
        this.m_sequenceGenerators = sequenceGenerators;
    }

    public void setSqlResultSetMappings(List<SQLResultSetMappingMetadata> sqlResultSetMappings) {
        this.m_sqlResultSetMappings = sqlResultSetMappings;
    }

    public void setStructConverters(List<StructConverterMetadata> structConverters) {
        this.m_structConverters = structConverters;
    }

    public void setTableGenerators(List<TableGeneratorMetadata> tableGenerators) {
        this.m_tableGenerators = tableGenerators;
    }

    public void setTenantDiscriminatorColumns(List<TenantDiscriminatorColumnMetadata> tenantDiscriminatorColumns) {
        this.m_tenantDiscriminatorColumns = tenantDiscriminatorColumns;
    }

    public void setTypeConverters(List<TypeConverterMetadata> typeConverters) {
        this.m_typeConverters = typeConverters;
    }

    public void setSerializedConverters(List<SerializedConverterMetadata> serializedConverters) {
        this.m_serializedConverters = serializedConverters;
    }

    public void setUnionPartitioning(List<UnionPartitioningMetadata> unionPartitioning) {
        this.m_unionPartitioning = unionPartitioning;
    }

    public void setUuidGenerators(List<UuidGeneratorMetadata> uuidGenerators) {
        this.m_uuidGenerators = uuidGenerators;
    }

    public void setValuePartitioning(List<ValuePartitioningMetadata> valuePartitioning) {
        this.m_valuePartitioning = valuePartitioning;
    }

    public void setVersion(String version) {
        this.m_version = version;
    }
}

