/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Tuple;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.expressions.ArgumentListFunctionExpression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.jpa.metamodel.TypeImpl;
import org.eclipse.persistence.internal.jpa.querydef.AbstractQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicCollectionJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicListJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicMapJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicSetJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.CollectionJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.CompoundExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.CompoundSelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.ConstructorSelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaDeleteImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaUpdateImpl;
import org.eclipse.persistence.internal.jpa.querydef.ExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.FromImpl;
import org.eclipse.persistence.internal.jpa.querydef.FunctionExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.InImpl;
import org.eclipse.persistence.internal.jpa.querydef.InternalExpression;
import org.eclipse.persistence.internal.jpa.querydef.InternalSelection;
import org.eclipse.persistence.internal.jpa.querydef.JoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.ListJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.MapJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.OrderImpl;
import org.eclipse.persistence.internal.jpa.querydef.ParameterExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.PathImpl;
import org.eclipse.persistence.internal.jpa.querydef.PredicateImpl;
import org.eclipse.persistence.internal.jpa.querydef.RootImpl;
import org.eclipse.persistence.internal.jpa.querydef.SelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.SetJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.SubQueryImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.jpa.JpaCriteriaBuilder;
import org.eclipse.persistence.queries.ReportQuery;

public class CriteriaBuilderImpl
implements JpaCriteriaBuilder,
Serializable {
    public static final String CONCAT = "concat";
    public static final String SIZE = "size";
    protected Metamodel metamodel;

    public CriteriaBuilderImpl(Metamodel metamodel) {
        this.metamodel = metamodel;
    }

    @Override
    public CriteriaQuery<Object> createQuery() {
        return new CriteriaQueryImpl<Object>(this.metamodel, AbstractQueryImpl.ResultType.UNKNOWN, ClassConstants.OBJECT, this);
    }

    @Override
    public <T> CriteriaQuery<T> createQuery(Class<T> resultClass) {
        if (resultClass == null) {
            return this.createQuery();
        }
        if (resultClass.equals(Tuple.class)) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.TUPLE, resultClass, this);
        }
        if (resultClass.equals(ClassConstants.AOBJECT)) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.OBJECT_ARRAY, resultClass, this);
        }
        if (resultClass.isArray()) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.OBJECT_ARRAY, resultClass, this);
        }
        if (resultClass.equals(ClassConstants.OBJECT)) {
            return this.createQuery();
        }
        if (resultClass.isPrimitive() || resultClass.equals(ClassConstants.STRING) || BasicTypeHelperImpl.getInstance().isWrapperClass(resultClass) || BasicTypeHelperImpl.getInstance().isDateClass(resultClass)) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.OTHER, resultClass, this);
        }
        TypeImpl<T> type = ((MetamodelImpl)this.metamodel).getType(resultClass);
        if (type != null && type.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.ENTITY, resultClass, this);
        }
        return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.CONSTRUCTOR, resultClass, this);
    }

    @Override
    public CriteriaQuery<Tuple> createTupleQuery() {
        return new CriteriaQueryImpl<Tuple>(this.metamodel, AbstractQueryImpl.ResultType.TUPLE, Tuple.class, this);
    }

    @Override
    public <Y> CompoundSelection<Y> construct(Class<Y> result, Selection<?> ... selections) {
        return new ConstructorSelectionImpl(result, selections);
    }

    @Override
    public CompoundSelection<Tuple> tuple(Selection<?> ... selections) {
        return new CompoundSelectionImpl(Tuple.class, selections, true);
    }

    @Override
    public CompoundSelection<Object[]> array(Selection<?> ... selections) {
        return new CompoundSelectionImpl(ClassConstants.AOBJECT, selections, true);
    }

    @Override
    public Order asc(javax.persistence.criteria.Expression<?> x2) {
        if (((InternalSelection)((Object)x2)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new OrderImpl(x2);
    }

    @Override
    public Order desc(javax.persistence.criteria.Expression<?> x2) {
        if (((InternalSelection)((Object)x2)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        OrderImpl order = new OrderImpl(x2, false);
        return order;
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<Double> avg(javax.persistence.criteria.Expression<N> x2) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ((InternalSelection)((Object)x2)).getCurrentNode().average(), this.buildList(x2), "AVG");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> sum(javax.persistence.criteria.Expression<N> x2) {
        return new FunctionExpressionImpl(this.metamodel, x2.getJavaType(), ((InternalSelection)((Object)x2)).getCurrentNode().sum(), this.buildList(x2), "SUM");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> max(javax.persistence.criteria.Expression<N> x2) {
        return new FunctionExpressionImpl(this.metamodel, x2.getJavaType(), ((InternalSelection)((Object)x2)).getCurrentNode().maximum(), this.buildList(x2), "MAX");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> min(javax.persistence.criteria.Expression<N> x2) {
        return new FunctionExpressionImpl(this.metamodel, x2.getJavaType(), ((InternalSelection)((Object)x2)).getCurrentNode().minimum(), this.buildList(x2), "MIN");
    }

    @Override
    public <X extends Comparable<? super X>> javax.persistence.criteria.Expression<X> greatest(javax.persistence.criteria.Expression<X> x2) {
        if (((InternalSelection)((Object)x2)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new ExpressionImpl(this.metamodel, x2.getJavaType(), ((InternalSelection)((Object)x2)).getCurrentNode().maximum());
    }

    @Override
    public <X extends Comparable<? super X>> javax.persistence.criteria.Expression<X> least(javax.persistence.criteria.Expression<X> x2) {
        if (((InternalSelection)((Object)x2)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new ExpressionImpl(this.metamodel, x2.getJavaType(), ((InternalSelection)((Object)x2)).getCurrentNode().minimum());
    }

    @Override
    public javax.persistence.criteria.Expression<Long> count(javax.persistence.criteria.Expression<?> x2) {
        if (((InternalSelection)((Object)x2)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new FunctionExpressionImpl<Long>(this.metamodel, ClassConstants.LONG, ((InternalSelection)((Object)x2)).getCurrentNode().count(), this.buildList(x2), "COUNT");
    }

    @Override
    public javax.persistence.criteria.Expression<Long> countDistinct(javax.persistence.criteria.Expression<?> x2) {
        if (((InternalSelection)((Object)x2)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new FunctionExpressionImpl<Long>(this.metamodel, ClassConstants.LONG, ((InternalSelection)((Object)x2)).getCurrentNode().distinct().count(), this.buildList(x2), "COUNT");
    }

    @Override
    public Predicate exists(Subquery<?> subquery) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionOperator.getOperator(86).expressionFor(((SubQueryImpl)subquery).getCurrentNode()), this.buildList(subquery), "exists");
    }

    @Override
    public <Y> javax.persistence.criteria.Expression<Y> all(Subquery<Y> subquery) {
        return new FunctionExpressionImpl(this.metamodel, subquery.getJavaType(), new ExpressionBuilder().all(((InternalSelection)((Object)subquery)).getCurrentNode()), this.buildList(subquery), "all");
    }

    @Override
    public <Y> javax.persistence.criteria.Expression<Y> some(Subquery<Y> subquery) {
        return new FunctionExpressionImpl(this.metamodel, subquery.getJavaType(), new ExpressionBuilder().some(((InternalSelection)((Object)subquery)).getCurrentNode()), this.buildList(subquery), "some");
    }

    @Override
    public <Y> javax.persistence.criteria.Expression<Y> any(Subquery<Y> subquery) {
        return new FunctionExpressionImpl(this.metamodel, subquery.getJavaType(), new ExpressionBuilder().any(((InternalSelection)((Object)subquery)).getCurrentNode()), this.buildList(subquery), "any");
    }

    @Override
    public Predicate and(javax.persistence.criteria.Expression<Boolean> x2, javax.persistence.criteria.Expression<Boolean> y2) {
        CompoundExpressionImpl xp = null;
        CompoundExpressionImpl yp = null;
        xp = ((InternalExpression)((Object)x2)).isExpression() ? (CompoundExpressionImpl)this.isTrue(x2) : (CompoundExpressionImpl)x2;
        yp = ((InternalExpression)((Object)y2)).isExpression() ? (CompoundExpressionImpl)this.isTrue(y2) : (CompoundExpressionImpl)y2;
        if (yp.isJunction()) {
            if (((PredicateImpl)yp).getJunctionValue().booleanValue()) {
                return xp;
            }
            return yp;
        }
        if (xp.isJunction()) {
            if (((PredicateImpl)xp).getJunctionValue().booleanValue()) {
                return yp;
            }
            return xp;
        }
        Expression currentNode = xp.getCurrentNode().and(yp.getCurrentNode());
        xp.setParentNode(currentNode);
        yp.setParentNode(currentNode);
        return new PredicateImpl(this.metamodel, currentNode, this.buildList(xp, yp), Predicate.BooleanOperator.AND);
    }

    @Override
    public Predicate or(javax.persistence.criteria.Expression<Boolean> x2, javax.persistence.criteria.Expression<Boolean> y2) {
        CompoundExpressionImpl xp = null;
        CompoundExpressionImpl yp = null;
        xp = ((InternalExpression)((Object)x2)).isExpression() ? (CompoundExpressionImpl)this.isTrue(x2) : (CompoundExpressionImpl)x2;
        yp = ((InternalExpression)((Object)y2)).isExpression() ? (CompoundExpressionImpl)this.isTrue(y2) : (CompoundExpressionImpl)y2;
        if (yp.isJunction()) {
            if (((PredicateImpl)yp).getJunctionValue().booleanValue()) {
                return yp;
            }
            return xp;
        }
        if (xp.isJunction()) {
            if (((PredicateImpl)xp).getJunctionValue().booleanValue()) {
                return xp;
            }
            return yp;
        }
        Expression parentNode = xp.getCurrentNode().or(yp.getCurrentNode());
        xp.setParentNode(parentNode);
        yp.setParentNode(parentNode);
        return new PredicateImpl(this.metamodel, parentNode, this.buildList(xp, yp), Predicate.BooleanOperator.OR);
    }

    @Override
    public Predicate and(Predicate ... restrictions) {
        int max = restrictions.length;
        if (max == 0) {
            return this.conjunction();
        }
        Predicate a2 = restrictions[0];
        int i2 = 1;
        while (i2 < max) {
            a2 = this.and((javax.persistence.criteria.Expression<Boolean>)a2, (javax.persistence.criteria.Expression<Boolean>)restrictions[i2]);
            ++i2;
        }
        return a2;
    }

    @Override
    public Predicate or(Predicate ... restrictions) {
        int max = restrictions.length;
        if (max == 0) {
            return this.disjunction();
        }
        Predicate a2 = restrictions[0];
        int i2 = 1;
        while (i2 < max) {
            a2 = this.or((javax.persistence.criteria.Expression<Boolean>)a2, (javax.persistence.criteria.Expression<Boolean>)restrictions[i2]);
            ++i2;
        }
        return a2;
    }

    @Override
    public Predicate not(javax.persistence.criteria.Expression<Boolean> restriction) {
        if (((InternalExpression)((Object)restriction)).isPredicate()) {
            return ((Predicate)restriction).not();
        }
        Expression parentNode = null;
        List<javax.persistence.criteria.Expression<?>> compoundExpressions = null;
        String name = "not";
        if (((InternalExpression)((Object)restriction)).isCompoundExpression() && ((CompoundExpressionImpl)restriction).getOperation().equals("exists")) {
            FunctionExpression exp = (FunctionExpression)((InternalSelection)((Object)restriction)).getCurrentNode();
            SubSelectExpression sub = (SubSelectExpression)exp.getChildren().get(0);
            parentNode = ExpressionOperator.getOperator(88).expressionFor(sub);
            name = "notExists";
            compoundExpressions = ((CompoundExpressionImpl)restriction).getChildExpressions();
        } else {
            parentNode = ((InternalSelection)((Object)restriction)).getCurrentNode().not();
            compoundExpressions = this.buildList(restriction);
        }
        CompoundExpressionImpl expr = new CompoundExpressionImpl(this.metamodel, parentNode, compoundExpressions, name);
        expr.setIsNegated(true);
        return expr;
    }

    @Override
    public Predicate conjunction() {
        return new PredicateImpl(this.metamodel, null, null, Predicate.BooleanOperator.AND);
    }

    @Override
    public Predicate disjunction() {
        return new PredicateImpl(this.metamodel, null, null, Predicate.BooleanOperator.OR);
    }

    @Override
    public Predicate isTrue(javax.persistence.criteria.Expression<Boolean> x2) {
        if (((InternalExpression)((Object)x2)).isPredicate()) {
            if (((InternalSelection)((Object)x2)).getCurrentNode() == null) {
                return (Predicate)x2;
            }
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("PREDICATE_PASSED_TO_EVALUATION"));
        }
        ArrayList list = new ArrayList();
        list.add(x2);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().equal(true), list, "equals");
    }

    @Override
    public Predicate isFalse(javax.persistence.criteria.Expression<Boolean> x2) {
        if (((InternalExpression)((Object)x2)).isPredicate()) {
            if (((InternalSelection)((Object)x2)).getCurrentNode() == null) {
                if (((Predicate)x2).getOperator() == Predicate.BooleanOperator.AND) {
                    return (Predicate)x2;
                }
                return this.conjunction();
            }
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("PREDICATE_PASSED_TO_EVALUATION"));
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().equal(false), this.buildList(x2), "equals");
    }

    @Override
    public Predicate isNull(javax.persistence.criteria.Expression<?> x2) {
        return new PredicateImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().isNull(), new ArrayList(), Predicate.BooleanOperator.AND);
    }

    @Override
    public Predicate isNotNull(javax.persistence.criteria.Expression<?> x2) {
        return new PredicateImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().notNull(), new ArrayList(), Predicate.BooleanOperator.AND);
    }

    @Override
    public Predicate equal(javax.persistence.criteria.Expression<?> x2, javax.persistence.criteria.Expression<?> y2) {
        ArrayList list = new ArrayList();
        list.add(x2);
        list.add(y2);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().equal(((InternalSelection)((Object)y2)).getCurrentNode()), list, "equals");
    }

    @Override
    public Predicate notEqual(javax.persistence.criteria.Expression<?> x2, javax.persistence.criteria.Expression<?> y2) {
        if (((InternalSelection)((Object)x2)).getCurrentNode() == null || ((InternalSelection)((Object)y2)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x2);
        list.add(y2);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().notEqual(((InternalSelection)((Object)y2)).getCurrentNode()), list, "not equal");
    }

    @Override
    public Predicate equal(javax.persistence.criteria.Expression<?> x2, Object y2) {
        if (((InternalSelection)((Object)x2)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        if (y2 instanceof ParameterExpression) {
            return this.equal(x2, (ParameterExpression)y2);
        }
        ArrayList list = new ArrayList();
        list.add(x2);
        list.add(this.internalLiteral(y2));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().equal(y2), list, "equal");
    }

    @Override
    public Predicate notEqual(javax.persistence.criteria.Expression<?> x2, Object y2) {
        if (((InternalSelection)((Object)x2)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        if (y2 instanceof ParameterExpression) {
            return this.notEqual(x2, (ParameterExpression)y2);
        }
        ArrayList list = new ArrayList();
        list.add(x2);
        list.add(this.internalLiteral(y2));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().notEqual(y2), list, "not equal");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate greaterThan(javax.persistence.criteria.Expression<? extends Y> x2, javax.persistence.criteria.Expression<? extends Y> y2) {
        if (((InternalSelection)((Object)x2)).getCurrentNode() == null || ((InternalSelection)((Object)y2)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x2);
        list.add(y2);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().greaterThan(((InternalSelection)((Object)y2)).getCurrentNode()), list, "greaterThan");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate lessThan(javax.persistence.criteria.Expression<? extends Y> x2, javax.persistence.criteria.Expression<? extends Y> y2) {
        if (((InternalSelection)((Object)x2)).getCurrentNode() == null || ((InternalSelection)((Object)y2)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().lessThan(((InternalSelection)((Object)y2)).getCurrentNode()), this.buildList(x2, y2), "lessThan");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(javax.persistence.criteria.Expression<? extends Y> x2, javax.persistence.criteria.Expression<? extends Y> y2) {
        if (((ExpressionImpl)x2).getCurrentNode() == null || ((ExpressionImpl)y2).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x2);
        list.add(y2);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x2).getCurrentNode().greaterThanEqual(((ExpressionImpl)y2).getCurrentNode()), list, "greaterThanEqual");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(javax.persistence.criteria.Expression<? extends Y> x2, javax.persistence.criteria.Expression<? extends Y> y2) {
        if (((ExpressionImpl)x2).getCurrentNode() == null || ((ExpressionImpl)y2).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x2);
        list.add(y2);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x2).getCurrentNode().lessThanEqual(((ExpressionImpl)y2).getCurrentNode()), list, "lessThanEqual");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate between(javax.persistence.criteria.Expression<? extends Y> v2, javax.persistence.criteria.Expression<? extends Y> x2, javax.persistence.criteria.Expression<? extends Y> y2) {
        ArrayList list = new ArrayList();
        list.add(v2);
        list.add(x2);
        list.add(y2);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)v2).getCurrentNode().between(((ExpressionImpl)x2).getCurrentNode(), ((ExpressionImpl)y2).getCurrentNode()), list, "between");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate greaterThan(javax.persistence.criteria.Expression<? extends Y> x2, Y y2) {
        javax.persistence.criteria.Expression<Y> expressionY = this.internalLiteral(y2);
        if (((ExpressionImpl)x2).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x2);
        list.add(expressionY);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x2).getCurrentNode().greaterThan(((ExpressionImpl)expressionY).getCurrentNode()), list, "greaterThan");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate lessThan(javax.persistence.criteria.Expression<? extends Y> x2, Y y2) {
        javax.persistence.criteria.Expression<Y> expressionY = this.internalLiteral(y2);
        if (((ExpressionImpl)x2).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x2);
        list.add(expressionY);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x2).getCurrentNode().lessThan(((ExpressionImpl)expressionY).getCurrentNode()), list, "lessThan");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(javax.persistence.criteria.Expression<? extends Y> x2, Y y2) {
        javax.persistence.criteria.Expression<Y> expressionY = this.internalLiteral(y2);
        if (((ExpressionImpl)x2).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x2);
        list.add(expressionY);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x2).getCurrentNode().greaterThanEqual(((ExpressionImpl)expressionY).getCurrentNode()), list, "greaterThanEqual");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(javax.persistence.criteria.Expression<? extends Y> x2, Y y2) {
        javax.persistence.criteria.Expression<Y> expressionY = this.internalLiteral(y2);
        if (((ExpressionImpl)x2).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x2);
        list.add(expressionY);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x2).getCurrentNode().lessThanEqual(((ExpressionImpl)expressionY).getCurrentNode()), list, "lessThanEqual");
    }

    @Override
    public <Y extends Comparable<? super Y>> Predicate between(javax.persistence.criteria.Expression<? extends Y> v2, Y x2, Y y2) {
        ArrayList list = new ArrayList();
        list.add(v2);
        list.add(this.internalLiteral(x2));
        list.add(this.internalLiteral(y2));
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)v2).getCurrentNode().between(x2, y2), list, "between");
    }

    protected List<javax.persistence.criteria.Expression<?>> buildList(javax.persistence.criteria.Expression<?> ... expressions) {
        ArrayList list = new ArrayList();
        javax.persistence.criteria.Expression<?>[] expressionArray = expressions;
        int n2 = expressions.length;
        int n3 = 0;
        while (n3 < n2) {
            javax.persistence.criteria.Expression<?> exp = expressionArray[n3];
            list.add(exp);
            ++n3;
        }
        return list;
    }

    @Override
    public Predicate gt(javax.persistence.criteria.Expression<? extends Number> x2, javax.persistence.criteria.Expression<? extends Number> y2) {
        ArrayList list = new ArrayList();
        list.add(x2);
        list.add(y2);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().greaterThan(((InternalSelection)((Object)y2)).getCurrentNode()), list, "gt");
    }

    @Override
    public Predicate lt(javax.persistence.criteria.Expression<? extends Number> x2, javax.persistence.criteria.Expression<? extends Number> y2) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().lessThan(((InternalSelection)((Object)y2)).getCurrentNode()), this.buildList(x2, y2), "lessThan");
    }

    @Override
    public Predicate ge(javax.persistence.criteria.Expression<? extends Number> x2, javax.persistence.criteria.Expression<? extends Number> y2) {
        ArrayList list = new ArrayList();
        list.add(x2);
        list.add(y2);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().greaterThanEqual(((InternalSelection)((Object)y2)).getCurrentNode()), list, "ge");
    }

    @Override
    public Predicate le(javax.persistence.criteria.Expression<? extends Number> x2, javax.persistence.criteria.Expression<? extends Number> y2) {
        ArrayList list = new ArrayList();
        list.add(x2);
        list.add(y2);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().lessThanEqual(((InternalSelection)((Object)y2)).getCurrentNode()), list, "le");
    }

    @Override
    public Predicate gt(javax.persistence.criteria.Expression<? extends Number> x2, Number y2) {
        ArrayList list = new ArrayList();
        list.add(x2);
        list.add(this.internalLiteral(y2));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().greaterThan(y2), list, "gt");
    }

    @Override
    public Predicate lt(javax.persistence.criteria.Expression<? extends Number> x2, Number y2) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().lessThan(y2), this.buildList(x2, this.internalLiteral(y2)), "lt");
    }

    @Override
    public Predicate ge(javax.persistence.criteria.Expression<? extends Number> x2, Number y2) {
        ArrayList list = new ArrayList();
        list.add(x2);
        list.add(this.internalLiteral(y2));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().greaterThanEqual(y2), list, "ge");
    }

    @Override
    public Predicate le(javax.persistence.criteria.Expression<? extends Number> x2, Number y2) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().lessThanEqual(y2), this.buildList(x2, this.internalLiteral(y2)), "le");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> neg(javax.persistence.criteria.Expression<N> x2) {
        return new FunctionExpressionImpl(this.metamodel, ClassConstants.INTEGER, ExpressionMath.negate(((InternalSelection)((Object)x2)).getCurrentNode()), this.buildList(x2), "neg");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> abs(javax.persistence.criteria.Expression<N> x2) {
        return new FunctionExpressionImpl(this.metamodel, x2.getJavaType(), ExpressionMath.abs(((InternalSelection)((Object)x2)).getCurrentNode()), this.buildList(x2), "ABS");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> sum(javax.persistence.criteria.Expression<? extends N> x2, javax.persistence.criteria.Expression<? extends N> y2) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x2.getJavaType(), y2.getJavaType()), ExpressionMath.add(((InternalSelection)((Object)x2)).getCurrentNode(), ((InternalSelection)((Object)y2)).getCurrentNode()), this.buildList(x2, y2), "sum");
    }

    @Override
    public javax.persistence.criteria.Expression<Long> sumAsLong(javax.persistence.criteria.Expression<Integer> x2) {
        return new FunctionExpressionImpl<Long>(this.metamodel, ClassConstants.LONG, ((InternalSelection)((Object)x2)).getCurrentNode().sum(), this.buildList(x2), "SUM");
    }

    @Override
    public javax.persistence.criteria.Expression<Double> sumAsDouble(javax.persistence.criteria.Expression<Float> x2) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ((InternalSelection)((Object)x2)).getCurrentNode().sum(), this.buildList(x2), "SUM");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> prod(javax.persistence.criteria.Expression<? extends N> x2, javax.persistence.criteria.Expression<? extends N> y2) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x2.getJavaType(), y2.getJavaType()), ExpressionMath.multiply(((InternalSelection)((Object)x2)).getCurrentNode(), ((InternalSelection)((Object)y2)).getCurrentNode()), this.buildList(x2, y2), "prod");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> diff(javax.persistence.criteria.Expression<? extends N> x2, javax.persistence.criteria.Expression<? extends N> y2) {
        ArrayList list = new ArrayList();
        list.add(x2);
        list.add(y2);
        return new FunctionExpressionImpl(this.metamodel, x2.getJavaType(), ExpressionMath.subtract(((InternalSelection)((Object)x2)).getCurrentNode(), ((InternalSelection)((Object)y2)).getCurrentNode()), list, "diff");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> sum(javax.persistence.criteria.Expression<? extends N> x2, N y2) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x2.getJavaType(), y2.getClass()), ExpressionMath.add(((InternalSelection)((Object)x2)).getCurrentNode(), y2), this.buildList(x2, this.internalLiteral(y2)), "sum");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> prod(javax.persistence.criteria.Expression<? extends N> x2, N y2) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x2.getJavaType(), y2.getClass()), ExpressionMath.multiply(((InternalSelection)((Object)x2)).getCurrentNode(), y2), this.buildList(x2, this.internalLiteral(y2)), "prod");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> diff(javax.persistence.criteria.Expression<? extends N> x2, N y2) {
        ArrayList list = new ArrayList();
        list.add(x2);
        list.add(this.internalLiteral(y2));
        return new FunctionExpressionImpl(this.metamodel, y2.getClass(), ExpressionMath.subtract(((InternalSelection)((Object)x2)).getCurrentNode(), y2), list, "diff");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> sum(N x2, javax.persistence.criteria.Expression<? extends N> y2) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x2.getClass(), y2.getJavaType()), ExpressionMath.add((Expression)new ConstantExpression(x2, ((InternalSelection)((Object)y2)).getCurrentNode()), ((InternalSelection)((Object)y2)).getCurrentNode()), this.buildList(this.internalLiteral(x2), y2), "sum");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> prod(N x2, javax.persistence.criteria.Expression<? extends N> y2) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x2.getClass(), y2.getJavaType()), ExpressionMath.multiply((Expression)new ConstantExpression(x2, ((InternalSelection)((Object)y2)).getCurrentNode()), ((InternalSelection)((Object)y2)).getCurrentNode()), this.buildList(this.internalLiteral(x2), y2), "prod");
    }

    @Override
    public <N extends Number> javax.persistence.criteria.Expression<N> diff(N x2, javax.persistence.criteria.Expression<? extends N> y2) {
        ArrayList list = new ArrayList();
        ExpressionImpl literal = (ExpressionImpl)this.internalLiteral(x2);
        list.add(literal);
        list.add(y2);
        return new FunctionExpressionImpl(this.metamodel, literal.getJavaType(), ExpressionMath.subtract(literal.getCurrentNode(), ((InternalSelection)((Object)y2)).getCurrentNode()), list, "diff");
    }

    @Override
    public javax.persistence.criteria.Expression<Number> quot(javax.persistence.criteria.Expression<? extends Number> x2, javax.persistence.criteria.Expression<? extends Number> y2) {
        return new FunctionExpressionImpl<Number>(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x2.getJavaType(), y2.getClass()), ExpressionMath.divide(((InternalSelection)((Object)x2)).getCurrentNode(), ((InternalSelection)((Object)y2)).getCurrentNode()), this.buildList(x2, y2), "quot");
    }

    @Override
    public javax.persistence.criteria.Expression<Number> quot(javax.persistence.criteria.Expression<? extends Number> x2, Number y2) {
        return new FunctionExpressionImpl<Number>(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x2.getJavaType(), y2.getClass()), ExpressionMath.divide(((InternalSelection)((Object)x2)).getCurrentNode(), y2), this.buildList(x2, this.internalLiteral(y2)), "quot");
    }

    @Override
    public javax.persistence.criteria.Expression<Number> quot(Number x2, javax.persistence.criteria.Expression<? extends Number> y2) {
        return new FunctionExpressionImpl<Number>(this.metamodel, ClassConstants.NUMBER, ExpressionMath.divide((Expression)new ConstantExpression(x2, ((InternalSelection)((Object)y2)).getCurrentNode()), ((InternalSelection)((Object)y2)).getCurrentNode()), this.buildList(this.internalLiteral(x2), y2), "quot");
    }

    @Override
    public javax.persistence.criteria.Expression<Integer> mod(javax.persistence.criteria.Expression<Integer> x2, javax.persistence.criteria.Expression<Integer> y2) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionMath.mod(((InternalSelection)((Object)x2)).getCurrentNode(), ((InternalSelection)((Object)y2)).getCurrentNode()), this.buildList(x2, y2), "mod");
    }

    @Override
    public javax.persistence.criteria.Expression<Integer> mod(javax.persistence.criteria.Expression<Integer> x2, Integer y2) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionMath.mod(((InternalSelection)((Object)x2)).getCurrentNode(), y2), this.buildList(x2, this.internalLiteral(y2)), "mod");
    }

    @Override
    public javax.persistence.criteria.Expression<Integer> mod(Integer x2, javax.persistence.criteria.Expression<Integer> y2) {
        javax.persistence.criteria.Expression<Integer> xExp = this.internalLiteral(x2);
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionMath.mod(((InternalSelection)((Object)xExp)).getCurrentNode(), ((InternalSelection)((Object)y2)).getCurrentNode()), this.buildList(xExp, y2), "mod");
    }

    @Override
    public javax.persistence.criteria.Expression<Double> sqrt(javax.persistence.criteria.Expression<? extends Number> x2) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ExpressionMath.sqrt(((InternalSelection)((Object)x2)).getCurrentNode()), this.buildList(x2), "sqrt");
    }

    @Override
    public javax.persistence.criteria.Expression<Long> toLong(javax.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    @Override
    public javax.persistence.criteria.Expression<Integer> toInteger(javax.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    @Override
    public javax.persistence.criteria.Expression<Float> toFloat(javax.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    @Override
    public javax.persistence.criteria.Expression<Double> toDouble(javax.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    @Override
    public javax.persistence.criteria.Expression<BigDecimal> toBigDecimal(javax.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    @Override
    public javax.persistence.criteria.Expression<BigInteger> toBigInteger(javax.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    @Override
    public javax.persistence.criteria.Expression<String> toString(javax.persistence.criteria.Expression<Character> character) {
        ExpressionImpl impl = (ExpressionImpl)character;
        return impl;
    }

    @Override
    public <T> javax.persistence.criteria.Expression<T> literal(T value) {
        if (value == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("jpa_criteriaapi_null_literal_value", new Object[0]));
        }
        return new ExpressionImpl(this.metamodel, value.getClass(), new ConstantExpression(value, new ExpressionBuilder()), value);
    }

    @Override
    public <T> javax.persistence.criteria.Expression<T> nullLiteral(Class<T> resultClass) {
        return new ExpressionImpl<T>(this.metamodel, resultClass, new ConstantExpression(null, new ExpressionBuilder()), null);
    }

    protected <T> javax.persistence.criteria.Expression<T> internalLiteral(T value) {
        return new ExpressionImpl(this.metamodel, value == null ? null : value.getClass(), new ConstantExpression(value, new ExpressionBuilder()), value);
    }

    @Override
    public <T> ParameterExpression<T> parameter(Class<T> paramClass) {
        return new ParameterExpressionImpl<T>(this.metamodel, paramClass);
    }

    @Override
    public <T> ParameterExpression<T> parameter(Class<T> paramClass, String name) {
        return new ParameterExpressionImpl<T>(this.metamodel, paramClass, name);
    }

    @Override
    public <C extends Collection<?>> Predicate isEmpty(javax.persistence.criteria.Expression<C> collection) {
        if (((InternalExpression)((Object)collection)).isLiteral()) {
            if (((Collection)((ConstantExpression)((InternalSelection)((Object)collection)).getCurrentNode()).getValue()).isEmpty()) {
                return this.conjunction();
            }
            return this.disjunction();
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)collection)).getCurrentNode().size(ClassConstants.INTEGER).equal(0), this.buildList(collection), "isEmpty");
    }

    @Override
    public <C extends Collection<?>> Predicate isNotEmpty(javax.persistence.criteria.Expression<C> collection) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)collection)).getCurrentNode().size(ClassConstants.INTEGER).equal(0).not(), this.buildList(collection), "isNotEmpty");
    }

    @Override
    public <C extends Collection<?>> javax.persistence.criteria.Expression<Integer> size(C collection) {
        return this.internalLiteral(collection.size());
    }

    @Override
    public <C extends Collection<?>> javax.persistence.criteria.Expression<Integer> size(javax.persistence.criteria.Expression<C> collection) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)((Object)collection)).getCurrentNode().size(ClassConstants.INTEGER), this.buildList(collection), SIZE);
    }

    @Override
    public <E, C extends Collection<E>> Predicate isMember(E elem, javax.persistence.criteria.Expression<C> collection) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)collection)).getCurrentNode().equal(elem), this.buildList(collection, this.internalLiteral(elem)), "isMember");
    }

    @Override
    public <E, C extends Collection<E>> Predicate isNotMember(E elem, javax.persistence.criteria.Expression<C> collection) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)collection)).getCurrentNode().notEqual(elem), this.buildList(collection, this.internalLiteral(elem)), "isMember");
    }

    @Override
    public <E, C extends Collection<E>> Predicate isMember(javax.persistence.criteria.Expression<E> elem, javax.persistence.criteria.Expression<C> collection) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)collection)).getCurrentNode().equal(((InternalSelection)((Object)elem)).getCurrentNode()), this.buildList(collection, elem), "isMember");
    }

    @Override
    public <E, C extends Collection<E>> Predicate isNotMember(javax.persistence.criteria.Expression<E> elem, javax.persistence.criteria.Expression<C> collection) {
        ReportQuery subQuery = new ReportQuery();
        subQuery.setReferenceClass(((ExpressionImpl)elem).getJavaType());
        ExpressionBuilder elemBuilder = new ExpressionBuilder();
        Expression collectionExp = ((InternalSelection)((Object)collection)).getCurrentNode();
        Expression elemExp = ((InternalSelection)((Object)elem)).getCurrentNode();
        subQuery.setExpressionBuilder(elemBuilder);
        subQuery.setShouldRetrieveFirstPrimaryKey(true);
        subQuery.setSelectionCriteria(elemBuilder.equal(collectionExp).and(collectionExp.equal(elemExp)));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)elem)).getCurrentNode().notExists(subQuery), this.buildList(elem, collection), "isNotMemeber");
    }

    @Override
    public <V, M extends Map<?, V>> javax.persistence.criteria.Expression<Collection<V>> values(M map) {
        return this.internalLiteral(map.values());
    }

    @Override
    public <K, M extends Map<K, ?>> javax.persistence.criteria.Expression<Set<K>> keys(M map) {
        return this.internalLiteral(map.keySet());
    }

    @Override
    public Predicate like(javax.persistence.criteria.Expression<String> x2, javax.persistence.criteria.Expression<String> pattern) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x2, pattern);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().like(((InternalSelection)((Object)pattern)).getCurrentNode()), list, "like");
    }

    @Override
    public Predicate like(javax.persistence.criteria.Expression<String> x2, javax.persistence.criteria.Expression<String> pattern, javax.persistence.criteria.Expression<Character> escapeChar) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x2, pattern, escapeChar);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().like(((InternalSelection)((Object)pattern)).getCurrentNode(), ((InternalSelection)((Object)escapeChar)).getCurrentNode()), list, "like");
    }

    @Override
    public Predicate like(javax.persistence.criteria.Expression<String> x2, javax.persistence.criteria.Expression<String> pattern, char escapeChar) {
        return this.like(x2, pattern, this.internalLiteral(Character.valueOf(escapeChar)));
    }

    @Override
    public Predicate like(javax.persistence.criteria.Expression<String> x2, String pattern) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x2, this.internalLiteral(pattern));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().like(pattern), list, "like");
    }

    @Override
    public Predicate like(javax.persistence.criteria.Expression<String> x2, String pattern, javax.persistence.criteria.Expression<Character> escapeChar) {
        return this.like(x2, this.internalLiteral(pattern), escapeChar);
    }

    @Override
    public Predicate like(javax.persistence.criteria.Expression<String> x2, String pattern, char escapeChar) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x2, this.internalLiteral(pattern), this.internalLiteral(Character.valueOf(escapeChar)));
        String escapeString = String.valueOf(escapeChar);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().like(pattern, escapeString), list, "like");
    }

    @Override
    public Predicate notLike(javax.persistence.criteria.Expression<String> x2, javax.persistence.criteria.Expression<String> pattern) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x2, pattern);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().notLike(((InternalSelection)((Object)pattern)).getCurrentNode()), list, "notLike");
    }

    @Override
    public Predicate notLike(javax.persistence.criteria.Expression<String> x2, javax.persistence.criteria.Expression<String> pattern, javax.persistence.criteria.Expression<Character> escapeChar) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x2, pattern, escapeChar);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().notLike(((InternalSelection)((Object)pattern)).getCurrentNode(), ((InternalSelection)((Object)escapeChar)).getCurrentNode()), list, "like");
    }

    @Override
    public Predicate notLike(javax.persistence.criteria.Expression<String> x2, javax.persistence.criteria.Expression<String> pattern, char escapeChar) {
        return this.notLike(x2, pattern, this.internalLiteral(Character.valueOf(escapeChar)));
    }

    @Override
    public Predicate notLike(javax.persistence.criteria.Expression<String> x2, String pattern) {
        ArrayList list = new ArrayList();
        list.add(x2);
        list.add(this.internalLiteral(pattern));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x2)).getCurrentNode().notLike(pattern), list, "notLike");
    }

    @Override
    public Predicate notLike(javax.persistence.criteria.Expression<String> x2, String pattern, javax.persistence.criteria.Expression<Character> escapeChar) {
        return this.notLike(x2, this.internalLiteral(pattern), escapeChar);
    }

    @Override
    public Predicate notLike(javax.persistence.criteria.Expression<String> x2, String pattern, char escapeChar) {
        return this.notLike(x2, this.internalLiteral(pattern), this.internalLiteral(Character.valueOf(escapeChar)));
    }

    @Override
    public javax.persistence.criteria.Expression<String> concat(javax.persistence.criteria.Expression<String> x2, javax.persistence.criteria.Expression<String> y2) {
        ArrayList list = new ArrayList();
        list.add(x2);
        list.add(y2);
        Expression xNode = ((InternalSelection)((Object)x2)).getCurrentNode();
        Expression yNode = ((InternalSelection)((Object)y2)).getCurrentNode();
        if (xNode.isParameterExpression() && yNode.isParameterExpression()) {
            ((org.eclipse.persistence.internal.expressions.ParameterExpression)xNode).setType(ClassConstants.STRING);
        }
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, xNode.concat(yNode), list, CONCAT);
    }

    @Override
    public javax.persistence.criteria.Expression<String> concat(javax.persistence.criteria.Expression<String> x2, String y2) {
        ArrayList list = new ArrayList();
        list.add(x2);
        list.add(this.internalLiteral(y2));
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x2)).getCurrentNode().concat(y2), list, CONCAT);
    }

    @Override
    public javax.persistence.criteria.Expression<String> concat(String x2, javax.persistence.criteria.Expression<String> y2) {
        ArrayList list = new ArrayList();
        ExpressionImpl literal = (ExpressionImpl)this.internalLiteral(x2);
        list.add(literal);
        list.add(y2);
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, literal.getCurrentNode().concat(((InternalSelection)((Object)y2)).getCurrentNode()), list, CONCAT);
    }

    @Override
    public javax.persistence.criteria.Expression<String> substring(javax.persistence.criteria.Expression<String> x2, javax.persistence.criteria.Expression<Integer> from) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x2)).getCurrentNode().substring(((InternalSelection)((Object)from)).getCurrentNode()), this.buildList(x2, from), "subString");
    }

    @Override
    public javax.persistence.criteria.Expression<String> substring(javax.persistence.criteria.Expression<String> x2, int from) {
        return this.substring(x2, this.internalLiteral(from));
    }

    @Override
    public javax.persistence.criteria.Expression<String> substring(javax.persistence.criteria.Expression<String> x2, javax.persistence.criteria.Expression<Integer> from, javax.persistence.criteria.Expression<Integer> len) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x2)).getCurrentNode().substring(((InternalSelection)((Object)from)).getCurrentNode(), ((InternalSelection)((Object)len)).getCurrentNode()), this.buildList(x2, from, len), "subString");
    }

    @Override
    public javax.persistence.criteria.Expression<String> substring(javax.persistence.criteria.Expression<String> x2, int from, int len) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x2)).getCurrentNode().substring(from, len), this.buildList(x2, this.internalLiteral(from), this.internalLiteral(len)), "subString");
    }

    @Override
    public javax.persistence.criteria.Expression<String> trim(javax.persistence.criteria.Expression<String> x2) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x2);
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x2)).getCurrentNode().trim(), list, "trim");
    }

    @Override
    public javax.persistence.criteria.Expression<String> trim(CriteriaBuilder.Trimspec ts, javax.persistence.criteria.Expression<String> x2) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x2);
        if (ts == CriteriaBuilder.Trimspec.LEADING) {
            return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x2)).getCurrentNode().leftTrim(), list, "leftTrim");
        }
        if (ts == CriteriaBuilder.Trimspec.TRAILING) {
            return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x2)).getCurrentNode().rightTrim(), list, "rightTrim");
        }
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x2)).getCurrentNode().rightTrim().leftTrim(), list, "bothTrim");
    }

    @Override
    public javax.persistence.criteria.Expression<String> trim(javax.persistence.criteria.Expression<Character> t2, javax.persistence.criteria.Expression<String> x2) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x2, t2);
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x2)).getCurrentNode().trim(((InternalSelection)((Object)t2)).getCurrentNode()), list, "trim");
    }

    @Override
    public javax.persistence.criteria.Expression<String> trim(CriteriaBuilder.Trimspec ts, javax.persistence.criteria.Expression<Character> t2, javax.persistence.criteria.Expression<String> x2) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x2, t2);
        if (ts == CriteriaBuilder.Trimspec.LEADING) {
            return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x2)).getCurrentNode().leftTrim(((InternalSelection)((Object)t2)).getCurrentNode()), list, "leftTrim");
        }
        if (ts == CriteriaBuilder.Trimspec.TRAILING) {
            return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x2)).getCurrentNode().rightTrim(((InternalSelection)((Object)t2)).getCurrentNode()), list, "rightTrim");
        }
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x2)).getCurrentNode().rightTrim(((InternalSelection)((Object)t2)).getCurrentNode()).leftTrim(((InternalSelection)((Object)t2)).getCurrentNode()), list, "bothTrim");
    }

    @Override
    public javax.persistence.criteria.Expression<String> trim(char t2, javax.persistence.criteria.Expression<String> x2) {
        return this.trim(this.internalLiteral(Character.valueOf(t2)), x2);
    }

    @Override
    public javax.persistence.criteria.Expression<String> trim(CriteriaBuilder.Trimspec ts, char t2, javax.persistence.criteria.Expression<String> x2) {
        return this.trim(ts, this.internalLiteral(Character.valueOf(t2)), x2);
    }

    @Override
    public javax.persistence.criteria.Expression<String> lower(javax.persistence.criteria.Expression<String> x2) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x2);
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x2)).getCurrentNode().toLowerCase(), list, "lower");
    }

    @Override
    public javax.persistence.criteria.Expression<String> upper(javax.persistence.criteria.Expression<String> x2) {
        List<javax.persistence.criteria.Expression<?>> list = this.buildList(x2);
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)((Object)x2)).getCurrentNode().toUpperCase(), list, "upper");
    }

    @Override
    public javax.persistence.criteria.Expression<Integer> length(javax.persistence.criteria.Expression<String> x2) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)((Object)x2)).getCurrentNode().length(), this.buildList(x2), "length");
    }

    @Override
    public javax.persistence.criteria.Expression<Integer> locate(javax.persistence.criteria.Expression<String> x2, javax.persistence.criteria.Expression<String> pattern) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)((Object)x2)).getCurrentNode().locate(((InternalSelection)((Object)pattern)).getCurrentNode()), this.buildList(x2, pattern), "locate");
    }

    @Override
    public javax.persistence.criteria.Expression<Integer> locate(javax.persistence.criteria.Expression<String> x2, javax.persistence.criteria.Expression<String> pattern, javax.persistence.criteria.Expression<Integer> from) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)((Object)x2)).getCurrentNode().locate(((InternalSelection)((Object)pattern)).getCurrentNode(), ((InternalSelection)((Object)from)).getCurrentNode()), this.buildList(x2, pattern, from), "locate");
    }

    @Override
    public javax.persistence.criteria.Expression<Integer> locate(javax.persistence.criteria.Expression<String> x2, String pattern) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)((Object)x2)).getCurrentNode().locate(pattern), this.buildList(x2, this.internalLiteral(pattern)), "locate");
    }

    @Override
    public javax.persistence.criteria.Expression<Integer> locate(javax.persistence.criteria.Expression<String> x2, String pattern, int from) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)((Object)x2)).getCurrentNode().locate(pattern, from), this.buildList(x2, this.internalLiteral(pattern), this.internalLiteral(from)), "locate");
    }

    @Override
    public javax.persistence.criteria.Expression<Date> currentDate() {
        return new ExpressionImpl<Date>(this.metamodel, ClassConstants.SQLDATE, new ExpressionBuilder().currentDateDate());
    }

    @Override
    public javax.persistence.criteria.Expression<Timestamp> currentTimestamp() {
        return new ExpressionImpl<Timestamp>(this.metamodel, ClassConstants.TIMESTAMP, new ExpressionBuilder().currentTimeStamp());
    }

    @Override
    public javax.persistence.criteria.Expression<Time> currentTime() {
        return new ExpressionImpl<Time>(this.metamodel, ClassConstants.TIME, new ExpressionBuilder().currentTime());
    }

    @Override
    public <T> CriteriaBuilder.In<T> in(javax.persistence.criteria.Expression<? extends T> expression) {
        ArrayList<javax.persistence.criteria.Expression<? extends T>> list = new ArrayList<javax.persistence.criteria.Expression<? extends T>>();
        list.add(expression);
        return new InImpl(this.metamodel, (ExpressionImpl)expression, new ArrayList(), list);
    }

    @Override
    public <Y> javax.persistence.criteria.Expression<Y> coalesce(javax.persistence.criteria.Expression<? extends Y> x2, javax.persistence.criteria.Expression<? extends Y> y2) {
        ArgumentListFunctionExpression coalesce = ((InternalSelection)((Object)x2)).getCurrentNode().coalesce();
        coalesce.addChild(((InternalSelection)((Object)x2)).getCurrentNode());
        coalesce.addChild(((InternalSelection)((Object)y2)).getCurrentNode());
        return new CoalesceImpl(this.metamodel, x2.getJavaType(), coalesce, this.buildList(x2, y2), "coalesce");
    }

    @Override
    public <Y> javax.persistence.criteria.Expression<Y> coalesce(javax.persistence.criteria.Expression<? extends Y> x2, Y y2) {
        ArgumentListFunctionExpression coalesce = ((InternalSelection)((Object)x2)).getCurrentNode().coalesce();
        coalesce.addChild(((InternalSelection)((Object)x2)).getCurrentNode());
        coalesce.addChild(((InternalSelection)y2).getCurrentNode());
        return new CoalesceImpl(this.metamodel, x2.getJavaType(), coalesce, this.buildList(x2, this.internalLiteral(y2)), "coalesce");
    }

    @Override
    public <Y> javax.persistence.criteria.Expression<Y> nullif(javax.persistence.criteria.Expression<Y> x2, javax.persistence.criteria.Expression<?> y2) {
        return new FunctionExpressionImpl(this.metamodel, x2.getJavaType(), ((InternalSelection)((Object)x2)).getCurrentNode().nullIf(((InternalSelection)((Object)y2)).getCurrentNode()), this.buildList(x2, y2), "nullIf");
    }

    @Override
    public <Y> javax.persistence.criteria.Expression<Y> nullif(javax.persistence.criteria.Expression<Y> x2, Y y2) {
        return new FunctionExpressionImpl(this.metamodel, x2.getJavaType(), ((InternalSelection)((Object)x2)).getCurrentNode().nullIf(y2), this.buildList(x2, this.internalLiteral(y2)), "nullIf");
    }

    @Override
    public <T> CriteriaBuilder.Coalesce<T> coalesce() {
        ArgumentListFunctionExpression coalesce = new ExpressionBuilder().coalesce();
        return new CoalesceImpl<Object>(this.metamodel, Object.class, (Expression)coalesce, new ArrayList());
    }

    @Override
    public <C, R> CriteriaBuilder.SimpleCase<C, R> selectCase(javax.persistence.criteria.Expression<? extends C> expression) {
        ArgumentListFunctionExpression caseStatement = new ExpressionBuilder().caseStatement();
        return new SimpleCaseImpl<C, Object>(this.metamodel, Object.class, caseStatement, new ArrayList(), expression);
    }

    @Override
    public <R> CriteriaBuilder.Case<R> selectCase() {
        ArgumentListFunctionExpression caseStatement = new ExpressionBuilder().caseConditionStatement();
        return new CaseImpl<Object>(this.metamodel, Object.class, (Expression)caseStatement, (List<javax.persistence.criteria.Expression<?>>)new ArrayList());
    }

    @Override
    public <T> javax.persistence.criteria.Expression<T> function(String name, Class<T> type, javax.persistence.criteria.Expression<?> ... args) {
        if (args != null && args.length > 0) {
            ArrayList<Expression> params = new ArrayList<Expression>();
            int index = 1;
            while (index < args.length) {
                javax.persistence.criteria.Expression<?> x2 = args[index];
                params.add(((InternalSelection)((Object)x2)).getCurrentNode());
                ++index;
            }
            return new FunctionExpressionImpl<T>(this.metamodel, type, ((InternalSelection)((Object)args[0])).getCurrentNode().getFunctionWithArguments(name, params), this.buildList(args), name);
        }
        return new FunctionExpressionImpl<T>(this.metamodel, type, new ExpressionBuilder().getFunction(name), new ArrayList(0), name);
    }

    @Override
    public <T> javax.persistence.criteria.Expression<T> fromExpression(Expression expression, Class<T> type) {
        return new FunctionExpressionImpl<T>(this.metamodel, type, expression, new ArrayList(0));
    }

    @Override
    public javax.persistence.criteria.Expression fromExpression(Expression expression) {
        return new FunctionExpressionImpl<Object>(this.metamodel, Object.class, expression, new ArrayList(0));
    }

    @Override
    public Expression toExpression(javax.persistence.criteria.Expression expression) {
        return ((SelectionImpl)((Object)expression)).getCurrentNode();
    }

    @Override
    public <T> CriteriaDelete<T> createCriteriaDelete(Class<T> targetEntity) {
        TypeImpl<T> type;
        if (targetEntity != null && (type = ((MetamodelImpl)this.metamodel).getType(targetEntity)) != null && type.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
            return new CriteriaDeleteImpl<T>(this.metamodel, this, targetEntity);
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unknown_bean_class", new Object[]{targetEntity}));
    }

    @Override
    public <T> CriteriaUpdate<T> createCriteriaUpdate(Class<T> targetEntity) {
        TypeImpl<T> type;
        if (targetEntity != null && (type = ((MetamodelImpl)this.metamodel).getType(targetEntity)) != null && type.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
            return new CriteriaUpdateImpl<T>(this.metamodel, this, targetEntity);
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unknown_bean_class", new Object[]{targetEntity}));
    }

    @Override
    public <X, T, V extends T> Join<X, V> treat(Join<X, T> join, Class<V> type) {
        JoinImpl parentJoin = (JoinImpl)join;
        JoinImpl joinImpl = new JoinImpl(parentJoin, this.metamodel.managedType(type), this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType());
        parentJoin.joins.add(joinImpl);
        joinImpl.isJoin = parentJoin.isJoin;
        parentJoin.isJoin = false;
        return joinImpl;
    }

    @Override
    public <X, T, E extends T> CollectionJoin<X, E> treat(CollectionJoin<X, T> join, Class<E> type) {
        CollectionJoinImpl parentJoin = (CollectionJoinImpl)join;
        CollectionJoinImpl joinImpl = null;
        joinImpl = join instanceof BasicCollectionJoinImpl ? new BasicCollectionJoinImpl(parentJoin, this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType()) : new CollectionJoinImpl(join, this.metamodel.managedType(type), this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType());
        parentJoin.joins.add(joinImpl);
        ((FromImpl)joinImpl).isJoin = parentJoin.isJoin;
        parentJoin.isJoin = false;
        return joinImpl;
    }

    @Override
    public <X, T, E extends T> SetJoin<X, E> treat(SetJoin<X, T> join, Class<E> type) {
        SetJoinImpl parentJoin = (SetJoinImpl)join;
        SetJoinImpl joinImpl = null;
        joinImpl = join instanceof BasicSetJoinImpl ? new BasicSetJoinImpl(parentJoin, this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType()) : new SetJoinImpl(join, this.metamodel.managedType(type), this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType());
        parentJoin.joins.add(joinImpl);
        ((FromImpl)joinImpl).isJoin = parentJoin.isJoin;
        parentJoin.isJoin = false;
        return joinImpl;
    }

    @Override
    public <X, T, E extends T> ListJoin<X, E> treat(ListJoin<X, T> join, Class<E> type) {
        ListJoinImpl parentJoin = (ListJoinImpl)join;
        ListJoinImpl joinImpl = null;
        joinImpl = join instanceof BasicListJoinImpl ? new BasicListJoinImpl(parentJoin, this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType()) : new ListJoinImpl(join, this.metamodel.managedType(type), this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType());
        parentJoin.joins.add(joinImpl);
        ((FromImpl)joinImpl).isJoin = parentJoin.isJoin;
        parentJoin.isJoin = false;
        return joinImpl;
    }

    @Override
    public <X, K, T, V extends T> MapJoin<X, K, V> treat(MapJoin<X, K, T> join, Class<V> type) {
        MapJoinImpl parentJoin = (MapJoinImpl)join;
        MapJoinImpl joinImpl = null;
        joinImpl = join instanceof BasicMapJoinImpl ? new BasicMapJoinImpl(parentJoin, this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType()) : new MapJoinImpl(join, (ManagedType)this.metamodel.managedType(type), this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType());
        parentJoin.joins.add(joinImpl);
        ((FromImpl)joinImpl).isJoin = parentJoin.isJoin;
        parentJoin.isJoin = false;
        return joinImpl;
    }

    @Override
    public <X, T extends X> Path<T> treat(Path<X> path, Class<T> type) {
        PathImpl parentPath = (PathImpl)path;
        PathImpl newPath = (PathImpl)parentPath.clone();
        newPath.currentNode = newPath.currentNode.treat(type);
        newPath.pathParent = parentPath;
        newPath.javaType = type;
        newPath.modelArtifact = this.metamodel.managedType(type);
        return newPath;
    }

    @Override
    public <X, T extends X> Root<T> treat(Root<X> root, Class<T> type) {
        RootImpl parentRoot = (RootImpl)root;
        EntityType<T> entity = this.metamodel.entity(type);
        return new RootImpl<T>(entity, this.metamodel, type, parentRoot.currentNode.treat(type), entity);
    }

    public static class CaseImpl<R>
    extends FunctionExpressionImpl<R>
    implements CriteriaBuilder.Case<R> {
        protected <T> CaseImpl(Metamodel metamodel, Class<R> resultClass, Expression expressionNode, List<javax.persistence.criteria.Expression<?>> compoundExpressions) {
            super(metamodel, resultClass, expressionNode, compoundExpressions);
        }

        protected <T> CaseImpl(Metamodel metamodel, Class<R> resultClass, Expression expressionNode, List<javax.persistence.criteria.Expression<?>> compoundExpressions, String operator) {
            super(metamodel, resultClass, expressionNode, compoundExpressions, operator);
        }

        @Override
        public CriteriaBuilder.Case<R> when(javax.persistence.criteria.Expression<Boolean> condition, R result) {
            Expression conditionExp = ((InternalSelection)((Object)condition)).getCurrentNode();
            conditionExp = Expression.from(conditionExp, this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            Expression resultExp = Expression.from(result, new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            return this;
        }

        @Override
        public CriteriaBuilder.Case<R> when(javax.persistence.criteria.Expression<Boolean> condition, javax.persistence.criteria.Expression<? extends R> result) {
            Expression conditionExp = ((InternalSelection)((Object)condition)).getCurrentNode();
            conditionExp = Expression.from(conditionExp, this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            Expression resultExp = ((InternalSelection)((Object)result)).getCurrentNode();
            resultExp = Expression.from(resultExp, this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            return this;
        }

        @Override
        public javax.persistence.criteria.Expression<R> otherwise(R result) {
            Expression resultExp = Expression.from(result, new ExpressionBuilder());
            ((ArgumentListFunctionExpression)this.currentNode).addRightMostChild(resultExp);
            return this;
        }

        @Override
        public javax.persistence.criteria.Expression<R> otherwise(javax.persistence.criteria.Expression<? extends R> result) {
            Expression resultExp = ((InternalSelection)((Object)result)).getCurrentNode();
            resultExp = Expression.from(resultExp, this.currentNode);
            ((ArgumentListFunctionExpression)this.currentNode).addRightMostChild(resultExp);
            return this;
        }
    }

    public static class CoalesceImpl<X>
    extends FunctionExpressionImpl<X>
    implements CriteriaBuilder.Coalesce<X> {
        protected <T> CoalesceImpl(Metamodel metamodel, Class<X> resultClass, Expression expressionNode, List<javax.persistence.criteria.Expression<?>> compoundExpressions) {
            super(metamodel, resultClass, expressionNode, compoundExpressions);
        }

        protected <T> CoalesceImpl(Metamodel metamodel, Class<X> resultClass, Expression expressionNode, List<javax.persistence.criteria.Expression<?>> compoundExpressions, String operator) {
            super(metamodel, resultClass, expressionNode, compoundExpressions, operator);
        }

        @Override
        public CriteriaBuilder.Coalesce<X> value(X value) {
            Expression exp = Expression.from(value, new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(exp);
            return this;
        }

        @Override
        public CriteriaBuilder.Coalesce<X> value(javax.persistence.criteria.Expression<? extends X> value) {
            Expression exp = ((InternalSelection)((Object)value)).getCurrentNode();
            exp = Expression.from(exp, this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(exp);
            return this;
        }
    }

    public static class SimpleCaseImpl<C, R>
    extends FunctionExpressionImpl<R>
    implements CriteriaBuilder.SimpleCase<C, R> {
        private javax.persistence.criteria.Expression<C> expression;

        protected <T> SimpleCaseImpl(Metamodel metamodel, Class<R> resultClass, FunctionExpression expressionNode, List<javax.persistence.criteria.Expression<?>> compoundExpressions, javax.persistence.criteria.Expression<C> expression) {
            super(metamodel, resultClass, (Expression)expressionNode, compoundExpressions);
            this.expression = expression;
            expressionNode.addChild(((InternalSelection)((Object)expression)).getCurrentNode());
        }

        protected <T> SimpleCaseImpl(Metamodel metamodel, Class<R> resultClass, FunctionExpression expressionNode, List<javax.persistence.criteria.Expression<?>> compoundExpressions, String operator, javax.persistence.criteria.Expression<C> expression) {
            super(metamodel, resultClass, expressionNode, compoundExpressions, operator);
            this.expression = expression;
            expressionNode.addChild(((InternalSelection)((Object)expression)).getCurrentNode());
        }

        @Override
        public javax.persistence.criteria.Expression<C> getExpression() {
            return this.expression;
        }

        @Override
        public CriteriaBuilder.SimpleCase<C, R> when(C condition, R result) {
            Expression conditionExp = Expression.from(condition, new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            Expression resultExp = Expression.from(result, new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            return this;
        }

        @Override
        public CriteriaBuilder.SimpleCase<C, R> when(C condition, javax.persistence.criteria.Expression<? extends R> result) {
            Expression conditionExp = Expression.from(condition, new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            Expression resultExp = ((InternalSelection)((Object)result)).getCurrentNode();
            resultExp = Expression.from(resultExp, this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            return this;
        }

        @Override
        public javax.persistence.criteria.Expression<R> otherwise(R result) {
            Expression resultExp = Expression.from(result, new ExpressionBuilder());
            ((ArgumentListFunctionExpression)this.currentNode).addRightMostChild(resultExp);
            return this;
        }

        @Override
        public javax.persistence.criteria.Expression<R> otherwise(javax.persistence.criteria.Expression<? extends R> result) {
            Expression resultExp = ((InternalSelection)((Object)result)).getCurrentNode();
            resultExp = Expression.from(resultExp, this.currentNode);
            ((ArgumentListFunctionExpression)this.currentNode).addRightMostChild(resultExp);
            return this;
        }
    }
}

