/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.libraries.antlr.runtime.CharStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.CharStreamState;

public class ANTLRStringStream
implements CharStream {
    protected char[] data;
    protected int n;
    protected int p = 0;
    protected int line = 1;
    protected int charPositionInLine = 0;
    protected int markDepth = 0;
    protected List<CharStreamState> markers;
    protected int lastMarker;
    public String name;

    public ANTLRStringStream() {
    }

    public ANTLRStringStream(String string) {
        this();
        this.data = string.toCharArray();
        this.n = string.length();
    }

    public ANTLRStringStream(char[] cArray, int n2) {
        this();
        this.data = cArray;
        this.n = n2;
    }

    public void reset() {
        this.p = 0;
        this.line = 1;
        this.charPositionInLine = 0;
        this.markDepth = 0;
    }

    @Override
    public void consume() {
        if (this.p < this.n) {
            ++this.charPositionInLine;
            if (this.data[this.p] == '\n') {
                ++this.line;
                this.charPositionInLine = 0;
            }
            ++this.p;
        }
    }

    @Override
    public int LA(int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (n2 < 0 && this.p + ++n2 - 1 < 0) {
            return -1;
        }
        if (this.p + n2 - 1 >= this.n) {
            return -1;
        }
        return this.data[this.p + n2 - 1];
    }

    @Override
    public int LT(int n2) {
        return this.LA(n2);
    }

    @Override
    public int index() {
        return this.p;
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public int mark() {
        CharStreamState charStreamState;
        if (this.markers == null) {
            this.markers = new ArrayList<CharStreamState>();
            this.markers.add(null);
        }
        ++this.markDepth;
        if (this.markDepth >= this.markers.size()) {
            charStreamState = new CharStreamState();
            this.markers.add(charStreamState);
        } else {
            charStreamState = this.markers.get(this.markDepth);
        }
        charStreamState.p = this.p;
        charStreamState.line = this.line;
        charStreamState.charPositionInLine = this.charPositionInLine;
        this.lastMarker = this.markDepth;
        return this.markDepth;
    }

    @Override
    public void rewind(int n2) {
        CharStreamState charStreamState = this.markers.get(n2);
        this.seek(charStreamState.p);
        this.line = charStreamState.line;
        this.charPositionInLine = charStreamState.charPositionInLine;
        this.release(n2);
    }

    @Override
    public void rewind() {
        this.rewind(this.lastMarker);
    }

    @Override
    public void release(int n2) {
        this.markDepth = n2;
        --this.markDepth;
    }

    @Override
    public void seek(int n2) {
        if (n2 <= this.p) {
            this.p = n2;
            return;
        }
        while (this.p < n2) {
            this.consume();
        }
    }

    @Override
    public String substring(int n2, int n3) {
        return new String(this.data, n2, n3 - n2 + 1);
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getCharPositionInLine() {
        return this.charPositionInLine;
    }

    @Override
    public void setLine(int n2) {
        this.line = n2;
    }

    @Override
    public void setCharPositionInLine(int n2) {
        this.charPositionInLine = n2;
    }

    @Override
    public String getSourceName() {
        return this.name;
    }

    public String toString() {
        return new String(this.data);
    }
}

