/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.BitSet;
import org.eclipse.persistence.internal.libraries.antlr.runtime.Token;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenSource;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenStream;

public class BufferedTokenStream
implements TokenStream {
    protected TokenSource tokenSource;
    protected List<Token> tokens = new ArrayList<Token>(100);
    protected int lastMarker;
    protected int p = -1;
    protected int range = -1;

    public BufferedTokenStream() {
    }

    public BufferedTokenStream(TokenSource tokenSource) {
        this.tokenSource = tokenSource;
    }

    @Override
    public TokenSource getTokenSource() {
        return this.tokenSource;
    }

    @Override
    public int index() {
        return this.p;
    }

    @Override
    public int range() {
        return this.range;
    }

    @Override
    public int mark() {
        if (this.p == -1) {
            this.setup();
        }
        this.lastMarker = this.index();
        return this.lastMarker;
    }

    @Override
    public void release(int n2) {
    }

    @Override
    public void rewind(int n2) {
        this.seek(n2);
    }

    @Override
    public void rewind() {
        this.seek(this.lastMarker);
    }

    public void reset() {
        this.p = 0;
        this.lastMarker = 0;
    }

    @Override
    public void seek(int n2) {
        this.p = n2;
    }

    @Override
    public int size() {
        return this.tokens.size();
    }

    @Override
    public void consume() {
        if (this.p == -1) {
            this.setup();
        }
        ++this.p;
        this.sync(this.p);
    }

    protected void sync(int n2) {
        int n3 = n2 - this.tokens.size() + 1;
        if (n3 > 0) {
            this.fetch(n3);
        }
    }

    protected void fetch(int n2) {
        for (int i2 = 1; i2 <= n2; ++i2) {
            Token token = this.tokenSource.nextToken();
            token.setTokenIndex(this.tokens.size());
            this.tokens.add(token);
            if (token.getType() == -1) break;
        }
    }

    @Override
    public Token get(int n2) {
        if (n2 < 0 || n2 >= this.tokens.size()) {
            throw new NoSuchElementException("token index " + n2 + " out of range 0.." + (this.tokens.size() - 1));
        }
        return this.tokens.get(n2);
    }

    public List<? extends Token> get(int n2, int n3) {
        Token token;
        if (n2 < 0 || n3 < 0) {
            return null;
        }
        if (this.p == -1) {
            this.setup();
        }
        ArrayList<Token> arrayList = new ArrayList<Token>();
        if (n3 >= this.tokens.size()) {
            n3 = this.tokens.size() - 1;
        }
        for (int i2 = n2; i2 <= n3 && (token = this.tokens.get(i2)).getType() != -1; ++i2) {
            arrayList.add(token);
        }
        return arrayList;
    }

    @Override
    public int LA(int n2) {
        return this.LT(n2).getType();
    }

    protected Token LB(int n2) {
        if (this.p - n2 < 0) {
            return null;
        }
        return this.tokens.get(this.p - n2);
    }

    @Override
    public Token LT(int n2) {
        if (this.p == -1) {
            this.setup();
        }
        if (n2 == 0) {
            return null;
        }
        if (n2 < 0) {
            return this.LB(-n2);
        }
        int n3 = this.p + n2 - 1;
        this.sync(n3);
        if (n3 >= this.tokens.size()) {
            return this.tokens.get(this.tokens.size() - 1);
        }
        if (n3 > this.range) {
            this.range = n3;
        }
        return this.tokens.get(n3);
    }

    protected void setup() {
        this.sync(0);
        this.p = 0;
    }

    public void setTokenSource(TokenSource tokenSource) {
        this.tokenSource = tokenSource;
        this.tokens.clear();
        this.p = -1;
    }

    public List<? extends Token> getTokens() {
        return this.tokens;
    }

    public List<? extends Token> getTokens(int n2, int n3) {
        return this.getTokens(n2, n3, (BitSet)null);
    }

    public List<? extends Token> getTokens(int n2, int n3, BitSet bitSet) {
        if (this.p == -1) {
            this.setup();
        }
        if (n3 >= this.tokens.size()) {
            n3 = this.tokens.size() - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > n3) {
            return null;
        }
        ArrayList<Token> arrayList = new ArrayList<Token>();
        for (int i2 = n2; i2 <= n3; ++i2) {
            Token token = this.tokens.get(i2);
            if (bitSet != null && !bitSet.member(token.getType())) continue;
            arrayList.add(token);
        }
        if (arrayList.isEmpty()) {
            arrayList = null;
        }
        return arrayList;
    }

    public List<? extends Token> getTokens(int n2, int n3, List<Integer> list) {
        return this.getTokens(n2, n3, new BitSet(list));
    }

    public List<? extends Token> getTokens(int n2, int n3, int n4) {
        return this.getTokens(n2, n3, BitSet.of(n4));
    }

    @Override
    public String getSourceName() {
        return this.tokenSource.getSourceName();
    }

    public String toString() {
        if (this.p == -1) {
            this.setup();
        }
        this.fill();
        return this.toString(0, this.tokens.size() - 1);
    }

    @Override
    public String toString(int n2, int n3) {
        Token token;
        if (n2 < 0 || n3 < 0) {
            return null;
        }
        if (this.p == -1) {
            this.setup();
        }
        if (n3 >= this.tokens.size()) {
            n3 = this.tokens.size() - 1;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = n2; i2 <= n3 && (token = this.tokens.get(i2)).getType() != -1; ++i2) {
            stringBuilder.append(token.getText());
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString(Token token, Token token2) {
        if (token != null && token2 != null) {
            return this.toString(token.getTokenIndex(), token2.getTokenIndex());
        }
        return null;
    }

    public void fill() {
        if (this.p == -1) {
            this.setup();
        }
        if (this.tokens.get(this.p).getType() == -1) {
            return;
        }
        int n2 = this.p + 1;
        this.sync(n2);
        while (this.tokens.get(n2).getType() != -1) {
            this.sync(++n2);
        }
    }
}

