/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime;

import java.io.Serializable;
import org.eclipse.persistence.internal.libraries.antlr.runtime.CharStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.Token;

public class CommonToken
implements Token,
Serializable {
    protected int type;
    protected int line;
    protected int charPositionInLine = -1;
    protected int channel = 0;
    protected transient CharStream input;
    protected String text;
    protected int index = -1;
    protected int start;
    protected int stop;

    public CommonToken(int n2) {
        this.type = n2;
    }

    public CommonToken(CharStream charStream, int n2, int n3, int n4, int n5) {
        this.input = charStream;
        this.type = n2;
        this.channel = n3;
        this.start = n4;
        this.stop = n5;
    }

    public CommonToken(int n2, String string) {
        this.type = n2;
        this.channel = 0;
        this.text = string;
    }

    public CommonToken(Token token) {
        this.text = token.getText();
        this.type = token.getType();
        this.line = token.getLine();
        this.index = token.getTokenIndex();
        this.charPositionInLine = token.getCharPositionInLine();
        this.channel = token.getChannel();
        this.input = token.getInputStream();
        if (token instanceof CommonToken) {
            this.start = ((CommonToken)token).start;
            this.stop = ((CommonToken)token).stop;
        }
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setLine(int n2) {
        this.line = n2;
    }

    @Override
    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        if (this.input == null) {
            return null;
        }
        int n2 = this.input.size();
        if (this.start < n2 && this.stop < n2) {
            return this.input.substring(this.start, this.stop);
        }
        return "<EOF>";
    }

    @Override
    public void setText(String string) {
        this.text = string;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getCharPositionInLine() {
        return this.charPositionInLine;
    }

    @Override
    public void setCharPositionInLine(int n2) {
        this.charPositionInLine = n2;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    public void setChannel(int n2) {
        this.channel = n2;
    }

    @Override
    public void setType(int n2) {
        this.type = n2;
    }

    public int getStartIndex() {
        return this.start;
    }

    public void setStartIndex(int n2) {
        this.start = n2;
    }

    public int getStopIndex() {
        return this.stop;
    }

    public void setStopIndex(int n2) {
        this.stop = n2;
    }

    @Override
    public int getTokenIndex() {
        return this.index;
    }

    @Override
    public void setTokenIndex(int n2) {
        this.index = n2;
    }

    @Override
    public CharStream getInputStream() {
        return this.input;
    }

    @Override
    public void setInputStream(CharStream charStream) {
        this.input = charStream;
    }

    public String toString() {
        String string;
        String string2 = "";
        if (this.channel > 0) {
            string2 = ",channel=" + this.channel;
        }
        if ((string = this.getText()) != null) {
            string = string.replaceAll("\n", "\\\\n");
            string = string.replaceAll("\r", "\\\\r");
            string = string.replaceAll("\t", "\\\\t");
        } else {
            string = "<no text>";
        }
        return "[@" + this.getTokenIndex() + "," + this.start + ":" + this.stop + "='" + string + "',<" + this.type + ">" + string2 + "," + this.line + ":" + this.getCharPositionInLine() + "]";
    }
}

