/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.internal.libraries.antlr.runtime.BitSet;
import org.eclipse.persistence.internal.libraries.antlr.runtime.Token;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenSource;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenStream;

public class LegacyCommonTokenStream
implements TokenStream {
    protected TokenSource tokenSource;
    protected List<Token> tokens = new ArrayList<Token>(500);
    protected Map<Integer, Integer> channelOverrideMap;
    protected Set<Integer> discardSet;
    protected int channel = 0;
    protected boolean discardOffChannelTokens = false;
    protected int lastMarker;
    protected int range = -1;
    protected int p = -1;

    public LegacyCommonTokenStream() {
    }

    public LegacyCommonTokenStream(TokenSource tokenSource) {
        this();
        this.tokenSource = tokenSource;
    }

    public LegacyCommonTokenStream(TokenSource tokenSource, int n2) {
        this(tokenSource);
        this.channel = n2;
    }

    public void setTokenSource(TokenSource tokenSource) {
        this.tokenSource = tokenSource;
        this.tokens.clear();
        this.p = -1;
        this.channel = 0;
    }

    protected void fillBuffer() {
        int n2 = 0;
        Token token = this.tokenSource.nextToken();
        while (token != null && token.getType() != -1) {
            Integer n3;
            boolean bl = false;
            if (this.channelOverrideMap != null && (n3 = this.channelOverrideMap.get(token.getType())) != null) {
                token.setChannel(n3);
            }
            if (this.discardSet != null && this.discardSet.contains(new Integer(token.getType()))) {
                bl = true;
            } else if (this.discardOffChannelTokens && token.getChannel() != this.channel) {
                bl = true;
            }
            if (!bl) {
                token.setTokenIndex(n2);
                this.tokens.add(token);
                ++n2;
            }
            token = this.tokenSource.nextToken();
        }
        this.p = 0;
        this.p = this.skipOffTokenChannels(this.p);
    }

    @Override
    public void consume() {
        if (this.p < this.tokens.size()) {
            ++this.p;
            this.p = this.skipOffTokenChannels(this.p);
        }
    }

    protected int skipOffTokenChannels(int n2) {
        int n3 = this.tokens.size();
        while (n2 < n3 && this.tokens.get(n2).getChannel() != this.channel) {
            ++n2;
        }
        return n2;
    }

    protected int skipOffTokenChannelsReverse(int n2) {
        while (n2 >= 0 && this.tokens.get(n2).getChannel() != this.channel) {
            --n2;
        }
        return n2;
    }

    public void setTokenTypeChannel(int n2, int n3) {
        if (this.channelOverrideMap == null) {
            this.channelOverrideMap = new HashMap<Integer, Integer>();
        }
        this.channelOverrideMap.put(n2, n3);
    }

    public void discardTokenType(int n2) {
        if (this.discardSet == null) {
            this.discardSet = new HashSet<Integer>();
        }
        this.discardSet.add(n2);
    }

    public void discardOffChannelTokens(boolean bl) {
        this.discardOffChannelTokens = bl;
    }

    public List<? extends Token> getTokens() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return this.tokens;
    }

    public List<? extends Token> getTokens(int n2, int n3) {
        return this.getTokens(n2, n3, (BitSet)null);
    }

    public List<? extends Token> getTokens(int n2, int n3, BitSet bitSet) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        if (n3 >= this.tokens.size()) {
            n3 = this.tokens.size() - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > n3) {
            return null;
        }
        ArrayList<Token> arrayList = new ArrayList<Token>();
        for (int i2 = n2; i2 <= n3; ++i2) {
            Token token = this.tokens.get(i2);
            if (bitSet != null && !bitSet.member(token.getType())) continue;
            arrayList.add(token);
        }
        if (arrayList.isEmpty()) {
            arrayList = null;
        }
        return arrayList;
    }

    public List<? extends Token> getTokens(int n2, int n3, List<Integer> list) {
        return this.getTokens(n2, n3, new BitSet(list));
    }

    public List<? extends Token> getTokens(int n2, int n3, int n4) {
        return this.getTokens(n2, n3, BitSet.of(n4));
    }

    @Override
    public Token LT(int n2) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        if (n2 == 0) {
            return null;
        }
        if (n2 < 0) {
            return this.LB(-n2);
        }
        if (this.p + n2 - 1 >= this.tokens.size()) {
            return this.tokens.get(this.tokens.size() - 1);
        }
        int n3 = this.p;
        for (int i2 = 1; i2 < n2; ++i2) {
            n3 = this.skipOffTokenChannels(n3 + 1);
        }
        if (n3 >= this.tokens.size()) {
            return this.tokens.get(this.tokens.size() - 1);
        }
        if (n3 > this.range) {
            this.range = n3;
        }
        return this.tokens.get(n3);
    }

    protected Token LB(int n2) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        if (n2 == 0) {
            return null;
        }
        if (this.p - n2 < 0) {
            return null;
        }
        int n3 = this.p;
        for (int i2 = 1; i2 <= n2; ++i2) {
            n3 = this.skipOffTokenChannelsReverse(n3 - 1);
        }
        if (n3 < 0) {
            return null;
        }
        return this.tokens.get(n3);
    }

    @Override
    public Token get(int n2) {
        return this.tokens.get(n2);
    }

    public List<? extends Token> get(int n2, int n3) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        if (n2 < 0 || n3 < 0) {
            return null;
        }
        return this.tokens.subList(n2, n3);
    }

    @Override
    public int LA(int n2) {
        return this.LT(n2).getType();
    }

    @Override
    public int mark() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        this.lastMarker = this.index();
        return this.lastMarker;
    }

    @Override
    public void release(int n2) {
    }

    @Override
    public int size() {
        return this.tokens.size();
    }

    @Override
    public int index() {
        return this.p;
    }

    @Override
    public int range() {
        return this.range;
    }

    @Override
    public void rewind(int n2) {
        this.seek(n2);
    }

    @Override
    public void rewind() {
        this.seek(this.lastMarker);
    }

    public void reset() {
        this.p = 0;
        this.lastMarker = 0;
    }

    @Override
    public void seek(int n2) {
        this.p = n2;
    }

    @Override
    public TokenSource getTokenSource() {
        return this.tokenSource;
    }

    @Override
    public String getSourceName() {
        return this.getTokenSource().getSourceName();
    }

    public String toString() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return this.toString(0, this.tokens.size() - 1);
    }

    @Override
    public String toString(int n2, int n3) {
        if (n2 < 0 || n3 < 0) {
            return null;
        }
        if (this.p == -1) {
            this.fillBuffer();
        }
        if (n3 >= this.tokens.size()) {
            n3 = this.tokens.size() - 1;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = n2; i2 <= n3; ++i2) {
            Token token = this.tokens.get(i2);
            stringBuilder.append(token.getText());
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString(Token token, Token token2) {
        if (token != null && token2 != null) {
            return this.toString(token.getTokenIndex(), token2.getTokenIndex());
        }
        return null;
    }
}

