/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.libraries.antlr.runtime.CommonTokenStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.Token;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenSource;

public class TokenRewriteStream
extends CommonTokenStream {
    public static final String DEFAULT_PROGRAM_NAME = "default";
    public static final int PROGRAM_INIT_SIZE = 100;
    public static final int MIN_TOKEN_INDEX = 0;
    protected Map<String, List<RewriteOperation>> programs = null;
    protected Map<String, Integer> lastRewriteTokenIndexes = null;

    public TokenRewriteStream() {
        this.init();
    }

    protected void init() {
        this.programs = new HashMap<String, List<RewriteOperation>>();
        this.programs.put(DEFAULT_PROGRAM_NAME, new ArrayList(100));
        this.lastRewriteTokenIndexes = new HashMap<String, Integer>();
    }

    public TokenRewriteStream(TokenSource tokenSource) {
        super(tokenSource);
        this.init();
    }

    public TokenRewriteStream(TokenSource tokenSource, int n2) {
        super(tokenSource, n2);
        this.init();
    }

    public void rollback(int n2) {
        this.rollback(DEFAULT_PROGRAM_NAME, n2);
    }

    public void rollback(String string, int n2) {
        List<RewriteOperation> list = this.programs.get(string);
        if (list != null) {
            this.programs.put(string, list.subList(0, n2));
        }
    }

    public void deleteProgram() {
        this.deleteProgram(DEFAULT_PROGRAM_NAME);
    }

    public void deleteProgram(String string) {
        this.rollback(string, 0);
    }

    public void insertAfter(Token token, Object object) {
        this.insertAfter(DEFAULT_PROGRAM_NAME, token, object);
    }

    public void insertAfter(int n2, Object object) {
        this.insertAfter(DEFAULT_PROGRAM_NAME, n2, object);
    }

    public void insertAfter(String string, Token token, Object object) {
        this.insertAfter(string, token.getTokenIndex(), object);
    }

    public void insertAfter(String string, int n2, Object object) {
        this.insertBefore(string, n2 + 1, object);
    }

    public void insertBefore(Token token, Object object) {
        this.insertBefore(DEFAULT_PROGRAM_NAME, token, object);
    }

    public void insertBefore(int n2, Object object) {
        this.insertBefore(DEFAULT_PROGRAM_NAME, n2, object);
    }

    public void insertBefore(String string, Token token, Object object) {
        this.insertBefore(string, token.getTokenIndex(), object);
    }

    public void insertBefore(String string, int n2, Object object) {
        InsertBeforeOp insertBeforeOp = new InsertBeforeOp(n2, object);
        List<RewriteOperation> list = this.getProgram(string);
        insertBeforeOp.instructionIndex = list.size();
        list.add(insertBeforeOp);
    }

    public void replace(int n2, Object object) {
        this.replace(DEFAULT_PROGRAM_NAME, n2, n2, object);
    }

    public void replace(int n2, int n3, Object object) {
        this.replace(DEFAULT_PROGRAM_NAME, n2, n3, object);
    }

    public void replace(Token token, Object object) {
        this.replace(DEFAULT_PROGRAM_NAME, token, token, object);
    }

    public void replace(Token token, Token token2, Object object) {
        this.replace(DEFAULT_PROGRAM_NAME, token, token2, object);
    }

    public void replace(String string, int n2, int n3, Object object) {
        if (n2 > n3 || n2 < 0 || n3 < 0 || n3 >= this.tokens.size()) {
            throw new IllegalArgumentException("replace: range invalid: " + n2 + ".." + n3 + "(size=" + this.tokens.size() + ")");
        }
        ReplaceOp replaceOp = new ReplaceOp(n2, n3, object);
        List<RewriteOperation> list = this.getProgram(string);
        replaceOp.instructionIndex = list.size();
        list.add(replaceOp);
    }

    public void replace(String string, Token token, Token token2, Object object) {
        this.replace(string, token.getTokenIndex(), token2.getTokenIndex(), object);
    }

    public void delete(int n2) {
        this.delete(DEFAULT_PROGRAM_NAME, n2, n2);
    }

    public void delete(int n2, int n3) {
        this.delete(DEFAULT_PROGRAM_NAME, n2, n3);
    }

    public void delete(Token token) {
        this.delete(DEFAULT_PROGRAM_NAME, token, token);
    }

    public void delete(Token token, Token token2) {
        this.delete(DEFAULT_PROGRAM_NAME, token, token2);
    }

    public void delete(String string, int n2, int n3) {
        this.replace(string, n2, n3, null);
    }

    public void delete(String string, Token token, Token token2) {
        this.replace(string, token, token2, null);
    }

    public int getLastRewriteTokenIndex() {
        return this.getLastRewriteTokenIndex(DEFAULT_PROGRAM_NAME);
    }

    protected int getLastRewriteTokenIndex(String string) {
        Integer n2 = this.lastRewriteTokenIndexes.get(string);
        if (n2 == null) {
            return -1;
        }
        return n2;
    }

    protected void setLastRewriteTokenIndex(String string, int n2) {
        this.lastRewriteTokenIndexes.put(string, n2);
    }

    protected List<RewriteOperation> getProgram(String string) {
        List<RewriteOperation> list = this.programs.get(string);
        if (list == null) {
            list = this.initializeProgram(string);
        }
        return list;
    }

    private List<RewriteOperation> initializeProgram(String string) {
        ArrayList<RewriteOperation> arrayList = new ArrayList<RewriteOperation>(100);
        this.programs.put(string, arrayList);
        return arrayList;
    }

    public String toOriginalString() {
        this.fill();
        return this.toOriginalString(0, this.size() - 1);
    }

    public String toOriginalString(int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = n2; i2 >= 0 && i2 <= n3 && i2 < this.tokens.size(); ++i2) {
            if (this.get(i2).getType() == -1) continue;
            stringBuilder.append(this.get(i2).getText());
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        this.fill();
        return this.toString(0, this.size() - 1);
    }

    public String toString(String string) {
        this.fill();
        return this.toString(string, 0, this.size() - 1);
    }

    @Override
    public String toString(int n2, int n3) {
        return this.toString(DEFAULT_PROGRAM_NAME, n2, n3);
    }

    public String toString(String string, int n2, int n3) {
        List<RewriteOperation> list = this.programs.get(string);
        if (n3 > this.tokens.size() - 1) {
            n3 = this.tokens.size() - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (list == null || list.isEmpty()) {
            return this.toOriginalString(n2, n3);
        }
        StringBuffer stringBuffer = new StringBuffer();
        Map<Integer, ? extends RewriteOperation> map = this.reduceToSingleOperationPerIndex(list);
        int n4 = n2;
        while (n4 <= n3 && n4 < this.tokens.size()) {
            RewriteOperation rewriteOperation = map.get(n4);
            map.remove(n4);
            Token object = (Token)this.tokens.get(n4);
            if (rewriteOperation == null) {
                if (object.getType() != -1) {
                    stringBuffer.append(object.getText());
                }
                ++n4;
                continue;
            }
            n4 = rewriteOperation.execute(stringBuffer);
        }
        if (n3 == this.tokens.size() - 1) {
            for (RewriteOperation rewriteOperation : map.values()) {
                if (rewriteOperation.index < this.tokens.size() - 1) continue;
                stringBuffer.append(rewriteOperation.text);
            }
        }
        return stringBuffer.toString();
    }

    protected Map<Integer, ? extends RewriteOperation> reduceToSingleOperationPerIndex(List<? extends RewriteOperation> list) {
        ReplaceOp replaceOp;
        int n2;
        List<ReplaceOp> list2;
        List<InsertBeforeOp> list3;
        RewriteOperation rewriteOperation;
        RewriteOperation rewriteOperation2;
        int n3;
        for (n3 = 0; n3 < list.size(); ++n3) {
            rewriteOperation2 = list.get(n3);
            if (rewriteOperation2 == null || !(rewriteOperation2 instanceof ReplaceOp)) continue;
            rewriteOperation = (ReplaceOp)list.get(n3);
            list3 = this.getKindOfOps(list, InsertBeforeOp.class, n3);
            for (int i2 = 0; i2 < list3.size(); ++i2) {
                InsertBeforeOp insertBeforeOp = list3.get(i2);
                if (insertBeforeOp.index == rewriteOperation.index) {
                    list.set(insertBeforeOp.instructionIndex, null);
                    rewriteOperation.text = insertBeforeOp.text.toString() + (rewriteOperation.text != null ? rewriteOperation.text.toString() : "");
                    continue;
                }
                if (insertBeforeOp.index <= rewriteOperation.index || insertBeforeOp.index > rewriteOperation.lastIndex) continue;
                list.set(insertBeforeOp.instructionIndex, null);
            }
            list2 = this.getKindOfOps(list, ReplaceOp.class, n3);
            for (n2 = 0; n2 < list2.size(); ++n2) {
                boolean bl;
                replaceOp = list2.get(n2);
                if (replaceOp.index >= rewriteOperation.index && replaceOp.lastIndex <= rewriteOperation.lastIndex) {
                    list.set(replaceOp.instructionIndex, null);
                    continue;
                }
                boolean bl2 = replaceOp.lastIndex < rewriteOperation.index || replaceOp.index > rewriteOperation.lastIndex;
                boolean bl3 = bl = replaceOp.index == rewriteOperation.index && replaceOp.lastIndex == rewriteOperation.lastIndex;
                if (replaceOp.text == null && rewriteOperation.text == null && !bl2) {
                    list.set(replaceOp.instructionIndex, null);
                    rewriteOperation.index = Math.min(replaceOp.index, rewriteOperation.index);
                    rewriteOperation.lastIndex = Math.max(replaceOp.lastIndex, rewriteOperation.lastIndex);
                    System.out.println("new rop " + rewriteOperation);
                    continue;
                }
                if (bl2 || bl) continue;
                throw new IllegalArgumentException("replace op boundaries of " + rewriteOperation + " overlap with previous " + replaceOp);
            }
        }
        for (n3 = 0; n3 < list.size(); ++n3) {
            rewriteOperation2 = list.get(n3);
            if (rewriteOperation2 == null || !(rewriteOperation2 instanceof InsertBeforeOp)) continue;
            rewriteOperation = (InsertBeforeOp)list.get(n3);
            list3 = this.getKindOfOps(list, InsertBeforeOp.class, n3);
            for (int i3 = 0; i3 < list3.size(); ++i3) {
                InsertBeforeOp insertBeforeOp = list3.get(i3);
                if (insertBeforeOp.index != ((InsertBeforeOp)rewriteOperation).index) continue;
                ((InsertBeforeOp)rewriteOperation).text = this.catOpText(((InsertBeforeOp)rewriteOperation).text, insertBeforeOp.text);
                list.set(insertBeforeOp.instructionIndex, null);
            }
            list2 = this.getKindOfOps(list, ReplaceOp.class, n3);
            for (n2 = 0; n2 < list2.size(); ++n2) {
                replaceOp = list2.get(n2);
                if (((InsertBeforeOp)rewriteOperation).index == replaceOp.index) {
                    replaceOp.text = this.catOpText(((InsertBeforeOp)rewriteOperation).text, replaceOp.text);
                    list.set(n3, null);
                    continue;
                }
                if (((InsertBeforeOp)rewriteOperation).index < replaceOp.index || ((InsertBeforeOp)rewriteOperation).index > replaceOp.lastIndex) continue;
                throw new IllegalArgumentException("insert op " + rewriteOperation + " within boundaries of previous " + replaceOp);
            }
        }
        HashMap<Integer, ReplaceOp> hashMap = new HashMap<Integer, ReplaceOp>();
        for (int i4 = 0; i4 < list.size(); ++i4) {
            rewriteOperation = list.get(i4);
            if (rewriteOperation == null) continue;
            if (hashMap.get(rewriteOperation.index) != null) {
                throw new Error("should only be one op per index");
            }
            hashMap.put(rewriteOperation.index, (ReplaceOp)rewriteOperation);
        }
        return hashMap;
    }

    protected String catOpText(Object object, Object object2) {
        String string = "";
        String string2 = "";
        if (object != null) {
            string = object.toString();
        }
        if (object2 != null) {
            string2 = object2.toString();
        }
        return string + string2;
    }

    protected <T extends RewriteOperation> List<? extends T> getKindOfOps(List<? extends RewriteOperation> list, Class<T> clazz) {
        return this.getKindOfOps(list, clazz, list.size());
    }

    protected <T extends RewriteOperation> List<? extends T> getKindOfOps(List<? extends RewriteOperation> list, Class<T> clazz, int n2) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (int i2 = 0; i2 < n2 && i2 < list.size(); ++i2) {
            RewriteOperation rewriteOperation = list.get(i2);
            if (rewriteOperation == null || !clazz.isInstance(rewriteOperation)) continue;
            arrayList.add(clazz.cast(rewriteOperation));
        }
        return arrayList;
    }

    public String toDebugString() {
        return this.toDebugString(0, this.size() - 1);
    }

    public String toDebugString(int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = n2; i2 >= 0 && i2 <= n3 && i2 < this.tokens.size(); ++i2) {
            stringBuilder.append(this.get(i2));
        }
        return stringBuilder.toString();
    }

    class ReplaceOp
    extends RewriteOperation {
        protected int lastIndex;

        public ReplaceOp(int n2, int n3, Object object) {
            super(n2, object);
            this.lastIndex = n3;
        }

        @Override
        public int execute(StringBuffer stringBuffer) {
            if (this.text != null) {
                stringBuffer.append(this.text);
            }
            return this.lastIndex + 1;
        }

        @Override
        public String toString() {
            if (this.text == null) {
                return "<DeleteOp@" + TokenRewriteStream.this.tokens.get(this.index) + ".." + TokenRewriteStream.this.tokens.get(this.lastIndex) + ">";
            }
            return "<ReplaceOp@" + TokenRewriteStream.this.tokens.get(this.index) + ".." + TokenRewriteStream.this.tokens.get(this.lastIndex) + ":\"" + this.text + "\">";
        }
    }

    class InsertBeforeOp
    extends RewriteOperation {
        public InsertBeforeOp(int n2, Object object) {
            super(n2, object);
        }

        @Override
        public int execute(StringBuffer stringBuffer) {
            stringBuffer.append(this.text);
            if (((Token)TokenRewriteStream.this.tokens.get(this.index)).getType() != -1) {
                stringBuffer.append(((Token)TokenRewriteStream.this.tokens.get(this.index)).getText());
            }
            return this.index + 1;
        }
    }

    public class RewriteOperation {
        protected int instructionIndex;
        protected int index;
        protected Object text;

        protected RewriteOperation(int n2) {
            this.index = n2;
        }

        protected RewriteOperation(int n2, Object object) {
            this.index = n2;
            this.text = object;
        }

        public int execute(StringBuffer stringBuffer) {
            return this.index;
        }

        public String toString() {
            String string = this.getClass().getName();
            int n2 = string.indexOf(36);
            string = string.substring(n2 + 1, string.length());
            return "<" + string + "@" + TokenRewriteStream.this.tokens.get(this.index) + ":\"" + this.text + "\">";
        }
    }
}

