/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime.misc;

import org.eclipse.persistence.internal.libraries.antlr.runtime.misc.FastQueue;

public abstract class LookaheadStream<T>
extends FastQueue<T> {
    public static final int UNINITIALIZED_EOF_ELEMENT_INDEX = Integer.MAX_VALUE;
    protected int currentElementIndex = 0;
    protected T prevElement;
    public T eof = null;
    protected int lastMarker;
    protected int markDepth = 0;

    @Override
    public void reset() {
        super.reset();
        this.currentElementIndex = 0;
        this.p = 0;
        this.prevElement = null;
    }

    public abstract T nextElement();

    public abstract boolean isEOF(T var1);

    @Override
    public T remove() {
        Object t2 = this.elementAt(0);
        ++this.p;
        if (this.p == this.data.size() && this.markDepth == 0) {
            this.prevElement = t2;
            this.clear();
        }
        return t2;
    }

    public void consume() {
        this.syncAhead(1);
        this.remove();
        ++this.currentElementIndex;
    }

    protected void syncAhead(int n2) {
        int n3 = this.p + n2 - 1 - this.data.size() + 1;
        if (n3 > 0) {
            this.fill(n3);
        }
    }

    public void fill(int n2) {
        for (int i2 = 1; i2 <= n2; ++i2) {
            T t2 = this.nextElement();
            if (this.isEOF(t2)) {
                this.eof = t2;
            }
            this.data.add(t2);
        }
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("streams are of unknown size");
    }

    public T LT(int n2) {
        if (n2 == 0) {
            return null;
        }
        if (n2 < 0) {
            return this.LB(-n2);
        }
        this.syncAhead(n2);
        if (this.p + n2 - 1 > this.data.size()) {
            return this.eof;
        }
        return this.elementAt(n2 - 1);
    }

    public int index() {
        return this.currentElementIndex;
    }

    public int mark() {
        ++this.markDepth;
        this.lastMarker = this.p;
        return this.lastMarker;
    }

    public void release(int n2) {
    }

    public void rewind(int n2) {
        --this.markDepth;
        int n3 = this.p - n2;
        this.currentElementIndex -= n3;
        this.p = n2;
    }

    public void rewind() {
        int n2 = this.p - this.lastMarker;
        this.currentElementIndex -= n2;
        this.p = this.lastMarker;
    }

    public void seek(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("can't seek before the beginning of the input");
        }
        int n3 = this.currentElementIndex - n2;
        if (this.p - n3 < 0) {
            throw new UnsupportedOperationException("can't seek before the beginning of this stream's buffer");
        }
        this.p -= n3;
        this.currentElementIndex = n2;
    }

    protected T LB(int n2) {
        assert (n2 > 0);
        int n3 = this.p - n2;
        if (n3 == -1) {
            return this.prevElement;
        }
        if (n3 >= 0) {
            return (T)this.data.get(n3);
        }
        if (n3 < -1) {
            throw new UnsupportedOperationException("can't look more than one token before the beginning of this stream's buffer");
        }
        throw new UnsupportedOperationException("can't look past the end of this stream's buffer using LB(int)");
    }
}

