/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.commons;

import org.eclipse.persistence.internal.libraries.asm.ModuleVisitor;
import org.eclipse.persistence.internal.libraries.asm.commons.Remapper;

public class ModuleRemapper
extends ModuleVisitor {
    protected final Remapper remapper;

    public ModuleRemapper(ModuleVisitor moduleVisitor, Remapper remapper) {
        this(458752, moduleVisitor, remapper);
    }

    protected ModuleRemapper(int api, ModuleVisitor moduleVisitor, Remapper remapper) {
        super(api, moduleVisitor);
        this.remapper = remapper;
    }

    @Override
    public void visitMainClass(String mainClass) {
        super.visitMainClass(this.remapper.mapType(mainClass));
    }

    @Override
    public void visitPackage(String packaze) {
        super.visitPackage(this.remapper.mapPackageName(packaze));
    }

    @Override
    public void visitRequire(String module, int access, String version) {
        super.visitRequire(this.remapper.mapModuleName(module), access, version);
    }

    @Override
    public void visitExport(String packaze, int access, String ... modules) {
        String[] remappedModules = null;
        if (modules != null) {
            remappedModules = new String[modules.length];
            for (int i2 = 0; i2 < modules.length; ++i2) {
                remappedModules[i2] = this.remapper.mapModuleName(modules[i2]);
            }
        }
        super.visitExport(this.remapper.mapPackageName(packaze), access, remappedModules);
    }

    @Override
    public void visitOpen(String packaze, int access, String ... modules) {
        String[] remappedModules = null;
        if (modules != null) {
            remappedModules = new String[modules.length];
            for (int i2 = 0; i2 < modules.length; ++i2) {
                remappedModules[i2] = this.remapper.mapModuleName(modules[i2]);
            }
        }
        super.visitOpen(this.remapper.mapPackageName(packaze), access, remappedModules);
    }

    @Override
    public void visitUse(String service) {
        super.visitUse(this.remapper.mapType(service));
    }

    @Override
    public void visitProvide(String service, String ... providers) {
        String[] remappedProviders = new String[providers.length];
        for (int i2 = 0; i2 < providers.length; ++i2) {
            remappedProviders[i2] = this.remapper.mapType(providers[i2]);
        }
        super.visitProvide(this.remapper.mapType(service), remappedProviders);
    }
}

