/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.mappings.converters;

import java.util.HashMap;
import java.util.Map;

public enum AttributeNamePrefix {
    NULL(""),
    KEY("key"),
    VALUE("value");

    public static final int LENGTH;
    private static final Map<String, AttributeNamePrefix> stringValuesMap;
    private final String name;

    static {
        LENGTH = AttributeNamePrefix.values().length;
        stringValuesMap = new HashMap<String, AttributeNamePrefix>(LENGTH);
        AttributeNamePrefix[] attributeNamePrefixArray = AttributeNamePrefix.values();
        int n2 = attributeNamePrefixArray.length;
        int n3 = 0;
        while (n3 < n2) {
            AttributeNamePrefix prefix = attributeNamePrefixArray[n3];
            stringValuesMap.put(prefix.getName(), prefix);
            ++n3;
        }
    }

    public static AttributeNamePrefix toValue(String name) {
        if (name != null) {
            return stringValuesMap.get(name);
        }
        return null;
    }

    private AttributeNamePrefix(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

