/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.persistence.core.sessions.CoreSession;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.NullCapableValue;
import org.eclipse.persistence.internal.oxm.TypeNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.mappings.DirectMapping;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;

public class XMLDirectMappingNodeValue
extends MappingNodeValue
implements NullCapableValue {
    private DirectMapping xmlDirectMapping;

    public XMLDirectMappingNodeValue(DirectMapping xmlDirectMapping) {
        this.xmlDirectMapping = xmlDirectMapping;
    }

    @Override
    public void setXPathNode(XPathNode xPathNode) {
        super.setXPathNode(xPathNode);
        this.xmlDirectMapping.getNullPolicy().xPathNode(xPathNode, this);
        if (((Field)this.xmlDirectMapping.getField()).isTypedTextField()) {
            XPathFragment typeAttributeXPathFragment = new XPathFragment();
            typeAttributeXPathFragment.setAttribute(true);
            typeAttributeXPathFragment.setLocalName("type");
            typeAttributeXPathFragment.setNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
            xPathNode.getParent().addChild(typeAttributeXPathFragment, new TypeNodeValue(), null);
        }
    }

    @Override
    public boolean isOwningNode(XPathFragment xPathFragment) {
        return xPathFragment.hasAttribute || xPathFragment.nameIsText;
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
        return this.marshal(xPathFragment, marshalRecord, object, session, namespaceResolver, ObjectMarshalContext.getInstance());
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (this.xmlDirectMapping.isReadOnly()) {
            return false;
        }
        Object objectValue = marshalContext.getAttributeValue(object, this.xmlDirectMapping);
        return this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, marshalContext);
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object objectValue, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        XPathFragment fragment;
        Object fieldValue = this.xmlDirectMapping.getFieldValue(objectValue, session, marshalRecord);
        if (fieldValue == null) {
            return this.xmlDirectMapping.getNullPolicy().directMarshal(xPathFragment, marshalRecord, object, session, namespaceResolver);
        }
        QName schemaType = ((Field)this.xmlDirectMapping.getField()).getSchemaTypeForValue(fieldValue, session);
        XPathFragment groupingFragment = null;
        boolean isQName = false;
        if (Constants.QNAME_QNAME.equals(schemaType)) {
            groupingFragment = this.openGroupingElementsForQName((QName)fieldValue, marshalRecord);
            isQName = true;
        }
        if (groupingFragment == null) {
            groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        }
        if (xPathFragment.hasAttribute) {
            marshalRecord.attribute(xPathFragment, namespaceResolver, fieldValue, schemaType);
            marshalRecord.closeStartGroupingElements(groupingFragment);
        } else {
            Field xmlField;
            XPathNode parentNode;
            if (((Field)this.xmlDirectMapping.getField()).getXPathFragment().nameIsText && (parentNode = this.xPathNode.getParent()).getAttributeChildren() != null) {
                marshalRecord.forceValueWrapper();
            }
            if ((xmlField = (Field)this.xmlDirectMapping.getField()).isTypedTextField()) {
                this.updateNamespaces(schemaType, marshalRecord, xmlField);
            }
            marshalRecord.closeStartGroupingElements(groupingFragment);
            marshalRecord.characters(schemaType, fieldValue, null, this.xmlDirectMapping.isCDATA());
        }
        if (isQName && (fragment = this.getLastGroupingFragment()) != groupingFragment) {
            marshalRecord.endElement(groupingFragment, namespaceResolver);
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private XPathFragment getLastGroupingFragment() {
        fragment = ((Field)this.getMapping().getField()).getXPathFragment();
        if (!fragment.hasAttribute && !fragment.nameIsText) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            if (fragment.getNextFragment().nameIsText || fragment.getNextFragment().hasAttribute) {
                return fragment;
            }
            fragment = fragment.getNextFragment();
lbl7:
            // 2 sources

            ** while (fragment.getNextFragment() != null)
        }
lbl8:
        // 1 sources

        return fragment;
    }

    private XPathFragment openGroupingElementsForQName(QName fieldValue, MarshalRecord marshalRecord) {
        XPathFragment xPathFragment = null;
        ArrayList<XPathNode> groupingElements = marshalRecord.getGroupingElements();
        Object namespaceResolver = marshalRecord.getNamespaceResolver();
        if ((fieldValue.getNamespaceURI() == null || fieldValue.getNamespaceURI().equals("")) && ((NamespaceResolver)marshalRecord.getNamespaceResolver()).getDefaultNamespaceURI() != null) {
            int x2 = 0;
            int groupingElementsSize = groupingElements.size();
            while (x2 < groupingElementsSize) {
                XPathNode xPathNode = groupingElements.get(x2);
                xPathFragment = xPathNode.getXPathFragment();
                if (x2 == groupingElements.size() - 1 && ((NamespaceResolver)namespaceResolver).getDefaultNamespaceURI().equals(xPathFragment.getNamespaceURI()) && xPathFragment.getPrefix() == null) {
                    String prefix = ((NamespaceResolver)namespaceResolver).generatePrefix();
                    String xPath = String.valueOf(prefix) + ':' + xPathFragment.getShortName();
                    XPathFragment newFragment = new XPathFragment(xPath);
                    newFragment.setNamespaceURI(((NamespaceResolver)namespaceResolver).getDefaultNamespaceURI());
                    marshalRecord.openStartElement(newFragment, namespaceResolver);
                    marshalRecord.namespaceDeclaration(prefix, ((NamespaceResolver)namespaceResolver).getDefaultNamespaceURI());
                    marshalRecord.predicateAttribute(xPathFragment, namespaceResolver);
                    xPathFragment = newFragment;
                } else {
                    marshalRecord.openStartElement(xPathFragment, namespaceResolver);
                    marshalRecord.predicateAttribute(xPathFragment, namespaceResolver);
                    marshalRecord.closeStartElement();
                }
                ++x2;
            }
            marshalRecord.setGroupingElement(null);
        }
        return xPathFragment;
    }

    @Override
    public void attribute(UnmarshalRecord unmarshalRecord, String namespaceURI, String localName, String value) {
        unmarshalRecord.removeNullCapableValue(this);
        Field xmlField = (Field)this.xmlDirectMapping.getField();
        Object session = unmarshalRecord.getSession();
        Object realValue = unmarshalRecord.getXMLReader().convertValueBasedOnSchemaType(xmlField, value, (ConversionManager)((CoreAbstractSession)session).getDatasourcePlatform().getConversionManager(), unmarshalRecord);
        Object convertedValue = this.xmlDirectMapping.getAttributeValue(realValue, session, unmarshalRecord);
        this.xmlDirectMapping.setAttributeValueInObject(unmarshalRecord.getCurrentObject(), convertedValue);
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        if (unmarshalRecord.isNil() && this.xmlDirectMapping.getNullPolicy().isNullRepresentedByXsiNil()) {
            Object convertedValue = this.xmlDirectMapping.getAttributeValue(XMLRecord.NIL, unmarshalRecord.getSession(), unmarshalRecord);
            unmarshalRecord.setAttributeValue(convertedValue, this.xmlDirectMapping);
            unmarshalRecord.resetStringBuffer();
            return;
        }
        unmarshalRecord.removeNullCapableValue(this);
        Field xmlField = (Field)this.xmlDirectMapping.getField();
        if (!xmlField.getLastXPathFragment().nameIsText) {
            return;
        }
        CharSequence unmarshalRecordCharacters = unmarshalRecord.getCharacters();
        Object value = unmarshalRecordCharacters.length() == 0 ? this.xmlDirectMapping.getNullValue() : unmarshalRecordCharacters.toString();
        unmarshalRecord.resetStringBuffer();
        Object session = unmarshalRecord.getSession();
        ConversionManager conversionManager = (ConversionManager)((CoreAbstractSession)session).getDatasourcePlatform().getConversionManager();
        QName typeQName = unmarshalRecord.getTypeQName();
        if (typeQName != null) {
            Class typeClass = xmlField.getJavaClass(typeQName, conversionManager);
            value = conversionManager.convertObject(value, typeClass, typeQName);
        } else {
            value = unmarshalRecord.getXMLReader().convertValueBasedOnSchemaType(xmlField, value, conversionManager, unmarshalRecord);
        }
        Object convertedValue = this.xmlDirectMapping.getAttributeValue(value, session, unmarshalRecord);
        unmarshalRecord.setAttributeValue(convertedValue, this.xmlDirectMapping);
    }

    @Override
    public void setNullValue(Object object, CoreSession session) {
        Object value = this.xmlDirectMapping.getObjectValue(null, session);
        this.xmlDirectMapping.setAttributeValueInObject(object, value);
    }

    @Override
    public boolean isNullCapableValue() {
        if (this.xmlDirectMapping.getAttributeAccessor().isInstanceVariableAttributeAccessor() && !this.xmlDirectMapping.hasConverter() && this.xmlDirectMapping.getNullValue() == null) {
            return false;
        }
        return this.xmlDirectMapping.getNullPolicy().getIsSetPerformedForAbsentNode();
    }

    @Override
    public DirectMapping getMapping() {
        return this.xmlDirectMapping;
    }

    @Override
    public boolean isWhitespaceAware() {
        return !this.xmlDirectMapping.getNullPolicy().isNullRepresentedByEmptyNode();
    }
}

