/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.descriptors.CoreObjectBuilder;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.Context;
import org.eclipse.persistence.internal.oxm.IDResolver;
import org.eclipse.persistence.internal.oxm.JsonTypeConfiguration;
import org.eclipse.persistence.internal.oxm.MediaType;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.StrBuffer;
import org.eclipse.persistence.internal.oxm.Unmarshaller;
import org.eclipse.persistence.internal.oxm.UnmarshallerHandler;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.record.PlatformUnmarshaller;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.XMLPlatform;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.oxm.attachment.XMLAttachmentUnmarshaller;
import org.eclipse.persistence.oxm.record.XMLRootRecord;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XMLUnmarshaller<ABSTRACT_SESSION extends CoreAbstractSession, CONTEXT extends Context, DESCRIPTOR extends Descriptor, ID_RESOLVER extends IDResolver, MEDIA_TYPE extends MediaType, ROOT extends Root, UNMARSHALLER_HANDLER extends UnmarshallerHandler, UNMARSHALLER_LISTENER extends Unmarshaller.Listener>
extends Unmarshaller<ABSTRACT_SESSION, CONTEXT, DESCRIPTOR, ID_RESOLVER, MEDIA_TYPE, ROOT, UNMARSHALLER_HANDLER, UNMARSHALLER_LISTENER>
implements Cloneable {
    public static final int NONVALIDATING = 0;
    public static final int SCHEMA_VALIDATION = 3;
    public static final int DTD_VALIDATION = 2;
    private static final String STAX_SOURCE_CLASS_NAME = "javax.xml.transform.stax.StAXSource";
    private static final String XML_STREAM_READER_CLASS_NAME = "javax.xml.stream.XMLStreamReader";
    private static final String XML_EVENT_READER_CLASS_NAME = "javax.xml.stream.XMLEventReader";
    private static final String GET_XML_STREAM_READER_METHOD_NAME = "getXMLStreamReader";
    private static final String GET_XML_EVENT_READER_METHOD_NAME = "getXMLEventReader";
    private static final String XML_STREAM_READER_READER_CLASS_NAME = "org.eclipse.persistence.internal.oxm.record.XMLStreamReaderReader";
    private static final String XML_EVENT_READER_READER_CLASS_NAME = "org.eclipse.persistence.internal.oxm.record.XMLEventReaderReader";
    private static final String XML_STREAM_READER_INPUT_SOURCE_CLASS_NAME = "org.eclipse.persistence.internal.oxm.record.XMLStreamReaderInputSource";
    private static final String XML_EVENT_READER_INPUT_SOURCE_CLASS_NAME = "org.eclipse.persistence.internal.oxm.record.XMLEventReaderInputSource";
    private static Class staxSourceClass;
    private static Method staxSourceGetStreamReaderMethod;
    private static Method staxSourceGetEventReaderMethod;
    private static Constructor xmlStreamReaderReaderConstructor;
    private static Constructor xmlStreamReaderInputSourceConstructor;
    private static Constructor xmlEventReaderReaderConstructor;
    private static Constructor xmlEventReaderInputSourceConstructor;
    private JsonTypeConfiguration jsonTypeConfiguration;
    private Boolean logPayload;
    private static final ErrorHandler DEFAULT_ERROR_HANDLER;
    protected UNMARSHALLER_HANDLER xmlUnmarshallerHandler;
    protected PlatformUnmarshaller platformUnmarshaller;
    protected boolean schemasAreInitialized;
    private XMLAttachmentUnmarshaller attachmentUnmarshaller;
    private Properties unmarshalProperties;
    private Class unmappedContentHandlerClass;
    private StrBuffer stringBuffer;
    private MEDIA_TYPE mediaType;
    private ID_RESOLVER idResolver;
    private String valueWrapper = "value";
    private char namespaceSeparator = (char)46;
    private String attributePrefix;
    private boolean includeRoot = true;
    private NamespaceResolver namespaceResolver;
    private boolean autoDetectMediaType = false;
    private boolean caseInsensitive = false;
    private Object unmarshalAttributeGroup;
    private boolean wrapperAsCollectionName = false;
    private boolean warnOnUnmappedElement = true;
    private boolean useXsdTypesWithPrefix = false;
    private boolean jsonTypeCompatibility = false;

    static {
        DEFAULT_ERROR_HANDLER = new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                if (exception.getException() instanceof EclipseLinkException) {
                    throw (EclipseLinkException)exception.getCause();
                }
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                if (exception.getException() instanceof EclipseLinkException) {
                    throw exception;
                }
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }
        };
        try {
            staxSourceClass = PrivilegedAccessHelper.getClassForName(STAX_SOURCE_CLASS_NAME);
            if (staxSourceClass != null) {
                staxSourceGetStreamReaderMethod = PrivilegedAccessHelper.getDeclaredMethod(staxSourceClass, GET_XML_STREAM_READER_METHOD_NAME, new Class[0]);
                staxSourceGetEventReaderMethod = PrivilegedAccessHelper.getDeclaredMethod(staxSourceClass, GET_XML_EVENT_READER_METHOD_NAME, new Class[0]);
                Class xmlStreamReaderInputSourceClass = PrivilegedAccessHelper.getClassForName(XML_STREAM_READER_INPUT_SOURCE_CLASS_NAME);
                Class xmlEventReaderInputSourceClass = PrivilegedAccessHelper.getClassForName(XML_EVENT_READER_INPUT_SOURCE_CLASS_NAME);
                Class xmlStreamReaderClass = PrivilegedAccessHelper.getClassForName(XML_STREAM_READER_CLASS_NAME);
                xmlStreamReaderInputSourceConstructor = PrivilegedAccessHelper.getConstructorFor(xmlStreamReaderInputSourceClass, new Class[]{xmlStreamReaderClass}, true);
                Class xmlEventReaderClass = PrivilegedAccessHelper.getClassForName(XML_EVENT_READER_CLASS_NAME);
                xmlEventReaderInputSourceConstructor = PrivilegedAccessHelper.getConstructorFor(xmlEventReaderInputSourceClass, new Class[]{xmlEventReaderClass}, true);
                Class xmlStreamReaderReaderClass = PrivilegedAccessHelper.getClassForName(XML_STREAM_READER_READER_CLASS_NAME);
                xmlStreamReaderReaderConstructor = PrivilegedAccessHelper.getConstructorFor(xmlStreamReaderReaderClass, new Class[0], true);
                Class xmlEventReaderReaderClass = PrivilegedAccessHelper.getClassForName(XML_EVENT_READER_READER_CLASS_NAME);
                xmlEventReaderReaderConstructor = PrivilegedAccessHelper.getConstructorFor(xmlEventReaderReaderClass, new Class[0], true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected XMLUnmarshaller(CONTEXT xmlContext) {
        this(xmlContext, null);
    }

    protected XMLUnmarshaller(CONTEXT xmlContext, Map<String, Boolean> parserFeatures) {
        super(xmlContext);
        this.stringBuffer = new StrBuffer();
        this.initialize(parserFeatures);
        this.setErrorHandler(DEFAULT_ERROR_HANDLER);
    }

    protected XMLUnmarshaller(XMLUnmarshaller xmlUnmarshaller) {
        super(xmlUnmarshaller);
        this.stringBuffer = new StrBuffer();
        this.initialize(null);
        this.setAttachmentUnmarshaller(xmlUnmarshaller.getAttachmentUnmarshaller());
        this.setEntityResolver(xmlUnmarshaller.getEntityResolver());
        this.setErrorHandler(xmlUnmarshaller.getErrorHandler());
        for (Map.Entry<Object, Object> entry : xmlUnmarshaller.getProperties().entrySet()) {
            this.getProperties().put(entry.getKey(), entry.getValue());
        }
        this.setResultAlwaysXMLRoot(xmlUnmarshaller.platformUnmarshaller.isResultAlwaysXMLRoot());
        try {
            Schema schema = xmlUnmarshaller.getSchema();
            if (schema != null) {
                this.setSchema(schema);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.setUnmappedContentHandlerClass(xmlUnmarshaller.unmappedContentHandlerClass);
    }

    protected void initialize(Map<String, Boolean> parserFeatures) {
        Object session = this.context.getSession();
        XMLPlatform xmlPlatform = (XMLPlatform)session.getDatasourceLogin().getDatasourcePlatform();
        this.platformUnmarshaller = xmlPlatform.newPlatformUnmarshaller(this, parserFeatures);
        this.platformUnmarshaller.setWhitespacePreserving(false);
    }

    public void setMediaType(MEDIA_TYPE mediaType) {
        if (this.mediaType != mediaType) {
            this.mediaType = mediaType;
            if (this.platformUnmarshaller != null) {
                this.platformUnmarshaller.mediaTypeChanged();
            }
        }
    }

    @Override
    public MEDIA_TYPE getMediaType() {
        return this.mediaType;
    }

    public CONTEXT getXMLContext() {
        return this.getContext();
    }

    public void setXMLContext(CONTEXT value) {
        this.context = value;
    }

    public int getValidationMode() {
        return this.platformUnmarshaller.getValidationMode();
    }

    public EntityResolver getEntityResolver() {
        return this.platformUnmarshaller.getEntityResolver();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.platformUnmarshaller.setEntityResolver(entityResolver);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.platformUnmarshaller.getErrorHandler();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            this.platformUnmarshaller.setErrorHandler(DEFAULT_ERROR_HANDLER);
        } else {
            this.platformUnmarshaller.setErrorHandler(errorHandler);
        }
    }

    @Override
    public Class getUnmappedContentHandlerClass() {
        return this.unmappedContentHandlerClass;
    }

    public void setUnmappedContentHandlerClass(Class aClass) {
        this.unmappedContentHandlerClass = aClass;
    }

    @Override
    public StrBuffer getStringBuffer() {
        return this.stringBuffer;
    }

    public Object unmarshal(File file) throws XMLMarshalException {
        if (file == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        Object result = this.platformUnmarshaller.unmarshal(file);
        this.logUnmarshall(result);
        return result;
    }

    public Object unmarshal(File file, Class clazz) throws XMLMarshalException {
        if (file == null || clazz == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        Object result = this.platformUnmarshaller.unmarshal(file, clazz);
        this.logUnmarshall(result);
        return result;
    }

    public Object unmarshal(InputStream inputStream) throws XMLMarshalException {
        if (inputStream == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        Object result = this.platformUnmarshaller.unmarshal(inputStream);
        this.logUnmarshall(result);
        return result;
    }

    public Object unmarshal(InputStream inputStream, Class clazz) throws XMLMarshalException {
        if (inputStream == null || clazz == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        Object result = this.platformUnmarshaller.unmarshal(inputStream, clazz);
        this.logUnmarshall(result);
        return result;
    }

    public Object unmarshal(Reader reader) throws XMLMarshalException {
        if (reader == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        Object result = this.platformUnmarshaller.unmarshal(reader);
        this.logUnmarshall(result);
        return result;
    }

    public Object unmarshal(Reader reader, Class clazz) throws XMLMarshalException {
        if (reader == null || clazz == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        Object result = this.platformUnmarshaller.unmarshal(reader, clazz);
        this.logUnmarshall(result);
        return result;
    }

    public Object unmarshal(URL url) throws XMLMarshalException {
        if (url == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        Object result = this.platformUnmarshaller.unmarshal(url);
        this.logUnmarshall(result);
        return result;
    }

    public Object unmarshal(URL url, Class clazz) throws XMLMarshalException {
        if (url == null || clazz == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        Object result = this.platformUnmarshaller.unmarshal(url, clazz);
        this.logUnmarshall(result);
        return result;
    }

    public Object unmarshal(InputSource inputSource) throws XMLMarshalException {
        if (inputSource == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        Object result = this.platformUnmarshaller.unmarshal(inputSource);
        this.logUnmarshall(result);
        return result;
    }

    public Object unmarshal(InputSource inputSource, Class clazz) throws XMLMarshalException {
        if (inputSource == null || clazz == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        Object result = this.platformUnmarshaller.unmarshal(inputSource, clazz);
        this.logUnmarshall(result);
        return result;
    }

    public Object unmarshal(Node node) throws XMLMarshalException {
        if (node == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        if (node.getNodeType() == 9 || node.getNodeType() == 1 || node.getNodeType() == 11) {
            Object result = this.platformUnmarshaller.unmarshal(node);
            this.logUnmarshall(result);
            return result;
        }
        throw XMLMarshalException.unmarshalException();
    }

    public Object unmarshal(Node node, Class clazz) throws XMLMarshalException {
        if (node == null || clazz == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        Object result = this.platformUnmarshaller.unmarshal(node, clazz);
        this.logUnmarshall(result);
        return result;
    }

    public Object unmarshal(Source source) throws XMLMarshalException {
        if (source == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        if (source.getClass() == staxSourceClass) {
            try {
                Object xmlStreamReader = PrivilegedAccessHelper.invokeMethod(staxSourceGetStreamReaderMethod, source);
                if (xmlStreamReader != null) {
                    InputSource inputSource = (InputSource)PrivilegedAccessHelper.invokeConstructor(xmlStreamReaderInputSourceConstructor, new Object[]{xmlStreamReader});
                    XMLReader xmlReader = (XMLReader)PrivilegedAccessHelper.invokeConstructor(xmlStreamReaderReaderConstructor, new Object[0]);
                    Object result = this.platformUnmarshaller.unmarshal(xmlReader, inputSource);
                    this.logUnmarshall(result);
                    return result;
                }
                Object xmlEventReader = PrivilegedAccessHelper.invokeMethod(staxSourceGetEventReaderMethod, source);
                if (xmlEventReader != null) {
                    InputSource inputSource = (InputSource)PrivilegedAccessHelper.invokeConstructor(xmlEventReaderInputSourceConstructor, new Object[]{xmlEventReader});
                    XMLReader xmlReader = (XMLReader)PrivilegedAccessHelper.invokeConstructor(xmlEventReaderReaderConstructor, new Object[0]);
                    Object result = this.platformUnmarshaller.unmarshal(xmlReader, inputSource);
                    this.logUnmarshall(result);
                    return result;
                }
            }
            catch (Exception e2) {
                throw XMLMarshalException.unmarshalException(e2);
            }
        }
        return this.platformUnmarshaller.unmarshal(source);
    }

    public Properties getProperties() {
        if (this.unmarshalProperties == null) {
            this.unmarshalProperties = new Properties();
        }
        return this.unmarshalProperties;
    }

    @Override
    public Object getProperty(Object key) {
        if (this.unmarshalProperties == null) {
            return null;
        }
        return this.unmarshalProperties.get(key);
    }

    public Object unmarshal(Source source, Class clazz) throws XMLMarshalException {
        if (source == null || clazz == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        if (source.getClass() == staxSourceClass) {
            try {
                Object xmlStreamReader = PrivilegedAccessHelper.invokeMethod(staxSourceGetStreamReaderMethod, source);
                if (xmlStreamReader != null) {
                    InputSource inputSource = (InputSource)PrivilegedAccessHelper.invokeConstructor(xmlStreamReaderInputSourceConstructor, new Object[]{xmlStreamReader});
                    XMLReader xmlReader = (XMLReader)PrivilegedAccessHelper.invokeConstructor(xmlStreamReaderReaderConstructor, new Object[0]);
                    Object result = this.platformUnmarshaller.unmarshal(xmlReader, inputSource, clazz);
                    this.logUnmarshall(result);
                    return result;
                }
                Object xmlEventReader = PrivilegedAccessHelper.invokeMethod(staxSourceGetEventReaderMethod, source);
                if (xmlEventReader != null) {
                    InputSource inputSource = (InputSource)PrivilegedAccessHelper.invokeConstructor(xmlEventReaderInputSourceConstructor, new Object[]{xmlEventReader});
                    XMLReader xmlReader = (XMLReader)PrivilegedAccessHelper.invokeConstructor(xmlEventReaderReaderConstructor, new Object[0]);
                    Object result = this.platformUnmarshaller.unmarshal(xmlReader, inputSource, clazz);
                    this.logUnmarshall(result);
                    return result;
                }
            }
            catch (Exception e2) {
                throw XMLMarshalException.unmarshalException(e2);
            }
        }
        Object result = this.platformUnmarshaller.unmarshal(source, clazz);
        this.logUnmarshall(result);
        return result;
    }

    public Object unmarshal(XMLReader xmlReader, InputSource inputSource) {
        Object result = this.platformUnmarshaller.unmarshal(xmlReader, inputSource);
        this.logUnmarshall(result);
        return result;
    }

    public Object unmarshal(XMLReader xmlReader, InputSource inputSource, Class clazz) {
        Object result = this.platformUnmarshaller.unmarshal(xmlReader, inputSource, clazz);
        this.logUnmarshall(result);
        return result;
    }

    @Override
    public UNMARSHALLER_HANDLER getUnmarshallerHandler() {
        throw new UnsupportedOperationException();
    }

    @Override
    public XMLAttachmentUnmarshaller getAttachmentUnmarshaller() {
        return this.attachmentUnmarshaller;
    }

    public void setAttachmentUnmarshaller(XMLAttachmentUnmarshaller atu) {
        this.attachmentUnmarshaller = atu;
    }

    public void setResultAlwaysXMLRoot(boolean alwaysReturnRoot) {
        this.platformUnmarshaller.setResultAlwaysXMLRoot(alwaysReturnRoot);
    }

    @Override
    public boolean isResultAlwaysXMLRoot() {
        return this.platformUnmarshaller.isResultAlwaysXMLRoot();
    }

    public void setSchema(Schema schema) {
        this.platformUnmarshaller.setSchema(schema);
    }

    @Override
    public Schema getSchema() {
        return this.platformUnmarshaller.getSchema();
    }

    @Override
    public String getAttributePrefix() {
        return this.attributePrefix;
    }

    public void setAttributePrefix(String attributePrefix) {
        this.attributePrefix = attributePrefix;
    }

    @Override
    public String getValueWrapper() {
        return this.valueWrapper;
    }

    public void setValueWrapper(String valueWrapper) {
        this.valueWrapper = valueWrapper;
    }

    @Override
    public char getNamespaceSeparator() {
        return this.namespaceSeparator;
    }

    public void setNamespaceSeparator(char namespaceSeparator) {
        this.namespaceSeparator = namespaceSeparator;
    }

    @Override
    public boolean isIncludeRoot() {
        return this.includeRoot;
    }

    public void setIncludeRoot(boolean includeRoot) {
        this.includeRoot = includeRoot;
    }

    @Override
    public boolean isApplicationJSON() {
        return this.mediaType != null && this.mediaType.isApplicationJSON();
    }

    @Override
    public boolean isApplicationXML() {
        return this.mediaType == null || this.mediaType.isApplicationXML();
    }

    @Override
    public boolean isAutoDetectMediaType() {
        return this.autoDetectMediaType;
    }

    public void setAutoDetectMediaType(boolean autoDetectMediaType) {
        this.autoDetectMediaType = autoDetectMediaType;
    }

    @Override
    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    @Override
    public boolean isWrapperAsCollectionName() {
        return this.wrapperAsCollectionName;
    }

    public void setWrapperAsCollectionName(boolean wrapperAsCollectionName) {
        this.wrapperAsCollectionName = wrapperAsCollectionName;
    }

    public XMLUnmarshaller clone() {
        return new XMLUnmarshaller<ABSTRACT_SESSION, CONTEXT, DESCRIPTOR, ID_RESOLVER, MEDIA_TYPE, ROOT, UNMARSHALLER_HANDLER, UNMARSHALLER_LISTENER>(this);
    }

    @Override
    public ID_RESOLVER getIDResolver() {
        return this.idResolver;
    }

    @Override
    public void setIDResolver(ID_RESOLVER idResolver) {
        this.idResolver = idResolver;
    }

    @Override
    public ROOT createRoot() {
        throw new UnsupportedOperationException();
    }

    @Override
    public UnmarshalRecord createRootUnmarshalRecord(Class clazz) {
        return new XMLRootRecord(clazz, this);
    }

    @Override
    public UnmarshalRecord createUnmarshalRecord(DESCRIPTOR xmlDescriptor, ABSTRACT_SESSION session) {
        return (UnmarshalRecord)((CoreObjectBuilder)xmlDescriptor.getObjectBuilder()).createRecord(session);
    }

    @Override
    public Object getUnmarshalAttributeGroup() {
        return this.unmarshalAttributeGroup;
    }

    public void setUnmarshalAttributeGroup(Object attributeGroup) {
        this.unmarshalAttributeGroup = attributeGroup;
    }

    @Override
    public boolean shouldWarnOnUnmappedElement() {
        return this.warnOnUnmappedElement;
    }

    public void setWarnOnUnmappedElement(boolean warnOnUnmappedElement) {
        this.warnOnUnmappedElement = warnOnUnmappedElement;
    }

    @Override
    public JsonTypeConfiguration getJsonTypeConfiguration() {
        if (this.jsonTypeConfiguration == null) {
            this.jsonTypeConfiguration = new JsonTypeConfiguration();
        }
        return this.jsonTypeConfiguration;
    }

    public final boolean isSecureProcessingDisabled() {
        return this.platformUnmarshaller.isSecureProcessingDisabled();
    }

    public final void setDisableSecureProcessing(boolean disableSecureProcessing) {
        this.platformUnmarshaller.setDisableSecureProcessing(disableSecureProcessing);
    }

    public Boolean isLogPayload() {
        return this.logPayload;
    }

    public void setLogPayload(Boolean logPayload) {
        this.logPayload = logPayload;
    }

    private void logUnmarshall(Object object) {
        SessionLog logger = AbstractSessionLog.getLog();
        if (logger.shouldLog(3, "moxy")) {
            logger.log(3, "moxy", "moxy_start_unmarshalling", new Object[]{object != null ? object.getClass().getName() : "N/A", this.mediaType, this.platformUnmarshaller.getClass().getName()});
        }
        if (object != null && this.logPayload != null && this.isLogPayload().booleanValue()) {
            AbstractSessionLog.getLog().log(1, "moxy", object.toString(), new Object[0], false);
        }
    }
}

