/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.DeferrableChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.OrderedChangeObject;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;

public class CollectionChangeRecord
extends DeferrableChangeRecord
implements org.eclipse.persistence.sessions.changesets.CollectionChangeRecord {
    protected Map<ObjectChangeSet, ObjectChangeSet> addObjectList;
    protected List<ObjectChangeSet> orderedAddObjects;
    protected Map<ObjectChangeSet, Integer> orderedAddObjectIndices;
    protected List<OrderedChangeObject> orderedChangeObjectList;
    protected Map<Integer, ObjectChangeSet> orderedRemoveObjects;
    protected transient List<Integer> orderedRemoveObjectIndices;
    protected transient List<ObjectChangeSet> addOverFlow;
    protected Map<ObjectChangeSet, ObjectChangeSet> removeObjectList;
    protected boolean orderHasBeenRepaired;

    public CollectionChangeRecord() {
    }

    public CollectionChangeRecord(ObjectChangeSet owner) {
        this.owner = owner;
    }

    public void addAdditionChange(Map objectChanges, ContainerPolicy cp, UnitOfWorkChangeSet changeSet, AbstractSession session) {
        Iterator enumtr = objectChanges.values().iterator();
        while (enumtr.hasNext()) {
            Object object = cp.unwrapElement(enumtr.next());
            ObjectChangeSet change = session.getDescriptor(object.getClass()).getObjectBuilder().createObjectChangeSet(object, changeSet, session);
            if (change.hasKeys()) {
                this.getAddObjectList().put(change, change);
                continue;
            }
            if (this.getRemoveObjectList().containsKey(change)) {
                this.getRemoveObjectList().remove(change);
                continue;
            }
            this.getAddObjectList().put(change, change);
        }
    }

    public void addOrderedAdditionChange(List<Object> orderedObjectsToAdd, Map<Object, Integer> objectChangesIndices, UnitOfWorkChangeSet changeSet, AbstractSession session) {
        for (Object object : orderedObjectsToAdd) {
            ObjectChangeSet change = session.getDescriptor(object.getClass()).getObjectBuilder().createObjectChangeSet(object, changeSet, session);
            this.getOrderedAddObjects().add(change);
            this.getOrderedAddObjectIndices().put(change, objectChangesIndices.get(object));
        }
    }

    public void addOrderedRemoveChange(List<Integer> indicesToRemove, Map objectChanges, UnitOfWorkChangeSet changeSet, AbstractSession session) {
        this.orderedRemoveObjectIndices = indicesToRemove;
        for (Integer index : indicesToRemove) {
            Object object = objectChanges.get(index);
            ObjectChangeSet change = session.getDescriptor(object.getClass()).getObjectBuilder().createObjectChangeSet(object, changeSet, session);
            this.getOrderedRemoveObjects().put(index, change);
        }
    }

    public void addRemoveChange(Map objectChanges, ContainerPolicy cp, UnitOfWorkChangeSet changeSet, AbstractSession session) {
        if (objectChanges.isEmpty()) {
            return;
        }
        ClassDescriptor descriptor = this.mapping.getReferenceDescriptor();
        boolean hasChildren = descriptor.hasInheritance() && descriptor.getInheritancePolicy().hasChildren() || descriptor.hasTablePerClassPolicy();
        Iterator enumtr = cp.getChangeValuesFrom(objectChanges);
        while (enumtr.hasNext()) {
            ObjectChangeSet change;
            Object object = cp.unwrapElement(enumtr.next());
            if (hasChildren) {
                descriptor = this.getReferenceDescriptor(object, session);
            }
            if ((change = descriptor.getObjectBuilder().createObjectChangeSet(object, changeSet, session)).hasKeys()) {
                this.getRemoveObjectList().put(change, change);
                continue;
            }
            if (this.getAddObjectList().containsKey(change)) {
                this.getAddObjectList().remove(change);
                continue;
            }
            this.getRemoveObjectList().put(change, change);
        }
    }

    @Override
    public Map<ObjectChangeSet, ObjectChangeSet> getAddObjectList() {
        if (this.addObjectList == null) {
            this.addObjectList = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>(10);
        }
        return this.addObjectList;
    }

    public List<ObjectChangeSet> getAddOverFlow() {
        if (this.addOverFlow == null) {
            this.addOverFlow = new ArrayList<ObjectChangeSet>();
        }
        return this.addOverFlow;
    }

    ClassDescriptor getReferenceDescriptor(Object object, AbstractSession session) {
        return session.getClassDescriptor(object);
    }

    @Override
    public Map<ObjectChangeSet, ObjectChangeSet> getRemoveObjectList() {
        if (this.removeObjectList == null) {
            this.removeObjectList = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>();
        }
        return this.removeObjectList;
    }

    @Override
    public boolean hasChanges() {
        return this.addObjectList != null && !this.addObjectList.isEmpty() || this.removeObjectList != null && !this.removeObjectList.isEmpty() || this.orderedAddObjects != null && !this.orderedAddObjects.isEmpty() || this.orderedRemoveObjects != null && !this.orderedRemoveObjects.isEmpty() || this.orderedChangeObjectList != null && !this.orderedChangeObjectList.isEmpty() || this.getOwner().isNew();
    }

    @Override
    public void mergeRecord(ChangeRecord mergeFromRecord, UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        if (((DeferrableChangeRecord)mergeFromRecord).isDeferred()) {
            if (this.hasChanges()) {
                ((DeferrableChangeRecord)mergeFromRecord).getMapping().calculateDeferredChanges(mergeFromRecord, mergeToChangeSet.getSession());
            } else {
                if (!this.isDeferred) {
                    this.originalCollection = ((DeferrableChangeRecord)mergeFromRecord).originalCollection;
                }
                this.isDeferred = true;
                this.latestCollection = ((DeferrableChangeRecord)mergeFromRecord).latestCollection;
                return;
            }
        }
        HashMap<ObjectChangeSet, ObjectChangeSet> changeSets = new HashMap<ObjectChangeSet, ObjectChangeSet>();
        for (ObjectChangeSet mergingObject : ((CollectionChangeRecord)mergeFromRecord).getAddObjectList().keySet()) {
            ObjectChangeSet localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(mergingObject, mergeFromChangeSet);
            if (this.getRemoveObjectList().containsKey(localChangeSet)) {
                this.getRemoveObjectList().remove(localChangeSet);
                continue;
            }
            changeSets.put(localChangeSet, localChangeSet);
        }
        this.getAddObjectList().putAll(changeSets);
        changeSets = new HashMap();
        for (ObjectChangeSet mergingObject : ((CollectionChangeRecord)mergeFromRecord).getRemoveObjectList().keySet()) {
            ObjectChangeSet localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(mergingObject, mergeFromChangeSet);
            if (this.getAddObjectList().containsKey(localChangeSet)) {
                this.getAddObjectList().remove(localChangeSet);
                continue;
            }
            changeSets.put(localChangeSet, localChangeSet);
        }
        this.getRemoveObjectList().putAll(changeSets);
        ArrayList<OrderedChangeObject> orderedChangeSets = new ArrayList<OrderedChangeObject>();
        for (OrderedChangeObject changeObject : ((CollectionChangeRecord)mergeFromRecord).getOrderedChangeObjectList()) {
            ObjectChangeSet mergingObject = changeObject.getChangeSet();
            ObjectChangeSet localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(mergingObject, mergeFromChangeSet);
            OrderedChangeObject orderedChangeObject = new OrderedChangeObject(changeObject.getChangeType(), changeObject.getIndex(), localChangeSet);
            orderedChangeSets.add(orderedChangeObject);
        }
        this.getOrderedChangeObjectList().addAll(orderedChangeSets);
    }

    public void setAddObjectList(Map<ObjectChangeSet, ObjectChangeSet> objectChangesList) {
        this.addObjectList = objectChangesList;
    }

    public void setRemoveObjectList(Map<ObjectChangeSet, ObjectChangeSet> objectChangesList) {
        this.removeObjectList = objectChangesList;
    }

    @Override
    public void updateReferences(UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        IdentityHashMap<ObjectChangeSet, ObjectChangeSet> addList = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>(this.getAddObjectList().size() + 1);
        IdentityHashMap<ObjectChangeSet, ObjectChangeSet> removeList = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>(this.getRemoveObjectList().size() + 1);
        if (this.getOrderedAddObjects().size() > 0 || this.getOrderedRemoveObjectIndices().size() > 0) {
            ArrayList<ObjectChangeSet> orderedAddList = new ArrayList<ObjectChangeSet>(this.getOrderedAddObjects().size());
            IdentityHashMap<ObjectChangeSet, Integer> orderedAddListIndices = new IdentityHashMap<ObjectChangeSet, Integer>(this.getOrderedAddObjectIndices().size());
            int i2 = 0;
            while (i2 < this.getOrderedAddObjects().size()) {
                ObjectChangeSet changeSet = this.getOrderedAddObjects().get(i2);
                ObjectChangeSet localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(changeSet, mergeFromChangeSet);
                orderedAddList.add(localChangeSet);
                orderedAddListIndices.put(localChangeSet, this.getOrderedAddObjectIndices().get(changeSet));
                if (this.getAddObjectList().containsKey(changeSet)) {
                    addList.put(localChangeSet, localChangeSet);
                }
                ++i2;
            }
            this.setOrderedAddObjects(orderedAddList);
            this.setOrderedAddObjectIndices(orderedAddListIndices);
            HashMap<Integer, ObjectChangeSet> orderedRemoveList = new HashMap<Integer, ObjectChangeSet>(this.getOrderedRemoveObjects().size());
            for (Integer index : this.getOrderedRemoveObjects().keySet()) {
                ObjectChangeSet changeSet = this.getOrderedRemoveObjects().get(index);
                ObjectChangeSet localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(changeSet, mergeFromChangeSet);
                orderedRemoveList.put(index, localChangeSet);
                if (!this.getRemoveObjectList().containsKey(changeSet)) continue;
                removeList.put(localChangeSet, localChangeSet);
            }
            this.setOrderedRemoveObjects(orderedRemoveList);
        } else {
            ObjectChangeSet localChangeSet;
            Iterator<ObjectChangeSet> changes = this.getAddObjectList().values().iterator();
            while (changes.hasNext()) {
                localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(changes.next(), mergeFromChangeSet);
                addList.put(localChangeSet, localChangeSet);
            }
            changes = this.getRemoveObjectList().values().iterator();
            while (changes.hasNext()) {
                localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(changes.next(), mergeFromChangeSet);
                removeList.put(localChangeSet, localChangeSet);
            }
        }
        this.setAddObjectList(addList);
        this.setRemoveObjectList(removeList);
    }

    public List<ObjectChangeSet> getOrderedAddObjects() {
        if (this.orderedAddObjects == null) {
            this.orderedAddObjects = new ArrayList<ObjectChangeSet>();
        }
        return this.orderedAddObjects;
    }

    public Integer getOrderedAddObjectIndex(ObjectChangeSet changes) {
        return this.getOrderedAddObjectIndices().get(changes);
    }

    public Map<ObjectChangeSet, Integer> getOrderedAddObjectIndices() {
        if (this.orderedAddObjectIndices == null) {
            this.orderedAddObjectIndices = new IdentityHashMap<ObjectChangeSet, Integer>();
        }
        return this.orderedAddObjectIndices;
    }

    public List<OrderedChangeObject> getOrderedChangeObjectList() {
        if (this.orderedChangeObjectList == null) {
            this.orderedChangeObjectList = new ArrayList<OrderedChangeObject>();
        }
        return this.orderedChangeObjectList;
    }

    public List<Integer> getOrderedRemoveObjectIndices() {
        if (this.orderedRemoveObjectIndices == null) {
            this.orderedRemoveObjectIndices = new ArrayList<Integer>();
        }
        return this.orderedRemoveObjectIndices;
    }

    public Object getOrderedRemoveObject(Integer index) {
        return this.getOrderedRemoveObjects().get(index);
    }

    public Map<Integer, ObjectChangeSet> getOrderedRemoveObjects() {
        if (this.orderedRemoveObjects == null) {
            this.orderedRemoveObjects = new HashMap<Integer, ObjectChangeSet>();
        }
        return this.orderedRemoveObjects;
    }

    public void setOrderedAddObjectIndices(Map<ObjectChangeSet, Integer> orderedAddObjectIndices) {
        this.orderedAddObjectIndices = orderedAddObjectIndices;
    }

    public void setOrderedAddObjects(List<ObjectChangeSet> orderedAddObjects) {
        this.orderedAddObjects = orderedAddObjects;
    }

    public void setOrderedChangeObjectList(List<OrderedChangeObject> orderedChangeObjectList) {
        this.orderedChangeObjectList = orderedChangeObjectList;
    }

    public void setOrderedRemoveObjects(Map<Integer, ObjectChangeSet> orderedRemoveObjects) {
        this.orderedRemoveObjects = orderedRemoveObjects;
    }

    public List<Integer> getCurrentIndexesOfOriginalObjects(List newList) {
        int newSize = newList.size();
        ArrayList<Integer> currentIndexes = new ArrayList<Integer>(newSize);
        int i2 = 0;
        while (i2 < newSize) {
            currentIndexes.add(i2);
            ++i2;
        }
        if (this.orderedChangeObjectList != null) {
            i2 = this.orderedChangeObjectList.size() - 1;
            while (i2 >= 0) {
                OrderedChangeObject orderedChange = this.orderedChangeObjectList.get(i2);
                Object obj = orderedChange.getAddedOrRemovedObject();
                Integer index = orderedChange.getIndex();
                int changeType = orderedChange.getChangeType();
                if (changeType == 0) {
                    if (index == null) {
                        currentIndexes.remove(currentIndexes.size() - 1);
                    } else {
                        currentIndexes.remove(index);
                    }
                } else if (changeType == 1) {
                    if (index == null) {
                        throw ValidationException.collectionRemoveEventWithNoIndex(this.getMapping());
                    }
                    currentIndexes.add(index, newList.indexOf(obj));
                }
                --i2;
            }
        }
        return currentIndexes;
    }

    @Override
    public void internalRecreateOriginalCollection(Object currentCollection, AbstractSession session) {
        block11: {
            block10: {
                ContainerPolicy cp = this.mapping.getContainerPolicy();
                if (this.orderedChangeObjectList != null && !this.orderedChangeObjectList.isEmpty()) break block10;
                if (this.removeObjectList != null) {
                    for (ObjectChangeSet changeSet : this.removeObjectList.keySet()) {
                        cp.addInto(changeSet.getUnitOfWorkClone(), currentCollection, session);
                    }
                }
                if (this.addObjectList == null) break block11;
                for (ObjectChangeSet changeSet : this.addObjectList.keySet()) {
                    cp.removeFrom(changeSet.getUnitOfWorkClone(), currentCollection, session);
                }
                break block11;
            }
            List originalList = (List)currentCollection;
            int i2 = this.orderedChangeObjectList.size() - 1;
            while (i2 >= 0) {
                OrderedChangeObject orderedChange = this.orderedChangeObjectList.get(i2);
                Object obj = orderedChange.getAddedOrRemovedObject();
                Integer index = orderedChange.getIndex();
                int changeType = orderedChange.getChangeType();
                if (changeType == 0) {
                    if (index == null) {
                        originalList.remove(originalList.size() - 1);
                    } else {
                        originalList.remove(index);
                    }
                } else if (changeType == 1) {
                    if (index == null) {
                        throw ValidationException.collectionRemoveEventWithNoIndex(this.getMapping());
                    }
                    originalList.add(index, obj);
                }
                --i2;
            }
        }
    }

    public void setOrderHasBeenRepaired(boolean hasBeenRepaired) {
        this.orderHasBeenRepaired = hasBeenRepaired;
    }

    public boolean orderHasBeenRepaired() {
        return this.orderHasBeenRepaired;
    }

    @Override
    public void clearChanges() {
        if (this.orderedChangeObjectList != null) {
            this.orderedChangeObjectList.clear();
        }
        if (this.removeObjectList != null) {
            this.removeObjectList.clear();
        }
        if (this.addObjectList != null) {
            this.addObjectList.clear();
        }
    }
}

