/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import org.eclipse.persistence.oxm.XMLNameTransformer;

public class DefaultXMLNameTransformer
implements XMLNameTransformer {
    private static final String EMPTY_STRING = "";
    private static final Character DOT_CHAR = Character.valueOf('.');
    private static final Character DOLLAR_SIGN_CHAR = Character.valueOf('$');

    @Override
    public String transformRootElementName(String className) {
        int idx;
        String elementName = null;
        elementName = className.indexOf(DOLLAR_SIGN_CHAR.charValue()) != -1 ? this.decapitalize(className.substring(className.lastIndexOf(DOLLAR_SIGN_CHAR.charValue()) + 1)) : this.decapitalize(className.substring(className.lastIndexOf(DOT_CHAR.charValue()) + 1));
        if (elementName.length() >= 3 && Character.isDigit(elementName.charAt((idx = elementName.length() - 1) - 1))) {
            elementName = String.valueOf(elementName.substring(0, idx)) + Character.toUpperCase(elementName.charAt(idx));
        }
        return elementName;
    }

    @Override
    public String transformTypeName(String className) {
        String typeName = EMPTY_STRING;
        typeName = className.indexOf(DOLLAR_SIGN_CHAR.charValue()) != -1 ? this.decapitalize(className.substring(className.lastIndexOf(DOLLAR_SIGN_CHAR.charValue()) + 1)) : this.decapitalize(className.substring(className.lastIndexOf(DOT_CHAR.charValue()) + 1));
        boolean inBreak = false;
        StringBuilder toReturn = new StringBuilder(typeName.length());
        int i2 = 0;
        while (i2 < typeName.length()) {
            char next = typeName.charAt(i2);
            if (Character.isDigit(next)) {
                if (!inBreak) {
                    inBreak = true;
                }
                toReturn.append(next);
            } else if (inBreak) {
                toReturn.append(Character.toUpperCase(next));
                inBreak = false;
            } else {
                toReturn.append(next);
            }
            ++i2;
        }
        return toReturn.toString();
    }

    private String decapitalize(String javaName) {
        char[] name = javaName.toCharArray();
        int i2 = 0;
        while (i2 < name.length && Character.isUpperCase(name[i2])) {
            ++i2;
        }
        if (i2 > 0) {
            if (name.length > i2 && Character.isLetter(name[i2])) {
                --i2;
            }
            name[0] = Character.toLowerCase(name[0]);
            int j2 = 1;
            while (j2 < i2) {
                name[j2] = Character.toLowerCase(name[j2]);
                ++j2;
            }
            return new String(name);
        }
        return javaName;
    }

    @Override
    public String transformElementName(String name) {
        return name;
    }

    @Override
    public String transformAttributeName(String name) {
        return name;
    }
}

