/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.oxm.XMLContext;

public class JAXBIntrospector
extends javax.xml.bind.JAXBIntrospector {
    private XMLContext context;

    public JAXBIntrospector(XMLContext context) {
        this.context = context;
    }

    public boolean isElement(Object obj) {
        if (obj instanceof JAXBElement) {
            return true;
        }
        try {
            Descriptor descriptor = this.context.getDescriptorForObject(obj);
            return descriptor != null && descriptor.getDefaultRootElementField() != null;
        }
        catch (XMLMarshalException e2) {
            return false;
        }
    }

    public QName getElementName(Object obj) {
        if (!this.isElement(obj)) {
            return null;
        }
        if (obj instanceof JAXBElement) {
            return ((JAXBElement)obj).getName();
        }
        try {
            Descriptor descriptor = (Descriptor)((Object)this.context.getSession(obj).getDescriptor(obj));
            XPathFragment rootFragment = descriptor.getDefaultRootElementField().getXPathFragment();
            return new QName(rootFragment.getNamespaceURI(), rootFragment.getLocalName());
        }
        catch (XMLMarshalException e2) {
            return null;
        }
    }
}

