/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.awt.Image;
import java.beans.Introspector;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.eclipse.persistence.exceptions.BeanValidationException;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.jaxb.many.MapValue;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.Namespace;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.schema.model.All;
import org.eclipse.persistence.internal.oxm.schema.model.Any;
import org.eclipse.persistence.internal.oxm.schema.model.AnyAttribute;
import org.eclipse.persistence.internal.oxm.schema.model.Attribute;
import org.eclipse.persistence.internal.oxm.schema.model.Choice;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexContent;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Element;
import org.eclipse.persistence.internal.oxm.schema.model.Extension;
import org.eclipse.persistence.internal.oxm.schema.model.Import;
import org.eclipse.persistence.internal.oxm.schema.model.List;
import org.eclipse.persistence.internal.oxm.schema.model.Restriction;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.oxm.schema.model.Sequence;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleComponent;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleContent;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleType;
import org.eclipse.persistence.internal.oxm.schema.model.TypeDefParticle;
import org.eclipse.persistence.internal.oxm.schema.model.TypeDefParticleOwner;
import org.eclipse.persistence.jaxb.compiler.CompilerHelper;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.PackageInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.SchemaTypeInfo;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.compiler.XMLProcessor;
import org.eclipse.persistence.jaxb.compiler.builder.TransformerPropertyBuilder;
import org.eclipse.persistence.jaxb.compiler.facets.DecimalMaxFacet;
import org.eclipse.persistence.jaxb.compiler.facets.DecimalMinFacet;
import org.eclipse.persistence.jaxb.compiler.facets.DigitsFacet;
import org.eclipse.persistence.jaxb.compiler.facets.Facet;
import org.eclipse.persistence.jaxb.compiler.facets.FacetVisitor;
import org.eclipse.persistence.jaxb.compiler.facets.MaxFacet;
import org.eclipse.persistence.jaxb.compiler.facets.MinFacet;
import org.eclipse.persistence.jaxb.compiler.facets.PatternFacet;
import org.eclipse.persistence.jaxb.compiler.facets.PatternListFacet;
import org.eclipse.persistence.jaxb.compiler.facets.SizeFacet;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementWrapper;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes;
import org.eclipse.persistence.jaxb.xmlmodel.XmlRootElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlVirtualAccessMethodsSchema;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;

public class SchemaGenerator {
    private Map<String, Schema> schemaForNamespace;
    private java.util.List<Schema> allSchemas;
    private int schemaCount;
    private Helper helper;
    private Map<String, TypeInfo> typeInfo;
    private Map<String, PackageInfo> packageToPackageInfoMappings;
    private Map<String, SchemaTypeInfo> schemaTypeInfo;
    private Map<String, QName> userDefinedSchemaTypes;
    private Map<String, Class> arrayClassesToGeneratedClasses;
    private static final String JAVAX_ACTIVATION_DATAHANDLER = "javax.activation.DataHandler";
    private static final String JAVAX_MAIL_INTERNET_MIMEMULTIPART = "javax.mail.internet.MimeMultipart";
    private static final String SWA_REF_IMPORT = "http://ws-i.org/profiles/basic/1.1/swaref.xsd";
    private static final String COLON = ":";
    private static final String ATT = "@";
    private static final String EMPTY_STRING = "";
    private static final String DOT = ".";
    private static final String SKIP = "skip";
    private static final String ENTRY = "entry";
    private static final String GENERATE = "##generate";
    private static final String SCHEMA = "schema";
    private static final String SCHEMA_EXT = ".xsd";
    private static final String OBJECT_CLASSNAME = "java.lang.Object";
    private static final String ID = "ID";
    private static final String IDREF = "IDREF";
    private static final Character DOT_CHAR = Character.valueOf('.');
    private static final Character SLASH = Character.valueOf('/');
    private static final Character SLASHES = Character.valueOf('\\');
    private SchemaOutputResolver outputResolver;
    private boolean facets;

    public SchemaGenerator(Helper helper) {
        this.helper = helper;
        this.facets = helper.isFacets();
    }

    public void generateSchema(java.util.List<JavaClass> typeInfoClasses, Map<String, TypeInfo> typeInfo, Map<String, QName> userDefinedSchemaTypes, Map<String, PackageInfo> packageToPackageInfoMappings, Map<QName, ElementDeclaration> additionalGlobalElements, Map<String, Class> arrayClassesToGeneratedClasses, SchemaOutputResolver outputResolver) {
        this.outputResolver = outputResolver;
        this.generateSchema(typeInfoClasses, typeInfo, userDefinedSchemaTypes, packageToPackageInfoMappings, additionalGlobalElements, arrayClassesToGeneratedClasses);
    }

    public void generateSchema(java.util.List<JavaClass> typeInfoClasses, Map<String, TypeInfo> typeInfo, Map<String, QName> userDefinedSchemaTypes, Map<String, PackageInfo> packageToPackageInfoMappings, Map<QName, ElementDeclaration> additionalGlobalElements, Map<String, Class> arrayClassesToGeneratedClasses) {
        this.typeInfo = typeInfo;
        this.userDefinedSchemaTypes = userDefinedSchemaTypes;
        this.packageToPackageInfoMappings = packageToPackageInfoMappings;
        this.schemaCount = 1;
        this.schemaTypeInfo = new HashMap<String, SchemaTypeInfo>(typeInfo.size());
        this.arrayClassesToGeneratedClasses = arrayClassesToGeneratedClasses;
        for (JavaClass javaClass : typeInfoClasses) {
            this.addSchemaComponents(javaClass);
        }
        this.populateSchemaTypes();
        if (additionalGlobalElements != null) {
            this.addGlobalElements(additionalGlobalElements);
        }
    }

    public void addSchemaComponents(JavaClass myClass) {
        String prefix;
        Object type;
        String myClassName = myClass.getQualifiedName();
        Element rootElement = null;
        TypeInfo info = this.typeInfo.get(myClassName);
        if (info.isTransient() || info.getClassNamespace().equals("http://www.w3.org/2001/XMLSchema")) {
            return;
        }
        SchemaTypeInfo schemaTypeInfo = new SchemaTypeInfo();
        schemaTypeInfo.setSchemaTypeName(new QName(info.getClassNamespace(), info.getSchemaTypeName()));
        this.schemaTypeInfo.put(myClass.getQualifiedName(), schemaTypeInfo);
        NamespaceInfo namespaceInfo = this.packageToPackageInfoMappings.get(myClass.getPackageName()).getNamespaceInfo();
        if (namespaceInfo.getLocation() != null && !namespaceInfo.getLocation().equals(GENERATE)) {
            return;
        }
        Schema schema = this.getSchemaForNamespace(info.getClassNamespace(), myClass.getPackageName());
        info.setSchema(schema);
        String typeName = info.getSchemaTypeName();
        String pfx = EMPTY_STRING;
        Property valueField = null;
        if (info.isSetXmlRootElement()) {
            Schema rootElementSchema;
            XmlRootElement xmlRE = info.getXmlRootElement();
            rootElement = new Element();
            String elementName = xmlRE.getName();
            if (elementName.equals("##default") || elementName.equals(EMPTY_STRING)) {
                try {
                    elementName = info.getXmlNameTransformer().transformRootElementName(myClassName);
                }
                catch (Exception ex) {
                    throw JAXBException.exceptionDuringNameTransformation(myClassName, info.getXmlNameTransformer().getClass().getName(), ex);
                }
            }
            rootElement.setName(elementName);
            String rootNamespace = xmlRE.getNamespace();
            if (rootNamespace.equals("##default")) {
                rootElementSchema = this.getSchemaForNamespace(namespaceInfo.getNamespace());
                if (rootElementSchema != null) {
                    rootElementSchema.addTopLevelElement(rootElement);
                }
                schemaTypeInfo.getGlobalElementDeclarations().add(new QName(namespaceInfo.getNamespace(), rootNamespace));
                rootNamespace = namespaceInfo.getNamespace();
            } else {
                rootElementSchema = this.getSchemaForNamespace(rootNamespace);
                if (rootElementSchema != null) {
                    rootElementSchema.addTopLevelElement(rootElement);
                }
                schemaTypeInfo.getGlobalElementDeclarations().add(new QName(rootNamespace, elementName));
            }
            Schema rootSchema = this.getSchemaForNamespace(rootNamespace);
            this.addImportIfRequired(rootSchema, schema, schema.getTargetNamespace());
            if (rootSchema != null && !info.getClassNamespace().equals(EMPTY_STRING)) {
                pfx = this.getOrGeneratePrefixForNamespace(info.getClassNamespace(), rootSchema);
                pfx = String.valueOf(pfx) + COLON;
            }
        }
        if (CompilerHelper.isSimpleType(info)) {
            type = new SimpleType();
            if (typeName.equals(EMPTY_STRING)) {
                if (rootElement != null) {
                    rootElement.setSimpleType((SimpleType)type);
                }
            } else {
                ((SimpleType)type).setName(typeName);
                schema.addTopLevelSimpleTypes((SimpleType)type);
                if (rootElement != null) {
                    rootElement.setType(String.valueOf(pfx) + ((SimpleType)type).getName());
                }
            }
            QName restrictionType = null;
            Restriction restriction = new Restriction();
            if (info.isEnumerationType()) {
                restrictionType = ((EnumTypeInfo)info).getRestrictionBase();
                restriction.setEnumerationFacets(this.getEnumerationFacetsFor((EnumTypeInfo)info));
                prefix = null;
                if (restrictionType.getNamespaceURI() != null && !EMPTY_STRING.equals(restrictionType.getNamespaceURI())) {
                    prefix = "http://www.w3.org/2001/XMLSchema".equals(restrictionType.getNamespaceURI()) ? "xsd" : this.getPrefixForNamespace(schema, restrictionType.getNamespaceURI());
                }
                String extensionTypeName = restrictionType.getLocalPart();
                if (prefix != null) {
                    extensionTypeName = String.valueOf(prefix) + COLON + extensionTypeName;
                }
                restriction.setBaseType(extensionTypeName);
                ((SimpleType)type).setRestriction(restriction);
            } else {
                valueField = info.getXmlValueProperty();
                JavaClass javaType = valueField.getActualType();
                QName baseType = this.getSchemaTypeFor(javaType);
                String prefix2 = null;
                if (baseType.getNamespaceURI() != null && !baseType.getNamespaceURI().equals(EMPTY_STRING)) {
                    prefix2 = baseType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") ? "xsd" : this.getPrefixForNamespace(schema, baseType.getNamespaceURI());
                }
                String baseTypeName = baseType.getLocalPart();
                if (prefix2 != null) {
                    baseTypeName = String.valueOf(prefix2) + COLON + baseTypeName;
                }
                if (valueField.isXmlList() || valueField.getGenericType() != null) {
                    List list = new List();
                    list.setItemType(baseTypeName);
                    ((SimpleType)type).setList(list);
                } else {
                    if (this.helper.isAnnotationPresent(valueField.getElement(), XmlSchemaType.class)) {
                        XmlSchemaType schemaType = (XmlSchemaType)this.helper.getAnnotation(valueField.getElement(), XmlSchemaType.class);
                        baseType = new QName(schemaType.namespace(), schemaType.name());
                    }
                    restriction.setBaseType(baseTypeName);
                    ((SimpleType)type).setRestriction(restriction);
                }
            }
            info.setSimpleType((SimpleType)type);
        } else {
            valueField = this.getXmlValueFieldForSimpleContent(info);
            if (valueField != null) {
                type = new ComplexType();
                SimpleContent content = new SimpleContent();
                if (EMPTY_STRING.equals(typeName)) {
                    if (rootElement != null) {
                        rootElement.setComplexType((ComplexType)type);
                    }
                    info.setComplexType((ComplexType)type);
                } else {
                    ((ComplexType)type).setName(typeName);
                    schema.addTopLevelComplexTypes((ComplexType)type);
                    if (rootElement != null) {
                        rootElement.setType(String.valueOf(pfx) + ((ComplexType)type).getName());
                    }
                }
                QName extensionType = this.getSchemaTypeFor(valueField.getType());
                if (this.helper.isAnnotationPresent(valueField.getElement(), XmlSchemaType.class)) {
                    XmlSchemaType schemaType = (XmlSchemaType)this.helper.getAnnotation(valueField.getElement(), XmlSchemaType.class);
                    extensionType = new QName(schemaType.namespace(), schemaType.name());
                }
                prefix = null;
                if (extensionType.getNamespaceURI() != null && !extensionType.getNamespaceURI().equals(EMPTY_STRING)) {
                    prefix = extensionType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") ? "xsd" : this.getPrefixForNamespace(schema, extensionType.getNamespaceURI());
                }
                String extensionTypeName = extensionType.getLocalPart();
                if (prefix != null) {
                    extensionTypeName = String.valueOf(prefix) + COLON + extensionTypeName;
                }
                Extension extension = new Extension();
                extension.setBaseType(extensionTypeName);
                content.setExtension(extension);
                ((ComplexType)type).setSimpleContent(content);
                info.setComplexType((ComplexType)type);
            } else {
                type = this.createComplexTypeForClass(myClass, info);
                TypeDefParticle compositor = null;
                compositor = ((ComplexType)type).getComplexContent() != null && ((ComplexType)type).getComplexContent().getExtension() != null ? ((ComplexType)type).getComplexContent().getExtension().getTypeDefParticle() : ((ComplexType)type).getTypeDefParticle();
                if (EMPTY_STRING.equals(typeName)) {
                    if (rootElement != null) {
                        rootElement.setComplexType((ComplexType)type);
                    }
                    info.setComplexType((ComplexType)type);
                    info.setCompositor(compositor);
                } else {
                    ((ComplexType)type).setName(typeName);
                    if (rootElement != null) {
                        rootElement.setType(String.valueOf(pfx) + ((ComplexType)type).getName());
                    }
                    schema.addTopLevelComplexTypes((ComplexType)type);
                    info.setComplexType((ComplexType)type);
                    info.setCompositor(compositor);
                }
            }
        }
    }

    private ComplexType createComplexTypeForClass(JavaClass myClass, TypeInfo info) {
        TypeInfo parentTypeInfo;
        Schema schema = this.getSchemaForNamespace(info.getClassNamespace());
        ComplexType type = new ComplexType();
        JavaClass superClass = CompilerHelper.getNextMappedSuperClass(myClass, this.typeInfo, this.helper);
        if (myClass.isAbstract()) {
            type.setAbstractValue(true);
        }
        Extension extension = null;
        if (superClass != null && (parentTypeInfo = this.typeInfo.get(superClass.getQualifiedName())) != null) {
            extension = new Extension();
            String parentPrefix = this.getPrefixForNamespace(schema, parentTypeInfo.getClassNamespace());
            if (parentPrefix != null) {
                extension.setBaseType(String.valueOf(parentPrefix) + COLON + parentTypeInfo.getSchemaTypeName());
            } else {
                extension.setBaseType(parentTypeInfo.getSchemaTypeName());
            }
            if (parentTypeInfo.getXmlValueProperty() != null) {
                SimpleContent content = new SimpleContent();
                content.setExtension(extension);
                type.setSimpleContent(content);
                return type;
            }
            ComplexContent content = new ComplexContent();
            content.setExtension(extension);
            type.setComplexContent(content);
        }
        TypeDefParticle compositor = null;
        String[] propOrder = null;
        if (info.isSetPropOrder()) {
            propOrder = info.getPropOrder();
        }
        if (propOrder != null && propOrder.length == 0) {
            if (info.hasElementRefs()) {
                compositor = new Sequence();
                if (extension != null) {
                    extension.setSequence((Sequence)compositor);
                } else {
                    type.setSequence((Sequence)compositor);
                }
            } else if (extension != null) {
                compositor = new All();
                extension.setAll((All)compositor);
            } else {
                compositor = new All();
                type.setAll((All)compositor);
            }
        } else {
            compositor = new Sequence();
            if (extension != null) {
                extension.setSequence((Sequence)compositor);
            } else {
                type.setSequence((Sequence)compositor);
            }
        }
        return type;
    }

    public void addToSchemaType(TypeInfo ownerTypeInfo, java.util.List<Property> properties, TypeDefParticle compositor, ComplexType type, Schema workingSchema) {
        if (properties.size() == 0) {
            type.setAll(null);
            type.setSequence(null);
            type.setChoice(null);
            ownerTypeInfo.setCompositor(null);
            return;
        }
        boolean extAnyAdded = false;
        for (Property next : properties) {
            if (next == null) continue;
            Schema currentSchema = workingSchema;
            TypeDefParticle parentCompositor = compositor;
            boolean isChoice = parentCompositor instanceof Choice;
            ComplexType parentType = type;
            if (next.isTransient() || next.isInverseReference() && !next.isWriteableInverseReference()) continue;
            if (next.isVirtual()) {
                boolean extSchemaAny = false;
                if (ownerTypeInfo.getXmlVirtualAccessMethods().getSchema() != null) {
                    extSchemaAny = ownerTypeInfo.getXmlVirtualAccessMethods().getSchema().equals((Object)XmlVirtualAccessMethodsSchema.ANY);
                }
                if (extSchemaAny && !next.isAttribute()) {
                    if (extAnyAdded) continue;
                    this.addAnyToSchema(next, compositor, true, "##any");
                    extAnyAdded = true;
                    continue;
                }
            }
            if (next.isSetXmlTransformation() && next.getXmlTransformation().isSetXmlWriteTransformers()) {
                this.addTransformerToSchema(next, ownerTypeInfo, compositor, type, workingSchema);
                continue;
            }
            if (next.isSetXmlJoinNodes()) {
                this.addXmlJoinNodesToSchema(next, parentCompositor, currentSchema, parentType);
                continue;
            }
            if (next.getXmlPath() != null) {
                AddToSchemaResult xpr = this.addXPathToSchema(next, parentCompositor, currentSchema, isChoice, type);
                if (xpr == null || (parentCompositor = xpr.particle) == null && xpr.simpleContentType == null || xpr.schema == null) continue;
                currentSchema = xpr.schema;
                if (parentCompositor == null) {
                    parentType = xpr.simpleContentType;
                } else if (parentCompositor.getOwner() instanceof ComplexType) {
                    parentType = (ComplexType)parentCompositor.getOwner();
                }
            } else if (!isChoice && !next.isMap() && next.isSetXmlElementWrapper()) {
                AddToSchemaResult asr = this.addXmlElementWrapperToSchema(next, currentSchema, compositor);
                if (asr == null) continue;
                parentType = asr.type;
                parentCompositor = asr.particle;
            }
            if (next.isMixedContent()) {
                parentType.setMixed(true);
            }
            if (next.isAttribute() && !next.isAnyAttribute()) {
                this.addAttributeToSchema(this.buildAttribute(next, currentSchema), next.getSchemaName(), currentSchema, parentType);
                continue;
            }
            if (next.isAnyAttribute()) {
                this.addAnyAttributeToSchema(parentType);
                continue;
            }
            if (next.isChoice()) {
                this.addChoiceToSchema(next, ownerTypeInfo, parentType, parentCompositor, currentSchema);
                continue;
            }
            if (next.isReference()) {
                this.addReferenceToSchema(next, currentSchema, parentCompositor);
                continue;
            }
            if (next.isAny() || next.getVariableAttributeName() != null) {
                this.addAnyToSchema(next, parentCompositor);
                continue;
            }
            if (ownerTypeInfo.getXmlValueProperty() != null && ownerTypeInfo.getXmlValueProperty() == next) continue;
            Element element = this.buildElement(next, parentCompositor instanceof All, currentSchema, ownerTypeInfo);
            this.addElementToSchema(element, next.getSchemaName().getNamespaceURI(), next.isPositional(), parentCompositor, currentSchema, ownerTypeInfo.getJavaClass().getPackageName());
        }
    }

    public QName getSchemaTypeFor(JavaClass javaClass) {
        TypeInfo targetInfo;
        Class wrapperClass;
        String className = javaClass.isArray() ? ((wrapperClass = this.arrayClassesToGeneratedClasses.get(javaClass.getName())) == null ? javaClass.getQualifiedName() : wrapperClass.getName()) : javaClass.getQualifiedName();
        QName schemaType = this.userDefinedSchemaTypes.get(className);
        if (schemaType == null) {
            schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(javaClass.getRawName());
        }
        if (schemaType == null && (targetInfo = this.typeInfo.get(className)) != null) {
            schemaType = new QName(targetInfo.getClassNamespace(), targetInfo.getSchemaTypeName());
        }
        if (schemaType == null) {
            if (javaClass.getQualifiedName().equals(OBJECT_CLASSNAME)) {
                return Constants.ANY_TYPE_QNAME;
            }
            return Constants.ANY_SIMPLE_TYPE_QNAME;
        }
        return schemaType;
    }

    public void populateSchemaTypes() {
        for (TypeInfo info : this.typeInfo.values()) {
            String xpath;
            String pname;
            if (!info.isComplexType() || info.getSchema() == null) continue;
            java.util.List<Property> props = info.getNonTransientPropertiesInPropOrder();
            if (info.isSetXmlDiscriminatorNode() && !(pname = XMLProcessor.getNameFromXPath(xpath = info.getXmlDiscriminatorNode(), EMPTY_STRING, true)).equals(EMPTY_STRING)) {
                Property prop = new Property(this.helper);
                prop.setPropertyName(pname);
                prop.setXmlPath(xpath);
                prop.setSchemaName(new QName(pname));
                prop.setType(this.helper.getJavaClass(String.class));
                prop.setIsAttribute(true);
                props.add(prop);
            }
            this.addToSchemaType(info, props, info.getCompositor(), info.getComplexType(), info.getSchema());
            if (!info.hasPredicateProperties()) continue;
            this.addToSchemaType(info, info.getPredicateProperties(), info.getCompositor(), info.getComplexType(), info.getSchema());
        }
    }

    public String getSchemaTypeNameForClassName(String className) {
        return Introspector.decapitalize(className.substring(className.lastIndexOf(DOT_CHAR.charValue()) + 1));
    }

    public ArrayList<Object> getEnumerationFacetsFor(EnumTypeInfo info) {
        return (ArrayList)info.getXmlEnumValues();
    }

    public Property getXmlValueFieldForSimpleContent(TypeInfo info) {
        ArrayList<Property> properties = info.getPropertyList();
        Property xmlValueProperty = info.getXmlValueProperty();
        boolean foundValue = false;
        boolean foundNonAttribute = false;
        Property valueField = null;
        for (Property prop : properties) {
            if (xmlValueProperty != null && xmlValueProperty == prop) {
                foundValue = true;
                valueField = prop;
                continue;
            }
            if (prop.isAttribute() || prop.isTransient() || prop.isAnyAttribute()) continue;
            foundNonAttribute = true;
        }
        if (foundValue && !foundNonAttribute) {
            return valueField;
        }
        return null;
    }

    public boolean isCollectionType(Property field) {
        JavaClass type = field.getType();
        return this.helper.getJavaClass(Collection.class).isAssignableFrom(type) || this.helper.getJavaClass(java.util.List.class).isAssignableFrom(type) || this.helper.getJavaClass(Set.class).isAssignableFrom(type);
    }

    private Schema getSchemaForNamespace(String namespace) {
        return this.getSchemaForNamespace(namespace, null);
    }

    private Schema getSchemaForNamespace(String namespace, String packageName) {
        Schema schema;
        if (this.schemaForNamespace == null) {
            this.schemaForNamespace = new HashMap<String, Schema>();
            this.allSchemas = new ArrayList<Schema>();
        }
        if ((schema = this.schemaForNamespace.get(namespace)) == null && !"http://www.w3.org/XML/1998/namespace".equals(namespace)) {
            schema = new Schema();
            String schemaName = SCHEMA + this.schemaCount + SCHEMA_EXT;
            NamespaceInfo namespaceInfo = this.getNamespaceInfoForNamespace(namespace, packageName);
            if (namespaceInfo != null) {
                if (namespaceInfo.getLocation() != null && !namespaceInfo.getLocation().equals(GENERATE)) {
                    return null;
                }
                Vector namespaces = namespaceInfo.getNamespaceResolver().getNamespaces();
                int i2 = 0;
                while (i2 < namespaces.size()) {
                    Namespace nextNamespace = (Namespace)namespaces.get(i2);
                    schema.getNamespaceResolver().put(nextNamespace.getPrefix(), nextNamespace.getNamespaceURI());
                    ++i2;
                }
            }
            if (this.outputResolver != null) {
                Result res;
                block14: {
                    res = this.outputResolver.createOutput(namespace, schemaName);
                    if (res != null) break block14;
                    return null;
                }
                try {
                    schema.setResult(res);
                    if (res.getSystemId() != null) {
                        schemaName = res.getSystemId();
                        schemaName = schemaName.replace(SLASHES.charValue(), SLASH.charValue());
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            schema.setName(schemaName);
            ++this.schemaCount;
            if (!namespace.equals(EMPTY_STRING)) {
                schema.setTargetNamespace(namespace);
                String prefix = null;
                if (namespaceInfo != null) {
                    prefix = namespaceInfo.getNamespaceResolver().resolveNamespaceURI(namespace);
                }
                if (prefix == null) {
                    prefix = schema.getNamespaceResolver().generatePrefix();
                }
                schema.getNamespaceResolver().put(prefix, namespace);
            }
            if (namespaceInfo != null) {
                schema.setAttributeFormDefault(namespaceInfo.isAttributeFormQualified());
                schema.setElementFormDefault(namespaceInfo.isElementFormQualified());
            }
            this.schemaForNamespace.put(namespace, schema);
            this.allSchemas.add(schema);
        }
        return schema;
    }

    public Collection<Schema> getAllSchemas() {
        if (this.allSchemas == null) {
            this.allSchemas = new ArrayList<Schema>();
        }
        return this.allSchemas;
    }

    public NamespaceInfo getNamespaceInfoForNamespace(String namespace) {
        return this.getNamespaceInfoForNamespace(namespace, null);
    }

    public NamespaceInfo getNamespaceInfoForNamespace(String namespace, String packageName) {
        Object packageInfo;
        if (packageName != null && this.packageToPackageInfoMappings.containsKey(packageName) && ((PackageInfo)(packageInfo = this.packageToPackageInfoMappings.get(packageName))).getNamespace().equals(namespace)) {
            return ((PackageInfo)packageInfo).getNamespaceInfo();
        }
        packageInfo = this.packageToPackageInfoMappings.values();
        Iterator<PackageInfo> iterator = packageInfo.iterator();
        while (iterator.hasNext()) {
            PackageInfo info = iterator.next();
            if (!info.getNamespace().equals(namespace)) continue;
            return info.getNamespaceInfo();
        }
        return null;
    }

    public String getPrefixForNamespace(Schema schema, String URI2) {
        Schema referencedSchema = this.getSchemaForNamespace(URI2);
        this.addImportIfRequired(schema, referencedSchema, URI2);
        NamespaceResolver namespaceResolver = schema.getNamespaceResolver();
        Enumeration keys = namespaceResolver.getPrefixes();
        while (keys.hasMoreElements()) {
            String next = (String)keys.nextElement();
            String nextUri = namespaceResolver.resolveNamespacePrefix(next);
            if (!nextUri.equals(URI2)) continue;
            return next;
        }
        return null;
    }

    public String getOrGeneratePrefixForNamespace(String URI2, Schema schema) {
        String prefix = schema.getNamespaceResolver().resolveNamespaceURI(URI2);
        if (prefix == null) {
            if (URI2.equals("http://www.w3.org/2001/XMLSchema")) {
                prefix = schema.getNamespaceResolver().generatePrefix("xsd");
            } else if (URI2.equals("http://ws-i.org/profiles/basic/1.1/xsd")) {
                prefix = schema.getNamespaceResolver().generatePrefix("ref");
                if (!this.importExists(schema, URI2, SWA_REF_IMPORT)) {
                    Import schemaImport = new Import();
                    schemaImport.setSchemaLocation(SWA_REF_IMPORT);
                    schemaImport.setNamespace(URI2);
                    schema.getImports().add(schemaImport);
                }
            } else {
                prefix = schema.getNamespaceResolver().generatePrefix();
            }
            schema.getNamespaceResolver().put(prefix, URI2);
        }
        return prefix;
    }

    public void addGlobalElements(Map<QName, ElementDeclaration> additionalElements) {
        for (Map.Entry<QName, ElementDeclaration> entry : additionalElements.entrySet()) {
            String prefix;
            String namespaceURI;
            Schema targetSchema;
            ElementDeclaration nextElement;
            QName next = entry.getKey();
            if (next == null || (nextElement = entry.getValue()).getScopeClass() != XmlElementDecl.GLOBAL.class || (targetSchema = this.getSchemaForNamespace(namespaceURI = next.getNamespaceURI())) == null || targetSchema.getTopLevelElements().get(next.getLocalPart()) != null) continue;
            Element element = new Element();
            element.setName(next.getLocalPart());
            element.setNillable(nextElement.isNillable());
            JavaClass javaClass = nextElement.getJavaType();
            QName schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(javaClass.getRawName());
            if (schemaType != null) {
                element.setType("xsd:" + schemaType.getLocalPart());
            } else if (this.areEquals(javaClass, JAVAX_ACTIVATION_DATAHANDLER) || this.areEquals(javaClass, byte[].class) || this.areEquals(javaClass, Byte[].class) || this.areEquals(javaClass, Image.class) || this.areEquals(javaClass, Source.class) || this.areEquals(javaClass, JAVAX_MAIL_INTERNET_MIMEMULTIPART)) {
                schemaType = Constants.BASE_64_BINARY_QNAME;
                if (nextElement.getTypeMappingInfo() != null) {
                    if (nextElement.isXmlAttachmentRef()) {
                        schemaType = Constants.SWA_REF_QNAME;
                    }
                    if (nextElement.getXmlMimeType() != null) {
                        element.getAttributesMap().put(Constants.EXPECTED_CONTENT_TYPES_QNAME, nextElement.getXmlMimeType());
                    }
                }
                String prefix2 = this.getOrGeneratePrefixForNamespace(schemaType.getNamespaceURI(), targetSchema);
                element.setType(String.valueOf(prefix2) + COLON + schemaType.getLocalPart());
            } else if (this.areEquals(javaClass, CoreClassConstants.XML_GREGORIAN_CALENDAR)) {
                schemaType = Constants.ANY_SIMPLE_TYPE_QNAME;
                element.setType("xsd:" + schemaType.getLocalPart());
            } else {
                TypeInfo type = this.typeInfo.get(javaClass.getQualifiedName());
                if (type != null) {
                    String typeName = null;
                    typeName = type.isComplexType() ? type.getComplexType().getName() : type.getSimpleType().getName();
                    if (typeName == null) {
                        Schema schema = this.getSchemaForNamespace(next.getNamespaceURI());
                        ComplexType cType = this.createComplexTypeForClass(javaClass, type);
                        TypeDefParticle particle = null;
                        particle = cType.getComplexContent() != null && cType.getComplexContent().getExtension() != null ? cType.getComplexContent().getExtension().getTypeDefParticle() : cType.getTypeDefParticle();
                        this.addToSchemaType(type, type.getPropertyList(), particle, cType, schema);
                        targetSchema = schema;
                        element.setComplexType(cType);
                    } else if (type.getClassNamespace().equals(namespaceURI)) {
                        prefix = targetSchema.getNamespaceResolver().resolveNamespaceURI(namespaceURI);
                        if (prefix != null && !prefix.equals(EMPTY_STRING)) {
                            element.setType(String.valueOf(prefix) + COLON + typeName);
                        } else {
                            element.setType(typeName);
                        }
                    } else {
                        Schema complexTypeSchema = this.getSchemaForNamespace(type.getClassNamespace());
                        String complexTypeSchemaNS = type.getClassNamespace();
                        if (complexTypeSchemaNS == null) {
                            complexTypeSchemaNS = EMPTY_STRING;
                        }
                        this.addImportIfRequired(targetSchema, complexTypeSchema, type.getClassNamespace());
                        String prefix3 = targetSchema.getNamespaceResolver().resolveNamespaceURI(complexTypeSchemaNS);
                        if (prefix3 != null) {
                            element.setType(String.valueOf(prefix3) + COLON + typeName);
                        } else {
                            element.setType(typeName);
                        }
                    }
                }
            }
            if (nextElement.getSubstitutionHead() != null) {
                String subLocal = nextElement.getSubstitutionHead().getLocalPart();
                String subNamespace = nextElement.getSubstitutionHead().getNamespaceURI();
                prefix = this.getPrefixForNamespace(targetSchema, subNamespace);
                if (prefix == null || prefix.equals(EMPTY_STRING)) {
                    element.setSubstitutionGroup(subLocal);
                } else {
                    element.setSubstitutionGroup(String.valueOf(prefix) + COLON + subLocal);
                }
            }
            targetSchema.addTopLevelElement(element);
            SchemaTypeInfo info = this.schemaTypeInfo.get(javaClass.getQualifiedName());
            if (info == null) {
                info = new SchemaTypeInfo();
                info.setSchemaTypeName(schemaType);
                this.schemaTypeInfo.put(javaClass.getQualifiedName(), info);
            }
            info.getGlobalElementDeclarations().add(next);
        }
    }

    public Map<String, SchemaTypeInfo> getSchemaTypeInfo() {
        return this.schemaTypeInfo;
    }

    private boolean importExists(Schema schema, String importNsURI, String schemaLocation) {
        java.util.List imports = schema.getImports();
        int i2 = 0;
        while (i2 < imports.size()) {
            Import nextImport = (Import)imports.get(i2);
            if (nextImport.getSchemaLocation() != null && nextImport.getSchemaLocation().equals(schemaLocation) && (EMPTY_STRING.equals(importNsURI) ? nextImport.getNamespace() == null : importNsURI.equals(nextImport.getNamespace()))) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private boolean addImportIfRequired(Schema sourceSchema, Schema importSchema, String importNamespace) {
        if (!(importSchema == sourceSchema || importNamespace != null && importNamespace.equals("http://www.w3.org/2001/XMLSchema"))) {
            String schemaName = null;
            if ("http://www.w3.org/XML/1998/namespace".equals(importNamespace)) {
                schemaName = "http://www.w3.org/XML/2001/xml.xsd";
            } else if (importSchema != null) {
                schemaName = importSchema.getName();
            } else if (importNamespace != null) {
                NamespaceInfo nInfo = this.getNamespaceInfoForNamespace(importNamespace);
                schemaName = nInfo.getLocation();
            }
            if (schemaName != null && importSchema != null) {
                URI relativizedURI = null;
                try {
                    String schemaPath = sourceSchema.getName();
                    int idx = schemaPath.lastIndexOf(SLASH.charValue());
                    if (idx != -1) {
                        schemaPath = schemaPath.substring(0, idx);
                    }
                    URI baseURI = new URI(schemaPath);
                    URI importURI = new URI(schemaName);
                    relativizedURI = baseURI.relativize(importURI);
                }
                catch (Exception e2) {
                    relativizedURI = null;
                }
                if (relativizedURI != null) {
                    schemaName = relativizedURI.getPath();
                }
            }
            if (schemaName != null && !this.importExists(sourceSchema, importNamespace, schemaName)) {
                Import schemaImport = new Import();
                schemaImport.setSchemaLocation(schemaName);
                if (importNamespace != null && !importNamespace.equals(EMPTY_STRING)) {
                    schemaImport.setNamespace(importNamespace);
                }
                sourceSchema.getImports().add(schemaImport);
                if (schemaImport.getNamespace() != null) {
                    String prefix;
                    if (schemaImport.getNamespace().equals("http://www.w3.org/XML/1998/namespace")) {
                        sourceSchema.getNamespaceResolver().put("xml", "http://www.w3.org/XML/1998/namespace");
                    }
                    if ((prefix = sourceSchema.getNamespaceResolver().resolveNamespaceURI(importNamespace)) == null && !importNamespace.equals(EMPTY_STRING)) {
                        sourceSchema.getNamespaceResolver().put(sourceSchema.getNamespaceResolver().generatePrefix(), importNamespace);
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected boolean areEquals(JavaClass src, String tgtCanonicalName) {
        if (src == null || tgtCanonicalName == null) {
            return false;
        }
        return src.getRawName().equals(tgtCanonicalName);
    }

    protected boolean areEquals(JavaClass src, Class tgt) {
        if (src == null || tgt == null) {
            return false;
        }
        return src.getRawName().equals(tgt.getCanonicalName());
    }

    private String getTypeName(Property next, JavaClass javaType, Schema theSchema) {
        QName schemaType = next.getSchemaType();
        if (schemaType == null) {
            schemaType = this.getSchemaTypeFor(javaType);
        }
        if (schemaType != null) {
            if (schemaType.getNamespaceURI() == null) {
                return schemaType.getLocalPart();
            }
            return String.valueOf(this.getOrGeneratePrefixForNamespace(schemaType.getNamespaceURI(), theSchema)) + COLON + schemaType.getLocalPart();
        }
        return "xsd:anySimpleType";
    }

    private String getQualifiedTypeName(Property prop, Schema schema) {
        String prefix;
        JavaClass javaType = prop.getActualType();
        String typeName = this.getTypeName(prop, javaType, schema);
        if (typeName != null && !typeName.contains(COLON) && (prefix = this.getPrefixForNamespace(schema, schema.getTargetNamespace())) != null) {
            typeName = String.valueOf(prefix) + COLON + typeName;
        }
        return typeName;
    }

    protected AddToSchemaResult buildSchemaComponentsForXPath(XPathFragment frag, AddToSchemaResult xpr, boolean isChoice, Property next) {
        ComplexType cType;
        boolean currentElementExists;
        boolean lastFrag;
        boolean isAny = next.isAny() || next.isAnyAttribute();
        TypeDefParticle currentParticle = xpr.particle;
        Schema workingSchema = xpr.schema;
        boolean isUnbounded = false;
        if (currentParticle != null) {
            isUnbounded = currentParticle.getMaxOccurs() != null && currentParticle.getMaxOccurs() == "unbounded";
        }
        boolean bl = lastFrag = frag.getNextFragment() == null || frag.getNextFragment().nameIsText();
        if (lastFrag && this.elementExistsInParticle(frag.getLocalName(), frag.getShortName(), currentParticle) != null) {
            xpr.particle = null;
            return xpr;
        }
        Element currentElement = this.elementExistsInParticle(frag.getLocalName(), frag.getShortName(), currentParticle);
        boolean bl2 = currentElementExists = currentElement != null;
        if (!currentElementExists) {
            currentElement = new Element();
            ComplexType cType2 = new ComplexType();
            TypeDefParticle particle = null;
            if (isChoice) {
                particle = new Choice();
                if (isUnbounded) {
                    particle.setMaxOccurs("unbounded");
                }
            } else {
                XPathFragment nextFragment = frag.getNextFragment();
                if (frag.containsIndex() || frag.getPredicate() != null || !next.isXmlList() && nextFragment != null && nextFragment.isAttribute() && this.helper.isCollectionType(next.getType())) {
                    currentElement.setMaxOccurs("unbounded");
                }
                particle = new Sequence();
            }
            cType2.setTypeDefParticle(particle);
            currentElement.setComplexType(cType2);
        } else {
            XPathFragment nextFrag = frag.getNextFragment();
            if (nextFrag != null && nextFrag.isAttribute() && currentElement.getType() != null && currentElement.getComplexType() == null) {
                SimpleType type = currentElement.getSimpleType();
                if (type != null) {
                    ComplexType cType3 = new ComplexType();
                    cType3.setSimpleContent(new SimpleContent());
                    Extension extension = new Extension();
                    extension.setBaseType(type.getRestriction().getBaseType());
                    cType3.getSimpleContent().setExtension(extension);
                    currentElement.setSimpleType(null);
                    currentElement.setComplexType(cType3);
                } else {
                    String eType = currentElement.getType();
                    cType = new ComplexType();
                    SimpleContent sContent = new SimpleContent();
                    Extension extension = new Extension();
                    extension.setBaseType(eType);
                    sContent.setExtension(extension);
                    cType.setSimpleContent(sContent);
                    currentElement.setType(null);
                    currentElement.setComplexType(cType);
                }
            }
        }
        Element globalElement = null;
        String fragUri = frag.getNamespaceURI();
        if (fragUri != null) {
            Schema fragSchema = this.getSchemaForNamespace(fragUri);
            String targetNS = workingSchema.getTargetNamespace();
            if (frag.isAttribute()) {
                if (fragSchema == null || fragSchema.isAttributeFormDefault() && !fragUri.equals(targetNS) || !fragSchema.isAttributeFormDefault() && fragUri.length() > 0) {
                    String attributeRefName;
                    if (fragSchema != null) {
                        Attribute globalAttribute = null;
                        globalAttribute = (Attribute)fragSchema.getTopLevelAttributes().get(frag.getLocalName());
                        if (globalAttribute == null) {
                            globalAttribute = this.createGlobalAttribute(frag, workingSchema, fragSchema, next);
                        }
                    } else {
                        this.addImportIfRequired(workingSchema, null, fragUri);
                    }
                    if (fragUri.equals(targetNS)) {
                        String prefix = fragSchema.getNamespaceResolver().resolveNamespaceURI(fragUri);
                        attributeRefName = String.valueOf(prefix) + COLON + frag.getLocalName();
                    } else {
                        attributeRefName = frag.getShortName();
                    }
                    TypeDefParticleOwner type = currentParticle != null ? currentParticle.getOwner() : xpr.simpleContentType;
                    if (type instanceof ComplexType) {
                        this.createRefAttribute(attributeRefName, (ComplexType)type);
                    }
                    xpr.schema = fragSchema;
                    xpr.particle = null;
                }
                return xpr;
            }
            if (fragSchema.isElementFormDefault() && !fragUri.equals(targetNS) || !fragSchema.isElementFormDefault() && fragUri.length() > 0) {
                globalElement = (Element)fragSchema.getTopLevelElements().get(frag.getLocalName());
                if (globalElement == null) {
                    globalElement = this.createGlobalElement(frag, workingSchema, fragSchema, isChoice, isUnbounded, next, lastFrag && !isAny);
                }
                if (!currentElementExists) {
                    String fragPrefix = workingSchema.getNamespaceResolver().resolveNamespaceURI(fragUri);
                    if (fragPrefix == null) {
                        fragPrefix = workingSchema.getNamespaceResolver().generatePrefix(frag.getPrefix());
                        workingSchema.getNamespaceResolver().put(fragPrefix, fragUri);
                    }
                    currentElement = this.createRefElement(String.valueOf(fragPrefix) + COLON + frag.getLocalName(), currentParticle);
                    if (frag.containsIndex() || frag.getPredicate() != null || this.helper.isCollectionType(next.getType())) {
                        currentElement.setMaxOccurs("unbounded");
                    }
                    currentElementExists = true;
                }
                xpr.schema = fragSchema;
                if (lastFrag) {
                    if (isAny) {
                        xpr.particle = globalElement.getComplexType().getTypeDefParticle();
                        return xpr;
                    }
                    xpr.particle = null;
                    return xpr;
                }
                currentElement = globalElement;
            }
        }
        if (!lastFrag || lastFrag && isAny) {
            if (!currentElementExists && globalElement == null) {
                currentElement.setName(frag.getLocalName());
                Integer minOccurs = next.getMinOccurs();
                if (minOccurs != null) {
                    currentElement.setMinOccurs(String.valueOf(minOccurs));
                } else {
                    currentElement.setMinOccurs("0");
                }
                currentParticle.addElement(currentElement);
            }
            if (currentElement.getComplexType() != null) {
                if (currentElement.getComplexType().getTypeDefParticle() == null) {
                    xpr.simpleContentType = currentElement.getComplexType();
                    xpr.particle = null;
                } else {
                    xpr.particle = currentElement.getComplexType().getTypeDefParticle();
                }
            } else {
                SimpleType type = currentElement.getSimpleType();
                if (type != null) {
                    cType = new ComplexType();
                    cType.setSimpleContent(new SimpleContent());
                    Extension extension = new Extension();
                    extension.setBaseType(type.getRestriction().getBaseType());
                    cType.getSimpleContent().setExtension(extension);
                    currentElement.setSimpleType(null);
                    currentElement.setComplexType(cType);
                    xpr.particle = null;
                    xpr.simpleContentType = cType;
                } else {
                    String eType = currentElement.getType();
                    ComplexType cType4 = new ComplexType();
                    SimpleContent sContent = new SimpleContent();
                    Extension extension = new Extension();
                    extension.setBaseType(eType);
                    sContent.setExtension(extension);
                    cType4.setSimpleContent(sContent);
                    currentElement.setType(null);
                    currentElement.setComplexType(cType4);
                    xpr.particle = null;
                    xpr.simpleContentType = cType4;
                }
            }
        }
        if (lastFrag) {
            return xpr;
        }
        return this.buildSchemaComponentsForXPath(frag.getNextFragment(), xpr, isChoice, next);
    }

    protected Element elementExistsInParticle(String elementName, String refString, TypeDefParticle particle) {
        if (particle == null || particle.getElements() == null || particle.getElements().size() == 0) {
            return null;
        }
        java.util.List existingElements = particle.getElements();
        if (existingElements != null) {
            Iterator elementIt = existingElements.iterator();
            while (elementIt.hasNext()) {
                Element element;
                try {
                    element = (Element)elementIt.next();
                }
                catch (ClassCastException cce) {
                    continue;
                }
                if (!(refString == null ? (element.getRef() == null || element.getRef() != null && element.getRef().equals(element.getName())) && elementName.equals(element.getName()) : (refString.equals(elementName) ? element.getRef() != null && element.getRef().equals(refString) || element.getRef() == null && elementName.equals(element.getName()) : element.getRef() != null && element.getRef().equals(refString)))) continue;
                return element;
            }
        }
        return null;
    }

    public Attribute createGlobalAttribute(XPathFragment frag, Schema workingSchema, Schema fragSchema, Property prop) {
        Attribute gAttribute = new Attribute();
        gAttribute.setName(frag.getLocalName());
        gAttribute.setType(this.getQualifiedTypeName(prop, fragSchema));
        fragSchema.getTopLevelAttributes().put(gAttribute.getName(), gAttribute);
        this.addImportIfRequired(workingSchema, fragSchema, frag.getNamespaceURI());
        return gAttribute;
    }

    public Element createGlobalElement(XPathFragment frag, Schema workingSchema, Schema fragSchema, boolean isChoice, boolean isUnbounded, Property prop, boolean shouldSetType) {
        Element gElement = new Element();
        gElement.setName(frag.getLocalName());
        if (shouldSetType) {
            gElement.setType(this.getQualifiedTypeName(prop, fragSchema));
        } else {
            TypeDefParticle particle;
            ComplexType gCType = new ComplexType();
            if (isChoice) {
                particle = new Choice();
                if (isUnbounded) {
                    particle.setMaxOccurs("unbounded");
                }
            } else {
                particle = new Sequence();
            }
            gCType.setTypeDefParticle(particle);
            gElement.setComplexType(gCType);
        }
        fragSchema.addTopLevelElement(gElement);
        this.addImportIfRequired(workingSchema, fragSchema, frag.getNamespaceURI());
        return gElement;
    }

    public Element createRefElement(String elementRefName, TypeDefParticle particle) {
        Element refElement = new Element();
        refElement.setComplexType(null);
        refElement.setMinOccurs("0");
        refElement.setMaxOccurs("1");
        refElement.setRef(elementRefName);
        particle.addElement(refElement);
        return refElement;
    }

    public Attribute createRefAttribute(String attributeRefName, ComplexType owningComplexType) {
        Attribute refAttribute = new Attribute();
        refAttribute.setRef(attributeRefName);
        if (owningComplexType.getSimpleContent() != null) {
            owningComplexType.getSimpleContent().getExtension().getOrderedAttributes().add(refAttribute);
        } else {
            owningComplexType.getOrderedAttributes().add(refAttribute);
        }
        return refAttribute;
    }

    private void addTransformerToSchema(Property property, TypeInfo typeInfo, TypeDefParticle compositor, ComplexType type, Schema schema) {
        java.util.List<Property> props = this.getTransformerPropertyBuilder(property, typeInfo).buildProperties();
        this.addToSchemaType(typeInfo, props, compositor, type, schema);
    }

    protected TransformerPropertyBuilder getTransformerPropertyBuilder(Property property, TypeInfo typeInfo) {
        return new TransformerPropertyBuilder(property, typeInfo, this.helper, ATT);
    }

    private AddToSchemaResult addXPathToSchema(Property property, TypeDefParticle compositor, Schema schema, boolean isChoice, ComplexType type) {
        if (property.getXmlPath().equals(DOT)) {
            TypeInfo info = this.typeInfo.get(property.getActualType().getQualifiedName());
            JavaClass infoClass = property.getActualType();
            this.addSelfProperties(infoClass, info, compositor, type);
            return null;
        }
        XMLField xfld = new XMLField(property.getXmlPath());
        xfld.setNamespaceResolver(schema.getNamespaceResolver());
        xfld.initialize();
        return this.buildSchemaComponentsForXPath(xfld.getXPathFragment(), new AddToSchemaResult(compositor, schema), isChoice, property);
    }

    private void addSelfProperties(JavaClass aJavaClass, TypeInfo info, TypeDefParticle compositor, ComplexType type) {
        TypeInfo superInfo;
        if (aJavaClass.getSuperclass() != null && (superInfo = this.typeInfo.get(aJavaClass.getSuperclass().getQualifiedName())) != null) {
            this.addSelfProperties(aJavaClass.getSuperclass(), superInfo, compositor, type);
        }
        this.addToSchemaType(info, info.getPropertyList(), compositor, type, info.getSchema());
    }

    private AddToSchemaResult addXmlElementWrapperToSchema(Property property, Schema schema, TypeDefParticle compositor) {
        XmlElementWrapper wrapper = property.getXmlElementWrapper();
        Element wrapperElement = new Element();
        String name = wrapper.getName();
        wrapperElement.setNillable(wrapper.isNillable());
        String wrapperNS = wrapper.getNamespace();
        if (!wrapperNS.equals("##default") && !wrapperNS.equals(schema.getTargetNamespace())) {
            wrapperElement.setMinOccurs("1");
            wrapperElement.setMaxOccurs("1");
            String prefix = this.getOrGeneratePrefixForNamespace(wrapperNS, schema);
            wrapperElement.setRef(String.valueOf(prefix) + COLON + name);
            compositor.addElement(wrapperElement);
            return null;
        }
        wrapperElement.setName(name);
        if (wrapper.isRequired()) {
            wrapperElement.setMinOccurs("1");
        } else {
            wrapperElement.setMinOccurs("0");
        }
        if (!wrapperNS.equals("##default")) {
            String lookupNamespace = schema.getTargetNamespace();
            if (lookupNamespace == null) {
                lookupNamespace = EMPTY_STRING;
            }
            NamespaceInfo namespaceInfo = this.getNamespaceInfoForNamespace(lookupNamespace);
            boolean isElementFormQualified = false;
            if (namespaceInfo != null) {
                isElementFormQualified = namespaceInfo.isElementFormQualified();
            }
            this.shouldAddRefAndSetForm(wrapperElement, wrapperNS, lookupNamespace, isElementFormQualified, true);
        }
        compositor.addElement(wrapperElement);
        ComplexType wrapperType = new ComplexType();
        Sequence wrapperSequence = new Sequence();
        wrapperType.setSequence(wrapperSequence);
        wrapperElement.setComplexType(wrapperType);
        return new AddToSchemaResult((TypeDefParticle)wrapperSequence, wrapperType);
    }

    private Attribute buildAttribute(QName attributeName, String typeName) {
        Attribute attribute = new Attribute();
        attribute.setName(attributeName.getLocalPart());
        attribute.setType(typeName);
        return attribute;
    }

    private Attribute buildAttribute(Property property, Schema schema) {
        String fixedValue;
        Attribute attribute = new Attribute();
        QName attributeName = property.getSchemaName();
        attribute.setName(attributeName.getLocalPart());
        if (property.isRequired()) {
            attribute.setUse("required");
        }
        if ((fixedValue = property.getFixedValue()) != null) {
            attribute.setFixed(fixedValue);
        }
        TypeInfo info = this.typeInfo.get(property.getActualType().getQualifiedName());
        String typeName = this.getTypeNameForComponent(property, schema, property.getActualType(), attribute, false);
        if (this.isCollectionType(property)) {
            if (!property.isXmlList() && property.getXmlPath() != null && property.getXmlPath().contains("/")) {
                attribute.setType(typeName);
            } else {
                SimpleType localType = new SimpleType();
                List list = new List();
                list.setItemType(typeName);
                localType.setList(list);
                attribute.setSimpleType(localType);
            }
        } else {
            if (typeName != null && !typeName.contains(COLON) && info.getSchema() == schema) {
                String prefix;
                String uri = schema.getTargetNamespace();
                if (uri == null) {
                    uri = EMPTY_STRING;
                }
                if ((prefix = this.getPrefixForNamespace(schema, uri)) != null) {
                    typeName = String.valueOf(prefix) + COLON + typeName;
                }
            }
            attribute.setType(typeName);
        }
        return attribute;
    }

    private void addAttributeToSchema(Attribute attribute, QName attributeName, Schema schema, ComplexType type) {
        boolean addRef;
        String lookupNamespace = schema.getTargetNamespace();
        if (lookupNamespace == null) {
            lookupNamespace = EMPTY_STRING;
        }
        NamespaceInfo namespaceInfo = this.getNamespaceInfoForNamespace(lookupNamespace);
        boolean isAttributeFormQualified = false;
        if (namespaceInfo != null) {
            isAttributeFormQualified = namespaceInfo.isAttributeFormQualified();
        }
        if (addRef = this.shouldAddRefAndSetForm(attribute, attributeName.getNamespaceURI(), lookupNamespace, isAttributeFormQualified, false)) {
            Schema attributeSchema = this.getSchemaForNamespace(attributeName.getNamespaceURI());
            if (attributeSchema != null && attributeSchema.getTopLevelAttributes().get(attribute.getName()) == null) {
                attributeSchema.getTopLevelAttributes().put(attribute.getName(), attribute);
            }
            Attribute reference = new Attribute();
            String prefix = this.getPrefixForNamespace(schema, attributeName.getNamespaceURI());
            if (prefix == null) {
                reference.setRef(attribute.getName());
            } else {
                reference.setRef(String.valueOf(prefix) + COLON + attribute.getName());
            }
            if (type.getSimpleContent() != null) {
                type.getSimpleContent().getExtension().getOrderedAttributes().add(reference);
            } else {
                type.getOrderedAttributes().add(reference);
            }
        } else if (type.getSimpleContent() != null) {
            type.getSimpleContent().getExtension().getOrderedAttributes().add(attribute);
        } else if (type.getComplexContent() != null) {
            type.getComplexContent().getExtension().getOrderedAttributes().add(attribute);
        } else {
            type.getOrderedAttributes().add(attribute);
        }
    }

    private boolean shouldAddRefAndSetForm(SimpleComponent sc, String simpleComponentNamespace, String lookupNamespace, boolean formQualified, boolean isElement) {
        if (sc.getRef() != null) {
            return true;
        }
        boolean addRef = false;
        boolean sameNamespace = simpleComponentNamespace.equals(lookupNamespace);
        if (formQualified && !sameNamespace) {
            if (simpleComponentNamespace.equals(EMPTY_STRING)) {
                sc.setForm("unqualified");
            } else {
                addRef = true;
            }
        } else if (!formQualified && !simpleComponentNamespace.equals(EMPTY_STRING)) {
            if (sameNamespace && isElement) {
                sc.setForm("qualified");
            } else {
                addRef = true;
            }
        }
        return addRef;
    }

    private void addAnyAttributeToSchema(ComplexType type) {
        AnyAttribute anyAttribute = new AnyAttribute();
        anyAttribute.setProcessContents(SKIP);
        anyAttribute.setNamespace("##other");
        if (type.getSimpleContent() != null) {
            SimpleContent content = type.getSimpleContent();
            if (content.getExtension() != null) {
                content.getExtension().setAnyAttribute(anyAttribute);
            } else if (content.getRestriction() != null) {
                content.getRestriction().setAnyAttribute(anyAttribute);
            }
        } else {
            type.setAnyAttribute(anyAttribute);
        }
    }

    private void addAnyToSchema(Property property, TypeDefParticle compositor) {
        this.addAnyToSchema(property, compositor, this.isCollectionType(property) || property.getType().isArray(), "##other");
    }

    private void addAnyToSchema(Property property, TypeDefParticle compositor, boolean isCollection) {
        this.addAnyToSchema(property, compositor, isCollection, "##other");
    }

    private void addAnyToSchema(Property property, TypeDefParticle compositor, boolean isCollection, String anyNamespace) {
        Any any = new Any();
        any.setNamespace(anyNamespace);
        if (property.isLax()) {
            any.setProcessContents("lax");
        } else {
            any.setProcessContents(SKIP);
        }
        if (isCollection) {
            any.setMinOccurs("0");
            any.setMaxOccurs("unbounded");
        }
        if (compositor instanceof Sequence) {
            ((Sequence)compositor).addAny(any);
        } else if (compositor instanceof Choice) {
            ((Choice)compositor).addAny(any);
        }
    }

    private void addChoiceToSchema(Property property, TypeInfo typeInfo, ComplexType type, TypeDefParticle compositor, Schema schema) {
        Choice choice = new Choice();
        if (property.getGenericType() != null) {
            choice.setMaxOccurs("unbounded");
        }
        ArrayList choiceProperties = (ArrayList)property.getChoiceProperties();
        this.addToSchemaType(typeInfo, choiceProperties, choice, type, schema);
        if (compositor instanceof Sequence) {
            ((Sequence)compositor).addChoice(choice);
        } else if (compositor instanceof Choice) {
            ((Choice)compositor).addChoice(choice);
        }
    }

    private void addReferenceToSchema(Property property, Schema schema, TypeDefParticle compositor) {
        java.util.List<ElementDeclaration> referencedElements = property.getReferencedElements();
        if (referencedElements.size() == 1 && !property.isAny()) {
            Element element = new Element();
            ElementDeclaration decl = referencedElements.get(0);
            String localName = decl.getElementName().getLocalPart();
            String prefix = this.getPrefixForNamespace(schema, decl.getElementName().getNamespaceURI());
            if (decl.getScopeClass() == XmlElementDecl.GLOBAL.class) {
                if (prefix == null || prefix.equals(EMPTY_STRING)) {
                    element.setRef(localName);
                } else {
                    element.setRef(String.valueOf(prefix) + COLON + localName);
                }
            } else {
                element.setType(this.getTypeName(property, decl.getJavaType(), schema));
                element.setName(localName);
            }
            if (property.getGenericType() != null) {
                element.setMinOccurs("0");
                element.setMaxOccurs("unbounded");
            } else if (!property.isRequired()) {
                element.setMinOccurs("0");
            }
            compositor.addElement(element);
        } else {
            Choice choice = new Choice();
            if (property.getGenericType() != null) {
                choice.setMaxOccurs("unbounded");
            }
            if (!property.isRequired()) {
                choice.setMinOccurs("0");
            }
            for (ElementDeclaration elementDecl : referencedElements) {
                Element element = new Element();
                String localName = elementDecl.getElementName().getLocalPart();
                String prefix = this.getPrefixForNamespace(schema, elementDecl.getElementName().getNamespaceURI());
                if (elementDecl.getScopeClass() == XmlElementDecl.GLOBAL.class) {
                    if (prefix == null || prefix.equals(EMPTY_STRING)) {
                        element.setRef(localName);
                    } else {
                        element.setRef(String.valueOf(prefix) + COLON + localName);
                    }
                } else {
                    Schema referencedSchema = this.getSchemaForNamespace(elementDecl.getElementName().getNamespaceURI());
                    element.setType(this.getTypeName(property, elementDecl.getJavaType(), referencedSchema));
                    element.setName(localName);
                }
                choice.addElement(element);
            }
            if (property.isAny()) {
                this.addAnyToSchema(property, choice, false);
            }
            if (compositor instanceof Sequence) {
                ((Sequence)compositor).addChoice(choice);
            } else if (compositor instanceof Choice) {
                ((Choice)compositor).addChoice(choice);
            }
        }
    }

    private void addMapToSchema(Property property, Element element, Schema schema, TypeInfo typeInfo) {
        String typeName;
        QName keySchemaType;
        ComplexType entryComplexType = new ComplexType();
        Sequence entrySequence = new Sequence();
        Element keyElement = new Element();
        keyElement.setName("key");
        keyElement.setMinOccurs("0");
        JavaClass keyType = property.getKeyType();
        JavaClass valueType = property.getActualValueType();
        if (keyType == null) {
            keyType = this.helper.getJavaClass(Object.class);
        }
        if (valueType == null) {
            valueType = this.helper.getJavaClass(Object.class);
        }
        if ((keySchemaType = this.getSchemaTypeFor(keyType)) != null) {
            TypeInfo targetInfo = this.typeInfo.get(keyType.getQualifiedName());
            if (targetInfo != null) {
                Schema keyElementSchema = this.getSchemaForNamespace(keySchemaType.getNamespaceURI());
                this.addImportIfRequired(schema, keyElementSchema, keySchemaType.getNamespaceURI());
            }
            String prefix = keySchemaType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") ? "xsd" : this.getPrefixForNamespace(schema, keySchemaType.getNamespaceURI());
            typeName = prefix != null && !prefix.equals(EMPTY_STRING) ? String.valueOf(prefix) + COLON + keySchemaType.getLocalPart() : keySchemaType.getLocalPart();
            keyElement.setType(typeName);
        }
        entrySequence.addElement(keyElement);
        Element valueElement = new Element();
        valueElement.setName("value");
        valueElement.setMinOccurs("0");
        QName valueSchemaType = this.getSchemaTypeFor(valueType);
        if (valueSchemaType != null) {
            TypeInfo targetInfo = this.typeInfo.get(valueType.getQualifiedName());
            if (targetInfo != null) {
                Schema valueElementSchema = this.getSchemaForNamespace(valueSchemaType.getNamespaceURI());
                this.addImportIfRequired(schema, valueElementSchema, valueSchemaType.getNamespaceURI());
            }
            String prefix = valueSchemaType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") ? "xsd" : this.getPrefixForNamespace(schema, valueSchemaType.getNamespaceURI());
            typeName = prefix != null && !prefix.equals(EMPTY_STRING) ? String.valueOf(prefix) + COLON + valueSchemaType.getLocalPart() : valueSchemaType.getLocalPart();
            if (property.getValueGenericType() != null) {
                valueElement.setMaxOccurs("unbounded");
            }
            valueElement.setType(typeName);
        }
        entrySequence.addElement(valueElement);
        entryComplexType.setSequence(entrySequence);
        JavaClass descriptorClass = null;
        if (typeInfo.getDescriptor() != null) {
            descriptorClass = this.helper.getJavaClass(typeInfo.getDescriptor().getJavaClassName());
        }
        JavaClass mapValueClass = this.helper.getJavaClass(MapValue.class);
        if (descriptorClass != null && mapValueClass.isAssignableFrom(descriptorClass)) {
            element.setComplexType(entryComplexType);
            element.setMaxOccurs("unbounded");
        } else {
            ComplexType complexType = new ComplexType();
            Sequence sequence = new Sequence();
            complexType.setSequence(sequence);
            Element entryElement = new Element();
            entryElement.setName(ENTRY);
            entryElement.setMinOccurs("0");
            entryElement.setMaxOccurs("unbounded");
            sequence.addElement(entryElement);
            entryElement.setComplexType(entryComplexType);
            element.setComplexType(complexType);
        }
    }

    private void addElementRefToSchema(Schema schema, TypeDefParticle compositor, Element referencedElement, String referencedElementURI) {
        String prefix;
        Element reference = new Element();
        reference.setMinOccurs(referencedElement.getMinOccurs());
        reference.setMaxOccurs(referencedElement.getMaxOccurs());
        Schema attributeSchema = this.getSchemaForNamespace(referencedElementURI);
        if (attributeSchema != null && attributeSchema.getTopLevelElements().get(referencedElement.getName()) == null) {
            referencedElement.setMinOccurs(null);
            referencedElement.setMaxOccurs(null);
            attributeSchema.getTopLevelElements().put(referencedElement.getName(), referencedElement);
        }
        if ((prefix = this.getPrefixForNamespace(schema, referencedElementURI)) == null) {
            reference.setRef(referencedElement.getName());
        } else {
            reference.setRef(String.valueOf(prefix) + COLON + referencedElement.getName());
        }
        if (this.elementExistsInParticle(reference.getName(), reference.getRef(), compositor) == null) {
            compositor.addElement(reference);
        }
    }

    private Element buildElement(String elementName, String elementType, boolean isAll) {
        Element element = new Element();
        if (!isAll) {
            element.setMinOccurs("0");
        }
        element.setName(elementName);
        element.setType(elementType);
        return element;
    }

    private Element buildElement(Property property, boolean isAll, Schema schema, TypeInfo typeInfo) {
        boolean addRef;
        Element element = new Element();
        if (property.shouldSetNillable()) {
            if (property.isNotNullAnnotated()) {
                throw BeanValidationException.notNullAndNillable(property.getPropertyName());
            }
            element.setNillable(true);
        }
        if (property.isSetDefaultValue()) {
            element.setDefaultValue(property.getDefaultValue());
        }
        if (property.getMimeType() != null) {
            element.getAttributesMap().put(Constants.EXPECTED_CONTENT_TYPES_QNAME, property.getMimeType());
        }
        QName elementName = property.getSchemaName();
        String elementNamespace = elementName.getNamespaceURI();
        String lookupNamespace = schema.getTargetNamespace();
        if (lookupNamespace == null) {
            lookupNamespace = EMPTY_STRING;
        }
        NamespaceInfo namespaceInfo = this.getNamespaceInfoForNamespace(lookupNamespace, this.getPackageName(typeInfo));
        boolean isElementFormQualified = false;
        if (namespaceInfo != null) {
            isElementFormQualified = namespaceInfo.isElementFormQualified();
        }
        if (addRef = this.shouldAddRefAndSetForm(element, elementNamespace, lookupNamespace, isElementFormQualified, true)) {
            schema = this.getSchemaForNamespace(elementNamespace);
        }
        JavaClass javaType = property.getActualType();
        element.setName(elementName.getLocalPart());
        String typeName = this.getTypeNameForComponent(property, schema, javaType, element, true);
        if (property.getGenericType() != null) {
            if (property.isXmlList()) {
                SimpleType localSimpleType = new SimpleType();
                List list = new List();
                list.setItemType(typeName);
                localSimpleType.setList(list);
                element.setSimpleType(localSimpleType);
            } else {
                element.setMaxOccurs("unbounded");
                element.setType(typeName);
            }
        } else if (property.isMap()) {
            this.addMapToSchema(property, element, schema, typeInfo);
        } else {
            element.setType(typeName);
        }
        Integer minOccurs = property.getMinOccurs();
        if (minOccurs != null) {
            element.setMinOccurs(String.valueOf(minOccurs));
        } else {
            element.setMinOccurs(property.isRequired() ? "1" : "0");
        }
        Integer maxOccurs = property.getMaxOccurs();
        if (maxOccurs != null) {
            element.setMaxOccurs(String.valueOf(maxOccurs));
        }
        if (this.facets) {
            for (Facet facet : property.getFacets()) {
                this.processFacet(element, facet);
            }
        }
        return element;
    }

    private String getPackageName(TypeInfo typeInfo) {
        if (typeInfo != null && typeInfo.getDescriptor() != null && typeInfo.getDescriptor().getJavaClass() != null && typeInfo.getDescriptor().getJavaClass().getPackage() != null) {
            return typeInfo.getDescriptor().getJavaClass().getPackage().getName();
        }
        return null;
    }

    private void processFacet(Element element, Facet facet) {
        Restriction restriction;
        if (element.getSimpleType() == null) {
            element.setSimpleType(new SimpleType());
        }
        if ((restriction = element.getSimpleType().getRestriction()) == null) {
            restriction = new Restriction(element.getType());
            element.getSimpleType().setRestriction(restriction);
        }
        element.setType(null);
        facet.accept(FacetVisitorHolder.VISITOR, restriction);
    }

    private void addElementToSchema(Element element, String elementURI, boolean isPositional, TypeDefParticle compositor, Schema schema, String packageName) {
        boolean addRef;
        String lookupNamespace = schema.getTargetNamespace();
        if (lookupNamespace == null) {
            lookupNamespace = EMPTY_STRING;
        }
        NamespaceInfo namespaceInfo = this.getNamespaceInfoForNamespace(lookupNamespace, packageName);
        boolean isElementFormQualified = false;
        if (namespaceInfo != null) {
            isElementFormQualified = namespaceInfo.isElementFormQualified();
        }
        if (addRef = this.shouldAddRefAndSetForm(element, elementURI, lookupNamespace, isElementFormQualified, true)) {
            this.addElementRefToSchema(schema, compositor, element, elementURI);
        } else if (this.elementExistsInParticle(element.getName(), element.getRef(), compositor) == null) {
            if (isPositional) {
                element.setMaxOccurs("unbounded");
            }
            compositor.addElement(element);
        }
    }

    private void addXmlJoinNodesToSchema(Property property, TypeDefParticle compositor, Schema schema, ComplexType type) {
        for (XmlJoinNodes.XmlJoinNode xmlJoinNode : property.getXmlJoinNodes().getXmlJoinNode()) {
            XMLField xfld = new XMLField(xmlJoinNode.getXmlPath());
            xfld.setNamespaceResolver(schema.getNamespaceResolver());
            xfld.initialize();
            AddToSchemaResult asr = this.buildSchemaComponentsForXPath(xfld.getXPathFragment(), new AddToSchemaResult(compositor, schema), false, property);
            TypeDefParticle currentParticle = asr.particle;
            Schema currentSchema = asr.schema;
            if (currentParticle.getOwner() instanceof ComplexType) {
                type = (ComplexType)currentParticle.getOwner();
            }
            XPathFragment frag = xfld.getLastXPathFragment();
            boolean isAttribute = xmlJoinNode.getXmlPath().contains(ATT);
            if (!isAttribute && frag.nameIsText()) {
                frag = xfld.getXPathFragment();
                while (frag.getNextFragment() != null && !frag.getNextFragment().nameIsText()) {
                    frag = frag.getNextFragment();
                }
            }
            QName schemaName = new QName(frag.getNamespaceURI(), frag.getLocalName());
            if (isAttribute) {
                this.addAttributeToSchema(this.buildAttribute(schemaName, "xsd:anySimpleType"), schemaName, currentSchema, type);
                continue;
            }
            this.addElementToSchema(this.buildElement(schemaName.getLocalPart(), "xsd:anySimpleType", currentParticle instanceof All), schemaName.getNamespaceURI(), false, currentParticle, currentSchema, null);
        }
    }

    private String getTypeNameForComponent(Property property, Schema schema, JavaClass javaClass, SimpleComponent sc, boolean isElement) {
        String typeName = null;
        if (property.isXmlId()) {
            typeName = property.getSchemaType() != null ? this.getTypeName(property, property.getActualType(), schema) : "xsd:ID";
        } else if (property.isXmlIdRef()) {
            typeName = "xsd:IDREF";
        } else {
            String prefix;
            TypeInfo info = this.typeInfo.get(javaClass.getQualifiedName());
            if (info != null) {
                typeName = info.isComplexType() ? info.getComplexType().getName() : (info.getSimpleType() != null ? info.getSimpleType().getName() : info.getSchemaTypeName());
                if (typeName == null) {
                    if (isElement && info.hasRootElement() && info.getXmlRootElement().getName().equals(sc.getName())) {
                        String refName = info.getXmlRootElement().getName();
                        sc.setRef(refName);
                    } else if (isElement && info.isComplexType()) {
                        ((Element)sc).setComplexType(info.getComplexType());
                    } else {
                        sc.setSimpleType(info.getSimpleType());
                    }
                } else if (this.addImportIfRequired(schema, info.getSchema(), info.getClassNamespace()) && (prefix = schema.getNamespaceResolver().resolveNamespaceURI(info.getClassNamespace())) != null && !typeName.equals(EMPTY_STRING)) {
                    typeName = String.valueOf(prefix) + COLON + typeName;
                }
            } else if (!property.isMap()) {
                typeName = this.getTypeName(property, javaClass, schema);
            }
            if (typeName != null && !typeName.contains(COLON) && (prefix = info.getClassNamespace().equals("http://www.w3.org/2001/XMLSchema") ? "xsd" : this.getPrefixForNamespace(schema, info.getClassNamespace())) != null) {
                typeName = String.valueOf(prefix) + COLON + typeName;
            }
        }
        return typeName;
    }

    private static String introduceShorthands(String regex) {
        return RegexMutator.mutate(regex);
    }

    private static final class AddToSchemaResult {
        ComplexType type;
        TypeDefParticle particle;
        Schema schema;
        ComplexType simpleContentType;

        AddToSchemaResult(TypeDefParticle particle, Schema schema) {
            this.particle = particle;
            this.schema = schema;
        }

        AddToSchemaResult(TypeDefParticle particle, ComplexType type) {
            this.particle = particle;
            this.type = type;
        }
    }

    private static final class FacetVisitorHolder {
        private static final FacetVisitor<Void, Restriction> VISITOR = new FacetVisitor<Void, Restriction>(){

            @Override
            public Void visit(DecimalMinFacet t2, Restriction restriction) {
                if (t2.isInclusive()) {
                    restriction.setMinInclusive(t2.getValue());
                } else {
                    restriction.setMinExclusive(t2.getValue());
                }
                return null;
            }

            @Override
            public Void visit(DecimalMaxFacet t2, Restriction restriction) {
                if (t2.isInclusive()) {
                    restriction.setMaxInclusive(t2.getValue());
                } else {
                    restriction.setMaxExclusive(t2.getValue());
                }
                return null;
            }

            @Override
            public Void visit(DigitsFacet t2, Restriction restriction) {
                int fraction = t2.getFraction();
                if (fraction > 0) {
                    restriction.setFractionDigits(fraction);
                    restriction.setTotalDigits(fraction + t2.getInteger());
                } else if (fraction == 0) {
                    restriction.setTotalDigits(t2.getInteger());
                }
                return null;
            }

            @Override
            public Void visit(MaxFacet t2, Restriction restriction) {
                restriction.setMaxInclusive(String.valueOf(t2.getValue()));
                return null;
            }

            @Override
            public Void visit(MinFacet t2, Restriction restriction) {
                restriction.setMinInclusive(String.valueOf(t2.getValue()));
                return null;
            }

            @Override
            public Void visit(PatternFacet t2, Restriction restriction) {
                String regex = t2.getRegexp();
                regex = SchemaGenerator.introduceShorthands(regex);
                restriction.addPattern(regex);
                return null;
            }

            @Override
            public Void visit(PatternListFacet t2, Restriction restriction) {
                for (PatternFacet pf : t2.getPatterns()) {
                    String regex = pf.getRegexp();
                    regex = SchemaGenerator.introduceShorthands(regex);
                    restriction.addPattern(regex);
                }
                return null;
            }

            @Override
            public Void visit(SizeFacet t2, Restriction restriction) {
                int maxLength;
                int minLength = t2.getMin();
                if (minLength == (maxLength = t2.getMax())) {
                    restriction.setLength(minLength);
                } else {
                    if (minLength > 0) {
                        restriction.setMinLength(minLength);
                    }
                    if (maxLength < Integer.MAX_VALUE) {
                        restriction.setMaxLength(maxLength);
                    }
                }
                return null;
            }
        };

        private FacetVisitorHolder() {
        }
    }

    private static final class RegexMutator {
        private static final Map<Pattern, String> shorthandReplacements = new LinkedHashMap<Pattern, String>(32){
            {
                this.put(Pattern.compile("[:A-Z_a-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]", 16), "\\\\i");
                this.put(Pattern.compile("[^:A-Z_a-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]", 16), "\\\\I");
                this.put(Pattern.compile("[-.0-9:A-Z_a-z\\u00B7\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u203F\\u2040\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]", 16), "\\\\c");
                this.put(Pattern.compile("[^-.0-9:A-Z_a-z\\u00B7\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u203F\\u2040\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]", 16), "\\\\C");
                this.put(Pattern.compile("[\\u0009-\\u000D\\u0020\\u0085\\u00A0\\u1680\\u180E\\u2000-\\u200A\\u2028\\u2029\\u202F\\u205F\\u3000]", 16), "\\\\s");
                this.put(Pattern.compile("[^\\u0009-\\u000D\\u0020\\u0085\\u00A0\\u1680\\u180E\\u2000-\\u200A\\u2028\\u2029\\u202F\\u205F\\u3000]", 16), "\\\\S");
                this.put(Pattern.compile("[\\u000A-\\u000D\\u0085\\u2028\\u2029]", 16), "\\\\v");
                this.put(Pattern.compile("[^\\u000A-\\u000D\\u0085\\u2028\\u2029]", 16), "\\\\V");
                this.put(Pattern.compile("[\\u0009\\u0020\\u00A0\\u1680\\u180E\\u2000-\\u200A\\u202F\\u205F\\u3000]", 16), "\\\\h");
                this.put(Pattern.compile("[^\\u0009\\u0020\\u00A0\\u1680\\u180E\\u2000\\u2001-\\u200A\\u202F\\u205F\\u3000]", 16), "\\\\H");
                this.put(Pattern.compile("[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]]", 16), "\\\\w");
                this.put(Pattern.compile("[^\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]]", 16), "\\\\W");
                this.put(Pattern.compile("(?:(?<=[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])(?![\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])|(?<![\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])(?=[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]]))", 16), "\\\\b");
                this.put(Pattern.compile("(?:(?<=[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])(?=[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])|(?<![\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])(?![\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]]))", 16), "\\\\B");
                this.put(Pattern.compile("\\p{Nd}", 16), "\\\\d");
                this.put(Pattern.compile("\\P{Nd}", 16), "\\\\D");
                this.put(Pattern.compile("(?:(?>\\u000D\\u000A)|[\\u000A\\u000B\\u000C\\u000D\\u0085\\u2028\\u2029])", 16), "\\\\R");
                this.put(Pattern.compile("(?:(?:\\u000D\\u000A)|(?:[\\u0E40\\u0E41\\u0E42\\u0E43\\u0E44\\u0EC0\\u0EC1\\u0EC2\\u0EC3\\u0EC4\\uAAB5\\uAAB6\\uAAB9\\uAABB\\uAABC]*(?:[\\u1100-\\u115F\\uA960-\\uA97C]+|([\\u1100-\\u115F\\uA960-\\uA97C]*((?:[[\\u1160-\\u11A2\\uD7B0-\\uD7C6][\\uAC00\\uAC1C\\uAC38]][\\u1160-\\u11A2\\uD7B0-\\uD7C6]*|[\\uAC01\\uAC02\\uAC03\\uAC04])[\\u11A8-\\u11F9\\uD7CB-\\uD7FB]*))|[\\u11A8-\\u11F9\\uD7CB-\\uD7FB]+|[^[\\p{Zl}\\p{Zp}\\p{Cc}\\p{Cf}&&[^\\u000D\\u000A\\u200C\\u200D]]\\u000D\\u000A])[[\\p{Mn}\\p{Me}\\u200C\\u200D\\u0488\\u0489\\u20DD\\u20DE\\u20DF\\u20E0\\u20E2\\u20E3\\u20E4\\uA670\\uA671\\uA672\\uFF9E\\uFF9F][\\p{Mc}\\u0E30\\u0E32\\u0E33\\u0E45\\u0EB0\\u0EB2\\u0EB3]]*)|(?s:.))", 16), "\\\\X");
                this.put(Pattern.compile("[_:A-Za-z]", 16), "\\\\i");
                this.put(Pattern.compile("[^:A-Z_a-z]", 16), "\\\\I");
                this.put(Pattern.compile("[-.0-9:A-Z_a-z]", 16), "\\\\c");
                this.put(Pattern.compile("[^-.0-9:A-Z_a-z]", 16), "\\\\C");
            }
        };

        private RegexMutator() {
        }

        private static String mutate(String input) {
            for (Map.Entry<Pattern, String> entry : shorthandReplacements.entrySet()) {
                Matcher m4 = entry.getKey().matcher(input);
                input = m4.replaceAll(entry.getValue());
            }
            return input;
        }
    }
}

