/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

public final class Assert {
    private Assert() {
    }

    public static void fail(String message) {
        throw new AssertException(message);
    }

    public static void isEqual(Object object1, Object object2, String message) {
        if (object1 != object2) {
            Assert.fail(message);
        }
    }

    public static void isFalse(boolean condition, String message) {
        if (condition) {
            Assert.fail(message);
        }
    }

    public static void isNotNull(Object object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
    }

    public static void isNull(Object object, String message) {
        if (object != null) {
            Assert.fail(message);
        }
    }

    public static void isTrue(boolean condition, String message) {
        if (!condition) {
            Assert.fail(message);
        }
    }

    public static void isValid(Object object, String message, Object ... choices) {
        Object[] objectArray = choices;
        int n2 = choices.length;
        int n3 = 0;
        while (n3 < n2) {
            Object choice = objectArray[n3];
            if (object == choice) {
                return;
            }
            ++n3;
        }
        Assert.fail(message);
    }

    public static class AssertException
    extends RuntimeException {
        public AssertException(String message) {
            super(message);
        }
    }
}

