/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.ComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionFactory;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

public final class ComparisonExpressionFactory
extends ExpressionFactory {
    public static final String ID = "comparison";

    public ComparisonExpressionFactory() {
        super(ID, "<>", "=", ">", ">=", "<", "<=");
    }

    @Override
    protected AbstractExpression buildExpression(AbstractExpression parent, WordParser wordParser, String word, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
        String operator = null;
        block0 : switch (wordParser.character()) {
            case '<': {
                switch (wordParser.character(wordParser.position() + 1)) {
                    case '=': {
                        operator = "<=";
                        break block0;
                    }
                    case '>': {
                        operator = "<>";
                        break block0;
                    }
                }
                operator = "<";
                break;
            }
            case '>': {
                switch (wordParser.character(wordParser.position() + 1)) {
                    case '=': {
                        operator = ">=";
                        break block0;
                    }
                }
                operator = ">";
                break;
            }
            case '=': {
                operator = "=";
            }
        }
        if (operator == null) {
            String[] stringArray = this.identifiers();
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String identifier = stringArray[n3];
                if (wordParser.startsWith(identifier)) {
                    operator = identifier;
                    break;
                }
                ++n3;
            }
        }
        if (operator != null) {
            ComparisonExpression comparisonExpression = new ComparisonExpression(parent, operator);
            comparisonExpression.parse(wordParser, tolerant);
            if (expression != null) {
                comparisonExpression.setLeftExpression(expression);
            }
            return comparisonExpression;
        }
        return null;
    }
}

