/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.features;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.jpa.rs.features.FeatureSet;
import org.eclipse.persistence.jpa.rs.features.FeatureSetPreV2;
import org.eclipse.persistence.jpa.rs.features.FeatureSetV2;

public enum ServiceVersion {
    NO_VERSION(null),
    VERSION_1_0("v1.0"),
    VERSION_2_0("v2.0"),
    LATEST("latest");

    private final String version;
    private static final Map<String, ServiceVersion> values;

    static {
        values = new HashMap<String, ServiceVersion>();
        ServiceVersion[] serviceVersionArray = ServiceVersion.values();
        int n2 = serviceVersionArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ServiceVersion e2 = serviceVersionArray[n3];
            values.put(e2.getCode(), e2);
            ++n3;
        }
    }

    private ServiceVersion(String version) {
        this.version = version;
    }

    public String getCode() {
        return this.version;
    }

    public static ServiceVersion fromCode(String version) throws IllegalArgumentException {
        ServiceVersion e2 = values.get(version);
        if (e2 == null) {
            throw new IllegalArgumentException("Unsupported version " + version);
        }
        return e2;
    }

    public FeatureSet getFeatureSet() {
        if (this.compareTo(VERSION_2_0) >= 0) {
            return new FeatureSetV2();
        }
        return new FeatureSetPreV2();
    }

    public static boolean hasCode(String code) {
        return values.containsKey(code);
    }
}

