/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.util.Enumeration;
import java.util.Vector;
import javax.activation.DataHandler;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.mappings.BinaryDataCollectionMapping;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.FixedMimeTypePolicy;
import org.eclipse.persistence.oxm.mappings.MimeTypePolicy;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.sessions.Session;
import org.w3c.dom.Element;

public class XMLBinaryDataCollectionMapping
extends XMLCompositeDirectCollectionMapping
implements BinaryDataCollectionMapping<AbstractSession, AttributeAccessor, ContainerPolicy, Converter, ClassDescriptor, DatabaseField, XMLMarshaller, MimeTypePolicy, Session, XMLUnmarshaller, XMLRecord> {
    private boolean shouldInlineBinaryData;
    private MimeTypePolicy mimeTypePolicy;
    private boolean isSwaRef;
    private Class collectionContentType = ClassConstants.APBYTE;
    private static final String INCLUDE = "Include";

    public XMLBinaryDataCollectionMapping() {
        this.mimeTypePolicy = new FixedMimeTypePolicy(null);
    }

    @Override
    public boolean shouldInlineBinaryData() {
        return this.shouldInlineBinaryData;
    }

    @Override
    public void setShouldInlineBinaryData(boolean b2) {
        this.shouldInlineBinaryData = b2;
    }

    @Override
    public String getMimeType(Object anObject) {
        if (this.mimeTypePolicy == null) {
            return null;
        }
        return this.mimeTypePolicy.getMimeType(anObject);
    }

    @Override
    public String getMimeType() {
        return this.getMimeType(null);
    }

    @Override
    public MimeTypePolicy getMimeTypePolicy() {
        return this.mimeTypePolicy;
    }

    @Override
    public void setMimeTypePolicy(MimeTypePolicy mimeTypePolicy) {
        this.mimeTypePolicy = mimeTypePolicy;
    }

    public void setMimeType(String mimeTypeString) {
        this.mimeTypePolicy = new FixedMimeTypePolicy(mimeTypeString);
    }

    @Override
    public boolean isSwaRef() {
        return this.isSwaRef;
    }

    @Override
    public void setSwaRef(boolean swaRef) {
        this.isSwaRef = swaRef;
    }

    @Override
    public boolean isAbstractCompositeDirectCollectionMapping() {
        return false;
    }

    @Override
    public void setXPath(String xpathString) {
        XMLField field = new XMLField(xpathString);
        field.setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
        this.setField(new XMLField(xpathString));
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        XMLRecord record = (XMLRecord)row;
        Object attributeValue = this.getAttributeValueFromObject(object);
        CoreContainerPolicy cp = this.getContainerPolicy();
        Vector<Object> elements = new Vector<Object>(((ContainerPolicy)cp).sizeFor(attributeValue));
        XMLField field = (XMLField)this.getField();
        NamespaceResolver resolver = field.getNamespaceResolver();
        boolean isAttribute = field.getLastXPathFragment().isAttribute();
        String prefix = null;
        XMLField includeField = null;
        if (!isAttribute && record.isXOPPackage() && !this.isSwaRef() && !this.shouldInlineBinaryData()) {
            field = (XMLField)this.getField();
            if (resolver != null) {
                prefix = resolver.resolveNamespaceURI("http://www.w3.org/2004/08/xop/include");
            }
            if (prefix == null) {
                prefix = "xop";
                resolver = new NamespaceResolver();
                resolver.put(prefix, "http://www.w3.org/2004/08/xop/include");
            }
            includeField = new XMLField(String.valueOf(prefix) + ':' + INCLUDE + "/@href");
            includeField.setNamespaceResolver(resolver);
        }
        XMLField textField = new XMLField(String.valueOf(field.getXPath()) + '/' + "text()");
        textField.setNamespaceResolver(field.getNamespaceResolver());
        textField.setSchemaType(field.getSchemaType());
        boolean inline = false;
        Object iter = ((ContainerPolicy)cp).iteratorFor(attributeValue);
        while (((ContainerPolicy)cp).hasNext(iter)) {
            Object element = ((ContainerPolicy)cp).next(iter, session);
            if ((element = this.getValueToWrite(element, object, record, field, includeField, session)) == null) {
                AbstractNullPolicy nullPolicy = this.getNullPolicy();
                if (nullPolicy == null) {
                    elements.addElement(null);
                    continue;
                }
                if (nullPolicy.getMarshalNullRepresentation() == XMLNullRepresentationType.XSI_NIL) {
                    elements.addElement(XMLRecord.NIL);
                    continue;
                }
                if (nullPolicy.getMarshalNullRepresentation() == XMLNullRepresentationType.ABSENT_NODE) continue;
                elements.addElement("");
                continue;
            }
            if (element.getClass() == ClassConstants.ABYTE) {
                inline = true;
            }
            elements.addElement(element);
        }
        Object fieldValue = null;
        if (!elements.isEmpty()) {
            fieldValue = ((ClassDescriptor)this.getDescriptor()).buildFieldValueFromDirectValues(elements, this.elementDataTypeName, session);
        }
        if (inline) {
            row.put(textField, fieldValue);
        } else {
            row.put(field, fieldValue);
        }
    }

    public Object getValueToWrite(Object value, Object parent, XMLRecord record, XMLField field, XMLField includeField, AbstractSession session) {
        XMLMarshaller marshaller = record.getMarshaller();
        Object element = this.convertObjectValueToDataValue(value, session, record.getMarshaller());
        boolean isAttribute = ((XMLField)this.getField()).getLastXPathFragment().isAttribute();
        if (element == null) {
            return null;
        }
        if (isAttribute) {
            if (this.isSwaRef() && marshaller.getAttachmentMarshaller() != null) {
                try {
                    String id = marshaller.getAttachmentMarshaller().addSwaRefAttachment((DataHandler)element);
                    element = id;
                }
                catch (ClassCastException cce) {
                    throw XMLMarshalException.invalidSwaRefAttribute(this.getAttributeClassification().getName());
                }
            } else {
                XMLBinaryDataHelper.EncodedData data = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(element, record.getMarshaller(), this.mimeTypePolicy.getMimeType(parent));
                String base64Value = ((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).buildBase64StringFromBytes(data.getData());
                element = base64Value;
            }
        } else if (record.isXOPPackage() && !this.isSwaRef() && !this.shouldInlineBinaryData()) {
            XMLBinaryDataHelper.EncodedData data;
            String c_id = "";
            byte[] bytes = null;
            if (this.getAttributeElementClass() == ClassConstants.ABYTE || this.getAttributeElementClass() == ClassConstants.APBYTE) {
                if (this.getAttributeElementClass() == ClassConstants.ABYTE) {
                    element = session.getDatasourcePlatform().getConversionManager().convertObject(element, ClassConstants.APBYTE);
                }
                bytes = (byte[])element;
                c_id = marshaller.getAttachmentMarshaller().addMtomAttachment(bytes, 0, bytes.length, this.mimeTypePolicy.getMimeType(parent), field.getLastXPathFragment().getLocalName(), field.getLastXPathFragment().getNamespaceURI());
            } else if (this.getAttributeElementClass() == XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER) {
                c_id = marshaller.getAttachmentMarshaller().addMtomAttachment((DataHandler)element, field.getLastXPathFragment().getLocalName(), field.getLastXPathFragment().getNamespaceURI());
                if (c_id == null) {
                    data = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(element, marshaller, this.mimeTypePolicy.getMimeType(parent));
                    bytes = data.getData();
                }
            } else {
                data = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(element, marshaller, this.mimeTypePolicy.getMimeType(parent));
                bytes = data.getData();
                c_id = marshaller.getAttachmentMarshaller().addMtomAttachment(bytes, 0, bytes.length, data.getMimeType(), field.getLastXPathFragment().getLocalName(), field.getLastXPathFragment().getNamespaceURI());
            }
            if (c_id == null) {
                element = bytes;
            } else {
                DOMRecord include = new DOMRecord(field.getLastXPathFragment().getLocalName());
                include.setSession(session);
                include.put(includeField, (Object)c_id);
                element = include;
                NamespaceResolver resolver = ((XMLField)this.getField()).getNamespaceResolver();
                if (resolver == null || resolver.resolveNamespaceURI("http://www.w3.org/2004/08/xop/include") == null) {
                    resolver = new NamespaceResolver();
                    resolver.put("xop", "http://www.w3.org/2004/08/xop/include");
                    String xpath = "xop:Include";
                    XMLField incField = new XMLField(xpath);
                    incField.setNamespaceResolver(resolver);
                    Object obj = include.getIndicatingNoEntry(incField);
                    if (obj != null && obj instanceof DOMRecord && ((DOMRecord)obj).getDOM().getNodeType() == 1) {
                        ((Element)((DOMRecord)obj).getDOM()).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xop", "http://www.w3.org/2004/08/xop/include");
                    }
                }
            }
        } else if (this.isSwaRef() && marshaller.getAttachmentMarshaller() != null) {
            try {
                String c_id = marshaller.getAttachmentMarshaller().addSwaRefAttachment((DataHandler)element);
                element = c_id;
            }
            catch (Exception exception) {}
        } else if (this.getAttributeElementClass() != ClassConstants.ABYTE && this.getAttributeElementClass() != ClassConstants.APBYTE) {
            element = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(element, marshaller, this.mimeTypePolicy.getMimeType(parent)).getData();
        }
        return element;
    }

    @Override
    public void writeSingleValue(Object value, Object parent, XMLRecord record, AbstractSession session) {
        XMLField field = (XMLField)this.getField();
        NamespaceResolver resolver = field.getNamespaceResolver();
        boolean isAttribute = field.getLastXPathFragment().isAttribute();
        String prefix = null;
        XMLField includeField = null;
        if (!isAttribute && record.isXOPPackage() && !this.isSwaRef() && !this.shouldInlineBinaryData()) {
            field = (XMLField)this.getField();
            if (resolver != null) {
                prefix = resolver.resolveNamespaceURI("http://www.w3.org/2004/08/xop/include");
            }
            if (prefix == null) {
                prefix = "xop";
                resolver = new NamespaceResolver();
                resolver.put(prefix, "http://www.w3.org/2004/08/xop/include");
            }
            includeField = new XMLField(String.valueOf(prefix) + ':' + INCLUDE + "/@href");
            includeField.setNamespaceResolver(resolver);
        }
        XMLField textField = new XMLField(String.valueOf(field.getXPath()) + '/' + "text()");
        textField.setNamespaceResolver(field.getNamespaceResolver());
        textField.setSchemaType(field.getSchemaType());
        Object valueToWrite = this.getValueToWrite(value, parent, record, field, includeField, session);
        if (!isAttribute && valueToWrite.getClass() == ClassConstants.ABYTE) {
            record.add(textField, valueToWrite);
        }
        record.add(field, valueToWrite);
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery query, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) {
        CoreContainerPolicy cp = this.getContainerPolicy();
        Object fieldValue = row.getValues((DatabaseField)this.getField());
        if (fieldValue == null) {
            if (this.reuseContainer) {
                Object currentObject = ((XMLRecord)row).getCurrentObject();
                Object container = ((AttributeAccessor)this.getAttributeAccessor()).getAttributeValueFromObject(currentObject);
                return container != null ? container : ((ContainerPolicy)cp).containerInstance();
            }
            return ((ContainerPolicy)cp).containerInstance();
        }
        Vector fieldValues = ((ClassDescriptor)this.getDescriptor()).buildDirectValuesFromFieldValue(fieldValue);
        if (fieldValues == null) {
            if (this.reuseContainer) {
                Object currentObject = ((XMLRecord)row).getCurrentObject();
                Object container = ((AttributeAccessor)this.getAttributeAccessor()).getAttributeValueFromObject(currentObject);
                return container != null ? container : ((ContainerPolicy)cp).containerInstance();
            }
            return ((ContainerPolicy)cp).containerInstance();
        }
        Object result = null;
        if (this.reuseContainer) {
            Object currentObject = ((XMLRecord)row).getCurrentObject();
            Object container = ((AttributeAccessor)this.getAttributeAccessor()).getAttributeValueFromObject(currentObject);
            result = container != null ? container : ((ContainerPolicy)cp).containerInstance();
        } else {
            result = ((ContainerPolicy)cp).containerInstance(fieldValues.size());
        }
        Enumeration stream = fieldValues.elements();
        while (stream.hasMoreElements()) {
            Object element = stream.nextElement();
            XMLUnmarshaller unmarshaller = ((XMLRecord)row).getUnmarshaller();
            if (element instanceof String) {
                if (this.isSwaRef() && unmarshaller.getAttachmentUnmarshaller() != null) {
                    fieldValue = unmarshaller.getAttachmentUnmarshaller().getAttachmentAsDataHandler((String)element);
                } else if (!this.isSwaRef()) {
                    byte[] bytes = ((XMLConversionManager)executionSession.getDatasourcePlatform().getConversionManager()).convertSchemaBase64ToByteArray(element);
                    fieldValue = bytes;
                }
            } else {
                XMLRecord record = (XMLRecord)element;
                if (this.getNullPolicy().valueIsNull((Element)record.getDOM())) {
                    fieldValue = null;
                } else {
                    record.setSession(executionSession);
                    if (unmarshaller.getAttachmentUnmarshaller() != null && unmarshaller.getAttachmentUnmarshaller().isXOPPackage() && !this.isSwaRef() && !this.shouldInlineBinaryData()) {
                        String xpath = "";
                        String prefix = null;
                        NamespaceResolver descriptorResolver = ((XMLDescriptor)this.getDescriptor()).getNamespaceResolver();
                        if (descriptorResolver != null) {
                            prefix = descriptorResolver.resolveNamespaceURI("http://www.w3.org/2004/08/xop/include");
                        }
                        if (prefix == null) {
                            prefix = "xop";
                        }
                        NamespaceResolver tempResolver = new NamespaceResolver();
                        tempResolver.put(prefix, "http://www.w3.org/2004/08/xop/include");
                        xpath = String.valueOf(prefix) + ':' + INCLUDE + "/@href";
                        XMLField field = new XMLField(xpath);
                        field.setNamespaceResolver(tempResolver);
                        String includeValue = (String)record.get(field);
                        if (element != null && includeValue != null) {
                            fieldValue = this.getAttributeElementClass() == ClassConstants.ABYTE || this.getAttributeElementClass() == ClassConstants.APBYTE ? (Object)unmarshaller.getAttachmentUnmarshaller().getAttachmentAsByteArray(includeValue) : unmarshaller.getAttachmentUnmarshaller().getAttachmentAsDataHandler(includeValue);
                        } else {
                            fieldValue = record.get("text()");
                            fieldValue = ((XMLConversionManager)executionSession.getDatasourcePlatform().getConversionManager()).convertSchemaBase64ToByteArray(fieldValue);
                        }
                    } else if (unmarshaller.getAttachmentUnmarshaller() != null && this.isSwaRef()) {
                        String refValue = (String)record.get("text()");
                        if (refValue != null) {
                            fieldValue = unmarshaller.getAttachmentUnmarshaller().getAttachmentAsDataHandler(refValue);
                        }
                    } else {
                        fieldValue = record.get("text()");
                        fieldValue = ((XMLConversionManager)executionSession.getDatasourcePlatform().getConversionManager()).convertSchemaBase64ToByteArray(fieldValue);
                    }
                }
            }
            Object attributeValue = this.convertDataValueToObjectValue(fieldValue, executionSession, unmarshaller);
            ((ContainerPolicy)cp).addInto(attributeValue, result, query.getSession());
        }
        return result;
    }

    public void setCollectionContentType(Class javaClass) {
        this.setAttributeElementClass(javaClass);
    }

    public Class getCollectionContentType() {
        return this.getAttributeElementClass();
    }

    @Override
    public void setAttributeElementClass(Class attributeElementClass) {
        super.setAttributeElementClass(attributeElementClass);
        this.collectionContentType = attributeElementClass;
    }

    @Override
    public Class getAttributeElementClass() {
        Class elementClass = super.getAttributeElementClass();
        if (elementClass == null) {
            return this.collectionContentType;
        }
        return elementClass;
    }
}

