/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.TransformationMapping;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.XMLTransformationRecord;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ReadObjectQuery;

public class XMLTransformationMapping
extends AbstractTransformationMapping
implements TransformationMapping<AbstractSession, AttributeAccessor, ContainerPolicy, ClassDescriptor, DatabaseField, XMLTransformationRecord, XMLRecord>,
XMLMapping {
    @Override
    public boolean isXMLMapping() {
        return true;
    }

    @Override
    public void addFieldTransformer(String fieldName, FieldTransformer transformer) {
        this.addFieldTransformer(new XMLField(fieldName), transformer);
    }

    @Override
    public void addFieldTransformerClassName(String fieldName, String className) {
        this.addFieldTransformerClassName(new XMLField(fieldName), className);
    }

    @Override
    public void addFieldTransformation(String fieldName, String methodName) {
        this.addFieldTransformation(new XMLField(fieldName), methodName);
    }

    @Override
    public void writeSingleValue(Object value, Object parent, XMLRecord row, AbstractSession session) {
        this.writeFromObjectIntoRow(parent, row, session, DatabaseMapping.WriteType.UNDEFINED);
    }

    @Override
    public void setIsWriteOnly(boolean b2) {
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        ((AttributeAccessor)this.getAttributeAccessor()).setIsWriteOnly(this.isWriteOnly());
        ((AttributeAccessor)this.getAttributeAccessor()).setIsReadOnly(this.isReadOnly());
        super.preInitialize(session);
    }

    @Override
    public void writeFromAttributeIntoRow(UnmarshalRecord unmarshalRecord, Field field, Object value, boolean isElement) {
        if (unmarshalRecord.getTransformationRecord() == null) {
            unmarshalRecord.setTransformationRecord(new XMLTransformationRecord("ROOT", unmarshalRecord));
        }
        Field toWrite = field;
        if (isElement) {
            boolean isCDATA = unmarshalRecord.isBufferCDATA();
            if (field.isCDATA() != isCDATA) {
                toWrite = new XMLField(field.getName());
                toWrite.setNamespaceResolver(field.getNamespaceResolver());
                toWrite.setIsCDATA(isCDATA);
            }
        }
        unmarshalRecord.getTransformationRecord().put(toWrite, value);
    }

    @Override
    public Object readFromRowIntoObject(XMLRecord row, Object object, AbstractSession executionSession, boolean isTargetProtected) throws DatabaseException {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSession(executionSession);
        return this.readFromRowIntoObject(row, null, object, null, query, executionSession, isTargetProtected);
    }
}

