/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.XMLMarshaller;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.record.JSONWriterRecord;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JSONFormattedWriterRecord
extends JSONWriterRecord {
    private String tab;
    private int numberOfTabs = 0;
    private boolean isLastEventText = false;

    public JSONFormattedWriterRecord() {
    }

    public JSONFormattedWriterRecord(OutputStream outputStream) {
        this();
        this.writer = new JSONWriterRecord.OutputStreamOutput(outputStream);
    }

    public JSONFormattedWriterRecord(OutputStream outputStream, String callbackName) {
        this(outputStream);
        this.setCallbackName(callbackName);
    }

    public JSONFormattedWriterRecord(Writer writer) {
        this();
        this.setWriter(writer);
    }

    public JSONFormattedWriterRecord(Writer writer, String callbackName) {
        this(writer);
        this.setCallbackName(callbackName);
    }

    private String tab() {
        if (this.tab == null) {
            this.tab = ((XMLMarshaller)this.getMarshaller()).getIndentString();
        }
        return this.tab;
    }

    @Override
    public void startDocument(String encoding, String version) {
        super.startDocument(encoding, version);
        ++this.numberOfTabs;
    }

    @Override
    public void endDocument() {
        --this.numberOfTabs;
        super.endDocument();
    }

    @Override
    protected void closeComplex() throws IOException {
        this.writer.writeCR();
        int x2 = 0;
        while (x2 < this.numberOfTabs) {
            this.writeValue(this.tab(), false);
            ++x2;
        }
        this.writer.write('}');
    }

    @Override
    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        try {
            if (this.level.isFirst()) {
                this.level.setFirst(false);
            } else {
                this.writer.write(',');
            }
            if (xPathFragment.nameIsText() && this.level.isCollection() && this.level.isEmptyCollection()) {
                this.writer.write('[');
                this.writer.write(' ');
                this.level.setEmptyCollection(false);
                this.level.setNeedToOpenComplex(false);
                this.level = new JSONWriterRecord.Level(true, true, false, this.level);
                ++this.numberOfTabs;
                return;
            }
            if (this.level.isNeedToOpenComplex()) {
                if (!this.level.isNestedArray()) {
                    this.writer.write('{');
                }
                this.level.setNeedToOpenComplex(false);
                this.level.setNeedToCloseComplex(true);
            }
            if (!this.isLastEventText) {
                if (this.level.isCollection() && !this.level.isEmptyCollection()) {
                    this.writer.write(' ');
                } else {
                    this.writer.writeCR();
                    int x2 = 0;
                    while (x2 < this.numberOfTabs) {
                        this.writeValue(this.tab(), false);
                        ++x2;
                    }
                }
            }
            if (!this.level.isCollection() || this.level.isEmptyCollection()) {
                if (!this.level.isNestedArray()) {
                    super.writeKey(xPathFragment);
                }
                if (this.level.isCollection() && this.level.isEmptyCollection()) {
                    this.writer.write('[');
                    this.writer.write(' ');
                    this.level.setEmptyCollection(false);
                }
            }
            ++this.numberOfTabs;
            this.isLastEventText = false;
            this.charactersAllowed = true;
            this.level = xPathFragment.getXMLField() != null && xPathFragment.getXMLField().isNestedArray() && ((XMLMarshaller)this.marshaller).getJsonTypeConfiguration().isJsonDisableNestedArrayName() ? new JSONWriterRecord.Level(true, true, true, this.level) : new JSONWriterRecord.Level(true, true, false, this.level);
        }
        catch (IOException e2) {
            throw XMLMarshalException.marshalException(e2);
        }
    }

    @Override
    public void element(XPathFragment frag) {
    }

    @Override
    protected void writeListSeparator() throws IOException {
        super.writeListSeparator();
        this.writer.write(' ');
    }

    @Override
    protected void writeSeparator() throws IOException {
        this.writer.write(' ');
        this.writer.write(':');
        this.writer.write(' ');
    }

    @Override
    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.isLastEventText = false;
        --this.numberOfTabs;
        super.endElement(xPathFragment, namespaceResolver);
    }

    @Override
    public void startCollection() {
        if (this.level == null) {
            try {
                super.startCollection();
                this.writer.write(' ');
            }
            catch (IOException e2) {
                throw XMLMarshalException.marshalException(e2);
            }
        } else {
            super.startCollection();
        }
    }

    @Override
    protected void endEmptyCollection() {
        super.endCollection();
    }

    @Override
    public void endCollection() {
        try {
            this.writer.write(' ');
            super.endCollection();
        }
        catch (IOException e2) {
            throw XMLMarshalException.marshalException(e2);
        }
    }

    @Override
    public void characters(String value) {
        super.characters(value);
        this.isLastEventText = true;
    }

    @Override
    public void node(Node node, NamespaceResolver namespaceResolver) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (this.getNamespaceResolver() != null) {
                resolverPfx = ((NamespaceResolver)this.getNamespaceResolver()).resolveNamespaceURI(attr.getNamespaceURI());
            }
            if (resolverPfx != null) {
                this.attribute(attr.getNamespaceURI(), "", String.valueOf(resolverPfx) + ':' + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.attribute("http://www.w3.org/2000/xmlns/", "", "xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
                    ((NamespaceResolver)this.getNamespaceResolver()).put(attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else if (node.getNodeType() == 3) {
            this.characters(node.getNodeValue(), false, false);
        } else {
            try {
                JSONFormattedWriterRecordContentHandler wrcHandler = new JSONFormattedWriterRecordContentHandler();
                XMLFragmentReader xfragReader = new XMLFragmentReader(namespaceResolver);
                xfragReader.setContentHandler(wrcHandler);
                xfragReader.setProperty("http://xml.org/sax/properties/lexical-handler", wrcHandler);
                xfragReader.parse(node);
            }
            catch (SAXException sex) {
                throw XMLMarshalException.marshalException(sex);
            }
        }
    }

    @Override
    protected void writeKey(XPathFragment xPathFragment) throws IOException {
        this.writer.writeCR();
        int x2 = 0;
        while (x2 < this.numberOfTabs) {
            this.writeValue(this.tab(), false);
            ++x2;
        }
        super.writeKey(xPathFragment);
    }

    private class JSONFormattedWriterRecordContentHandler
    extends JSONWriterRecord.JSONWriterRecordContentHandler {
        private JSONFormattedWriterRecordContentHandler() {
            super(JSONFormattedWriterRecord.this);
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            XPathFragment xPathFragment = new XPathFragment(localName);
            xPathFragment.setNamespaceURI(namespaceURI);
            JSONFormattedWriterRecord.this.endElement(xPathFragment, JSONFormattedWriterRecord.this.namespaceResolver);
        }
    }
}

