/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.persistence.sdo.helper.CodeWriter;

public class FileCodeWriter
implements CodeWriter {
    private static final String fsep = System.getProperty("file.separator");
    private String sourceDir;

    @Override
    public void writeInterface(String dir, String filename, StringBuffer content) {
        this.writeFile(dir, filename, content);
    }

    @Override
    public void writeImpl(String dir, String filename, StringBuffer content) {
        this.writeFile(dir, filename, content);
    }

    public void writeFile(String dir, String filename, StringBuffer content) {
        if (this.sourceDir != null) {
            dir = String.valueOf(this.sourceDir) + fsep + dir;
        }
        FileOutputStream outStream = null;
        try {
            try {
                File directory = new File(dir);
                directory.mkdirs();
                File file = new File(dir, filename);
                outStream = new FileOutputStream(file);
                byte[] bytes = new String(content).getBytes();
                outStream.write(bytes);
                outStream.flush();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                try {
                    outStream.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                outStream.close();
            }
            catch (IOException e4) {
                e4.printStackTrace();
            }
        }
    }

    public void setSourceDir(String sourceDir) {
        this.sourceDir = sourceDir;
    }

    public String getSourceDir() {
        return this.sourceDir;
    }
}

