/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.extension;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;

public class SDOUtil {
    private static final String HEXADECIMAL_DIGITS = "0123456789abcdefABCDEF";
    private static final String INVALID_URI_WARNING = "SDOUtil: The URI [{0}] used for java package name generation is invalid - generating [{1}].";
    private static final String XML_NCNAME_START_CHAR_GROUP = "A-Z_a-z\\x{C0}-\\x{D6}\\x{D8}-\\x{F6}\\x{F8}-\\x{2FF}\\x{370}-\\x{37D}\\x{37F}-\\x{1FFF}\\x{200C}-\\x{200D}\\x{2070}-\\x{218F}\\x{2C00}-\\x{2FEF}\\x{3001}-\\x{D7FF}\\x{F900}-\\x{FDCF}\\x{FDF0}-\\x{FFFD}\\x{10000}-\\x{EFFFF}";
    private static final String XML_NCNAME_CHAR_GROUP = "\\-.0-9\\x{B7}\\x{300}-\\x{36F}\\x{203F}-\\x{2040}";
    private static final Pattern XML_NCNAME_VALIDATION_PATTERN = Pattern.compile("^[ A-Z_a-z\\x{C0}-\\x{D6}\\x{D8}-\\x{F6}\\x{F8}-\\x{2FF}\\x{370}-\\x{37D}\\x{37F}-\\x{1FFF}\\x{200C}-\\x{200D}\\x{2070}-\\x{218F}\\x{2C00}-\\x{2FEF}\\x{3001}-\\x{D7FF}\\x{F900}-\\x{FDCF}\\x{FDF0}-\\x{FFFD}\\x{10000}-\\x{EFFFF}][A-Z_a-z\\x{C0}-\\x{D6}\\x{D8}-\\x{F6}\\x{F8}-\\x{2FF}\\x{370}-\\x{37D}\\x{37F}-\\x{1FFF}\\x{200C}-\\x{200D}\\x{2070}-\\x{218F}\\x{2C00}-\\x{2FEF}\\x{3001}-\\x{D7FF}\\x{F900}-\\x{FDCF}\\x{FDF0}-\\x{FFFD}\\x{10000}-\\x{EFFFF}\\-.0-9\\x{B7}\\x{300}-\\x{36F}\\x{203F}-\\x{2040}]*$");
    private static final String IS = "is";
    private static final String GET = "get";
    private static final String SET = "set";
    private static boolean asWordSeparator = false;

    private static void preProcessJavaReservedNames(String name) {
        SDOUtil.preProcessReservedNames(name, SDOConstants.javaReservedWordsList, "sdo_type_generation_warning_class_name_violates_java_spec");
    }

    private static void preProcessSDOReservedNames(String name) {
        SDOUtil.preProcessReservedNames(name, SDOConstants.sdoInterfaceReservedWordsList, "sdo_type_generation_warning_class_name_violates_sdo_spec");
    }

    private static void preProcessReservedNames(String name, String[] wordArray, String warningLogKey) {
        int i2 = 0;
        while (i2 < wordArray.length) {
            if (wordArray[i2].equalsIgnoreCase(name)) {
                AbstractSessionLog.getLog().log(6, warningLogKey, new Object[]{"SDOUtil", name, wordArray[i2]});
            }
            ++i2;
        }
    }

    public static String getDefaultPackageName() {
        return SDOUtil.getPackageNameFromURI("");
    }

    /*
     * Exception decompiling
     */
    public static String getPackageNameFromURI(String uriString) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[DOLOOP]], but top level block is 13[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String decodeUriHexadecimalEscapeSequence(String uri) {
        StringBuffer sb = new StringBuffer(uri.length());
        int index = 0;
        while (index < uri.length()) {
            char c2 = uri.charAt(index);
            if (c2 == '%') {
                if (index + 2 < uri.length() && HEXADECIMAL_DIGITS.indexOf(uri.charAt(index + 1)) >= 0 && HEXADECIMAL_DIGITS.indexOf(uri.charAt(index + 2)) >= 0) {
                    String g2 = uri.substring(index + 1, index + 3);
                    sb.append((char)Integer.parseInt(g2, 16));
                    index += 2;
                } else {
                    sb.append(c2);
                }
            } else {
                sb.append(c2);
            }
            ++index;
        }
        return sb.toString();
    }

    public static String className(String s2, boolean isClass) {
        return SDOUtil.className(s2, true, isClass, true);
    }

    public static String className(String s2, boolean flag, boolean isClass, boolean logOn) {
        SDOUtil.preProcessJavaReservedNames(s2);
        SDOUtil.preProcessSDOReservedNames(s2);
        String[] as = SDOUtil.getWordList(s2);
        StringBuffer stringbuffer = new StringBuffer();
        StringBuffer stringbuffer1 = new StringBuffer();
        if (as.length == 0) {
            return stringbuffer.toString();
        }
        int i2 = 0;
        while (i2 < as.length) {
            char[] ac2 = as[i2].toCharArray();
            if (Character.isLowerCase(ac2[0])) {
                ac2[0] = Character.toUpperCase(ac2[0]);
            }
            int j2 = 0;
            while (j2 < ac2.length) {
                if (ac2[j2] >= ' ' && ac2[j2] < '\u007f') {
                    if (ac2[j2] != '_' || !asWordSeparator) {
                        stringbuffer.append(ac2[j2]);
                    }
                } else if (flag) {
                    stringbuffer.append(SDOUtil.escapeUnicode(stringbuffer1, ac2[j2]));
                } else {
                    stringbuffer.append(ac2[j2]);
                }
                ++j2;
            }
            ++i2;
        }
        String normalizedName = stringbuffer.toString();
        if (!s2.equals(normalizedName) && logOn) {
            int logLevel = !s2.equalsIgnoreCase(normalizedName) ? 5 : 2;
            if (isClass) {
                AbstractSessionLog.getLog().log(logLevel, "sdo_type_generation_modified_class_naming_format_to", new Object[]{"SDOUtil", s2, normalizedName});
            } else {
                AbstractSessionLog.getLog().log(logLevel, "sdo_type_generation_modified_function_naming_format_to", new Object[]{"SDOUtil", s2, normalizedName});
            }
        }
        return normalizedName;
    }

    public static String methodName(String s2) {
        return SDOUtil.methodName(s2, true);
    }

    public static String methodName(String s2, boolean flag) {
        return SDOUtil.className(s2, flag, false, true);
    }

    public static String setMethodName(String s2) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append(SET).append(SDOUtil.methodName(s2));
        return stringbuffer.toString();
    }

    public static String getMethodName(String s2, String returnType) {
        StringBuffer stringBuffer = new StringBuffer();
        if (returnType.equals(ClassConstants.PBOOLEAN.getName()) || returnType.equals(ClassConstants.BOOLEAN.getName())) {
            stringBuffer.append(IS);
        } else {
            stringBuffer.append(GET);
        }
        stringBuffer.append(SDOUtil.className(s2, true, false, false));
        return stringBuffer.toString();
    }

    public static String getBooleanGetMethodName(String s2, String returnType) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(GET);
        stringBuffer.append(SDOUtil.className(s2, true, false, false));
        return stringBuffer.toString();
    }

    public static String constantName(String s2) {
        StringBuffer stringbuffer = new StringBuffer();
        String[] as = SDOUtil.getWordList(s2);
        if (as.length > 0) {
            stringbuffer.append(as[0].toUpperCase());
            int i2 = 1;
            while (i2 < as.length) {
                stringbuffer.append('_');
                stringbuffer.append(as[i2].toUpperCase());
                ++i2;
            }
        }
        return stringbuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static String[] getWordList(String s) {
        arraylist = new ArrayList<String>();
        i = s.length();
        j = 0;
        while (true) {
            if (j < i) ** GOTO lbl8
            break;
lbl-1000:
            // 1 sources

            {
                ++j;
lbl8:
                // 2 sources

                ** while (j < i && SDOUtil.isPunct((char)s.charAt((int)j)))
            }
lbl9:
            // 1 sources

            if (j >= i) break;
            k = SDOUtil.nextBreak(s, j);
            s1 = k != -1 ? s.substring(j, k) : s.substring(j);
            arraylist.add(SDOUtil.escape(s1));
            if (k == -1) break;
            j = k;
        }
        return arraylist.toArray(new String[0]);
    }

    private static boolean isPunct(char c2) {
        if (c2 == '-' || c2 == '.' || c2 == ':' || c2 == '\u00b7' || c2 == '\u0387' || c2 == '\u06dd' || c2 == '\u06de') {
            return true;
        }
        return c2 == '_' && asWordSeparator;
    }

    private static boolean isUncased(char c2) {
        return Character.isLetter(c2) && !Character.isUpperCase(c2) && !Character.isLowerCase(c2);
    }

    /*
     * Unable to fully structure code
     */
    private static int nextBreak(String s, int i) {
        j = s.length();
        k = i;
        while (k < j) {
            c = s.charAt(k);
            if ((c != '_' || SDOUtil.asWordSeparator) && k < j - 1 && ((c1 = s.charAt(k + 1)) != '_' || SDOUtil.asWordSeparator)) {
                if (SDOUtil.isPunct(c1)) {
                    return k + 1;
                }
                if (Character.isDigit(c) && !Character.isDigit(c1)) {
                    return k + 1;
                }
                if (!Character.isDigit(c) && Character.isDigit(c1)) {
                    return k + 1;
                }
                if (Character.isLowerCase(c) && !Character.isLowerCase(c1)) {
                    return k + 1;
                }
                if (k < j - 2) {
                    c2 = s.charAt(k + 2);
                    if (c2 != '_' || SDOUtil.asWordSeparator) {
                        if (Character.isUpperCase(c) && Character.isUpperCase(c1) && Character.isLowerCase(c2)) {
                            return k + 1;
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    if (Character.isLetter(c) && !Character.isLetter(c1)) {
                        return k + 1;
                    }
                    if (!Character.isLetter(c) && Character.isLetter(c1)) {
                        return k + 1;
                    }
                    if (SDOUtil.isUncased(c) && !SDOUtil.isUncased(c1)) {
                        return k + 1;
                    }
                    if (!SDOUtil.isUncased(c) && SDOUtil.isUncased(c1)) {
                        return k + 1;
                    }
                }
            }
            ++k;
        }
        return -1;
    }

    private static String escape(String s2) {
        int i2 = s2.length();
        int j2 = 0;
        while (j2 < i2) {
            if (!Character.isJavaIdentifierPart(s2.charAt(j2))) {
                StringBuffer stringbuffer = new StringBuffer(s2.substring(0, j2));
                SDOUtil.escape(stringbuffer, s2, j2);
                return stringbuffer.toString();
            }
            ++j2;
        }
        return s2;
    }

    private static void escape(StringBuffer stringbuffer, String s2, int i2) {
        int j2 = s2.length();
        int k2 = i2;
        while (k2 < j2) {
            char c2 = s2.charAt(k2);
            if (Character.isJavaIdentifierPart(c2)) {
                stringbuffer.append(c2);
            } else {
                stringbuffer.append("_");
                if (c2 <= '\u000f') {
                    stringbuffer.append("000");
                } else if (c2 <= '\u00ff') {
                    stringbuffer.append("00");
                } else if (c2 <= '\u0fff') {
                    stringbuffer.append("0");
                }
                stringbuffer.append(Integer.toString(c2, 16));
            }
            ++k2;
        }
    }

    private static String escapeUnicode(StringBuffer stringbuffer, char c2) {
        String s2 = Integer.toString(c2, 16);
        int i2 = s2.length();
        stringbuffer.setLength(6);
        stringbuffer.setCharAt(0, '\\');
        stringbuffer.setCharAt(1, 'u');
        int j2 = 2;
        int k2 = i2;
        while (k2 < 4) {
            stringbuffer.setCharAt(j2, '0');
            ++k2;
            ++j2;
        }
        stringbuffer.replace(j2, 6, s2);
        return stringbuffer.toString();
    }

    public static String getJavaTypeForProperty(SDOProperty property) {
        if (property.isMany() || property.getType().isXsdList()) {
            return "java.util.List";
        }
        SDOType propertyType = property.getType();
        if (propertyType.isDataType()) {
            Class instanceClass = propertyType.getInstanceClass();
            if (ClassConstants.ABYTE.equals(instanceClass)) {
                return "Byte[]";
            }
            if (ClassConstants.APBYTE.equals(instanceClass)) {
                return "byte[]";
            }
        }
        return propertyType.getInstanceClassName();
    }

    public static String getBuiltInType(String typeName) {
        if (typeName.equals(ClassConstants.PBOOLEAN.getName()) || typeName.equals(ClassConstants.BOOLEAN.getName())) {
            return "Boolean";
        }
        if (typeName.equals(ClassConstants.PBYTE.getName()) || typeName.equals(ClassConstants.BYTE.getName())) {
            return "Byte";
        }
        if (typeName.equals("byte[]") || typeName.equals("Byte[]") || typeName.equals(ClassConstants.APBYTE.getName()) || typeName.equals(ClassConstants.ABYTE.getName())) {
            return "Bytes";
        }
        if (typeName.equals(ClassConstants.PCHAR.getName()) || typeName.equals(ClassConstants.CHAR.getName())) {
            return "Char";
        }
        if (typeName.equals(ClassConstants.PDOUBLE.getName()) || typeName.equals(ClassConstants.DOUBLE.getName())) {
            return "Double";
        }
        if (typeName.equals(ClassConstants.PFLOAT.getName()) || typeName.equals(ClassConstants.FLOAT.getName())) {
            return "Float";
        }
        if (typeName.equals(ClassConstants.PLONG.getName()) || typeName.equals(ClassConstants.LONG.getName())) {
            return "Long";
        }
        if (typeName.equals(ClassConstants.PSHORT.getName()) || typeName.equals(ClassConstants.SHORT.getName())) {
            return "Short";
        }
        if (typeName.equals(ClassConstants.PINT.getName()) || typeName.equals(ClassConstants.INTEGER.getName())) {
            return "Int";
        }
        if (typeName.equals(ClassConstants.STRING.getName())) {
            return "String";
        }
        if (typeName.equals(ClassConstants.BIGINTEGER.getName())) {
            return "BigInteger";
        }
        if (typeName.equals(ClassConstants.BIGDECIMAL.getName())) {
            return "BigDecimal";
        }
        if (typeName.equals(ClassConstants.UTILDATE.getName())) {
            return "Date";
        }
        if (typeName.equals("java.util.List")) {
            return "List";
        }
        return null;
    }

    public static boolean isValidXmlNCName(String name) {
        return XML_NCNAME_VALIDATION_PATTERN.matcher(name).matches();
    }
}

