/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.templates.CodeTemplate;

public class CodeTemplateManager {
    private int maxTemplateIDLength;
    private List<CodeTemplate> templates;
    private Segment s = new Segment();
    private TemplateComparator comparator = new TemplateComparator();
    private File directory;

    public CodeTemplateManager() {
        this.templates = new ArrayList<CodeTemplate>();
    }

    public synchronized void addTemplate(CodeTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("template cannot be null");
        }
        this.templates.add(template);
        this.sortTemplates();
    }

    public synchronized CodeTemplate getTemplate(RSyntaxTextArea textArea) {
        int caretPos = textArea.getCaretPosition();
        int charsToGet = Math.min(caretPos, this.maxTemplateIDLength);
        try {
            Document doc = textArea.getDocument();
            doc.getText(caretPos - charsToGet, charsToGet, this.s);
            int index = Collections.binarySearch(this.templates, this.s, this.comparator);
            return index >= 0 ? this.templates.get(index) : null;
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            throw new InternalError("Error in CodeTemplateManager");
        }
    }

    private synchronized int getTemplateCount() {
        return this.templates.size();
    }

    public synchronized CodeTemplate[] getTemplates() {
        CodeTemplate[] temp = new CodeTemplate[this.templates.size()];
        return this.templates.toArray(temp);
    }

    private static boolean isValidChar(char ch) {
        return RSyntaxUtilities.isLetterOrDigit(ch) || ch == '_';
    }

    public synchronized boolean removeTemplate(CodeTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("template cannot be null");
        }
        return this.templates.remove(template);
    }

    public synchronized CodeTemplate removeTemplate(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        Iterator<CodeTemplate> i2 = this.templates.iterator();
        while (i2.hasNext()) {
            CodeTemplate template = i2.next();
            if (!id.equals(template.getID())) continue;
            i2.remove();
            return template;
        }
        return null;
    }

    public synchronized void replaceTemplates(CodeTemplate[] newTemplates) {
        this.templates.clear();
        if (newTemplates != null) {
            Collections.addAll(this.templates, newTemplates);
        }
        this.sortTemplates();
    }

    public synchronized boolean saveTemplates() {
        if (this.templates == null) {
            return true;
        }
        if (this.directory == null || !this.directory.isDirectory()) {
            return false;
        }
        File[] oldXMLFiles = this.directory.listFiles(new XMLFileFilter());
        if (oldXMLFiles == null) {
            return false;
        }
        for (File oldXMLFile : oldXMLFiles) {
            oldXMLFile.delete();
        }
        boolean wasSuccessful = true;
        for (CodeTemplate template : this.templates) {
            File xmlFile = new File(this.directory, template.getID() + ".xml");
            try {
                XMLEncoder e2 = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(xmlFile)));
                e2.writeObject(template);
                e2.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                wasSuccessful = false;
            }
        }
        return wasSuccessful;
    }

    public synchronized int setTemplateDirectory(File dir) {
        if (dir != null && dir.isDirectory()) {
            this.directory = dir;
            File[] files = dir.listFiles(new XMLFileFilter());
            int newCount = files == null ? 0 : files.length;
            int oldCount = this.templates.size();
            ArrayList<CodeTemplate> temp = new ArrayList<CodeTemplate>(oldCount + newCount);
            temp.addAll(this.templates);
            for (int i2 = 0; i2 < newCount; ++i2) {
                try {
                    XMLDecoder d2 = new XMLDecoder(new BufferedInputStream(new FileInputStream(files[i2])));
                    Object obj = d2.readObject();
                    if (!(obj instanceof CodeTemplate)) {
                        d2.close();
                        throw new IOException("Not a CodeTemplate: " + files[i2].getAbsolutePath());
                    }
                    temp.add((CodeTemplate)obj);
                    d2.close();
                    continue;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            this.templates = temp;
            this.sortTemplates();
            return this.getTemplateCount();
        }
        return -1;
    }

    private synchronized void sortTemplates() {
        this.maxTemplateIDLength = 0;
        Iterator<CodeTemplate> i2 = this.templates.iterator();
        while (i2.hasNext()) {
            CodeTemplate temp = i2.next();
            if (temp == null || temp.getID() == null) {
                i2.remove();
                continue;
            }
            this.maxTemplateIDLength = Math.max(this.maxTemplateIDLength, temp.getID().length());
        }
        Collections.sort(this.templates);
    }

    private static class XMLFileFilter
    implements FileFilter {
        private XMLFileFilter() {
        }

        @Override
        public boolean accept(File f2) {
            return f2.getName().toLowerCase().endsWith(".xml");
        }
    }

    private static class TemplateComparator
    implements Comparator<Object>,
    Serializable {
        private TemplateComparator() {
        }

        @Override
        public int compare(Object template, Object segment) {
            int j2;
            CodeTemplate t2 = (CodeTemplate)template;
            char[] templateArray = t2.getID().toCharArray();
            int i2 = 0;
            int len1 = templateArray.length;
            Segment s2 = (Segment)segment;
            char[] segArray = s2.array;
            int len2 = s2.count;
            for (j2 = s2.offset + len2 - 1; j2 >= s2.offset && CodeTemplateManager.isValidChar(segArray[j2]); --j2) {
            }
            int segShift = ++j2 - s2.offset;
            int n2 = Math.min(len1, len2 -= segShift);
            while (n2-- != 0) {
                char c2;
                char c1;
                if ((c1 = templateArray[i2++]) == (c2 = segArray[j2++])) continue;
                return c1 - c2;
            }
            return len1 - len2;
        }
    }
}

