/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.IconRowHeader;

public class FoldingAwareIconRowHeader
extends IconRowHeader {
    public FoldingAwareIconRowHeader(RSyntaxTextArea textArea) {
        super(textArea);
    }

    @Override
    protected void paintComponent(Graphics g2) {
        if (this.textArea == null) {
            return;
        }
        RSyntaxTextArea rsta = (RSyntaxTextArea)this.textArea;
        FoldManager fm = rsta.getFoldManager();
        if (!fm.isCodeFoldingSupportedAndEnabled()) {
            super.paintComponent(g2);
            return;
        }
        this.visibleRect = g2.getClipBounds(this.visibleRect);
        if (this.visibleRect == null) {
            this.visibleRect = this.getVisibleRect();
        }
        if (this.visibleRect == null) {
            return;
        }
        this.paintBackgroundImpl(g2, this.visibleRect);
        if (this.textArea.getLineWrap()) {
            this.paintComponentWrapped(g2);
            return;
        }
        Document doc = this.textArea.getDocument();
        Element root = doc.getDefaultRootElement();
        this.textAreaInsets = this.textArea.getInsets(this.textAreaInsets);
        if (this.visibleRect.y < this.textAreaInsets.top) {
            this.visibleRect.height -= this.textAreaInsets.top - this.visibleRect.y;
            this.visibleRect.y = this.textAreaInsets.top;
        }
        int cellHeight = this.textArea.getLineHeight();
        int topLine = (this.visibleRect.y - this.textAreaInsets.top) / cellHeight;
        int y2 = topLine * cellHeight + this.textAreaInsets.top;
        topLine += fm.getHiddenLineCountAbove(topLine, true);
        if (this.activeLineRangeStart > -1 && this.activeLineRangeEnd > -1) {
            Color activeLineRangeColor = this.getActiveLineRangeColor();
            g2.setColor(activeLineRangeColor);
            try {
                int realY1 = rsta.yForLine(this.activeLineRangeStart);
                if (realY1 > -1) {
                    int y1 = realY1;
                    int y22 = rsta.yForLine(this.activeLineRangeEnd);
                    if (y22 == -1) {
                        y22 = y1;
                    }
                    if ((y22 += cellHeight - 1) < this.visibleRect.y || y1 > this.visibleRect.y + this.visibleRect.height) {
                        return;
                    }
                    y1 = Math.max(y2, realY1);
                    y22 = Math.min(y22, this.visibleRect.y + this.visibleRect.height);
                    for (int j2 = y1; j2 <= y22; j2 += 2) {
                        int yEnd = Math.min(y22, j2 + this.getWidth());
                        int xEnd = yEnd - j2;
                        g2.drawLine(0, j2, xEnd, yEnd);
                    }
                    for (int i2 = 2; i2 < this.getWidth(); i2 += 2) {
                        int yEnd = y1 + this.getWidth() - i2;
                        g2.drawLine(i2, y1, this.getWidth(), yEnd);
                    }
                    if (realY1 >= y2 && realY1 < this.visibleRect.y + this.visibleRect.height) {
                        g2.drawLine(0, realY1, this.getWidth(), realY1);
                    }
                    if (y22 >= y2 && y22 < this.visibleRect.y + this.visibleRect.height) {
                        g2.drawLine(0, y22, this.getWidth(), y22);
                    }
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
        if (this.trackingIcons != null) {
            int lastLine = this.textArea.getLineCount() - 1;
            for (int i3 = this.trackingIcons.size() - 1; i3 >= 0; --i3) {
                IconRowHeader.GutterIconImpl ti = this.getTrackingIcon(i3);
                int offs = ti.getMarkedOffset();
                if (offs < 0 || offs > doc.getLength()) continue;
                int line = root.getElementIndex(offs);
                if (line <= lastLine && line >= topLine) {
                    try {
                        int lineY;
                        Icon icon = ti.getIcon();
                        if (icon == null || (lineY = rsta.yForLine(line)) < y2 || lineY > this.visibleRect.y + this.visibleRect.height) continue;
                        int y23 = lineY + (cellHeight - icon.getIconHeight()) / 2;
                        icon.paintIcon(this, g2, 0, y23);
                        lastLine = line - 1;
                    }
                    catch (BadLocationException ble) {
                        ble.printStackTrace();
                    }
                    continue;
                }
                if (line < topLine) break;
            }
        }
    }

    private void paintComponentWrapped(Graphics g2) {
        RSyntaxTextArea rsta = (RSyntaxTextArea)this.textArea;
        Document doc = this.textArea.getDocument();
        Element root = doc.getDefaultRootElement();
        int topPosition = this.textArea.viewToModel(new Point(this.visibleRect.x, this.visibleRect.y));
        int topLine = root.getElementIndex(topPosition);
        int topY = this.visibleRect.y;
        int bottomY = this.visibleRect.y + this.visibleRect.height;
        int cellHeight = this.textArea.getLineHeight();
        if (this.trackingIcons != null) {
            int lastLine = this.textArea.getLineCount() - 1;
            for (int i2 = this.trackingIcons.size() - 1; i2 >= 0; --i2) {
                IconRowHeader.GutterIconImpl ti = this.getTrackingIcon(i2);
                Icon icon = ti.getIcon();
                if (icon == null) continue;
                int iconH = icon.getIconHeight();
                int offs = ti.getMarkedOffset();
                if (offs < 0 || offs > doc.getLength()) continue;
                int line = root.getElementIndex(offs);
                if (line <= lastLine && line >= topLine) {
                    try {
                        int lineY = rsta.yForLine(line);
                        if (lineY > bottomY || lineY + iconH < topY) continue;
                        int y2 = lineY + (cellHeight - iconH) / 2;
                        ti.getIcon().paintIcon(this, g2, 0, y2);
                        lastLine = line - 1;
                    }
                    catch (BadLocationException ble) {
                        ble.printStackTrace();
                    }
                    continue;
                }
                if (line < topLine) break;
            }
        }
    }
}

