/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;

final class RtfToText {
    private Reader r;
    private StringBuilder sb;
    private StringBuilder controlWord;
    private int blockCount;
    private boolean inControlWord;

    private RtfToText(Reader r2) {
        this.r = r2;
        this.sb = new StringBuilder();
        this.controlWord = new StringBuilder();
        this.blockCount = 0;
        this.inControlWord = false;
    }

    private String convert() throws IOException {
        int i2 = this.r.read();
        if (i2 != 123) {
            throw new IOException("Invalid RTF file");
        }
        block7: while ((i2 = this.r.read()) != -1) {
            char ch = (char)i2;
            switch (ch) {
                case '{': {
                    if (this.inControlWord && this.controlWord.length() == 0) {
                        this.sb.append('{');
                        this.controlWord.setLength(0);
                        this.inControlWord = false;
                        continue block7;
                    }
                    ++this.blockCount;
                    continue block7;
                }
                case '}': {
                    if (this.inControlWord && this.controlWord.length() == 0) {
                        this.sb.append('}');
                        this.controlWord.setLength(0);
                        this.inControlWord = false;
                        continue block7;
                    }
                    --this.blockCount;
                    continue block7;
                }
                case '\\': {
                    if (this.blockCount != 0) continue block7;
                    if (this.inControlWord) {
                        if (this.controlWord.length() == 0) {
                            this.sb.append('\\');
                            this.controlWord.setLength(0);
                            this.inControlWord = false;
                            continue block7;
                        }
                        this.endControlWord();
                        this.inControlWord = true;
                        continue block7;
                    }
                    this.inControlWord = true;
                    continue block7;
                }
                case ' ': {
                    if (this.blockCount != 0) continue block7;
                    if (this.inControlWord) {
                        this.endControlWord();
                        continue block7;
                    }
                    this.sb.append(' ');
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    if (this.blockCount != 0 || !this.inControlWord) continue block7;
                    this.endControlWord();
                    continue block7;
                }
            }
            if (this.blockCount != 0) continue;
            if (this.inControlWord) {
                this.controlWord.append(ch);
                continue;
            }
            this.sb.append(ch);
        }
        return this.sb.toString();
    }

    private void endControlWord() {
        String word = this.controlWord.toString();
        if ("par".equals(word) || "line".equals(word)) {
            this.sb.append('\n');
        } else if ("tab".equals(word)) {
            this.sb.append('\t');
        } else if (RtfToText.isUnicodeEscape(word)) {
            this.sb.append((char)Integer.valueOf(word.substring(1)).intValue());
        }
        this.controlWord.setLength(0);
        this.inControlWord = false;
    }

    private static boolean isUnicodeEscape(String controlWord) {
        if (controlWord.startsWith("u") && controlWord.length() > 1) {
            for (int i2 = 1; i2 < controlWord.length(); ++i2) {
                char ch = controlWord.charAt(i2);
                if (ch >= '0' && ch <= '9') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String getPlainText(byte[] rtf) throws IOException {
        return RtfToText.getPlainText(new ByteArrayInputStream(rtf));
    }

    public static String getPlainText(File file) throws IOException {
        return RtfToText.getPlainText(new BufferedReader(new FileReader(file)));
    }

    public static String getPlainText(InputStream in) throws IOException {
        return RtfToText.getPlainText(new InputStreamReader(in, StandardCharsets.US_ASCII));
    }

    private static String getPlainText(Reader r2) throws IOException {
        try {
            RtfToText converter = new RtfToText(r2);
            String string = converter.convert();
            return string;
        }
        finally {
            r2.close();
        }
    }

    public static String getPlainText(String rtf) throws IOException {
        return RtfToText.getPlainText(new StringReader(rtf));
    }
}

