/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.fife.ui.rtextarea.ChangeableHighlightPainter;

public class SquiggleUnderlineHighlightPainter
extends ChangeableHighlightPainter {
    private static final int AMT = 2;

    public SquiggleUnderlineHighlightPainter(Color color) {
        super(color);
        this.setPaint(color);
    }

    @Override
    public Shape paintLayer(Graphics g2, int offs0, int offs1, Shape bounds, JTextComponent c2, View view) {
        g2.setColor((Color)this.getPaint());
        if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
            Rectangle alloc = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            this.paintSquiggle(g2, alloc);
            return alloc;
        }
        try {
            Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
            Rectangle r2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            this.paintSquiggle(g2, r2);
            return r2;
        }
        catch (BadLocationException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    protected void paintSquiggle(Graphics g2, Rectangle r2) {
        int y2 = r2.y + r2.height - 2;
        int delta = -2;
        for (int x2 = r2.x; x2 < r2.x + r2.width; x2 += 2) {
            g2.drawLine(x2, y2, x2 + 2, y2 + delta);
            y2 += delta;
            delta = -delta;
        }
    }
}

