/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.fife.ui.rsyntaxtextarea.RSTAView;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;
import org.fife.ui.rsyntaxtextarea.TokenOrientedView;
import org.fife.ui.rsyntaxtextarea.TokenPainter;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;

public class SyntaxView
extends View
implements TabExpander,
TokenOrientedView,
RSTAView {
    private Font font;
    private FontMetrics metrics;
    private Element longLine;
    private float longLineWidth;
    private int tabSize;
    private int tabBase;
    private RSyntaxTextArea host;
    private int lineHeight;
    private int ascent;
    private int clipStart;
    private int clipEnd;
    private TokenImpl tempToken = new TokenImpl();

    public SyntaxView(Element elem) {
        super(elem);
    }

    void calculateLongestLine() {
        Container c2 = this.getContainer();
        this.font = c2.getFont();
        this.metrics = c2.getFontMetrics(this.font);
        this.tabSize = this.getTabSize() * this.metrics.charWidth(' ');
        Element lines = this.getElement();
        int n2 = lines.getElementCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Element line = lines.getElement(i2);
            float w2 = this.getLineWidth(i2);
            if (!(w2 > this.longLineWidth)) continue;
            this.longLineWidth = w2;
            this.longLine = line;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent changes, Shape a2, ViewFactory f2) {
        this.updateDamage(changes, a2, f2);
    }

    protected void damageLineRange(int line0, int line1, Shape a2, Component host) {
        if (a2 != null) {
            Rectangle area0 = this.lineToRect(a2, line0);
            Rectangle area1 = this.lineToRect(a2, line1);
            if (area0 != null && area1 != null) {
                Rectangle dmg = area0.union(area1);
                host.repaint(dmg.x, dmg.y, dmg.width, dmg.height);
            } else {
                host.repaint();
            }
        }
    }

    private float drawLine(TokenPainter painter, Token token, Graphics2D g2, float x2, float y2, int line) {
        float nextX = x2;
        boolean paintBG = this.host.getPaintTokenBackgrounds(line, y2);
        while (token != null && token.isPaintable() && nextX < (float)this.clipEnd) {
            nextX = painter.paint(token, g2, nextX, y2, this.host, this, this.clipStart, paintBG);
            token = token.getNextToken();
        }
        if (this.host.getEOLMarkersVisible()) {
            g2.setColor(this.host.getForegroundForTokenType(21));
            g2.setFont(this.host.getFontForTokenType(21));
            g2.drawString("\u00b6", nextX, y2);
        }
        return nextX;
    }

    private float drawLineWithSelection(TokenPainter painter, Token token, Graphics2D g2, float x2, float y2, int selStart, int selEnd) {
        float nextX = x2;
        boolean useSTC = this.host.getUseSelectedTextColor();
        while (token != null && token.isPaintable() && nextX < (float)this.clipEnd) {
            if (token.containsPosition(selStart)) {
                int tokenLen;
                int selCount;
                if (selStart > token.getOffset()) {
                    this.tempToken.copyFrom(token);
                    this.tempToken.textCount = selStart - this.tempToken.getOffset();
                    nextX = painter.paint(this.tempToken, g2, nextX, y2, this.host, this, this.clipStart);
                    this.tempToken.textCount = token.length();
                    this.tempToken.makeStartAt(selStart);
                    token = new TokenImpl(this.tempToken);
                }
                if ((selCount = Math.min(tokenLen = token.length(), selEnd - token.getOffset())) == tokenLen) {
                    nextX = painter.paintSelected(token, g2, nextX, y2, this.host, this, this.clipStart, useSTC);
                } else {
                    this.tempToken.copyFrom(token);
                    this.tempToken.textCount = selCount;
                    nextX = painter.paintSelected(this.tempToken, g2, nextX, y2, this.host, this, this.clipStart, useSTC);
                    this.tempToken.textCount = token.length();
                    this.tempToken.makeStartAt(token.getOffset() + selCount);
                    token = this.tempToken;
                    nextX = painter.paint(token, g2, nextX, y2, this.host, this, this.clipStart);
                }
            } else if (token.containsPosition(selEnd)) {
                this.tempToken.copyFrom(token);
                this.tempToken.textCount = selEnd - this.tempToken.getOffset();
                nextX = painter.paintSelected(this.tempToken, g2, nextX, y2, this.host, this, this.clipStart, useSTC);
                this.tempToken.textCount = token.length();
                this.tempToken.makeStartAt(selEnd);
                token = this.tempToken;
                nextX = painter.paint(token, g2, nextX, y2, this.host, this, this.clipStart);
            } else {
                nextX = token.getOffset() >= selStart && token.getEndOffset() <= selEnd ? painter.paintSelected(token, g2, nextX, y2, this.host, this, this.clipStart, useSTC) : painter.paint(token, g2, nextX, y2, this.host, this, this.clipStart);
            }
            token = token.getNextToken();
        }
        if (this.host.getEOLMarkersVisible()) {
            g2.setColor(this.host.getForegroundForTokenType(21));
            g2.setFont(this.host.getFontForTokenType(21));
            g2.drawString("\u00b6", nextX, y2);
        }
        return nextX;
    }

    private float getLineWidth(int lineNumber) {
        Token tokenList = ((RSyntaxDocument)this.getDocument()).getTokenListForLine(lineNumber);
        return RSyntaxUtilities.getTokenListWidth(tokenList, (RSyntaxTextArea)this.getContainer(), this);
    }

    @Override
    public int getNextVisualPositionFrom(int pos, Position.Bias b2, Shape a2, int direction, Position.Bias[] biasRet) throws BadLocationException {
        return RSyntaxUtilities.getNextVisualPositionFrom(pos, b2, a2, direction, biasRet, this);
    }

    @Override
    public float getPreferredSpan(int axis) {
        this.updateMetrics();
        switch (axis) {
            case 0: {
                float span = this.longLineWidth + (float)this.getRhsCorrection();
                if (this.host.getEOLMarkersVisible()) {
                    span += (float)this.metrics.charWidth('\u00b6');
                }
                return span;
            }
            case 1: {
                this.lineHeight = this.host != null ? this.host.getLineHeight() : this.lineHeight;
                int visibleLineCount = this.getElement().getElementCount();
                if (this.host.isCodeFoldingEnabled()) {
                    visibleLineCount -= this.host.getFoldManager().getHiddenLineCount();
                }
                return (float)visibleLineCount * (float)this.lineHeight;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    private int getRhsCorrection() {
        int rhsCorrection = 10;
        if (this.host != null) {
            rhsCorrection = this.host.getRightHandSideCorrection();
        }
        return rhsCorrection;
    }

    private int getTabSize() {
        Integer i2 = (Integer)this.getDocument().getProperty("tabSize");
        int size = i2 != null ? i2 : 5;
        return size;
    }

    @Override
    public Token getTokenListForPhysicalLineAbove(int offset) {
        RSyntaxDocument document = (RSyntaxDocument)this.getDocument();
        Element map = document.getDefaultRootElement();
        int line = map.getElementIndex(offset);
        FoldManager fm = this.host.getFoldManager();
        if (fm == null ? --line >= 0 : (line = fm.getVisibleLineAbove(line)) >= 0) {
            return document.getTokenListForLine(line);
        }
        return null;
    }

    @Override
    public Token getTokenListForPhysicalLineBelow(int offset) {
        RSyntaxDocument document = (RSyntaxDocument)this.getDocument();
        Element map = document.getDefaultRootElement();
        int lineCount = map.getElementCount();
        int line = map.getElementIndex(offset);
        if (!this.host.isCodeFoldingEnabled()) {
            if (line < lineCount - 1) {
                return document.getTokenListForLine(line + 1);
            }
        } else {
            FoldManager fm = this.host.getFoldManager();
            line = fm.getVisibleLineBelow(line);
            if (line >= 0 && line < lineCount) {
                return document.getTokenListForLine(line);
            }
        }
        return null;
    }

    @Override
    public void insertUpdate(DocumentEvent changes, Shape a2, ViewFactory f2) {
        this.updateDamage(changes, a2, f2);
    }

    protected Rectangle lineToRect(Shape a2, int line) {
        Rectangle r2 = null;
        this.updateMetrics();
        if (this.metrics != null) {
            Rectangle alloc = a2.getBounds();
            int n2 = this.lineHeight = this.host != null ? this.host.getLineHeight() : this.lineHeight;
            if (this.host != null && this.host.isCodeFoldingEnabled()) {
                FoldManager fm = this.host.getFoldManager();
                int hiddenCount = fm.getHiddenLineCountAbove(line);
                line -= hiddenCount;
            }
            r2 = new Rectangle(alloc.x, alloc.y + line * this.lineHeight, alloc.width, this.lineHeight);
        }
        return r2;
    }

    @Override
    public Shape modelToView(int pos, Shape a2, Position.Bias b2) throws BadLocationException {
        Element map = this.getElement();
        RSyntaxDocument doc = (RSyntaxDocument)this.getDocument();
        int lineIndex = map.getElementIndex(pos);
        Token tokenList = doc.getTokenListForLine(lineIndex);
        Rectangle lineArea = this.lineToRect(a2, lineIndex);
        this.tabBase = lineArea.x;
        lineArea = tokenList.listOffsetToView((RSyntaxTextArea)this.getContainer(), this, pos, this.tabBase, lineArea);
        return lineArea;
    }

    @Override
    public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a2) throws BadLocationException {
        Rectangle r1;
        Shape s1;
        Shape s0 = this.modelToView(p0, a2, b0);
        if (p1 == this.getEndOffset()) {
            try {
                s1 = this.modelToView(p1, a2, b1);
            }
            catch (BadLocationException ble) {
                s1 = null;
            }
            if (s1 == null) {
                Rectangle alloc = a2 instanceof Rectangle ? (Rectangle)a2 : a2.getBounds();
                s1 = new Rectangle(alloc.x + alloc.width - 1, alloc.y, 1, alloc.height);
            }
        } else {
            s1 = this.modelToView(p1, a2, b1);
        }
        Rectangle r0 = s0 instanceof Rectangle ? (Rectangle)s0 : s0.getBounds();
        Rectangle rectangle = r1 = s1 instanceof Rectangle ? (Rectangle)s1 : s1.getBounds();
        if (r0.y != r1.y) {
            Rectangle alloc = a2 instanceof Rectangle ? (Rectangle)a2 : a2.getBounds();
            r0.x = alloc.x;
            r0.width = alloc.width;
        }
        r0.add(r1);
        if (p1 > p0) {
            r0.width -= r1.width;
        }
        return r0;
    }

    @Override
    public float nextTabStop(float x2, int tabOffset) {
        if (this.tabSize == 0) {
            return x2;
        }
        int ntabs = ((int)x2 - this.tabBase) / this.tabSize;
        return (float)this.tabBase + ((float)ntabs + 1.0f) * (float)this.tabSize;
    }

    @Override
    public void paint(Graphics g2, Shape a2) {
        RSyntaxDocument document = (RSyntaxDocument)this.getDocument();
        Rectangle alloc = a2.getBounds();
        this.tabBase = alloc.x;
        this.host = (RSyntaxTextArea)this.getContainer();
        Rectangle clip = g2.getClipBounds();
        this.clipStart = clip.x;
        this.clipEnd = this.clipStart + clip.width;
        this.lineHeight = this.host.getLineHeight();
        this.ascent = this.host.getMaxAscent();
        int heightAbove = clip.y - alloc.y;
        int linesAbove = Math.max(0, heightAbove / this.lineHeight);
        FoldManager fm = this.host.getFoldManager();
        linesAbove += fm.getHiddenLineCountAbove(linesAbove, true);
        Rectangle lineArea = this.lineToRect(a2, linesAbove);
        int y2 = lineArea.y + this.ascent;
        int x2 = lineArea.x;
        Element map = this.getElement();
        int lineCount = map.getElementCount();
        int selStart = this.host.getSelectionStart();
        int selEnd = this.host.getSelectionEnd();
        RSyntaxTextAreaHighlighter h2 = (RSyntaxTextAreaHighlighter)this.host.getHighlighter();
        Graphics2D g2d = (Graphics2D)g2;
        TokenPainter painter = this.host.getTokenPainter();
        for (int line = linesAbove; y2 < clip.y + clip.height + this.ascent && line < lineCount; y2 += this.lineHeight, ++line) {
            int hiddenLineCount;
            Fold fold = fm.getFoldForLine(line);
            Element lineElement = map.getElement(line);
            int startOffset = lineElement.getStartOffset();
            int endOffset = lineElement.getEndOffset() - 1;
            h2.paintLayeredHighlights(g2d, startOffset, endOffset, a2, this.host, this);
            Token token = document.getTokenListForLine(line);
            if (selStart == selEnd || startOffset >= selEnd || endOffset < selStart) {
                this.drawLine(painter, token, g2d, x2, y2, line);
            } else {
                this.drawLineWithSelection(painter, token, g2d, x2, y2, selStart, selEnd);
            }
            h2.paintParserHighlights(g2d, startOffset, endOffset, a2, this.host, this);
            if (fold == null || !fold.isCollapsed()) continue;
            Color c2 = RSyntaxUtilities.getFoldedLineBottomColor(this.host);
            if (c2 != null) {
                g2.setColor(c2);
                g2.drawLine(x2, y2 + this.lineHeight - this.ascent - 1, this.host.getWidth(), y2 + this.lineHeight - this.ascent - 1);
            }
            while ((hiddenLineCount = fold.getLineCount()) != 0 && (fold = fm.getFoldForLine(line += hiddenLineCount)) != null && fold.isCollapsed()) {
            }
        }
    }

    private boolean possiblyUpdateLongLine(Element line, int lineNumber) {
        float w2 = this.getLineWidth(lineNumber);
        if (w2 > this.longLineWidth) {
            this.longLineWidth = w2;
            this.longLine = line;
            return true;
        }
        return false;
    }

    @Override
    public void removeUpdate(DocumentEvent changes, Shape a2, ViewFactory f2) {
        this.updateDamage(changes, a2, f2);
    }

    @Override
    public void setSize(float width, float height) {
        super.setSize(width, height);
        this.updateMetrics();
    }

    protected void updateDamage(DocumentEvent changes, Shape a2, ViewFactory f2) {
        Element[] removed;
        Container host = this.getContainer();
        this.updateMetrics();
        Element elem = this.getElement();
        DocumentEvent.ElementChange ec = changes.getChange(elem);
        Element[] added = ec != null ? ec.getChildrenAdded() : null;
        Element[] elementArray = removed = ec != null ? ec.getChildrenRemoved() : null;
        if (added != null && added.length > 0 || removed != null && removed.length > 0) {
            if (added != null) {
                int addedAt = ec.getIndex();
                for (int i2 = 0; i2 < added.length; ++i2) {
                    this.possiblyUpdateLongLine(added[i2], addedAt + i2);
                }
            }
            if (removed != null) {
                for (Element element : removed) {
                    if (element != this.longLine) continue;
                    this.longLineWidth = -1.0f;
                    this.calculateLongestLine();
                    break;
                }
            }
            this.preferenceChanged(null, true, true);
            host.repaint();
        } else if (changes.getType() == DocumentEvent.EventType.CHANGE) {
            int startLine = changes.getOffset();
            int endLine = changes.getLength();
            this.damageLineRange(startLine, endLine, a2, host);
        } else {
            Element map = this.getElement();
            int line = map.getElementIndex(changes.getOffset());
            this.damageLineRange(line, line, a2, host);
            if (changes.getType() == DocumentEvent.EventType.INSERT) {
                Element e2 = map.getElement(line);
                if (e2 == this.longLine) {
                    this.longLineWidth = this.getLineWidth(line);
                    this.preferenceChanged(null, true, false);
                } else if (this.possiblyUpdateLongLine(e2, line)) {
                    this.preferenceChanged(null, true, false);
                }
            } else if (changes.getType() == DocumentEvent.EventType.REMOVE && map.getElement(line) == this.longLine) {
                this.longLineWidth = -1.0f;
                this.calculateLongestLine();
                this.preferenceChanged(null, true, false);
            }
        }
    }

    private void updateMetrics() {
        this.host = (RSyntaxTextArea)this.getContainer();
        Font f2 = this.host.getFont();
        if (this.font != f2) {
            this.calculateLongestLine();
        }
    }

    @Override
    public int viewToModel(float fx, float fy, Shape a2, Position.Bias[] bias) {
        bias[0] = Position.Bias.Forward;
        Rectangle alloc = a2.getBounds();
        RSyntaxDocument doc = (RSyntaxDocument)this.getDocument();
        int x2 = (int)fx;
        int y2 = (int)fy;
        if (y2 < alloc.y) {
            return this.getStartOffset();
        }
        if (y2 > alloc.y + alloc.height) {
            return this.host.getLastVisibleOffset();
        }
        Element map = doc.getDefaultRootElement();
        this.lineHeight = this.host.getLineHeight();
        int lineIndex = Math.abs((y2 - alloc.y) / this.lineHeight);
        FoldManager fm = this.host.getFoldManager();
        if ((lineIndex += fm.getHiddenLineCountAbove(lineIndex, true)) >= map.getElementCount()) {
            return this.host.getLastVisibleOffset();
        }
        Element line = map.getElement(lineIndex);
        if (x2 < alloc.x) {
            return line.getStartOffset();
        }
        if (x2 > alloc.x + alloc.width) {
            return line.getEndOffset() - 1;
        }
        int p0 = line.getStartOffset();
        Token tokenList = doc.getTokenListForLine(lineIndex);
        this.tabBase = alloc.x;
        int offs = tokenList.getListOffset((RSyntaxTextArea)this.getContainer(), this, this.tabBase, x2);
        return offs != -1 ? offs : p0;
    }

    @Override
    public int yForLine(Rectangle alloc, int line) throws BadLocationException {
        this.updateMetrics();
        if (this.metrics != null) {
            FoldManager fm;
            int n2 = this.lineHeight = this.host != null ? this.host.getLineHeight() : this.lineHeight;
            if (this.host != null && !(fm = this.host.getFoldManager()).isLineHidden(line)) {
                line -= fm.getHiddenLineCountAbove(line);
                return alloc.y + line * this.lineHeight;
            }
        }
        return -1;
    }

    @Override
    public int yForLineContaining(Rectangle alloc, int offs) throws BadLocationException {
        Element map = this.getElement();
        int line = map.getElementIndex(offs);
        return this.yForLine(alloc, line);
    }
}

