/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import javax.swing.text.TabExpander;
import org.fife.ui.rsyntaxtextarea.DefaultTokenPainter;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;

class VisibleWhitespaceTokenPainter
extends DefaultTokenPainter {
    VisibleWhitespaceTokenPainter() {
    }

    @Override
    protected float paintImpl(Token token, Graphics2D g2, float x2, float y2, RSyntaxTextArea host, TabExpander e2, float clipStart, boolean selected, boolean useSTC) {
        int origX = (int)x2;
        int textOffs = token.getTextOffset();
        char[] text = token.getTextArray();
        int end = textOffs + token.length();
        float nextX = x2;
        int flushLen = 0;
        int flushIndex = textOffs;
        Color fg = useSTC ? host.getSelectedTextColor() : host.getForegroundForToken(token);
        Color bg = selected ? null : host.getBackgroundForToken(token);
        g2.setFont(host.getFontForTokenType(token.getType()));
        FontMetrics fm = host.getFontMetricsForTokenType(token.getType());
        int ascent = fm.getAscent();
        int height = fm.getHeight();
        block4: for (int i2 = textOffs; i2 < end; ++i2) {
            switch (text[i2]) {
                case '\t': {
                    nextX = x2 + (float)fm.charsWidth(text, flushIndex, flushLen);
                    float nextNextX = e2.nextTabStop(nextX, 0);
                    if (bg != null) {
                        this.paintBackground(x2, y2, nextNextX - x2, height, g2, ascent, host, bg);
                    }
                    g2.setColor(fg);
                    if (flushLen > 0) {
                        g2.drawChars(text, flushIndex, flushLen, (int)x2, (int)y2);
                        flushLen = 0;
                    }
                    flushIndex = i2 + 1;
                    int halfHeight = height / 2;
                    int quarterHeight = halfHeight / 2;
                    int ymid = (int)y2 - ascent + halfHeight;
                    g2.drawLine((int)nextX, ymid, (int)nextNextX, ymid);
                    g2.drawLine((int)nextNextX, ymid, (int)nextNextX - 4, ymid - quarterHeight);
                    g2.drawLine((int)nextNextX, ymid, (int)nextNextX - 4, ymid + quarterHeight);
                    x2 = nextNextX;
                    continue block4;
                }
                case ' ': {
                    nextX = x2 + (float)fm.charsWidth(text, flushIndex, flushLen + 1);
                    int width = fm.charWidth(' ');
                    if (bg != null) {
                        this.paintBackground(x2, y2, nextX - x2, height, g2, ascent, host, bg);
                    }
                    g2.setColor(fg);
                    if (flushLen > 0) {
                        g2.drawChars(text, flushIndex, flushLen, (int)x2, (int)y2);
                        flushLen = 0;
                    }
                    int dotX = (int)(nextX - (float)width / 2.0f);
                    int dotY = (int)(y2 - (float)ascent + (float)height / 2.0f);
                    g2.drawLine(dotX, dotY, dotX, dotY);
                    flushIndex = i2 + 1;
                    x2 = nextX;
                    continue block4;
                }
                default: {
                    ++flushLen;
                }
            }
        }
        nextX = x2 + (float)fm.charsWidth(text, flushIndex, flushLen);
        if (flushLen > 0 && nextX >= clipStart) {
            if (bg != null) {
                this.paintBackground(x2, y2, nextX - x2, height, g2, ascent, host, bg);
            }
            g2.setColor(fg);
            g2.drawChars(text, flushIndex, flushLen, (int)x2, (int)y2);
        }
        if (host.getUnderlineForToken(token)) {
            g2.setColor(fg);
            int y22 = (int)(y2 + 1.0f);
            g2.drawLine(origX, y22, (int)nextX, y22);
        }
        if (host.getPaintTabLines() && origX == host.getMargin().left) {
            this.paintTabLines(token, origX, (int)y2, (int)nextX, g2, e2, host);
        }
        return nextX;
    }
}

