/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.focusabletip;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MouseInputAdapter;
import org.fife.ui.rsyntaxtextarea.PopupWindowDecorator;
import org.fife.ui.rsyntaxtextarea.focusabletip.TipUtil;
import org.fife.ui.rsyntaxtextarea.focusabletip.TipWindow;

public class FocusableTip {
    private JTextArea textArea;
    private TipWindow tipWindow;
    private URL imageBase;
    private TextAreaListener textAreaListener;
    private HyperlinkListener hyperlinkListener;
    private String lastText;
    private Dimension maxSize;
    private Rectangle tipVisibleBounds;
    private static final int X_MARGIN = 18;
    private static final int Y_MARGIN = 12;
    private static final ResourceBundle MSG = ResourceBundle.getBundle("org.fife.ui.rsyntaxtextarea.focusabletip.FocusableTip");

    public FocusableTip(JTextArea textArea, HyperlinkListener listener) {
        this.setTextArea(textArea);
        this.hyperlinkListener = listener;
        this.textAreaListener = new TextAreaListener();
        this.tipVisibleBounds = new Rectangle();
    }

    private void computeTipVisibleBounds() {
        Rectangle r2 = this.tipWindow.getBounds();
        Point p2 = r2.getLocation();
        SwingUtilities.convertPointFromScreen(p2, this.textArea);
        r2.setLocation(p2);
        this.tipVisibleBounds.setBounds(r2.x, r2.y - 15, r2.width, r2.height + 30);
    }

    private void createAndShowTipWindow(MouseEvent e2, String text) {
        Window owner = SwingUtilities.getWindowAncestor(this.textArea);
        this.tipWindow = new TipWindow(owner, this, text);
        this.tipWindow.setHyperlinkListener(this.hyperlinkListener);
        PopupWindowDecorator decorator = PopupWindowDecorator.get();
        if (decorator != null) {
            decorator.decorate(this.tipWindow);
        }
        this.invokeLater(() -> {
            if (this.tipWindow == null) {
                return;
            }
            this.tipWindow.fixSize();
            ComponentOrientation o2 = this.textArea.getComponentOrientation();
            Point p2 = e2.getPoint();
            SwingUtilities.convertPointToScreen(p2, this.textArea);
            Rectangle sb = TipUtil.getScreenBoundsForPoint(p2.x, p2.y);
            int y2 = p2.y + 12;
            if (y2 + this.tipWindow.getHeight() >= sb.y + sb.height && (y2 = p2.y - 12 - this.tipWindow.getHeight()) < sb.y) {
                y2 = sb.y + 12;
            }
            int x2 = p2.x - 18;
            if (!o2.isLeftToRight()) {
                x2 = p2.x - this.tipWindow.getWidth() + 18;
            }
            if (x2 < sb.x) {
                x2 = sb.x;
            } else if (x2 + this.tipWindow.getWidth() > sb.x + sb.width) {
                x2 = sb.x + sb.width - this.tipWindow.getWidth();
            }
            this.tipWindow.setLocation(x2, y2);
            this.tipWindow.setVisible(true);
            this.computeTipVisibleBounds();
            this.textAreaListener.install(this.textArea);
            this.lastText = text;
        });
    }

    public URL getImageBase() {
        return this.imageBase;
    }

    public Dimension getMaxSize() {
        return this.maxSize;
    }

    static String getString(String key) {
        return MSG.getString(key);
    }

    protected void invokeLater(Runnable r2) {
        SwingUtilities.invokeLater(r2);
    }

    public void possiblyDisposeOfTipWindow() {
        if (this.tipWindow != null) {
            this.tipWindow.dispose();
            this.tipWindow = null;
            this.textAreaListener.uninstall();
            this.tipVisibleBounds.setBounds(-1, -1, 0, 0);
            this.lastText = null;
            this.textArea.requestFocus();
        }
    }

    void removeListeners() {
        this.textAreaListener.uninstall();
    }

    public void setImageBase(URL url) {
        this.imageBase = url;
    }

    public void setMaxSize(Dimension maxSize) {
        this.maxSize = maxSize;
    }

    private void setTextArea(JTextArea textArea) {
        this.textArea = textArea;
        ToolTipManager.sharedInstance().registerComponent(textArea);
    }

    public void toolTipRequested(MouseEvent e2, String text) {
        if (text == null || text.length() == 0) {
            this.possiblyDisposeOfTipWindow();
            this.lastText = text;
            return;
        }
        if (this.lastText == null || text.length() != this.lastText.length() || !text.equals(this.lastText)) {
            this.possiblyDisposeOfTipWindow();
            this.createAndShowTipWindow(e2, text);
        }
    }

    private class TextAreaListener
    extends MouseInputAdapter
    implements CaretListener,
    ComponentListener,
    FocusListener,
    KeyListener {
        private TextAreaListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e2) {
            Object source = e2.getSource();
            if (source == FocusableTip.this.textArea) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            }
        }

        @Override
        public void componentHidden(ComponentEvent e2) {
            this.handleComponentEvent(e2);
        }

        @Override
        public void componentMoved(ComponentEvent e2) {
            this.handleComponentEvent(e2);
        }

        @Override
        public void componentResized(ComponentEvent e2) {
            this.handleComponentEvent(e2);
        }

        @Override
        public void componentShown(ComponentEvent e2) {
            this.handleComponentEvent(e2);
        }

        @Override
        public void focusGained(FocusEvent e2) {
        }

        @Override
        public void focusLost(FocusEvent e2) {
            boolean tipClicked;
            Component c2 = e2.getOppositeComponent();
            boolean bl = tipClicked = c2 instanceof TipWindow || c2 != null && SwingUtilities.getWindowAncestor(c2) instanceof TipWindow;
            if (!tipClicked) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            }
        }

        private void handleComponentEvent(ComponentEvent e2) {
            FocusableTip.this.possiblyDisposeOfTipWindow();
        }

        public void install(JTextArea textArea) {
            textArea.addCaretListener(this);
            textArea.addComponentListener(this);
            textArea.addFocusListener(this);
            textArea.addKeyListener(this);
            textArea.addMouseListener(this);
            textArea.addMouseMotionListener(this);
        }

        @Override
        public void keyPressed(KeyEvent e2) {
            if (e2.getKeyCode() == 27) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            } else if (e2.getKeyCode() == 113 && FocusableTip.this.tipWindow != null && !FocusableTip.this.tipWindow.getFocusableWindowState()) {
                FocusableTip.this.tipWindow.actionPerformed(null);
                e2.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e2) {
        }

        @Override
        public void keyTyped(KeyEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            if (FocusableTip.this.tipVisibleBounds == null || !FocusableTip.this.tipVisibleBounds.contains(e2.getPoint())) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            }
        }

        public void uninstall() {
            FocusableTip.this.textArea.removeCaretListener(this);
            FocusableTip.this.textArea.removeComponentListener(this);
            FocusableTip.this.textArea.removeFocusListener(this);
            FocusableTip.this.textArea.removeKeyListener(this);
            FocusableTip.this.textArea.removeMouseListener(this);
            FocusableTip.this.textArea.removeMouseMotionListener(this);
        }
    }
}

