/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.plaf.effect;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.lang.ref.SoftReference;
import org.jdesktop.jxlayer.plaf.effect.AbstractLayerEffect;

public class AbstractBufferedImageOpEffect
extends AbstractLayerEffect {
    private transient SoftReference<BufferedImage> cachedSubImage;
    private static final BufferedImageOp[] emptyOpsArray = new BufferedImageOp[0];

    public void apply(BufferedImage bufferedImage, Shape shape) {
        BufferedImage bufferedImage2;
        Rectangle rectangle;
        if (bufferedImage == null) {
            throw new IllegalArgumentException("BufferedImage is null");
        }
        Rectangle rectangle2 = new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight());
        if (shape == null) {
            shape = rectangle2;
        }
        if ((rectangle = shape.getBounds().intersection(rectangle2)).isEmpty() || bufferedImage.getWidth() <= rectangle.x || bufferedImage.getHeight() <= rectangle.y) {
            return;
        }
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        if (bufferedImage.getWidth() < n2 + n4) {
            n4 = bufferedImage.getWidth() - n2;
        }
        if (bufferedImage.getHeight() < n3 + n5) {
            n5 = bufferedImage.getHeight() - n3;
        }
        BufferedImage bufferedImage3 = bufferedImage2 = this.cachedSubImage == null ? null : this.cachedSubImage.get();
        if (bufferedImage2 == null || bufferedImage2.getWidth() != n4 || bufferedImage2.getHeight() != n5) {
            bufferedImage2 = new BufferedImage(n4, n5, bufferedImage.getType());
            this.cachedSubImage = new SoftReference<BufferedImage>(bufferedImage2);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setClip(shape);
        Graphics2D graphics2D2 = bufferedImage2.createGraphics();
        for (BufferedImageOp bufferedImageOp : this.getBufferedImageOps()) {
            graphics2D2.drawImage(bufferedImage, 0, 0, n4, n5, n2, n3, n2 + n4, n3 + n5, null);
            graphics2D.drawImage(bufferedImage2, bufferedImageOp, n2, n3);
        }
        graphics2D2.dispose();
        graphics2D.dispose();
    }

    protected BufferedImageOp[] getBufferedImageOps() {
        return emptyOpsArray;
    }
}

