/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.plaf.ext;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractBufferedLayerUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugRepaintingUI
extends AbstractBufferedLayerUI<JComponent>
implements ActionListener {
    private Map<Shape, DebugPainterEntry> shapeMap = new HashMap<Shape, DebugPainterEntry>();
    private final Timer timer;

    public DebugRepaintingUI() {
        this(50);
    }

    public DebugRepaintingUI(int n2) {
        this.timer = new Timer(n2, this);
    }

    @Override
    protected void paintLayer(Graphics2D graphics2D, JXLayer<? extends JComponent> jXLayer) {
        Object object;
        Object object2;
        Object object3;
        super.paintLayer(graphics2D, jXLayer);
        Shape shape = graphics2D.getClip();
        if (!this.isDirty() && shape != null && !this.shapeMap.containsKey(shape)) {
            object3 = shape.getBounds();
            object2 = new BufferedImage(((Rectangle)object3).width, ((Rectangle)object3).height, 2);
            object = ((BufferedImage)object2).createGraphics();
            ((Graphics)object).setColor(Color.WHITE);
            ((Graphics)object).fillRect(0, 0, ((BufferedImage)object2).getWidth(), ((BufferedImage)object2).getHeight());
            ((Graphics)object).setXORMode(Color.BLACK);
            ((Graphics)object).drawImage(this.getBuffer(), 0, 0, ((Rectangle)object3).width, ((Rectangle)object3).height, ((Rectangle)object3).x, ((Rectangle)object3).y, ((Rectangle)object3).x + ((Rectangle)object3).width, ((Rectangle)object3).y + ((Rectangle)object3).height, null);
            ((Graphics)object).dispose();
            this.shapeMap.put(shape, new DebugPainterEntry((Image)object2, ((Rectangle)object3).x, ((Rectangle)object3).y));
            if (!this.timer.isRunning()) {
                this.timer.start();
            }
        }
        object3 = this.shapeMap.keySet();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            DebugPainterEntry debugPainterEntry = this.shapeMap.get(object);
            if (debugPainterEntry.alpha <= 0.0f) {
                object2.remove();
                continue;
            }
            graphics2D.setComposite(AlphaComposite.getInstance(3, debugPainterEntry.alpha));
            graphics2D.drawImage(debugPainterEntry.image, debugPainterEntry.x, debugPainterEntry.y, null);
            debugPainterEntry.alpha = (float)((double)debugPainterEntry.alpha - 0.1);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.shapeMap.isEmpty()) {
            this.setDirty(true);
        } else {
            this.timer.stop();
        }
    }

    private static class DebugPainterEntry {
        private Image image;
        private int x;
        private int y;
        private float alpha = 1.0f;

        public DebugPainterEntry(Image image, int n2, int n3) {
            this.image = image;
            this.x = n2;
            this.y = n3;
        }
    }
}

