/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.plaf.ext;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractBufferedLayerUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpotLightUI
extends AbstractBufferedLayerUI<JComponent> {
    private ArrayList<Shape> clipList = new ArrayList();
    private Color overlayColor;
    private int softClipWidth;
    private boolean isEnabled;

    public SpotLightUI() {
        this(0);
    }

    public SpotLightUI(int n2) {
        this(new Color(0, 0, 0, 128), n2);
    }

    public SpotLightUI(Color color, int n2) {
        this.setOverlayColor(color);
        this.setSoftClipWidth(n2);
    }

    @Override
    public long getLayerEventMask() {
        return 0L;
    }

    private void softClipping(Graphics2D graphics2D, Shape shape) {
        graphics2D.setComposite(AlphaComposite.Src);
        for (int i2 = 0; i2 < this.softClipWidth; ++i2) {
            int n2 = (i2 + 1) * this.overlayColor.getAlpha() / (this.softClipWidth + 1);
            Color color = new Color(this.overlayColor.getRed(), this.overlayColor.getGreen(), this.overlayColor.getBlue(), n2);
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(this.softClipWidth - i2));
            graphics2D.draw(shape);
        }
    }

    public boolean isShadowEnabled() {
        return this.isEnabled;
    }

    public void setShadowEnabled(boolean bl) {
        boolean bl2 = this.isShadowEnabled();
        this.isEnabled = bl;
        this.firePropertyChange("shadowEnabled", bl2, this.isEnabled);
    }

    public Color getOverlayColor() {
        return this.overlayColor;
    }

    public void setOverlayColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("overlayColor is null");
        }
        Color color2 = this.getOverlayColor();
        this.overlayColor = color;
        this.firePropertyChange("overlayColor", color2, color);
    }

    public int getSoftClipWidth() {
        return this.softClipWidth;
    }

    public void setSoftClipWidth(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("softClipWidth can't be less than 0");
        }
        int n3 = this.getSoftClipWidth();
        this.softClipWidth = n2;
        this.firePropertyChange("softClipWidth", n3, n2);
    }

    public void reset() {
        this.clipList.clear();
        this.setDirty(true);
    }

    public void addShape(Shape shape) {
        this.clipList.add(shape);
        this.setDirty(true);
    }

    @Override
    protected boolean isIncrementalUpdate(JXLayer<? extends JComponent> jXLayer) {
        return false;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        jComponent.paint(graphics);
        if (this.isShadowEnabled()) {
            super.paint(graphics, jComponent);
        }
    }

    @Override
    protected void paintLayer(Graphics2D graphics2D, JXLayer<? extends JComponent> jXLayer) {
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, jXLayer.getWidth(), jXLayer.getHeight());
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.setColor(this.overlayColor);
        graphics2D.fillRect(0, 0, jXLayer.getWidth(), jXLayer.getHeight());
        for (Shape shape : this.clipList) {
            graphics2D.setClip(shape);
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fill(shape);
            this.softClipping(graphics2D, shape);
        }
    }

    @Override
    public boolean contains(JComponent jComponent, int n2, int n3) {
        if (this.isShadowEnabled()) {
            for (Shape shape : this.clipList) {
                if (!shape.contains(n2, n3)) continue;
                return true;
            }
            return false;
        }
        return super.contains(jComponent, n2, n3);
    }
}

