/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXStatusBar;

public class JXRootPane
extends JRootPane {
    protected JXStatusBar statusBar;
    private JToolBar toolBar;
    private JButton cancelButton;

    public JXRootPane() {
        this.installKeyboardActions();
    }

    @Override
    protected Container createContentPane() {
        JXPanel c2 = new JXPanel(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void addImpl(Component comp, Object constraints, int index) {
                Object object = this.getTreeLock();
                synchronized (object) {
                    super.addImpl(comp, constraints, index);
                    JXRootPane.this.registerStatusBar(comp);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove(int index) {
                Object object = this.getTreeLock();
                synchronized (object) {
                    JXRootPane.this.unregisterStatusBar(this.getComponent(index));
                    super.remove(index);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAll() {
                Object object = this.getTreeLock();
                synchronized (object) {
                    for (Component c2 : this.getComponents()) {
                        JXRootPane.this.unregisterStatusBar(c2);
                    }
                    super.removeAll();
                }
            }
        };
        c2.setName(this.getName() + ".contentPane");
        c2.setLayout(new BorderLayout(){

            @Override
            public void addLayoutComponent(Component comp, Object constraints) {
                if (constraints == null) {
                    constraints = "Center";
                }
                super.addLayoutComponent(comp, constraints);
            }
        });
        return c2;
    }

    @Override
    public void setLayout(LayoutManager layout) {
        if (layout instanceof XRootLayout) {
            if (layout != null && layout == this.getLayout()) {
                ((XRootLayout)layout).setLayoutManager(null);
            }
            super.setLayout(layout);
        } else if (layout instanceof LayoutManager2) {
            ((XRootLayout)this.getLayout()).setLayoutManager((LayoutManager2)layout);
            if (!this.isValid()) {
                this.invalidate();
            }
        }
    }

    @Override
    protected LayoutManager createRootLayout() {
        return new XRootLayout();
    }

    private void installKeyboardActions() {
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JButton cancelButton = JXRootPane.this.getCancelButton();
                if (cancelButton != null) {
                    cancelButton.doClick(20);
                }
            }

            @Override
            public boolean isEnabled() {
                Action cancelPopup;
                Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (component instanceof JComponent && (cancelPopup = ((JComponent)component).getActionMap().get("cancel")) != null) {
                    return false;
                }
                return JXRootPane.this.cancelButton != null && JXRootPane.this.cancelButton.isEnabled();
            }
        };
        this.getActionMap().put("esc-action", escAction);
        InputMap im = this.getInputMap(1);
        KeyStroke key = KeyStroke.getKeyStroke(27, 0);
        im.put(key, "esc-action");
    }

    private void registerStatusBar(Component comp) {
        if (this.statusBar == null || comp == null) {
            return;
        }
        if (comp instanceof Container) {
            Component[] comps = ((Container)comp).getComponents();
            for (int i2 = 0; i2 < comps.length; ++i2) {
                this.registerStatusBar(comps[i2]);
            }
        }
    }

    private void unregisterStatusBar(Component comp) {
        if (this.statusBar == null || comp == null) {
            return;
        }
        if (comp instanceof Container) {
            Component[] comps = ((Container)comp).getComponents();
            for (int i2 = 0; i2 < comps.length; ++i2) {
                this.unregisterStatusBar(comps[i2]);
            }
        }
    }

    public void setStatusBar(JXStatusBar statusBar) {
        JXStatusBar oldStatusBar = this.statusBar;
        this.statusBar = statusBar;
        Component[] comps = this.getContentPane().getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            this.unregisterStatusBar(comps[i2]);
            this.registerStatusBar(comps[i2]);
        }
        if (oldStatusBar != null) {
            this.remove(oldStatusBar);
        }
        if (statusBar != null) {
            this.add(statusBar);
        }
        this.firePropertyChange("statusBar", oldStatusBar, this.getStatusBar());
    }

    public JXStatusBar getStatusBar() {
        return this.statusBar;
    }

    public void setToolBar(JToolBar toolBar) {
        JToolBar oldToolBar = this.getToolBar();
        this.toolBar = toolBar;
        if (oldToolBar != null) {
            this.getContentPane().remove(oldToolBar);
        }
        this.getContentPane().add("North", this.toolBar);
        this.getContentPane().validate();
        this.firePropertyChange("toolBar", oldToolBar, this.getToolBar());
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void setCancelButton(JButton cancelButton) {
        JButton old = this.cancelButton;
        if (old != cancelButton) {
            this.cancelButton = cancelButton;
            if (old != null) {
                old.repaint();
            }
            if (cancelButton != null) {
                cancelButton.repaint();
            }
        }
        this.firePropertyChange("cancelButton", old, cancelButton);
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    protected class XRootLayout
    extends JRootPane.RootLayout {
        LayoutManager2 delegate;

        protected XRootLayout() {
            super(JXRootPane.this);
        }

        public void setLayoutManager(LayoutManager2 delegate) {
            this.delegate = delegate;
        }

        private Dimension delegatePreferredLayoutSize(Container parent) {
            if (this.delegate == null) {
                return super.preferredLayoutSize(parent);
            }
            return this.delegate.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension pref = this.delegatePreferredLayoutSize(parent);
            if (JXRootPane.this.statusBar != null && JXRootPane.this.statusBar.isVisible()) {
                Dimension statusPref = JXRootPane.this.statusBar.getPreferredSize();
                pref.width = Math.max(pref.width, statusPref.width);
                pref.height += statusPref.height;
            }
            return pref;
        }

        private Dimension delegateMinimumLayoutSize(Container parent) {
            if (this.delegate == null) {
                return super.minimumLayoutSize(parent);
            }
            return this.delegate.minimumLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension pref = this.delegateMinimumLayoutSize(parent);
            if (JXRootPane.this.statusBar != null && JXRootPane.this.statusBar.isVisible()) {
                Dimension statusPref = JXRootPane.this.statusBar.getMinimumSize();
                pref.width = Math.max(pref.width, statusPref.width);
                pref.height += statusPref.height;
            }
            return pref;
        }

        private Dimension delegateMaximumLayoutSize(Container parent) {
            if (this.delegate == null) {
                return super.maximumLayoutSize(parent);
            }
            return this.delegate.maximumLayoutSize(parent);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            Dimension pref = this.delegateMaximumLayoutSize(target);
            if (JXRootPane.this.statusBar != null && JXRootPane.this.statusBar.isVisible()) {
                Dimension statusPref = JXRootPane.this.statusBar.getMaximumSize();
                pref.width = Math.max(pref.width, statusPref.width);
                pref.height += statusPref.height;
            }
            return pref;
        }

        private void delegateLayoutContainer(Container parent) {
            if (this.delegate == null) {
                super.layoutContainer(parent);
            } else {
                this.delegate.layoutContainer(parent);
            }
        }

        @Override
        public void layoutContainer(Container parent) {
            this.delegateLayoutContainer(parent);
            if (JXRootPane.this.statusBar == null || !JXRootPane.this.statusBar.isVisible()) {
                return;
            }
            Rectangle b2 = parent.getBounds();
            Insets i2 = JXRootPane.this.getInsets();
            int w2 = b2.width - i2.right - i2.left;
            Dimension statusPref = JXRootPane.this.statusBar.getPreferredSize();
            JXRootPane.this.statusBar.setBounds(i2.right, b2.height - i2.bottom - statusPref.height, w2, statusPref.height);
            if (JXRootPane.this.contentPane != null) {
                Rectangle bounds = JXRootPane.this.contentPane.getBounds();
                JXRootPane.this.contentPane.setBounds(bounds.x, bounds.y, bounds.width, bounds.height - statusPref.height);
            }
        }
    }
}

