/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellEditor;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.plaf.UIAction;
import org.jdesktop.swingx.plaf.UIDependent;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.rollover.RolloverProducer;
import org.jdesktop.swingx.rollover.RolloverRenderer;
import org.jdesktop.swingx.rollover.TreeRolloverController;
import org.jdesktop.swingx.rollover.TreeRolloverProducer;
import org.jdesktop.swingx.search.SearchFactory;
import org.jdesktop.swingx.search.Searchable;
import org.jdesktop.swingx.search.TreeSearchable;
import org.jdesktop.swingx.tree.DefaultXTreeCellEditor;
import org.jdesktop.swingx.tree.DefaultXTreeCellRenderer;

public class JXTree
extends JTree {
    private static final Logger LOG = Logger.getLogger(JXTree.class.getName());
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final TreePath[] EMPTY_TREEPATH_ARRAY = new TreePath[0];
    protected CompoundHighlighter compoundHighlighter;
    private ChangeListener highlighterChangeListener;
    private DelegatingRenderer delegatingRenderer;
    private RolloverProducer rolloverProducer;
    private TreeRolloverController<JXTree> linkController;
    private boolean overwriteIcons;
    private Searchable searchable;
    private CellEditorRemover editorRemover;
    private CellEditorListener editorListener;
    private Color selectionForeground;
    private Color selectionBackground;
    protected ComponentAdapter dataAdapter;

    public JXTree() {
        this.init();
    }

    public JXTree(Object[] value) {
        super(value);
        this.init();
    }

    public JXTree(Vector<?> value) {
        super(value);
        this.init();
    }

    public JXTree(Hashtable<?, ?> value) {
        super(value);
        this.init();
    }

    public JXTree(TreeNode root) {
        super(root, false);
        this.init();
    }

    public JXTree(TreeNode root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
        this.init();
    }

    public JXTree(TreeModel newModel) {
        super(newModel);
        this.init();
    }

    private void init() {
        this.setCellRenderer(this.createDefaultCellRenderer());
        if (this.getWrappedCellRenderer() instanceof DefaultTreeCellRenderer) {
            this.setCellEditor(new DefaultXTreeCellEditor(this, (DefaultTreeCellRenderer)this.getWrappedCellRenderer()));
        }
        ActionMap map = this.getActionMap();
        map.put("expand-all", new Actions("expand-all"));
        map.put("collapse-all", new Actions("collapse-all"));
        map.put("find", this.createFindAction());
        KeyStroke findStroke = SearchFactory.getInstance().getSearchAccelerator();
        this.getInputMap(1).put(findStroke, "find");
    }

    @Override
    protected TreeModelListener createTreeModelListener() {
        return new XTreeModelHandler();
    }

    private Action createFindAction() {
        return new UIAction("find"){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JXTree.this.doFind();
            }
        };
    }

    protected void doFind() {
        SearchFactory.getInstance().showFindInput(this, this.getSearchable());
    }

    public Searchable getSearchable() {
        if (this.searchable == null) {
            this.searchable = new TreeSearchable(this);
        }
        return this.searchable;
    }

    public void setSearchable(Searchable searchable) {
        this.searchable = searchable;
    }

    public String getStringAt(int row) {
        return this.getStringAt(this.getPathForRow(row));
    }

    public String getStringAt(TreePath path) {
        if (path == null) {
            return null;
        }
        TreeCellRenderer renderer = this.getDelegatingRenderer().getDelegateRenderer();
        if (renderer instanceof StringValue) {
            return ((StringValue)((Object)renderer)).getString(path.getLastPathComponent());
        }
        return StringValues.TO_STRING.getString(path.getLastPathComponent());
    }

    @Override
    public TreePath getNextMatch(String prefix, int startingRow, Position.Bias bias) {
        Pattern pattern = Pattern.compile("^" + prefix, 2);
        int row = this.getSearchable().search(pattern, startingRow, bias == Position.Bias.Backward);
        return this.getPathForRow(row);
    }

    public void collapseAll() {
        for (int i2 = this.getRowCount() - 1; i2 >= 0; --i2) {
            this.collapseRow(i2);
        }
    }

    public void expandAll() {
        if (this.getRowCount() == 0) {
            this.expandRoot();
        }
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            this.expandRow(i2);
        }
    }

    private void expandRoot() {
        TreeModel model = this.getModel();
        if (model != null && model.getRoot() != null) {
            this.expandPath(new TreePath(model.getRoot()));
        }
    }

    @Override
    public int[] getSelectionRows() {
        int[] rows = super.getSelectionRows();
        return rows != null ? rows : EMPTY_INT_ARRAY;
    }

    @Override
    public TreePath[] getSelectionPaths() {
        TreePath[] paths = super.getSelectionPaths();
        return paths != null ? paths : EMPTY_TREEPATH_ARRAY;
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color selectionForeground) {
        Color oldValue = this.getSelectionForeground();
        this.selectionForeground = selectionForeground;
        this.firePropertyChange("selectionForeground", oldValue, this.getSelectionForeground());
        this.repaint();
    }

    public void setSelectionBackground(Color selectionBackground) {
        Color oldValue = this.getSelectionBackground();
        this.selectionBackground = selectionBackground;
        this.firePropertyChange("selectionBackground", oldValue, this.getSelectionBackground());
        this.repaint();
    }

    @Override
    public void updateUI() {
        this.uninstallSelectionColors();
        super.updateUI();
        this.installSelectionColors();
        this.updateHighlighterUI();
        this.updateRendererEditorUI();
        this.invalidateCellSizeCache();
    }

    protected void updateRendererEditorUI() {
        if (this.getCellEditor() instanceof UIDependent) {
            ((UIDependent)((Object)this.getCellEditor())).updateUI();
        }
    }

    private void installSelectionColors() {
        if (SwingXUtilities.isUIInstallable(this.getSelectionBackground())) {
            this.setSelectionBackground(UIManager.getColor("Tree.selectionBackground"));
        }
        if (SwingXUtilities.isUIInstallable(this.getSelectionForeground())) {
            this.setSelectionForeground(UIManager.getColor("Tree.selectionForeground"));
        }
    }

    private void uninstallSelectionColors() {
        if (SwingXUtilities.isUIInstallable(this.getSelectionBackground())) {
            this.setSelectionBackground(null);
        }
        if (SwingXUtilities.isUIInstallable(this.getSelectionForeground())) {
            this.setSelectionForeground(null);
        }
    }

    protected void updateHighlighterUI() {
        if (this.compoundHighlighter == null) {
            return;
        }
        this.compoundHighlighter.updateUI();
    }

    public void setRolloverEnabled(boolean rolloverEnabled) {
        boolean old = this.isRolloverEnabled();
        if (rolloverEnabled == old) {
            return;
        }
        if (rolloverEnabled) {
            this.rolloverProducer = this.createRolloverProducer();
            this.rolloverProducer.install(this);
            this.getLinkController().install(this);
        } else {
            this.rolloverProducer.release(this);
            this.rolloverProducer = null;
            this.getLinkController().release();
        }
        this.firePropertyChange("rolloverEnabled", old, this.isRolloverEnabled());
    }

    public boolean isRolloverEnabled() {
        return this.rolloverProducer != null;
    }

    protected TreeRolloverController<JXTree> getLinkController() {
        if (this.linkController == null) {
            this.linkController = this.createLinkController();
        }
        return this.linkController;
    }

    protected TreeRolloverController<JXTree> createLinkController() {
        return new TreeRolloverController<JXTree>();
    }

    protected RolloverProducer createRolloverProducer() {
        return new TreeRolloverProducer();
    }

    public void setHighlighters(Highlighter ... highlighters) {
        Highlighter[] old = this.getHighlighters();
        this.getCompoundHighlighter().setHighlighters(highlighters);
        this.firePropertyChange("highlighters", old, this.getHighlighters());
    }

    public Highlighter[] getHighlighters() {
        return this.getCompoundHighlighter().getHighlighters();
    }

    public void addHighlighter(Highlighter highlighter) {
        Highlighter[] old = this.getHighlighters();
        this.getCompoundHighlighter().addHighlighter(highlighter);
        this.firePropertyChange("highlighters", old, this.getHighlighters());
    }

    public void removeHighlighter(Highlighter highlighter) {
        Highlighter[] old = this.getHighlighters();
        this.getCompoundHighlighter().removeHighlighter(highlighter);
        this.firePropertyChange("highlighters", old, this.getHighlighters());
    }

    protected CompoundHighlighter getCompoundHighlighter() {
        if (this.compoundHighlighter == null) {
            this.compoundHighlighter = new CompoundHighlighter(new Highlighter[0]);
            this.compoundHighlighter.addChangeListener(this.getHighlighterChangeListener());
        }
        return this.compoundHighlighter;
    }

    protected ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = this.createHighlighterChangeListener();
        }
        return this.highlighterChangeListener;
    }

    protected ChangeListener createHighlighterChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                JXTree.this.repaint();
            }
        };
    }

    public void setExpandedIcon(Icon expandedIcon) {
        if (this.getUI() instanceof BasicTreeUI) {
            ((BasicTreeUI)this.getUI()).setExpandedIcon(expandedIcon);
        }
    }

    public void setCollapsedIcon(Icon collapsedIcon) {
        if (this.getUI() instanceof BasicTreeUI) {
            ((BasicTreeUI)this.getUI()).setCollapsedIcon(collapsedIcon);
        }
    }

    public void setLeafIcon(Icon leafIcon) {
        this.getDelegatingRenderer().setLeafIcon(leafIcon);
    }

    public void setOpenIcon(Icon openIcon) {
        this.getDelegatingRenderer().setOpenIcon(openIcon);
    }

    public void setClosedIcon(Icon closedIcon) {
        this.getDelegatingRenderer().setClosedIcon(closedIcon);
    }

    public void setOverwriteRendererIcons(boolean overwrite) {
        if (this.overwriteIcons == overwrite) {
            return;
        }
        boolean old = this.overwriteIcons;
        this.overwriteIcons = overwrite;
        this.firePropertyChange("overwriteRendererIcons", old, overwrite);
    }

    public boolean isOverwriteRendererIcons() {
        return this.overwriteIcons;
    }

    private DelegatingRenderer getDelegatingRenderer() {
        if (this.delegatingRenderer == null) {
            this.delegatingRenderer = new DelegatingRenderer();
        }
        return this.delegatingRenderer;
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new DefaultXTreeCellRenderer();
    }

    @Override
    public TreeCellRenderer getCellRenderer() {
        return this.getDelegatingRenderer();
    }

    public TreeCellRenderer getWrappedCellRenderer() {
        return this.getDelegatingRenderer().getDelegateRenderer();
    }

    @Override
    public void setCellRenderer(TreeCellRenderer renderer) {
        this.getDelegatingRenderer().setDelegateRenderer(renderer);
        super.setCellRenderer(this.delegatingRenderer);
        if (renderer instanceof DefaultTreeCellRenderer && this.getCellEditor() instanceof DefaultXTreeCellEditor) {
            ((DefaultXTreeCellEditor)this.getCellEditor()).setRenderer((DefaultTreeCellRenderer)renderer);
        }
        this.firePropertyChange("cellRenderer", null, this.delegatingRenderer);
    }

    public void invalidateCellSizeCache() {
        if (this.getUI() instanceof BasicTreeUI) {
            BasicTreeUI ui = (BasicTreeUI)this.getUI();
            ui.setLeftChildIndent(ui.getLeftChildIndent());
        }
    }

    @Override
    public void startEditingAtPath(TreePath path) {
        super.startEditingAtPath(path);
        if (this.isEditing()) {
            this.updateEditorListener();
            this.updateEditorRemover();
        }
    }

    private void updateEditorListener() {
        if (this.editorListener == null) {
            this.editorListener = new CellEditorListener(){

                @Override
                public void editingCanceled(ChangeEvent e2) {
                    this.terminated(e2);
                }

                private void terminated(ChangeEvent e2) {
                    JXTree.this.analyseFocus();
                    ((CellEditor)e2.getSource()).removeCellEditorListener(JXTree.this.editorListener);
                }

                @Override
                public void editingStopped(ChangeEvent e2) {
                    this.terminated(e2);
                }
            };
        }
        this.getCellEditor().addCellEditorListener(this.editorListener);
    }

    protected void analyseFocus() {
        if (this.isFocusOwnerDescending()) {
            this.requestFocusInWindow();
        }
    }

    private boolean isFocusOwnerDescending() {
        if (!this.isEditing()) {
            return false;
        }
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null) {
            return false;
        }
        if (SwingXUtilities.isDescendingFrom(focusOwner, this)) {
            return true;
        }
        Component permanent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        return SwingXUtilities.isDescendingFrom(permanent, this);
    }

    @Override
    public void removeNotify() {
        if (this.editorRemover != null) {
            this.editorRemover.release();
            this.editorRemover = null;
        }
        super.removeNotify();
    }

    private void updateEditorRemover() {
        if (this.editorRemover == null) {
            this.editorRemover = new CellEditorRemover();
        }
        this.editorRemover.updateKeyboardFocusManager();
    }

    @Override
    public void setModel(TreeModel newModel) {
        super.setModel(newModel);
    }

    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new TreeAdapter(this);
        }
        return this.dataAdapter;
    }

    protected ComponentAdapter getComponentAdapter(int index) {
        ComponentAdapter adapter = this.getComponentAdapter();
        adapter.column = 0;
        adapter.row = index;
        return adapter;
    }

    protected static class TreeAdapter
    extends ComponentAdapter {
        private final JXTree tree;

        public TreeAdapter(JXTree component) {
            super(component);
            this.tree = component;
        }

        public JXTree getTree() {
            return this.tree;
        }

        @Override
        public boolean hasFocus() {
            return this.tree.isFocusOwner() && this.tree.getLeadSelectionRow() == this.row;
        }

        @Override
        public Object getValueAt(int row, int column) {
            TreePath path = this.tree.getPathForRow(row);
            return path.getLastPathComponent();
        }

        @Override
        public String getStringAt(int row, int column) {
            return this.tree.getStringAt(row);
        }

        @Override
        public Rectangle getCellBounds() {
            return this.tree.getRowBounds(this.row);
        }

        @Override
        public boolean isEditable() {
            return this.tree.isPathEditable(this.tree.getPathForRow(this.row));
        }

        @Override
        public boolean isSelected() {
            return this.tree.isRowSelected(this.row);
        }

        @Override
        public boolean isExpanded() {
            return this.tree.isExpanded(this.row);
        }

        @Override
        public int getDepth() {
            return this.tree.getPathForRow(this.row).getPathCount() - 1;
        }

        @Override
        public boolean isHierarchical() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return this.tree.getModel().isLeaf(this.getValue());
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    public class CellEditorRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;

        public CellEditorRemover() {
            this.updateKeyboardFocusManager();
        }

        public void updateKeyboardFocusManager() {
            KeyboardFocusManager current = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.setKeyboardFocusManager(current);
        }

        public void release() {
            this.setKeyboardFocusManager(null);
        }

        private void setKeyboardFocusManager(KeyboardFocusManager current) {
            if (this.focusManager == current) {
                return;
            }
            KeyboardFocusManager old = this.focusManager;
            if (old != null) {
                old.removePropertyChangeListener("permanentFocusOwner", this);
            }
            this.focusManager = current;
            if (this.focusManager != null) {
                this.focusManager.addPropertyChangeListener("permanentFocusOwner", this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (!JXTree.this.isEditing()) {
                return;
            }
            Component c2 = this.focusManager.getPermanentFocusOwner();
            JXTree tree = JXTree.this;
            while (c2 != null) {
                if (c2 instanceof JPopupMenu) {
                    c2 = ((JPopupMenu)c2).getInvoker();
                    continue;
                }
                if (c2 == tree) {
                    return;
                }
                if (c2 instanceof Window || c2 instanceof Applet && c2.getParent() == null) {
                    if (c2 != SwingUtilities.getRoot(tree)) break;
                    if (tree.getInvokesStopCellEditing()) {
                        tree.stopEditing();
                    }
                    if (!tree.isEditing()) break;
                    tree.cancelEditing();
                    break;
                }
                c2 = c2.getParent();
            }
        }
    }

    public class DelegatingRenderer
    implements TreeCellRenderer,
    RolloverRenderer {
        private Icon closedIcon = null;
        private Icon openIcon = null;
        private Icon leafIcon = null;
        private TreeCellRenderer delegate;

        public DelegatingRenderer() {
            this(null);
            this.initIcons(new DefaultTreeCellRenderer());
        }

        public DelegatingRenderer(TreeCellRenderer delegate) {
            this.initIcons((DefaultTreeCellRenderer)(delegate instanceof DefaultTreeCellRenderer ? delegate : new DefaultTreeCellRenderer()));
            this.setDelegateRenderer(delegate);
        }

        private void initIcons(DefaultTreeCellRenderer renderer) {
            this.closedIcon = renderer.getDefaultClosedIcon();
            this.openIcon = renderer.getDefaultOpenIcon();
            this.leafIcon = renderer.getDefaultLeafIcon();
        }

        public void setDelegateRenderer(TreeCellRenderer delegate) {
            if (delegate == null) {
                delegate = JXTree.this.createDefaultCellRenderer();
            }
            this.delegate = delegate;
            this.updateIcons();
        }

        private void updateIcons() {
            if (!JXTree.this.isOverwriteRendererIcons()) {
                return;
            }
            this.setClosedIcon(this.closedIcon);
            this.setOpenIcon(this.openIcon);
            this.setLeafIcon(this.leafIcon);
        }

        public void setClosedIcon(Icon closedIcon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setClosedIcon(closedIcon);
            }
            this.closedIcon = closedIcon;
        }

        public void setOpenIcon(Icon openIcon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setOpenIcon(openIcon);
            }
            this.openIcon = openIcon;
        }

        public void setLeafIcon(Icon leafIcon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setLeafIcon(leafIcon);
            }
            this.leafIcon = leafIcon;
        }

        public TreeCellRenderer getDelegateRenderer() {
            return this.delegate;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component result = this.delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (JXTree.this.compoundHighlighter != null && row < JXTree.this.getRowCount() && row >= 0) {
                result = JXTree.this.compoundHighlighter.highlight(result, JXTree.this.getComponentAdapter(row));
            }
            return result;
        }

        @Override
        public boolean isEnabled() {
            return this.delegate instanceof RolloverRenderer && ((RolloverRenderer)((Object)this.delegate)).isEnabled();
        }

        @Override
        public void doClick() {
            if (this.isEnabled()) {
                ((RolloverRenderer)((Object)this.delegate)).doClick();
            }
        }
    }

    private class Actions
    extends UIAction {
        Actions(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if ("expand-all".equals(this.getName())) {
                JXTree.this.expandAll();
            } else if ("collapse-all".equals(this.getName())) {
                JXTree.this.collapseAll();
            }
        }
    }

    protected class XTreeModelHandler
    extends JTree.TreeModelHandler {
        protected XTreeModelHandler() {
            super(JXTree.this);
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e2) {
            TreePath path = e2.getTreePath();
            if (path.getParentPath() == null && !JXTree.this.isRootVisible() && JXTree.this.isCollapsed(path)) {
                JXTree.this.expandPath(path);
            }
            super.treeNodesInserted(e2);
        }
    }
}

