/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.auth;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.spec.SecretKeySpec;

public class KeyChain {
    private static final Logger LOG = Logger.getLogger(KeyChain.class.getName());
    private KeyStore store;
    private char[] masterPassword;

    public KeyChain(char[] masterPassword, InputStream inputStream) throws IOException {
        this.masterPassword = masterPassword;
        try {
            this.store = KeyStore.getInstance("JCEKS");
            this.store.load(inputStream, masterPassword);
        }
        catch (KeyStoreException ex) {
            LOG.log(Level.WARNING, "", ex);
        }
        catch (CertificateException ex) {
            LOG.log(Level.WARNING, "", ex);
        }
        catch (NoSuchAlgorithmException ex) {
            LOG.log(Level.WARNING, "", ex);
        }
        catch (EOFException ex) {
            LOG.log(Level.WARNING, "", ex);
        }
    }

    public String getPassword(String user, String server) {
        try {
            KeyStore.SecretKeyEntry entry2 = (KeyStore.SecretKeyEntry)this.store.getEntry(user + "@" + server, new KeyStore.PasswordProtection(this.masterPassword));
            return new String(entry2.getSecretKey().getEncoded());
        }
        catch (KeyStoreException ex) {
            LOG.log(Level.WARNING, "", ex);
        }
        catch (UnrecoverableEntryException ex) {
            LOG.log(Level.WARNING, "", ex);
        }
        catch (NoSuchAlgorithmException ex) {
            LOG.log(Level.WARNING, "", ex);
        }
        return null;
    }

    public void addPassword(String user, String server, char[] password) {
        String pass = new String(password);
        SecretKeySpec passwordKey = new SecretKeySpec(pass.getBytes(), "JCEKS");
        KeyStore.SecretKeyEntry entry = new KeyStore.SecretKeyEntry(passwordKey);
        try {
            this.store.setEntry(user + "@" + server, entry, new KeyStore.PasswordProtection(this.masterPassword));
        }
        catch (KeyStoreException e2) {
            LOG.log(Level.WARNING, "", e2);
        }
    }

    public void removePassword(String user, String server) {
        try {
            this.store.deleteEntry(user + "@" + server);
        }
        catch (KeyStoreException e2) {
            LOG.log(Level.WARNING, "", e2);
        }
    }

    public void store(OutputStream ostream) throws IOException {
        try {
            this.store.store(ostream, this.masterPassword);
        }
        catch (KeyStoreException ex) {
            LOG.log(Level.WARNING, "", ex);
        }
        catch (CertificateException ex) {
            LOG.log(Level.WARNING, "", ex);
        }
        catch (NoSuchAlgorithmException ex) {
            LOG.log(Level.WARNING, "", ex);
        }
    }

    public static void main(String[] args) {
        try {
            int i2;
            FileInputStream fis;
            File file = new File("c:\\test.txt");
            if (!file.exists()) {
                file.createNewFile();
                fis = null;
            } else {
                fis = new FileInputStream(file);
            }
            KeyChain kc = new KeyChain("test".toCharArray(), fis);
            kc.addPassword("bino", "sun-ds.sfbay", "test123".toCharArray());
            LOG.fine("pass = " + kc.getPassword("bino", "sun-ds.sfbay"));
            LOG.fine("More testing :");
            for (i2 = 0; i2 < 100; ++i2) {
                kc.addPassword("" + i2, "sun-ds.sfbay", ("" + i2).toCharArray());
            }
            for (i2 = 0; i2 < 100; ++i2) {
                LOG.fine("key =" + i2 + " pass =" + kc.getPassword("" + i2, "sun-ds.sfbay"));
            }
            kc.store(new FileOutputStream(file));
        }
        catch (Exception e2) {
            LOG.log(Level.WARNING, "", e2);
        }
    }
}

